//MCEWrapper.cpp: Implementation of the MCE D-bus wrapper class.

#include <MCEWrapper.h>

MCEWrapper::MCEWrapper(QObject *parent)
    : QObject(parent)
{
    //constructor
    QDBusInterface* pdBusInterface = new QDBusInterface(MCE_SERVICE, MCE_REQUEST_PATH,
                                       MCE_REQUEST_IF, QDBusConnection::systemBus(), this);

    QDBusConnection::systemBus().connect(MCE_SERVICE, MCE_SIGNAL_PATH, MCE_SIGNAL_IF,
                           MCE_DISPLAY_SIG, this, SLOT(displayStateChanged(const QDBusMessage &)));

    pdBusInterface->callWithCallback(MCE_DISPLAY_STATUS_GET, QList<QVariant>(), this,
                                      SLOT(setDisplayState(QString)),
                                      SLOT(displayStateError(QDBusError))); //request current display state
}

MCEWrapper::~MCEWrapper()
{
}

void MCEWrapper::displayStateChanged(const QDBusMessage &message)
{
    QString state = message.arguments().at(0).toString();
    setDisplayState(state);
}

void MCEWrapper::displayStateError(const QDBusError &error)
{
    Q_UNUSED(error)
}

void MCEWrapper::setDisplayState(const QString &state)
{
    if (!state.isEmpty()) {
        if (state == MCE_DISPLAY_ON_STRING)
        {
            //Display on
            emit onDisplayStateChange(true);
        }
        else if (state == MCE_DISPLAY_OFF_STRING)
        {
            //Display off
            emit onDisplayStateChange(false);
        }
    }
}
