import QtQuick 1.0
import "components"

Item {
    id: delegate

    property bool checked

    signal clicked
    signal pressAndHold

    width: parent.width
    height: 83

    ListHighlight {
        visible: mouseArea.pressed
    }

    Label {
        id: titleText

        anchors { left: frame.right; leftMargin: 5; right: delegate.right; rightMargin: 5; top: frame.top; bottom: frame.bottom; bottomMargin: 5 }
        wrapMode: Text.WordWrap
        font.bold: true
        clip: true
        text: fileName.slice(0, fileName.lastIndexOf("."))
    }

    Image {
        id: frame

        z: 1
        width: 102
        height: 77
        anchors { left: delegate.left; leftMargin: 5; verticalCenter: delegate.verticalCenter }
        source: "images/frame.png"
        sourceSize.width: width
        sourceSize.height: height
        smooth: true

        Image {
            id: thumb

            z: -1
            anchors.fill: frame
            source: Settings.downloadPath + ".thumbnails/" + fileName.slice(0, fileName.lastIndexOf(".")) + ".jpg"
            smooth: true
            asynchronous: true
            onStatusChanged: if (thumb.status == Image.Error) thumb.source = !theme.inverted ? "images/video.png" : "images/video-white.png";
        }
    }

    MouseArea {
        id: mouseArea

        anchors.fill: parent
        onClicked: parent.clicked()
        onPressAndHold: parent.pressAndHold()
    }
}

