import QtQuick 1.0

Item {
    id: delegate

    signal delegateClicked

    width: delegate.ListView.view.width
    height: 100

    ListHighlight {
        visible: (mouseArea.pressed) || (delegate.ListView.view.currentIndex == index)
    }

    Text {
        id: titleText
        elide: Text.ElideRight
        text: (site == "") ? username : username + " (" + site + ")"
        color: _TEXT_COLOR
        font.pixelSize: _STANDARD_FONT_SIZE
        anchors.fill: parent
        horizontalAlignment: Text.AlignHCenter
        verticalAlignment: Text.AlignVCenter
    }

    MouseArea {
        id: mouseArea

        anchors.fill: parent
        onClicked: delegateClicked()
    }
}
