#ifndef QEMAEMO5DYNAMICWIDGETHELPER_H
#define QEMAEMO5DYNAMICWIDGETHELPER_H

#include <QtCore>
#include "qemaemo5dynamichomescreenwidget.h"

#define SETTING_SAVED_WIDGET_IDS (QApplication::applicationName() + "-SavedWidgetIds")

class QeMaemo5DynamicWidgetHelper
{

private:

    QList<QeMaemo5DynamicHomescreenWidget*> *_widgets;
    QList<QString> *_savedAppletIds;

    explicit QeMaemo5DynamicWidgetHelper();

protected:

public:

    static QeMaemo5DynamicWidgetHelper *globalInstance();

    void registerWidget(QeMaemo5DynamicHomescreenWidget *widget);
    void registerAll(const QList<QeMaemo5DynamicHomescreenWidget*> list);
    void unregisterWidget(QeMaemo5DynamicHomescreenWidget *widget);
    void unregisterAll(const QList<QeMaemo5DynamicHomescreenWidget*> list);
    bool isWidgetRegistered(QeMaemo5DynamicHomescreenWidget *widget);
    const QList<QeMaemo5DynamicHomescreenWidget*> &widgets();
    const QList<QString> &savedAppletIds();

    void forgetAllWidgets();
    template<typename TWidget> void restoreWidgets();

};

template<typename TWidget>
void QeMaemo5DynamicWidgetHelper::restoreWidgets()
{
    for (int i = 0; i < savedAppletIds().count(); i++)
    {
        qDebug() << "beginning to restore widget:" << savedAppletIds().at(i);
        TWidget *newWidget = new TWidget();

        if (!newWidget->restoreAppletId(savedAppletIds().at(i)))
        {
            qDebug() << "this widget is not able to restore itelf, deleting it:" << newWidget->appletId();
            delete newWidget;
        }
        else
        {
            registerWidget(newWidget);
            newWidget->show();
        }
    }
}

#endif // QEMAEMO5DYNAMICWIDGETHELPER_H
