#define QT_NO_KEYWORDS

#include "qemaemo5dynamicwidgethelper.h"
#include "qemaemo5dynamichomescreenwidget.h"
#include "qesettingsmanager.h"

static QeMaemo5DynamicWidgetHelper *_globalInstance = NULL;

QeMaemo5DynamicWidgetHelper *QeMaemo5DynamicWidgetHelper::globalInstance()
{
    if (_globalInstance == NULL)
        _globalInstance = new QeMaemo5DynamicWidgetHelper();

    return _globalInstance;
}

QeMaemo5DynamicWidgetHelper::QeMaemo5DynamicWidgetHelper()
    : _widgets(new QList<QeMaemo5DynamicHomescreenWidget*>()), _savedAppletIds(new QList<QString>(QeSettingsManager::retrieveBinary<QList<QString> >(SETTING_SAVED_WIDGET_IDS)))
{
}

void QeMaemo5DynamicWidgetHelper::registerWidget(QeMaemo5DynamicHomescreenWidget *widget)
{
    if (!_widgets->contains(widget))
        _widgets->append(widget);;
    if (!_savedAppletIds->contains(widget->appletId()))
        _savedAppletIds->append(widget->appletId());

    QeSettingsManager::storeBinary<QList<QString> >(SETTING_SAVED_WIDGET_IDS, *_savedAppletIds);
    qDebug() << "widget registered:" << widget->appletId();
}

void QeMaemo5DynamicWidgetHelper::registerAll(const QList<QeMaemo5DynamicHomescreenWidget *> list)
{
    for (int i = 0; i < list.count(); i++)
    {
        registerWidget(list[i]);
    }
}

void QeMaemo5DynamicWidgetHelper::unregisterWidget(QeMaemo5DynamicHomescreenWidget *widget)
{
    if (_widgets->contains(widget))
        _widgets->removeOne(widget);
    if (_savedAppletIds->contains(widget->appletId()))
        _savedAppletIds->removeOne(widget->appletId());
    QeSettingsManager::storeBinary<QList<QString> >(SETTING_SAVED_WIDGET_IDS, *_savedAppletIds);
    qDebug() << "widget unregistered:" << widget->appletId();
}

void QeMaemo5DynamicWidgetHelper::unregisterAll(const QList<QeMaemo5DynamicHomescreenWidget *> list)
{
    for (int i = 0; i < list.count(); i++)
    {
        unregisterWidget(list[i]);
    }
}

bool QeMaemo5DynamicWidgetHelper::isWidgetRegistered(QeMaemo5DynamicHomescreenWidget *widget)
{
    return _widgets->contains(widget);
}

const QList<QString> &QeMaemo5DynamicWidgetHelper::savedAppletIds()
{
    return *_savedAppletIds;
}

const QList<QeMaemo5DynamicHomescreenWidget*> &QeMaemo5DynamicWidgetHelper::widgets()
{
    return *_widgets;
}

void QeMaemo5DynamicWidgetHelper::forgetAllWidgets()
{
    _savedAppletIds->clear();
    QeSettingsManager::removeSettingsStartingWith(SETTING_SAVED_WIDGET_IDS);
    QeSettingsManager::removeSettingsStartingWith(WIDGET_SETTINGS_BASE_APPLETID);
    qDebug() << "forgot all widgets";
}
