
#include "qemaemo5dynamichomescreenwidget.h"
#include "qemaemo5dynamicwidgethelper.h"
#include "qesettingsmanager.h"

#include <QtCore>
#include <QtGui>
#include <QtGui/QX11Info>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/Xutil.h>

static bool _atomsInitialized = false;

static Atom winTypeAtom;
static Atom homeAppletAtom;
static Atom appletIDAtom;
static Atom utf8Atom;
static Atom appletSettingAtom;
static Atom appletShowSettingAtom;
static Atom onCurrentHomescreenAtom;

static unsigned long get_card_prop(Display *dpy, Window w, Atom atom)
{
    Atom type;
    int format, rc;
    unsigned long items;
    unsigned long left;
    unsigned char *value; // will point to 'unsigned long', actually

    rc = XGetWindowProperty(dpy, w, atom, 0, 1, False, XA_CARDINAL, &type, &format, &items, &left, &value);

    if (type == None || rc != Success)
        return 0;
    else
        return *value;
}

static void set_input_hint(QWidget *w, bool input)
{
    XWMHints *h = XGetWMHints(w->x11Info().display(), w->winId());
    XWMHints wm_hints;
    if (!h)
    {
        memset(&wm_hints, 0, sizeof(wm_hints)); // make valgrind happy
        h = &wm_hints;
    }
    h->flags |= InputHint;
    h->input = input ? True : False;

    XSetWMHints(w->x11Info().display(), w->winId(), h);
    if (h != &wm_hints)
        XFree(h);
}

bool qt_sendSpontaneousEvent(QObject *receiver, QEvent *event)
{
    return QCoreApplication::sendSpontaneousEvent(receiver, event);
}

QeMaemo5DynamicHomescreenWidget::QeMaemo5DynamicHomescreenWidget(bool SettingsAvailable, QWidget *parent)
    : QWidget(parent),
      _isPressed(false), _settingsDialogAvailable(SettingsAvailable)
{
    setAttribute(Qt::WA_TranslucentBackground);
    _appletId = WIDGET_SETTINGS_BASE_APPLETID + QUuid::createUuid().toString().remove("{").remove("}");
    _shouldRegister = true;

    if (!_atomsInitialized)
    {
        winTypeAtom = XInternAtom(QX11Info::display(), "_NET_WM_WINDOW_TYPE", false);
        homeAppletAtom = XInternAtom(QX11Info::display(), "_HILDON_WM_WINDOW_TYPE_HOME_APPLET", false);
        appletIDAtom = XInternAtom(QX11Info::display(), "_HILDON_APPLET_ID", false);
        utf8Atom = XInternAtom(QX11Info::display(), "UTF8_STRING", false);
        appletSettingAtom = XInternAtom(QX11Info::display(), "_HILDON_APPLET_SETTINGS", false);
        appletShowSettingAtom = XInternAtom(QX11Info::display(), "_HILDON_APPLET_SHOW_SETTINGS", false);
        onCurrentHomescreenAtom = XInternAtom(QX11Info::display(), "_HILDON_APPLET_ON_CURRENT_DESKTOP", false);
        _atomsInitialized = true;
    }

    // Set correct window type
    XChangeProperty(QX11Info::display(), winId(), winTypeAtom, XA_ATOM, 32, PropModeReplace, (unsigned char *) &homeAppletAtom, 1);

    if (_settingsDialogAvailable)
    {
        // Add setting button. This button is shown when hildon-desktop is in edit mode.
        int settings = 0;
        XChangeProperty(QX11Info::display(), winId(), appletSettingAtom, XA_CARDINAL, 32, PropModeReplace, (unsigned char*)&settings, 1);
    }

    // Set WM input hints indicating that we don't want focus events
    set_input_hint(this, false);
    this->setMouseTracking(true);

    _focusHackTimer = new QTimer(this);
    connect(_focusHackTimer, SIGNAL(timeout()), this, SLOT(checkFocusHack()));
}

void QeMaemo5DynamicHomescreenWidget::checkFocusHack()
{
    //qDebug() << "pos: " << QCursor::pos();
    QWidget *lastMouseWidget = this->childAt(this->mapFromGlobal(QCursor::pos()));
    if (lastMouseWidget == NULL)
    {
        XSetInputFocus(this->x11Info().display(), PointerRoot, RevertToPointerRoot, CurrentTime);
        qDebug() << "focus stolen!";
        _focusHackTimer->stop();
    }
}

QeMaemo5DynamicHomescreenWidget::~QeMaemo5DynamicHomescreenWidget()
{
}

void QeMaemo5DynamicHomescreenWidget::showSettingsDialog()
{
    QMessageBox::information(NULL, "No settings!", "Sorry, this widget has no settings!");
}

bool QeMaemo5DynamicHomescreenWidget::settingsDialogAvailable()
{
    return _settingsDialogAvailable;
}

QString QeMaemo5DynamicHomescreenWidget::appletId()
{
    return _appletId;
}

bool QeMaemo5DynamicHomescreenWidget::x11Event(XEvent *event)
{
    if (event->xclient.message_type == appletShowSettingAtom)
    {
        showSettingsDialog();
        return true;
    }
    else if (event->xclient.message_type == onCurrentHomescreenAtom)
    {
        // Setting whether we are on the current desktop or not
        _isVisibleOnCurrentHomescreen = get_card_prop(QX11Info::display(), winId(), onCurrentHomescreenAtom) == 1;
        return true;
    }
    else
    {
        QPoint globalPos(event->xbutton.x_root, event->xbutton.y_root);
        static QWidget *lastMouseWidget = NULL;

        switch (event->type)
        {
        case ButtonPress:
            //qDebug() << "ButtonPress";
            lastMouseWidget = this->childAt(this->mapFromGlobal(globalPos));
            if (lastMouseWidget != NULL && dynamic_cast<QAbstractButton*>(lastMouseWidget) == NULL)
            {
                XSetInputFocus(this->x11Info().display(), this->winId(), RevertToPointerRoot, CurrentTime);
            }
            break;
        case ButtonRelease:
            //qDebug() << "ButtonRelease";
            lastMouseWidget = 0;
            break;
        case FocusIn:
            //qDebug() << "FocusIn";
            _focusHackTimer->start(700);
            break;
        case FocusOut:
            //qDebug() << "FocusOut";
            _focusHackTimer->stop();
            break;
        case LeaveNotify:
            if (lastMouseWidget)
            {
                // create a mouse up event that lies in Nirvana.
                QPoint pos(-1000, -1000);
                QMouseEvent e(QEvent::MouseButtonRelease, pos, pos, Qt::LeftButton, Qt::NoButton, Qt::NoModifier);
                qt_sendSpontaneousEvent(lastMouseWidget, &e);
                lastMouseWidget = 0;
            }
            break;
        }
    }
    return false;
}

void QeMaemo5DynamicHomescreenWidget::showEvent(QShowEvent *event)
{
    // Fill the AppletID atom
    QByteArray id(appletId().remove(' ').toUtf8());
    XChangeProperty(QX11Info::display(), winId(), appletIDAtom, utf8Atom, 8, PropModeReplace, (unsigned char *)id.constData(), id.length());

    QWidget::showEvent(event);
}

void QeMaemo5DynamicHomescreenWidget::closeEvent(QCloseEvent *event)
{
    if (QeMaemo5DynamicWidgetHelper::globalInstance()->isWidgetRegistered(this))
        QeMaemo5DynamicWidgetHelper::globalInstance()->unregisterWidget(this);

    QWidget::closeEvent(event);
    QeSettingsManager::removeSettingsStartingWith(_appletId);

    deleteLater();
}

void QeMaemo5DynamicHomescreenWidget::paintEvent(QPaintEvent *event)
{
    QPainter p(this);
    QColor bgColor(0, 0, 0, 128);
    if (_isPressed)
        bgColor.setRgb(101,150,254,128);
    p.setBrush(bgColor);
    p.setPen(Qt::NoPen);
    p.drawRoundedRect(rect(), 10, 10);

    QWidget::paintEvent(event);
}

void QeMaemo5DynamicHomescreenWidget::mousePressEvent(QMouseEvent *event)
{
    qDebug() << "Mouse press event" << event->x() << event->y();
    _isPressed = true;
    update();

    QWidget::mousePressEvent(event);
}

void QeMaemo5DynamicHomescreenWidget::mouseReleaseEvent(QMouseEvent *event)
{
    _isPressed = false;
    update();

    QWidget::mouseReleaseEvent(event);
}

bool QeMaemo5DynamicHomescreenWidget::isVisibleOnCurrentHomescreen()
{
    return _isVisibleOnCurrentHomescreen;
}

void QeMaemo5DynamicHomescreenWidget::saveSetting(const QString& key, const QVariant& data)
{
    QeSettingsManager::storeSetting(appletId() + key, data);
}

QVariant QeMaemo5DynamicHomescreenWidget::loadSetting(const QString& key, const QVariant &defaultValue)
{
    return QeSettingsManager::retrieveSetting(appletId() + key, defaultValue);
}

bool QeMaemo5DynamicHomescreenWidget::restoreAppletId(const QString &restoredAppletId)
{
    _appletId = restoredAppletId;
    qDebug() << "restoring widget state for:" << _appletId;
    return restoreWidgetState();
}

bool QeMaemo5DynamicHomescreenWidget::restoreWidgetState()
{
    return true;
}
