/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtxmlpatterns_python.h"

#include "qxmlschemavalidator_wrapper.h"

// Extra includes
#include <qabstractmessagehandler.h>
#include <qabstracturiresolver.h>
#include <qbytearray.h>
#include <qiodevice.h>
#include <qurl.h>
#include <qxmlnamepool.h>
#include <qxmlschema.h>
#include <qxmlschemavalidator.h>

using namespace Shiboken;

static int
SbkQXmlSchemaValidator_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QXmlSchemaValidator* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QXmlSchemaValidator", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QXmlSchemaValidator()
        cptr = new QXmlSchemaValidator();
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QXmlSchema & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QXmlSchema* cpp_arg0 = Shiboken::Converter<QXmlSchema* >::toCpp(pyargs[0]);
        // QXmlSchemaValidator(QXmlSchema)
        cptr = new QXmlSchemaValidator(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQXmlSchemaValidator_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QXmlSchemaValidator >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQXmlSchemaValidator_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQXmlSchemaValidator_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtXmlPatterns.QXmlSchema", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtXmlPatterns.QXmlSchemaValidator", overloads);
        return -1;
}

static PyObject* SbkQXmlSchemaValidatorFunc_messageHandler(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // messageHandler()const
    QXmlSchemaValidator* cppSelf = Shiboken::Converter<QXmlSchemaValidator* >::toCpp((PyObject*)self);
    QAbstractMessageHandler * cpp_result = cppSelf->QXmlSchemaValidator::messageHandler();
    py_result = Shiboken::Converter<QAbstractMessageHandler * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQXmlSchemaValidatorFunc_namePool(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // namePool()const
    QXmlSchemaValidator* cppSelf = Shiboken::Converter<QXmlSchemaValidator* >::toCpp((PyObject*)self);
    QXmlNamePool cpp_result = cppSelf->QXmlSchemaValidator::namePool();
    py_result = Shiboken::Converter<QXmlNamePool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQXmlSchemaValidatorFunc_schema(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // schema()const
    QXmlSchemaValidator* cppSelf = Shiboken::Converter<QXmlSchemaValidator* >::toCpp((PyObject*)self);
    QXmlSchema cpp_result = cppSelf->QXmlSchemaValidator::schema();
    py_result = Shiboken::Converter<QXmlSchema >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQXmlSchemaValidatorFunc_setMessageHandler(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QAbstractMessageHandler * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QAbstractMessageHandler* cpp_arg0 = Shiboken::Converter<QAbstractMessageHandler* >::toCpp(arg);
        // setMessageHandler(QAbstractMessageHandler*)
        QXmlSchemaValidator* cppSelf = Shiboken::Converter<QXmlSchemaValidator* >::toCpp((PyObject*)self);
        cppSelf->QXmlSchemaValidator::setMessageHandler(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQXmlSchemaValidatorFunc_setMessageHandler_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQXmlSchemaValidatorFunc_setMessageHandler_TypeError:
        const char* overloads[] = {"PySide.QtXmlPatterns.QAbstractMessageHandler", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXmlPatterns.QXmlSchemaValidator.setMessageHandler", overloads);
        return 0;
}

static PyObject* SbkQXmlSchemaValidatorFunc_setSchema(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QXmlSchema & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QXmlSchema* cpp_arg0 = Shiboken::Converter<QXmlSchema* >::toCpp(arg);
        // setSchema(QXmlSchema)
        QXmlSchemaValidator* cppSelf = Shiboken::Converter<QXmlSchemaValidator* >::toCpp((PyObject*)self);
        cppSelf->QXmlSchemaValidator::setSchema(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQXmlSchemaValidatorFunc_setSchema_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQXmlSchemaValidatorFunc_setSchema_TypeError:
        const char* overloads[] = {"PySide.QtXmlPatterns.QXmlSchema", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXmlPatterns.QXmlSchemaValidator.setSchema", overloads);
        return 0;
}

static PyObject* SbkQXmlSchemaValidatorFunc_setUriResolver(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QAbstractUriResolver * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QAbstractUriResolver* cpp_arg0 = Shiboken::Converter<QAbstractUriResolver* >::toCpp(arg);
        // setUriResolver(const QAbstractUriResolver*)
        QXmlSchemaValidator* cppSelf = Shiboken::Converter<QXmlSchemaValidator* >::toCpp((PyObject*)self);
        cppSelf->QXmlSchemaValidator::setUriResolver(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQXmlSchemaValidatorFunc_setUriResolver_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQXmlSchemaValidatorFunc_setUriResolver_TypeError:
        const char* overloads[] = {"PySide.QtXmlPatterns.QAbstractUriResolver", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXmlPatterns.QXmlSchemaValidator.setUriResolver", overloads);
        return 0;
}

static PyObject* SbkQXmlSchemaValidatorFunc_uriResolver(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // uriResolver()const
    QXmlSchemaValidator* cppSelf = Shiboken::Converter<QXmlSchemaValidator* >::toCpp((PyObject*)self);
    const QAbstractUriResolver * cpp_result = cppSelf->QXmlSchemaValidator::uriResolver();
    py_result = Shiboken::Converter<QAbstractUriResolver * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQXmlSchemaValidatorFunc_validate(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "validate", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 1 && Shiboken::Converter<QUrl & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QUrl > cpp_arg0_auto_ptr;
        QUrl* cpp_arg0 = Shiboken::Converter<QUrl* >::toCpp(pyargs[0]);
        if (!SbkQUrl_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QUrl >(cpp_arg0);
        // validate(QUrl)const
        QXmlSchemaValidator* cppSelf = Shiboken::Converter<QXmlSchemaValidator* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QXmlSchemaValidator::validate(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QByteArray & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QByteArray > cpp_arg0_auto_ptr;
        QByteArray* cpp_arg0 = Shiboken::Converter<QByteArray* >::toCpp(pyargs[0]);
        if (!SbkQByteArray_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg0);
        if (numArgs == 1) {
            // validate(QByteArray,QUrl)const
            QXmlSchemaValidator* cppSelf = Shiboken::Converter<QXmlSchemaValidator* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QXmlSchemaValidator::validate(*cpp_arg0);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QUrl & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QUrl > cpp_arg1_auto_ptr;
            QUrl* cpp_arg1 = Shiboken::Converter<QUrl* >::toCpp(pyargs[1]);
            if (!SbkQUrl_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QUrl >(cpp_arg1);
            // validate(QByteArray,QUrl)const
            QXmlSchemaValidator* cppSelf = Shiboken::Converter<QXmlSchemaValidator* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QXmlSchemaValidator::validate(*cpp_arg0, *cpp_arg1);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQXmlSchemaValidatorFunc_validate_TypeError;
    } else if (Shiboken::Converter<QIODevice * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QIODevice* cpp_arg0 = Shiboken::Converter<QIODevice* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // validate(QIODevice*,QUrl)const
            QXmlSchemaValidator* cppSelf = Shiboken::Converter<QXmlSchemaValidator* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QXmlSchemaValidator::validate(cpp_arg0);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QUrl & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QUrl > cpp_arg1_auto_ptr;
            QUrl* cpp_arg1 = Shiboken::Converter<QUrl* >::toCpp(pyargs[1]);
            if (!SbkQUrl_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QUrl >(cpp_arg1);
            // validate(QIODevice*,QUrl)const
            QXmlSchemaValidator* cppSelf = Shiboken::Converter<QXmlSchemaValidator* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QXmlSchemaValidator::validate(cpp_arg0, *cpp_arg1);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQXmlSchemaValidatorFunc_validate_TypeError;
    } else goto SbkQXmlSchemaValidatorFunc_validate_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQXmlSchemaValidatorFunc_validate_TypeError:
        const char* overloads[] = {"PySide.QtCore.QIODevice, PySide.QtCore.QUrl = QUrl()", "PySide.QtCore.QByteArray, PySide.QtCore.QUrl = QUrl()", "PySide.QtCore.QUrl", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtXmlPatterns.QXmlSchemaValidator.validate", overloads);
        return 0;
}

static PyMethodDef SbkQXmlSchemaValidator_methods[] = {
    {"messageHandler", (PyCFunction)SbkQXmlSchemaValidatorFunc_messageHandler, METH_NOARGS},
    {"namePool", (PyCFunction)SbkQXmlSchemaValidatorFunc_namePool, METH_NOARGS},
    {"schema", (PyCFunction)SbkQXmlSchemaValidatorFunc_schema, METH_NOARGS},
    {"setMessageHandler", (PyCFunction)SbkQXmlSchemaValidatorFunc_setMessageHandler, METH_O},
    {"setSchema", (PyCFunction)SbkQXmlSchemaValidatorFunc_setSchema, METH_O},
    {"setUriResolver", (PyCFunction)SbkQXmlSchemaValidatorFunc_setUriResolver, METH_O},
    {"uriResolver", (PyCFunction)SbkQXmlSchemaValidatorFunc_uriResolver, METH_NOARGS},
    {"validate", (PyCFunction)SbkQXmlSchemaValidatorFunc_validate, METH_VARARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQXmlSchemaValidator_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtXmlPatterns.QXmlSchemaValidator",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQXmlSchemaValidator_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQXmlSchemaValidator_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QXmlSchemaValidator >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_QXmlSchemaValidator(PyObject* module)
{
    SbkPySide_QtXmlPatternsTypes[SBK_QXMLSCHEMAVALIDATOR_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQXmlSchemaValidator_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQXmlSchemaValidator_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQXmlSchemaValidator_Type));
    PyModule_AddObject(module, "QXmlSchemaValidator",
        ((PyObject*)&SbkQXmlSchemaValidator_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QXmlSchemaValidator >("QXmlSchemaValidator*");
    Shiboken::TypeResolver::createObjectTypeResolver<QXmlSchemaValidator >(typeid(QXmlSchemaValidator).name());
}


} // extern "C"

