/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


#ifndef PyMODINIT_FUNC  /* declarations for DLL import/export */
#define PyMODINIT_FUNC void
#endif

#include <Python.h>
#include <shiboken.h>
#include "pyside_qtxmlpatterns_python.h"


// Global functions ------------------------------------------------------------

static PyMethodDef QtXmlPatterns_methods[] = {
    {0} // Sentinel
};

// Classes initialization functions ------------------------------------------------------------
extern "C" PyAPI_FUNC(void) init_QXmlNamePool(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QXmlResultItems(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QXmlNodeModelIndex(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QXmlItem(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QAbstractXmlNodeModel(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QAbstractXmlReceiver(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QXmlSerializer(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QAbstractUriResolver(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QXmlSchemaValidator(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QXmlSchema(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QXmlQuery(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QXmlFormatter(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QSourceLocation(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QAbstractMessageHandler(PyObject* module);
extern "C" PyAPI_FUNC(void) init_QXmlName(PyObject* module);

PyTypeObject** SbkPySide_QtXmlPatternsTypes;

PyTypeObject** SbkPySide_QtCoreTypes;

// Module initialization ------------------------------------------------------------

extern "C" {

SHIBOKEN_QTXMLPATTERNS_API PyMODINIT_FUNC
initQtXmlPatterns()
{
    if (!Shiboken::importModule("PySide.QtCore", &SbkPySide_QtCoreTypes)) {
        PyErr_SetString(PyExc_ImportError,"could not import PySide.QtCore");
        return;
    }

    Shiboken::initShiboken();
    PyObject* module = Py_InitModule("QtXmlPatterns", QtXmlPatterns_methods);

    // Create a CObject containing the API pointer array's address
    static PyTypeObject* cppApi[SBK_QtXmlPatterns_IDX_COUNT];
    SbkPySide_QtXmlPatternsTypes = cppApi;
    PyObject* cppApiObject = PyCObject_FromVoidPtr(reinterpret_cast<void*>(cppApi), 0);
    PyModule_AddObject(module, "_Cpp_Api", cppApiObject);

    // Initialize classes in the type system
    init_QXmlNamePool(module);
    init_QXmlResultItems(module);
    init_QXmlNodeModelIndex(module);
    init_QXmlItem(module);
    init_QAbstractXmlNodeModel(module);
    init_QAbstractXmlReceiver(module);
    init_QXmlSerializer(module);
    init_QAbstractUriResolver(module);
    init_QXmlSchemaValidator(module);
    init_QXmlSchema(module);
    init_QXmlQuery(module);
    init_QXmlFormatter(module);
    init_QSourceLocation(module);
    init_QAbstractMessageHandler(module);
    init_QXmlName(module);

    if (PyErr_Occurred()) {
        PyErr_Print();
        Py_FatalError("can't initialize module QtXmlPatterns");
    }
}

} // extern "C"

