/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtxmlpatterns_python.h"

#include "qabstractxmlnodemodel_wrapper.h"

// Extra includes
#include <QVector>
#include <qabstractxmlnodemodel.h>
#include <qabstractxmlreceiver.h>
#include <qsourcelocation.h>
#include <qstring.h>
#include <qurl.h>
#include <qvariant.h>
#include <qxmlname.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QAbstractXmlNodeModelWrapper::QAbstractXmlNodeModelWrapper() : QAbstractXmlNodeModel() {
    // ... middle
}

QVector<QXmlNodeModelIndex > QAbstractXmlNodeModelWrapper::attributes(const QXmlNodeModelIndex & element) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "attributes"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractXmlNodeModel.attributes()' not implemented.");
        return QVector<QXmlNodeModelIndex >();
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QXmlNodeModelIndex & >::toPython(element)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QVector<QXmlNodeModelIndex >();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QVector<QXmlNodeModelIndex > >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QAbstractXmlNodeModel.attributes", "vector", py_result->ob_type->tp_name);
        return QVector<QXmlNodeModelIndex >();
    }
    QVector<QXmlNodeModelIndex > cpp_result(Shiboken::Converter<QVector<QXmlNodeModelIndex > >::toCpp(py_result));
    return cpp_result;
}

QUrl QAbstractXmlNodeModelWrapper::baseUri(const QXmlNodeModelIndex & ni) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "baseUri"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractXmlNodeModel.baseUri()' not implemented.");
        return QUrl();
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QXmlNodeModelIndex & >::toPython(ni)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QUrl();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QUrl >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QAbstractXmlNodeModel.baseUri", SbkType<QUrl >()->tp_name, py_result->ob_type->tp_name);
        return QUrl();
    }
    QUrl cpp_result(Shiboken::Converter<QUrl >::toCpp(py_result));
    return cpp_result;
}

QXmlNodeModelIndex::DocumentOrder QAbstractXmlNodeModelWrapper::compareOrder(const QXmlNodeModelIndex & ni1, const QXmlNodeModelIndex & ni2) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "compareOrder"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractXmlNodeModel.compareOrder()' not implemented.");
        return QXmlNodeModelIndex::DocumentOrder();
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QXmlNodeModelIndex & >::toPython(ni1),
        Shiboken::Converter<QXmlNodeModelIndex & >::toPython(ni2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QXmlNodeModelIndex::DocumentOrder();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QXmlNodeModelIndex::DocumentOrder >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QAbstractXmlNodeModel.compareOrder", SbkType<QXmlNodeModelIndex::DocumentOrder >()->tp_name, py_result->ob_type->tp_name);
        return QXmlNodeModelIndex::DocumentOrder();
    }
    QXmlNodeModelIndex::DocumentOrder cpp_result(Shiboken::Converter<QXmlNodeModelIndex::DocumentOrder >::toCpp(py_result));
    return cpp_result;
}

QUrl QAbstractXmlNodeModelWrapper::documentUri(const QXmlNodeModelIndex & ni) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "documentUri"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractXmlNodeModel.documentUri()' not implemented.");
        return QUrl();
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QXmlNodeModelIndex & >::toPython(ni)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QUrl();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QUrl >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QAbstractXmlNodeModel.documentUri", SbkType<QUrl >()->tp_name, py_result->ob_type->tp_name);
        return QUrl();
    }
    QUrl cpp_result(Shiboken::Converter<QUrl >::toCpp(py_result));
    return cpp_result;
}

QXmlNodeModelIndex QAbstractXmlNodeModelWrapper::elementById(const QXmlName & NCName) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "elementById"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractXmlNodeModel.elementById()' not implemented.");
        return QXmlNodeModelIndex();
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QXmlName & >::toPython(NCName)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QXmlNodeModelIndex();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QXmlNodeModelIndex >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QAbstractXmlNodeModel.elementById", SbkType<QXmlNodeModelIndex >()->tp_name, py_result->ob_type->tp_name);
        return QXmlNodeModelIndex();
    }
    QXmlNodeModelIndex cpp_result(Shiboken::Converter<QXmlNodeModelIndex >::toCpp(py_result));
    return cpp_result;
}

bool QAbstractXmlNodeModelWrapper::isDeepEqual(const QXmlNodeModelIndex & ni1, const QXmlNodeModelIndex & ni2) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "isDeepEqual"));
    if (py_override.isNull()) {
        return this->QAbstractXmlNodeModel::isDeepEqual(ni1, ni2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QXmlNodeModelIndex & >::toPython(ni1),
        Shiboken::Converter<QXmlNodeModelIndex & >::toPython(ni2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QAbstractXmlNodeModel.isDeepEqual", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

QXmlNodeModelIndex::NodeKind QAbstractXmlNodeModelWrapper::kind(const QXmlNodeModelIndex & ni) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "kind"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractXmlNodeModel.kind()' not implemented.");
        return QXmlNodeModelIndex::NodeKind();
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QXmlNodeModelIndex & >::toPython(ni)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QXmlNodeModelIndex::NodeKind();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QXmlNodeModelIndex::NodeKind >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QAbstractXmlNodeModel.kind", SbkType<QXmlNodeModelIndex::NodeKind >()->tp_name, py_result->ob_type->tp_name);
        return QXmlNodeModelIndex::NodeKind();
    }
    QXmlNodeModelIndex::NodeKind cpp_result(Shiboken::Converter<QXmlNodeModelIndex::NodeKind >::toCpp(py_result));
    return cpp_result;
}

QXmlName QAbstractXmlNodeModelWrapper::name(const QXmlNodeModelIndex & ni) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "name"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractXmlNodeModel.name()' not implemented.");
        return QXmlName();
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QXmlNodeModelIndex & >::toPython(ni)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QXmlName();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QXmlName >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QAbstractXmlNodeModel.name", SbkType<QXmlName >()->tp_name, py_result->ob_type->tp_name);
        return QXmlName();
    }
    QXmlName cpp_result(Shiboken::Converter<QXmlName >::toCpp(py_result));
    return cpp_result;
}

QVector<QXmlName > QAbstractXmlNodeModelWrapper::namespaceBindings(const QXmlNodeModelIndex & n) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "namespaceBindings"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractXmlNodeModel.namespaceBindings()' not implemented.");
        return QVector<QXmlName >();
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QXmlNodeModelIndex & >::toPython(n)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QVector<QXmlName >();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QVector<QXmlName > >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QAbstractXmlNodeModel.namespaceBindings", "vector", py_result->ob_type->tp_name);
        return QVector<QXmlName >();
    }
    QVector<QXmlName > cpp_result(Shiboken::Converter<QVector<QXmlName > >::toCpp(py_result));
    return cpp_result;
}

short QAbstractXmlNodeModelWrapper::namespaceForPrefix(const QXmlNodeModelIndex & ni, const short prefix) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "namespaceForPrefix"));
    if (py_override.isNull()) {
        return this->QAbstractXmlNodeModel::namespaceForPrefix(ni, prefix);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(Sh)",
        Shiboken::Converter<QXmlNodeModelIndex & >::toPython(ni),
        prefix
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return short(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QAbstractXmlNodeModel.namespaceForPrefix", SbkType<short >()->tp_name, py_result->ob_type->tp_name);
        return short(0);
    }
    short cpp_result(Shiboken::Converter<short >::toCpp(py_result));
    return cpp_result;
}

QXmlNodeModelIndex QAbstractXmlNodeModelWrapper::nextFromSimpleAxis(QAbstractXmlNodeModel::SimpleAxis axis, const QXmlNodeModelIndex & origin) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "nextFromSimpleAxis"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractXmlNodeModel.nextFromSimpleAxis()' not implemented.");
        return QXmlNodeModelIndex();
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QAbstractXmlNodeModel::SimpleAxis >::toPython(axis),
        Shiboken::Converter<QXmlNodeModelIndex & >::toPython(origin)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QXmlNodeModelIndex();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QXmlNodeModelIndex >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QAbstractXmlNodeModel.nextFromSimpleAxis", SbkType<QXmlNodeModelIndex >()->tp_name, py_result->ob_type->tp_name);
        return QXmlNodeModelIndex();
    }
    QXmlNodeModelIndex cpp_result(Shiboken::Converter<QXmlNodeModelIndex >::toCpp(py_result));
    return cpp_result;
}

QVector<QXmlNodeModelIndex > QAbstractXmlNodeModelWrapper::nodesByIdref(const QXmlName & NCName) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "nodesByIdref"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractXmlNodeModel.nodesByIdref()' not implemented.");
        return QVector<QXmlNodeModelIndex >();
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QXmlName & >::toPython(NCName)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QVector<QXmlNodeModelIndex >();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QVector<QXmlNodeModelIndex > >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QAbstractXmlNodeModel.nodesByIdref", "vector", py_result->ob_type->tp_name);
        return QVector<QXmlNodeModelIndex >();
    }
    QVector<QXmlNodeModelIndex > cpp_result(Shiboken::Converter<QVector<QXmlNodeModelIndex > >::toCpp(py_result));
    return cpp_result;
}

QXmlNodeModelIndex QAbstractXmlNodeModelWrapper::root(const QXmlNodeModelIndex & n) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "root"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractXmlNodeModel.root()' not implemented.");
        return QXmlNodeModelIndex();
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QXmlNodeModelIndex & >::toPython(n)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QXmlNodeModelIndex();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QXmlNodeModelIndex >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QAbstractXmlNodeModel.root", SbkType<QXmlNodeModelIndex >()->tp_name, py_result->ob_type->tp_name);
        return QXmlNodeModelIndex();
    }
    QXmlNodeModelIndex cpp_result(Shiboken::Converter<QXmlNodeModelIndex >::toCpp(py_result));
    return cpp_result;
}

void QAbstractXmlNodeModelWrapper::sendNamespaces(const QXmlNodeModelIndex & n, QAbstractXmlReceiver * receiver) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "sendNamespaces"));
    if (py_override.isNull()) {
        return this->QAbstractXmlNodeModel::sendNamespaces(n, receiver);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QXmlNodeModelIndex & >::toPython(n),
        Shiboken::Converter<QAbstractXmlReceiver * >::toPython(receiver)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QString QAbstractXmlNodeModelWrapper::stringValue(const QXmlNodeModelIndex & n) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "stringValue"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractXmlNodeModel.stringValue()' not implemented.");
        return QString();
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QXmlNodeModelIndex & >::toPython(n)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QString();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QString >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QAbstractXmlNodeModel.stringValue", SbkType<QString >()->tp_name, py_result->ob_type->tp_name);
        return QString();
    }
    QString cpp_result(Shiboken::Converter<QString >::toCpp(py_result));
    return cpp_result;
}

QVariant QAbstractXmlNodeModelWrapper::typedValue(const QXmlNodeModelIndex & n) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "typedValue"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractXmlNodeModel.typedValue()' not implemented.");
        return QVariant();
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QXmlNodeModelIndex & >::toPython(n)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QVariant();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QVariant >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QAbstractXmlNodeModel.typedValue", SbkType<QVariant >()->tp_name, py_result->ob_type->tp_name);
        return QVariant();
    }
    QVariant cpp_result(Shiboken::Converter<QVariant >::toCpp(py_result));
    return cpp_result;
}

QAbstractXmlNodeModelWrapper::~QAbstractXmlNodeModelWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

static int
SbkQAbstractXmlNodeModel_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QAbstractXmlNodeModelWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    SbkBaseWrapperType* type = reinterpret_cast<SbkBaseWrapperType*>(self->ob_type);
    SbkBaseWrapperType* myType = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtXmlPatternsTypes[SBK_QABSTRACTXMLNODEMODEL_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'QAbstractXmlNodeModel' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }

    // QAbstractXmlNodeModel()
    cptr = new QAbstractXmlNodeModelWrapper();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QAbstractXmlNodeModel >(), cptr)) {
        delete cptr;
        return -1;
    }
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;
}

static PyObject* SbkQAbstractXmlNodeModelFunc_attributes(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QXmlNodeModelIndex & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QXmlNodeModelIndex* cpp_arg0 = Shiboken::Converter<QXmlNodeModelIndex* >::toCpp(arg);
        // attributes(QXmlNodeModelIndex)const
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractXmlNodeModel.attributes()' not implemented.");
            return 0;
        }
        QAbstractXmlNodeModel* cppSelf = Shiboken::Converter<QAbstractXmlNodeModel* >::toCpp((PyObject*)self);
        QVector<QXmlNodeModelIndex > cpp_result = cppSelf->attributes(*cpp_arg0);
        py_result = Shiboken::Converter<QVector<QXmlNodeModelIndex > >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractXmlNodeModelFunc_attributes_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQAbstractXmlNodeModelFunc_attributes_TypeError:
        const char* overloads[] = {"PySide.QtXmlPatterns.QXmlNodeModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXmlPatterns.QAbstractXmlNodeModel.attributes", overloads);
        return 0;
}

static PyObject* SbkQAbstractXmlNodeModelFunc_baseUri(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QXmlNodeModelIndex & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QXmlNodeModelIndex* cpp_arg0 = Shiboken::Converter<QXmlNodeModelIndex* >::toCpp(arg);
        // baseUri(QXmlNodeModelIndex)const
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractXmlNodeModel.baseUri()' not implemented.");
            return 0;
        }
        QAbstractXmlNodeModel* cppSelf = Shiboken::Converter<QAbstractXmlNodeModel* >::toCpp((PyObject*)self);
        QUrl cpp_result = cppSelf->baseUri(*cpp_arg0);
        py_result = Shiboken::Converter<QUrl >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractXmlNodeModelFunc_baseUri_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQAbstractXmlNodeModelFunc_baseUri_TypeError:
        const char* overloads[] = {"PySide.QtXmlPatterns.QXmlNodeModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXmlPatterns.QAbstractXmlNodeModel.baseUri", overloads);
        return 0;
}

static PyObject* SbkQAbstractXmlNodeModelFunc_compareOrder(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "compareOrder", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QXmlNodeModelIndex & >::isConvertible(pyargs[0]) && Shiboken::Converter<QXmlNodeModelIndex & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QXmlNodeModelIndex* cpp_arg0 = Shiboken::Converter<QXmlNodeModelIndex* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QXmlNodeModelIndex* cpp_arg1 = Shiboken::Converter<QXmlNodeModelIndex* >::toCpp(pyargs[1]);
        // compareOrder(QXmlNodeModelIndex,QXmlNodeModelIndex)const
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractXmlNodeModel.compareOrder()' not implemented.");
            return 0;
        }
        QAbstractXmlNodeModel* cppSelf = Shiboken::Converter<QAbstractXmlNodeModel* >::toCpp((PyObject*)self);
        QXmlNodeModelIndex::DocumentOrder cpp_result = cppSelf->compareOrder(*cpp_arg0, *cpp_arg1);
        py_result = Shiboken::Converter<QXmlNodeModelIndex::DocumentOrder >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractXmlNodeModelFunc_compareOrder_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQAbstractXmlNodeModelFunc_compareOrder_TypeError:
        const char* overloads[] = {"PySide.QtXmlPatterns.QXmlNodeModelIndex, PySide.QtXmlPatterns.QXmlNodeModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtXmlPatterns.QAbstractXmlNodeModel.compareOrder", overloads);
        return 0;
}

static PyObject* SbkQAbstractXmlNodeModelFunc_createIndex(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "createIndex", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<void * >::isConvertible(pyargs[0])) {
        void * cpp_arg0 = Shiboken::Converter<void * >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // createIndex(void*,qint64)const
            QAbstractXmlNodeModel* cppSelf = Shiboken::Converter<QAbstractXmlNodeModel* >::toCpp((PyObject*)self);
            QXmlNodeModelIndex cpp_result = cppSelf->QAbstractXmlNodeModel::createIndex(cpp_arg0);
            py_result = Shiboken::Converter<QXmlNodeModelIndex >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[1])) {
            qint64 cpp_arg1 = Shiboken::Converter<qint64 >::toCpp(pyargs[1]);
            // createIndex(void*,qint64)const
            QAbstractXmlNodeModel* cppSelf = Shiboken::Converter<QAbstractXmlNodeModel* >::toCpp((PyObject*)self);
            QXmlNodeModelIndex cpp_result = cppSelf->QAbstractXmlNodeModel::createIndex(cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<QXmlNodeModelIndex >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQAbstractXmlNodeModelFunc_createIndex_TypeError;
    } else if (PyNumber_Check(pyargs[0])) {
        qint64 cpp_arg0 = Shiboken::Converter<qint64 >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // createIndex(qint64)const
            QAbstractXmlNodeModel* cppSelf = Shiboken::Converter<QAbstractXmlNodeModel* >::toCpp((PyObject*)self);
            QXmlNodeModelIndex cpp_result = cppSelf->QAbstractXmlNodeModel::createIndex(cpp_arg0);
            py_result = Shiboken::Converter<QXmlNodeModelIndex >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && PyNumber_Check(pyargs[1])) {
            qint64 cpp_arg1 = Shiboken::Converter<qint64 >::toCpp(pyargs[1]);
            // createIndex(qint64,qint64)const
            QAbstractXmlNodeModel* cppSelf = Shiboken::Converter<QAbstractXmlNodeModel* >::toCpp((PyObject*)self);
            QXmlNodeModelIndex cpp_result = cppSelf->QAbstractXmlNodeModel::createIndex(cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<QXmlNodeModelIndex >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQAbstractXmlNodeModelFunc_createIndex_TypeError;
    } else goto SbkQAbstractXmlNodeModelFunc_createIndex_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQAbstractXmlNodeModelFunc_createIndex_TypeError:
        const char* overloads[] = {"long long", "long long, long long", "void, long long = 0", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtXmlPatterns.QAbstractXmlNodeModel.createIndex", overloads);
        return 0;
}

static PyObject* SbkQAbstractXmlNodeModelFunc_documentUri(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QXmlNodeModelIndex & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QXmlNodeModelIndex* cpp_arg0 = Shiboken::Converter<QXmlNodeModelIndex* >::toCpp(arg);
        // documentUri(QXmlNodeModelIndex)const
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractXmlNodeModel.documentUri()' not implemented.");
            return 0;
        }
        QAbstractXmlNodeModel* cppSelf = Shiboken::Converter<QAbstractXmlNodeModel* >::toCpp((PyObject*)self);
        QUrl cpp_result = cppSelf->documentUri(*cpp_arg0);
        py_result = Shiboken::Converter<QUrl >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractXmlNodeModelFunc_documentUri_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQAbstractXmlNodeModelFunc_documentUri_TypeError:
        const char* overloads[] = {"PySide.QtXmlPatterns.QXmlNodeModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXmlPatterns.QAbstractXmlNodeModel.documentUri", overloads);
        return 0;
}

static PyObject* SbkQAbstractXmlNodeModelFunc_elementById(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QXmlName & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QXmlName* cpp_arg0 = Shiboken::Converter<QXmlName* >::toCpp(arg);
        // elementById(QXmlName)const
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractXmlNodeModel.elementById()' not implemented.");
            return 0;
        }
        QAbstractXmlNodeModel* cppSelf = Shiboken::Converter<QAbstractXmlNodeModel* >::toCpp((PyObject*)self);
        QXmlNodeModelIndex cpp_result = cppSelf->elementById(*cpp_arg0);
        py_result = Shiboken::Converter<QXmlNodeModelIndex >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractXmlNodeModelFunc_elementById_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQAbstractXmlNodeModelFunc_elementById_TypeError:
        const char* overloads[] = {"PySide.QtXmlPatterns.QXmlName", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXmlPatterns.QAbstractXmlNodeModel.elementById", overloads);
        return 0;
}

static PyObject* SbkQAbstractXmlNodeModelFunc_isDeepEqual(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "isDeepEqual", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QXmlNodeModelIndex & >::isConvertible(pyargs[0]) && Shiboken::Converter<QXmlNodeModelIndex & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QXmlNodeModelIndex* cpp_arg0 = Shiboken::Converter<QXmlNodeModelIndex* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QXmlNodeModelIndex* cpp_arg1 = Shiboken::Converter<QXmlNodeModelIndex* >::toCpp(pyargs[1]);
        // isDeepEqual(QXmlNodeModelIndex,QXmlNodeModelIndex)const
        QAbstractXmlNodeModel* cppSelf = Shiboken::Converter<QAbstractXmlNodeModel* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QAbstractXmlNodeModel::isDeepEqual(*cpp_arg0, *cpp_arg1);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractXmlNodeModelFunc_isDeepEqual_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQAbstractXmlNodeModelFunc_isDeepEqual_TypeError:
        const char* overloads[] = {"PySide.QtXmlPatterns.QXmlNodeModelIndex, PySide.QtXmlPatterns.QXmlNodeModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtXmlPatterns.QAbstractXmlNodeModel.isDeepEqual", overloads);
        return 0;
}

static PyObject* SbkQAbstractXmlNodeModelFunc_kind(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QXmlNodeModelIndex & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QXmlNodeModelIndex* cpp_arg0 = Shiboken::Converter<QXmlNodeModelIndex* >::toCpp(arg);
        // kind(QXmlNodeModelIndex)const
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractXmlNodeModel.kind()' not implemented.");
            return 0;
        }
        QAbstractXmlNodeModel* cppSelf = Shiboken::Converter<QAbstractXmlNodeModel* >::toCpp((PyObject*)self);
        QXmlNodeModelIndex::NodeKind cpp_result = cppSelf->kind(*cpp_arg0);
        py_result = Shiboken::Converter<QXmlNodeModelIndex::NodeKind >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractXmlNodeModelFunc_kind_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQAbstractXmlNodeModelFunc_kind_TypeError:
        const char* overloads[] = {"PySide.QtXmlPatterns.QXmlNodeModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXmlPatterns.QAbstractXmlNodeModel.kind", overloads);
        return 0;
}

static PyObject* SbkQAbstractXmlNodeModelFunc_name(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QXmlNodeModelIndex & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QXmlNodeModelIndex* cpp_arg0 = Shiboken::Converter<QXmlNodeModelIndex* >::toCpp(arg);
        // name(QXmlNodeModelIndex)const
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractXmlNodeModel.name()' not implemented.");
            return 0;
        }
        QAbstractXmlNodeModel* cppSelf = Shiboken::Converter<QAbstractXmlNodeModel* >::toCpp((PyObject*)self);
        QXmlName cpp_result = cppSelf->name(*cpp_arg0);
        py_result = Shiboken::Converter<QXmlName >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractXmlNodeModelFunc_name_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQAbstractXmlNodeModelFunc_name_TypeError:
        const char* overloads[] = {"PySide.QtXmlPatterns.QXmlNodeModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXmlPatterns.QAbstractXmlNodeModel.name", overloads);
        return 0;
}

static PyObject* SbkQAbstractXmlNodeModelFunc_namespaceBindings(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QXmlNodeModelIndex & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QXmlNodeModelIndex* cpp_arg0 = Shiboken::Converter<QXmlNodeModelIndex* >::toCpp(arg);
        // namespaceBindings(QXmlNodeModelIndex)const
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractXmlNodeModel.namespaceBindings()' not implemented.");
            return 0;
        }
        QAbstractXmlNodeModel* cppSelf = Shiboken::Converter<QAbstractXmlNodeModel* >::toCpp((PyObject*)self);
        QVector<QXmlName > cpp_result = cppSelf->namespaceBindings(*cpp_arg0);
        py_result = Shiboken::Converter<QVector<QXmlName > >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractXmlNodeModelFunc_namespaceBindings_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQAbstractXmlNodeModelFunc_namespaceBindings_TypeError:
        const char* overloads[] = {"PySide.QtXmlPatterns.QXmlNodeModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXmlPatterns.QAbstractXmlNodeModel.namespaceBindings", overloads);
        return 0;
}

static PyObject* SbkQAbstractXmlNodeModelFunc_namespaceForPrefix(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "namespaceForPrefix", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QXmlNodeModelIndex & >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QXmlNodeModelIndex* cpp_arg0 = Shiboken::Converter<QXmlNodeModelIndex* >::toCpp(pyargs[0]);
        short cpp_arg1 = Shiboken::Converter<short >::toCpp(pyargs[1]);
        // namespaceForPrefix(QXmlNodeModelIndex,short)const
        QAbstractXmlNodeModel* cppSelf = Shiboken::Converter<QAbstractXmlNodeModel* >::toCpp((PyObject*)self);
        short cpp_result = cppSelf->QAbstractXmlNodeModel::namespaceForPrefix(*cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<short >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractXmlNodeModelFunc_namespaceForPrefix_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQAbstractXmlNodeModelFunc_namespaceForPrefix_TypeError:
        const char* overloads[] = {"PySide.QtXmlPatterns.QXmlNodeModelIndex, short", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtXmlPatterns.QAbstractXmlNodeModel.namespaceForPrefix", overloads);
        return 0;
}

static PyObject* SbkQAbstractXmlNodeModelFunc_nextFromSimpleAxis(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "nextFromSimpleAxis", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QAbstractXmlNodeModel::SimpleAxis >::isConvertible(pyargs[0]) && Shiboken::Converter<QXmlNodeModelIndex & >::isConvertible(pyargs[1])) {
        QAbstractXmlNodeModel::SimpleAxis cpp_arg0 = Shiboken::Converter<QAbstractXmlNodeModel::SimpleAxis >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QXmlNodeModelIndex* cpp_arg1 = Shiboken::Converter<QXmlNodeModelIndex* >::toCpp(pyargs[1]);
        // nextFromSimpleAxis(QAbstractXmlNodeModel::SimpleAxis,QXmlNodeModelIndex)const
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractXmlNodeModel.nextFromSimpleAxis()' not implemented.");
            return 0;
        }
        QAbstractXmlNodeModel* cppSelf = Shiboken::Converter<QAbstractXmlNodeModel* >::toCpp((PyObject*)self);
        QXmlNodeModelIndex cpp_result = cppSelf->nextFromSimpleAxis(cpp_arg0, *cpp_arg1);
        py_result = Shiboken::Converter<QXmlNodeModelIndex >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractXmlNodeModelFunc_nextFromSimpleAxis_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQAbstractXmlNodeModelFunc_nextFromSimpleAxis_TypeError:
        const char* overloads[] = {"PySide.QtXmlPatterns.QAbstractXmlNodeModel.SimpleAxis, PySide.QtXmlPatterns.QXmlNodeModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtXmlPatterns.QAbstractXmlNodeModel.nextFromSimpleAxis", overloads);
        return 0;
}

static PyObject* SbkQAbstractXmlNodeModelFunc_nodesByIdref(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QXmlName & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QXmlName* cpp_arg0 = Shiboken::Converter<QXmlName* >::toCpp(arg);
        // nodesByIdref(QXmlName)const
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractXmlNodeModel.nodesByIdref()' not implemented.");
            return 0;
        }
        QAbstractXmlNodeModel* cppSelf = Shiboken::Converter<QAbstractXmlNodeModel* >::toCpp((PyObject*)self);
        QVector<QXmlNodeModelIndex > cpp_result = cppSelf->nodesByIdref(*cpp_arg0);
        py_result = Shiboken::Converter<QVector<QXmlNodeModelIndex > >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractXmlNodeModelFunc_nodesByIdref_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQAbstractXmlNodeModelFunc_nodesByIdref_TypeError:
        const char* overloads[] = {"PySide.QtXmlPatterns.QXmlName", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXmlPatterns.QAbstractXmlNodeModel.nodesByIdref", overloads);
        return 0;
}

static PyObject* SbkQAbstractXmlNodeModelFunc_root(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QXmlNodeModelIndex & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QXmlNodeModelIndex* cpp_arg0 = Shiboken::Converter<QXmlNodeModelIndex* >::toCpp(arg);
        // root(QXmlNodeModelIndex)const
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractXmlNodeModel.root()' not implemented.");
            return 0;
        }
        QAbstractXmlNodeModel* cppSelf = Shiboken::Converter<QAbstractXmlNodeModel* >::toCpp((PyObject*)self);
        QXmlNodeModelIndex cpp_result = cppSelf->root(*cpp_arg0);
        py_result = Shiboken::Converter<QXmlNodeModelIndex >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractXmlNodeModelFunc_root_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQAbstractXmlNodeModelFunc_root_TypeError:
        const char* overloads[] = {"PySide.QtXmlPatterns.QXmlNodeModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXmlPatterns.QAbstractXmlNodeModel.root", overloads);
        return 0;
}

static PyObject* SbkQAbstractXmlNodeModelFunc_sendNamespaces(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "sendNamespaces", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QXmlNodeModelIndex & >::isConvertible(pyargs[0]) && Shiboken::Converter<QAbstractXmlReceiver * >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QXmlNodeModelIndex* cpp_arg0 = Shiboken::Converter<QXmlNodeModelIndex* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QAbstractXmlReceiver* cpp_arg1 = Shiboken::Converter<QAbstractXmlReceiver* >::toCpp(pyargs[1]);
        // sendNamespaces(QXmlNodeModelIndex,QAbstractXmlReceiver*)const
        QAbstractXmlNodeModel* cppSelf = Shiboken::Converter<QAbstractXmlNodeModel* >::toCpp((PyObject*)self);
        cppSelf->QAbstractXmlNodeModel::sendNamespaces(*cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractXmlNodeModelFunc_sendNamespaces_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractXmlNodeModelFunc_sendNamespaces_TypeError:
        const char* overloads[] = {"PySide.QtXmlPatterns.QXmlNodeModelIndex, PySide.QtXmlPatterns.QAbstractXmlReceiver", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtXmlPatterns.QAbstractXmlNodeModel.sendNamespaces", overloads);
        return 0;
}

static PyObject* SbkQAbstractXmlNodeModelFunc_sourceLocation(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QXmlNodeModelIndex & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QXmlNodeModelIndex* cpp_arg0 = Shiboken::Converter<QXmlNodeModelIndex* >::toCpp(arg);
        // sourceLocation(QXmlNodeModelIndex)const
        QAbstractXmlNodeModel* cppSelf = Shiboken::Converter<QAbstractXmlNodeModel* >::toCpp((PyObject*)self);
        QSourceLocation cpp_result = cppSelf->QAbstractXmlNodeModel::sourceLocation(*cpp_arg0);
        py_result = Shiboken::Converter<QSourceLocation >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractXmlNodeModelFunc_sourceLocation_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQAbstractXmlNodeModelFunc_sourceLocation_TypeError:
        const char* overloads[] = {"PySide.QtXmlPatterns.QXmlNodeModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXmlPatterns.QAbstractXmlNodeModel.sourceLocation", overloads);
        return 0;
}

static PyObject* SbkQAbstractXmlNodeModelFunc_stringValue(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QXmlNodeModelIndex & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QXmlNodeModelIndex* cpp_arg0 = Shiboken::Converter<QXmlNodeModelIndex* >::toCpp(arg);
        // stringValue(QXmlNodeModelIndex)const
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractXmlNodeModel.stringValue()' not implemented.");
            return 0;
        }
        QAbstractXmlNodeModel* cppSelf = Shiboken::Converter<QAbstractXmlNodeModel* >::toCpp((PyObject*)self);
        QString cpp_result = cppSelf->stringValue(*cpp_arg0);
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractXmlNodeModelFunc_stringValue_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQAbstractXmlNodeModelFunc_stringValue_TypeError:
        const char* overloads[] = {"PySide.QtXmlPatterns.QXmlNodeModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXmlPatterns.QAbstractXmlNodeModel.stringValue", overloads);
        return 0;
}

static PyObject* SbkQAbstractXmlNodeModelFunc_typedValue(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QXmlNodeModelIndex & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QXmlNodeModelIndex* cpp_arg0 = Shiboken::Converter<QXmlNodeModelIndex* >::toCpp(arg);
        // typedValue(QXmlNodeModelIndex)const
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractXmlNodeModel.typedValue()' not implemented.");
            return 0;
        }
        QAbstractXmlNodeModel* cppSelf = Shiboken::Converter<QAbstractXmlNodeModel* >::toCpp((PyObject*)self);
        QVariant cpp_result = cppSelf->typedValue(*cpp_arg0);
        py_result = Shiboken::Converter<QVariant >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractXmlNodeModelFunc_typedValue_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQAbstractXmlNodeModelFunc_typedValue_TypeError:
        const char* overloads[] = {"PySide.QtXmlPatterns.QXmlNodeModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtXmlPatterns.QAbstractXmlNodeModel.typedValue", overloads);
        return 0;
}

static PyMethodDef SbkQAbstractXmlNodeModel_methods[] = {
    {"attributes", (PyCFunction)SbkQAbstractXmlNodeModelFunc_attributes, METH_O},
    {"baseUri", (PyCFunction)SbkQAbstractXmlNodeModelFunc_baseUri, METH_O},
    {"compareOrder", (PyCFunction)SbkQAbstractXmlNodeModelFunc_compareOrder, METH_VARARGS},
    {"createIndex", (PyCFunction)SbkQAbstractXmlNodeModelFunc_createIndex, METH_VARARGS},
    {"documentUri", (PyCFunction)SbkQAbstractXmlNodeModelFunc_documentUri, METH_O},
    {"elementById", (PyCFunction)SbkQAbstractXmlNodeModelFunc_elementById, METH_O},
    {"isDeepEqual", (PyCFunction)SbkQAbstractXmlNodeModelFunc_isDeepEqual, METH_VARARGS},
    {"kind", (PyCFunction)SbkQAbstractXmlNodeModelFunc_kind, METH_O},
    {"name", (PyCFunction)SbkQAbstractXmlNodeModelFunc_name, METH_O},
    {"namespaceBindings", (PyCFunction)SbkQAbstractXmlNodeModelFunc_namespaceBindings, METH_O},
    {"namespaceForPrefix", (PyCFunction)SbkQAbstractXmlNodeModelFunc_namespaceForPrefix, METH_VARARGS},
    {"nextFromSimpleAxis", (PyCFunction)SbkQAbstractXmlNodeModelFunc_nextFromSimpleAxis, METH_VARARGS},
    {"nodesByIdref", (PyCFunction)SbkQAbstractXmlNodeModelFunc_nodesByIdref, METH_O},
    {"root", (PyCFunction)SbkQAbstractXmlNodeModelFunc_root, METH_O},
    {"sendNamespaces", (PyCFunction)SbkQAbstractXmlNodeModelFunc_sendNamespaces, METH_VARARGS},
    {"sourceLocation", (PyCFunction)SbkQAbstractXmlNodeModelFunc_sourceLocation, METH_O},
    {"stringValue", (PyCFunction)SbkQAbstractXmlNodeModelFunc_stringValue, METH_O},
    {"typedValue", (PyCFunction)SbkQAbstractXmlNodeModelFunc_typedValue, METH_O},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQAbstractXmlNodeModel_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtXmlPatterns.QAbstractXmlNodeModel",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQAbstractXmlNodeModel_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQAbstractXmlNodeModel_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QAbstractXmlNodeModel >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static SbkBaseWrapperType* SbkQAbstractXmlNodeModel_typeDiscovery(void* cptr, SbkBaseWrapperType* instanceType)
{
    if (instanceType->mi_specialcast)
        cptr = instanceType->mi_specialcast(cptr, &SbkQAbstractXmlNodeModel_Type);
    TypeResolver* typeResolver = TypeResolver::get(typeid(*reinterpret_cast<QAbstractXmlNodeModel*>(cptr)).name());
    if (typeResolver)
        return reinterpret_cast<SbkBaseWrapperType*>(typeResolver->pythonType());
    return 0;
}

static PyGetSetDef SbkPySide_QtXmlPatterns_QAbstractXmlNodeModel_SimpleAxis_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtXmlPatterns_QAbstractXmlNodeModel_SimpleAxis_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtXmlPatterns_QAbstractXmlNodeModel_SimpleAxis_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "SimpleAxis",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtXmlPatterns_QAbstractXmlNodeModel_SimpleAxis_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtXmlPatterns_QAbstractXmlNodeModel_SimpleAxis_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtXmlPatterns_QAbstractXmlNodeModel_SimpleAxis_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtXmlPatterns_QAbstractXmlNodeModel_NodeCopySetting_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtXmlPatterns_QAbstractXmlNodeModel_NodeCopySetting_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtXmlPatterns_QAbstractXmlNodeModel_NodeCopySetting_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "NodeCopySetting",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtXmlPatterns_QAbstractXmlNodeModel_NodeCopySetting_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtXmlPatterns_QAbstractXmlNodeModel_NodeCopySetting_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtXmlPatterns_QAbstractXmlNodeModel_NodeCopySetting_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void) init_QAbstractXmlNodeModel(PyObject* module)
{
    SbkPySide_QtXmlPatternsTypes[SBK_QABSTRACTXMLNODEMODEL_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQAbstractXmlNodeModel_Type);

    // Fill type discovery information
    SbkQAbstractXmlNodeModel_Type.type_discovery = new Shiboken::TypeDiscovery;
    SbkQAbstractXmlNodeModel_Type.type_discovery->addTypeDiscoveryFunction(&SbkQAbstractXmlNodeModel_typeDiscovery);

    if (PyType_Ready((PyTypeObject*)&SbkQAbstractXmlNodeModel_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQAbstractXmlNodeModel_Type));
    PyModule_AddObject(module, "QAbstractXmlNodeModel",
        ((PyObject*)&SbkQAbstractXmlNodeModel_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: SimpleAxis
    SbkPySide_QtXmlPatternsTypes[SBK_QABSTRACTXMLNODEMODEL_SIMPLEAXIS_IDX] = &SbkPySide_QtXmlPatterns_QAbstractXmlNodeModel_SimpleAxis_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtXmlPatterns_QAbstractXmlNodeModel_SimpleAxis_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtXmlPatterns_QAbstractXmlNodeModel_SimpleAxis_Type);
    PyDict_SetItemString(SbkQAbstractXmlNodeModel_Type.super.ht_type.tp_dict,
            "SimpleAxis",((PyObject*)&SbkPySide_QtXmlPatterns_QAbstractXmlNodeModel_SimpleAxis_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtXmlPatterns_QAbstractXmlNodeModel_SimpleAxis_Type,
        (long) QAbstractXmlNodeModel::Parent, "Parent");
    PyDict_SetItemString(SbkQAbstractXmlNodeModel_Type.super.ht_type.tp_dict,
        "Parent", enum_item);
    PyDict_SetItemString(SbkPySide_QtXmlPatterns_QAbstractXmlNodeModel_SimpleAxis_Type.tp_dict,
        "Parent", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtXmlPatterns_QAbstractXmlNodeModel_SimpleAxis_Type,
        (long) QAbstractXmlNodeModel::FirstChild, "FirstChild");
    PyDict_SetItemString(SbkQAbstractXmlNodeModel_Type.super.ht_type.tp_dict,
        "FirstChild", enum_item);
    PyDict_SetItemString(SbkPySide_QtXmlPatterns_QAbstractXmlNodeModel_SimpleAxis_Type.tp_dict,
        "FirstChild", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtXmlPatterns_QAbstractXmlNodeModel_SimpleAxis_Type,
        (long) QAbstractXmlNodeModel::PreviousSibling, "PreviousSibling");
    PyDict_SetItemString(SbkQAbstractXmlNodeModel_Type.super.ht_type.tp_dict,
        "PreviousSibling", enum_item);
    PyDict_SetItemString(SbkPySide_QtXmlPatterns_QAbstractXmlNodeModel_SimpleAxis_Type.tp_dict,
        "PreviousSibling", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtXmlPatterns_QAbstractXmlNodeModel_SimpleAxis_Type,
        (long) QAbstractXmlNodeModel::NextSibling, "NextSibling");
    PyDict_SetItemString(SbkQAbstractXmlNodeModel_Type.super.ht_type.tp_dict,
        "NextSibling", enum_item);
    PyDict_SetItemString(SbkPySide_QtXmlPatterns_QAbstractXmlNodeModel_SimpleAxis_Type.tp_dict,
        "NextSibling", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QAbstractXmlNodeModel::SimpleAxis");

    // init enum class: NodeCopySetting
    SbkPySide_QtXmlPatternsTypes[SBK_QABSTRACTXMLNODEMODEL_NODECOPYSETTING_IDX] = &SbkPySide_QtXmlPatterns_QAbstractXmlNodeModel_NodeCopySetting_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtXmlPatterns_QAbstractXmlNodeModel_NodeCopySetting_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtXmlPatterns_QAbstractXmlNodeModel_NodeCopySetting_Type);
    PyDict_SetItemString(SbkQAbstractXmlNodeModel_Type.super.ht_type.tp_dict,
            "NodeCopySetting",((PyObject*)&SbkPySide_QtXmlPatterns_QAbstractXmlNodeModel_NodeCopySetting_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtXmlPatterns_QAbstractXmlNodeModel_NodeCopySetting_Type,
        (long) QAbstractXmlNodeModel::InheritNamespaces, "InheritNamespaces");
    PyDict_SetItemString(SbkQAbstractXmlNodeModel_Type.super.ht_type.tp_dict,
        "InheritNamespaces", enum_item);
    PyDict_SetItemString(SbkPySide_QtXmlPatterns_QAbstractXmlNodeModel_NodeCopySetting_Type.tp_dict,
        "InheritNamespaces", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtXmlPatterns_QAbstractXmlNodeModel_NodeCopySetting_Type,
        (long) QAbstractXmlNodeModel::PreserveNamespaces, "PreserveNamespaces");
    PyDict_SetItemString(SbkQAbstractXmlNodeModel_Type.super.ht_type.tp_dict,
        "PreserveNamespaces", enum_item);
    PyDict_SetItemString(SbkPySide_QtXmlPatterns_QAbstractXmlNodeModel_NodeCopySetting_Type.tp_dict,
        "PreserveNamespaces", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QAbstractXmlNodeModel::NodeCopySetting");

    Shiboken::TypeResolver::createObjectTypeResolver<QAbstractXmlNodeModel >("QAbstractXmlNodeModel*");
    Shiboken::TypeResolver::createObjectTypeResolver<QAbstractXmlNodeModel >(typeid(QAbstractXmlNodeModel).name());
}


} // extern "C"

