/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */



#ifndef SBK_QTXMLPATTERNS_PYTHON_H
#define SBK_QTXMLPATTERNS_PYTHON_H

//workaround to access protected functions
#define protected public

#include <Python.h>
#include <conversions.h>
#include <pyenum.h>
#include <basewrapper.h>
#include <bindingmanager.h>
#include <memory>

#if defined _WIN32 || defined __CYGWIN__
    #define SHIBOKEN_QTXMLPATTERNS_API __declspec(dllexport)
#else
#if __GNUC__ >= 4
    #define SHIBOKEN_QTXMLPATTERNS_API __attribute__ ((visibility("default")))
#else
    #define SHIBOKEN_QTXMLPATTERNS_API
#endif
#endif

// Module Includes
#include <pyside_qtcore_python.h>

// Binded library includes
#include <qabstractxmlnodemodel.h>
#include <qabstractxmlreceiver.h>
#include <qxmlschemavalidator.h>
#include <qxmlquery.h>
#include <qxmlformatter.h>
#include <qxmlresultitems.h>
#include <qabstracturiresolver.h>
#include <qxmlschema.h>
#include <qxmlnamepool.h>
#include <qabstractmessagehandler.h>
#include <qxmlname.h>
#include <qxmlserializer.h>
#include <qsourcelocation.h>
// Conversion Includes - Primitive Types
#include <QTextDocument>
#include <QtConcurrentFilter>

// Conversion Includes - Container Types
#include <QList>
#include <QMap>
#include <QMultiMap>
#include <QVector>
#include <QPair>
#include <pysideconversions.h>
#include <QSet>
#include <qqueue.h>

// Type indices
#define SBK_QXMLNAMEPOOL_IDX                                         0
#define SBK_QXMLRESULTITEMS_IDX                                      1
#define SBK_QXMLNODEMODELINDEX_IDX                                   2
#define SBK_QXMLNODEMODELINDEX_NODEKIND_IDX                          3
#define SBK_QXMLNODEMODELINDEX_DOCUMENTORDER_IDX                     4
#define SBK_QXMLNODEMODELINDEX_AXIS_IDX                              5
#define SBK_QXMLITEM_IDX                                             6
#define SBK_QABSTRACTXMLNODEMODEL_IDX                                7
#define SBK_QABSTRACTXMLNODEMODEL_SIMPLEAXIS_IDX                     8
#define SBK_QABSTRACTXMLNODEMODEL_NODECOPYSETTING_IDX                9
#define SBK_QABSTRACTXMLRECEIVER_IDX                                 10
#define SBK_QXMLSERIALIZER_IDX                                       11
#define SBK_QABSTRACTURIRESOLVER_IDX                                 12
#define SBK_QXMLSCHEMAVALIDATOR_IDX                                  13
#define SBK_QXMLSCHEMA_IDX                                           14
#define SBK_QXMLQUERY_IDX                                            15
#define SBK_QXMLQUERY_QUERYLANGUAGE_IDX                              16
#define SBK_QXMLFORMATTER_IDX                                        17
#define SBK_QSOURCELOCATION_IDX                                      18
#define SBK_QABSTRACTMESSAGEHANDLER_IDX                              19
#define SBK_QXMLNAME_IDX                                             20
#define SBK_QtXmlPatterns_IDX_COUNT                                  21

// This variable stores all python types exported by this module
extern PyTypeObject** SbkPySide_QtXmlPatternsTypes;

// Macros for type check
#define SbkQXmlNamePool_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtXmlPatternsTypes[SBK_QXMLNAMEPOOL_IDX])
#define SbkQXmlResultItems_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtXmlPatternsTypes[SBK_QXMLRESULTITEMS_IDX])
#define SbkPySide_QtXmlPatterns_QXmlNodeModelIndex_NodeKind_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_NODEKIND_IDX])
#define SbkPySide_QtXmlPatterns_QXmlNodeModelIndex_DocumentOrder_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_DOCUMENTORDER_IDX])
#define SbkPySide_QtXmlPatterns_QXmlNodeModelIndex_Axis_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_AXIS_IDX])
#define SbkQXmlNodeModelIndex_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_IDX])
#define SbkQXmlItem_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtXmlPatternsTypes[SBK_QXMLITEM_IDX])
#define SbkPySide_QtXmlPatterns_QAbstractXmlNodeModel_SimpleAxis_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtXmlPatternsTypes[SBK_QABSTRACTXMLNODEMODEL_SIMPLEAXIS_IDX])
#define SbkPySide_QtXmlPatterns_QAbstractXmlNodeModel_NodeCopySetting_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtXmlPatternsTypes[SBK_QABSTRACTXMLNODEMODEL_NODECOPYSETTING_IDX])
#define SbkQAbstractXmlNodeModel_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtXmlPatternsTypes[SBK_QABSTRACTXMLNODEMODEL_IDX])
#define SbkQAbstractXmlReceiver_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtXmlPatternsTypes[SBK_QABSTRACTXMLRECEIVER_IDX])
#define SbkQXmlSerializer_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtXmlPatternsTypes[SBK_QXMLSERIALIZER_IDX])
#define SbkQAbstractUriResolver_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtXmlPatternsTypes[SBK_QABSTRACTURIRESOLVER_IDX])
#define SbkQXmlSchemaValidator_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtXmlPatternsTypes[SBK_QXMLSCHEMAVALIDATOR_IDX])
#define SbkQXmlSchema_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtXmlPatternsTypes[SBK_QXMLSCHEMA_IDX])
#define SbkPySide_QtXmlPatterns_QXmlQuery_QueryLanguage_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtXmlPatternsTypes[SBK_QXMLQUERY_QUERYLANGUAGE_IDX])
#define SbkQXmlQuery_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtXmlPatternsTypes[SBK_QXMLQUERY_IDX])
#define SbkQXmlFormatter_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtXmlPatternsTypes[SBK_QXMLFORMATTER_IDX])
#define SbkQSourceLocation_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtXmlPatternsTypes[SBK_QSOURCELOCATION_IDX])
#define SbkQAbstractMessageHandler_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtXmlPatternsTypes[SBK_QABSTRACTMESSAGEHANDLER_IDX])
#define SbkQXmlName_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtXmlPatternsTypes[SBK_QXMLNAME_IDX])

namespace Shiboken
{

// PyType functions, to get the PyObjectType for a type T
template<> inline PyTypeObject* SbkType<QXmlNamePool >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtXmlPatternsTypes[SBK_QXMLNAMEPOOL_IDX]); }
template<> inline PyTypeObject* SbkType<QXmlResultItems >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtXmlPatternsTypes[SBK_QXMLRESULTITEMS_IDX]); }
template<> inline PyTypeObject* SbkType<QXmlNodeModelIndex::NodeKind >() { return SbkPySide_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_NODEKIND_IDX]; }
template<> inline PyTypeObject* SbkType<QXmlNodeModelIndex::DocumentOrder >() { return SbkPySide_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_DOCUMENTORDER_IDX]; }
template<> inline PyTypeObject* SbkType<QXmlNodeModelIndex::Axis >() { return SbkPySide_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_AXIS_IDX]; }
template<> inline PyTypeObject* SbkType<QXmlNodeModelIndex >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtXmlPatternsTypes[SBK_QXMLNODEMODELINDEX_IDX]); }
template<> inline PyTypeObject* SbkType<QXmlItem >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtXmlPatternsTypes[SBK_QXMLITEM_IDX]); }
template<> inline PyTypeObject* SbkType<QAbstractXmlNodeModel::SimpleAxis >() { return SbkPySide_QtXmlPatternsTypes[SBK_QABSTRACTXMLNODEMODEL_SIMPLEAXIS_IDX]; }
template<> inline PyTypeObject* SbkType<QAbstractXmlNodeModel::NodeCopySetting >() { return SbkPySide_QtXmlPatternsTypes[SBK_QABSTRACTXMLNODEMODEL_NODECOPYSETTING_IDX]; }
template<> inline PyTypeObject* SbkType<QAbstractXmlNodeModel >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtXmlPatternsTypes[SBK_QABSTRACTXMLNODEMODEL_IDX]); }
template<> inline PyTypeObject* SbkType<QAbstractXmlReceiver >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtXmlPatternsTypes[SBK_QABSTRACTXMLRECEIVER_IDX]); }
template<> inline PyTypeObject* SbkType<QXmlSerializer >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtXmlPatternsTypes[SBK_QXMLSERIALIZER_IDX]); }
template<> inline PyTypeObject* SbkType<QAbstractUriResolver >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtXmlPatternsTypes[SBK_QABSTRACTURIRESOLVER_IDX]); }
template<> inline PyTypeObject* SbkType<QXmlSchemaValidator >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtXmlPatternsTypes[SBK_QXMLSCHEMAVALIDATOR_IDX]); }
template<> inline PyTypeObject* SbkType<QXmlSchema >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtXmlPatternsTypes[SBK_QXMLSCHEMA_IDX]); }
template<> inline PyTypeObject* SbkType<QXmlQuery::QueryLanguage >() { return SbkPySide_QtXmlPatternsTypes[SBK_QXMLQUERY_QUERYLANGUAGE_IDX]; }
template<> inline PyTypeObject* SbkType<QXmlQuery >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtXmlPatternsTypes[SBK_QXMLQUERY_IDX]); }
template<> inline PyTypeObject* SbkType<QXmlFormatter >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtXmlPatternsTypes[SBK_QXMLFORMATTER_IDX]); }
template<> inline PyTypeObject* SbkType<QSourceLocation >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtXmlPatternsTypes[SBK_QSOURCELOCATION_IDX]); }
template<> inline PyTypeObject* SbkType<QAbstractMessageHandler >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtXmlPatternsTypes[SBK_QABSTRACTMESSAGEHANDLER_IDX]); }
template<> inline PyTypeObject* SbkType<QXmlName >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtXmlPatternsTypes[SBK_QXMLNAME_IDX]); }

// Generated converters declarations ----------------------------------

template<>
struct Converter<QXmlNamePool > : ValueTypeConverter<QXmlNamePool >
{
};

template<>
struct Converter<QXmlResultItems* > : ObjectTypeConverter<QXmlResultItems >
{
};

template<>
struct Converter<QXmlResultItems& > : ObjectTypeReferenceConverter<QXmlResultItems >
{
};

template<>
struct Converter<QXmlNodeModelIndex::NodeKind > : EnumConverter<QXmlNodeModelIndex::NodeKind >
{
};

template<>
struct Converter<QXmlNodeModelIndex::DocumentOrder > : EnumConverter<QXmlNodeModelIndex::DocumentOrder >
{
};

template<>
struct Converter<QXmlNodeModelIndex::Axis > : EnumConverter<QXmlNodeModelIndex::Axis >
{
};

template<>
struct Converter<QXmlNodeModelIndex > : ValueTypeConverter<QXmlNodeModelIndex >
{
};

template<>
struct Converter<QXmlItem > : ValueTypeConverter<QXmlItem >
{
    static QXmlItem toCpp(PyObject* pyobj);
    static bool isConvertible(PyObject* pyobj);
};

template<>
struct Converter<QAbstractXmlNodeModel::SimpleAxis > : EnumConverter<QAbstractXmlNodeModel::SimpleAxis >
{
};

template<>
struct Converter<QAbstractXmlNodeModel::NodeCopySetting > : EnumConverter<QAbstractXmlNodeModel::NodeCopySetting >
{
};

template<>
struct Converter<QAbstractXmlNodeModel* > : ObjectTypeConverter<QAbstractXmlNodeModel >
{
};

template<>
struct Converter<QAbstractXmlNodeModel& > : ObjectTypeReferenceConverter<QAbstractXmlNodeModel >
{
};

template<>
struct Converter<QAbstractXmlReceiver* > : ObjectTypeConverter<QAbstractXmlReceiver >
{
};

template<>
struct Converter<QAbstractXmlReceiver& > : ObjectTypeReferenceConverter<QAbstractXmlReceiver >
{
};

template<>
struct Converter<QXmlSerializer* > : ObjectTypeConverter<QXmlSerializer >
{
};

template<>
struct Converter<QXmlSerializer& > : ObjectTypeReferenceConverter<QXmlSerializer >
{
};

template<>
struct Converter<QAbstractUriResolver* > : ObjectTypeConverter<QAbstractUriResolver >
{
};

template<>
struct Converter<QAbstractUriResolver& > : ObjectTypeReferenceConverter<QAbstractUriResolver >
{
};

template<>
struct Converter<QXmlSchemaValidator* > : ObjectTypeConverter<QXmlSchemaValidator >
{
};

template<>
struct Converter<QXmlSchemaValidator& > : ObjectTypeReferenceConverter<QXmlSchemaValidator >
{
};

template<>
struct Converter<QXmlSchema > : ValueTypeConverter<QXmlSchema >
{
};

template<>
struct Converter<QXmlQuery::QueryLanguage > : EnumConverter<QXmlQuery::QueryLanguage >
{
};

template<>
struct Converter<QXmlQuery > : ValueTypeConverter<QXmlQuery >
{
    static QXmlQuery toCpp(PyObject* pyobj);
    static bool isConvertible(PyObject* pyobj);
};

template<>
struct Converter<QXmlFormatter* > : ObjectTypeConverter<QXmlFormatter >
{
};

template<>
struct Converter<QXmlFormatter& > : ObjectTypeReferenceConverter<QXmlFormatter >
{
};

template<>
struct Converter<QSourceLocation > : ValueTypeConverter<QSourceLocation >
{
    static QSourceLocation toCpp(PyObject* pyobj);
    static bool isConvertible(PyObject* pyobj);
};

template<>
struct Converter<QAbstractMessageHandler* > : ObjectTypeConverter<QAbstractMessageHandler >
{
};

template<>
struct Converter<QAbstractMessageHandler& > : ObjectTypeReferenceConverter<QAbstractMessageHandler >
{
};

template<>
struct Converter<QXmlName > : ValueTypeConverter<QXmlName >
{
};

} // namespace Shiboken

// User defined converters --------------------------------------------
// Generated converters implemantations -------------------------------

inline bool Shiboken::Converter<QXmlItem >::isConvertible(PyObject* pyobj)
{
    if (ValueTypeConverter<QXmlItem >::isConvertible(pyobj))
        return true;
    SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QXmlItem >());
    return Shiboken::Converter<QVariant & >::isConvertible(pyobj)
         || Shiboken::Converter<QXmlNodeModelIndex & >::isConvertible(pyobj)
         || (shiboType->ext_isconvertible && shiboType->ext_isconvertible(pyobj));
}

inline QXmlItem Shiboken::Converter<QXmlItem >::toCpp(PyObject* pyobj)
{
    if (!Shiboken_TypeCheck(pyobj, QXmlItem)) {
        SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QXmlItem >());
        if (Shiboken::Converter<QVariant & >::isConvertible(pyobj))
            return QXmlItem(Shiboken::Converter<QVariant & >::toCpp(pyobj));
        else if (Shiboken::Converter<QXmlNodeModelIndex & >::isConvertible(pyobj))
            return QXmlItem(Shiboken::Converter<QXmlNodeModelIndex & >::toCpp(pyobj));
        else if (shiboType->ext_isconvertible && shiboType->ext_tocpp && shiboType->ext_isconvertible(pyobj)) {
            QXmlItem* cptr = reinterpret_cast<QXmlItem*>(shiboType->ext_tocpp(pyobj));
            std::auto_ptr<QXmlItem > cptr_auto_ptr(cptr);
            return *cptr;
        }
    }
    return *Shiboken::Converter<QXmlItem* >::toCpp((PyObject*)pyobj);
}

inline bool Shiboken::Converter<QXmlQuery >::isConvertible(PyObject* pyobj)
{
    if (ValueTypeConverter<QXmlQuery >::isConvertible(pyobj))
        return true;
    SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QXmlQuery >());
    return Shiboken::Converter<QXmlQuery::QueryLanguage >::isConvertible(pyobj)
         || Shiboken::Converter<QXmlNamePool & >::isConvertible(pyobj)
         || (shiboType->ext_isconvertible && shiboType->ext_isconvertible(pyobj));
}

inline QXmlQuery Shiboken::Converter<QXmlQuery >::toCpp(PyObject* pyobj)
{
    if (!Shiboken_TypeCheck(pyobj, QXmlQuery)) {
        SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QXmlQuery >());
        if (Shiboken::Converter<QXmlQuery::QueryLanguage >::isConvertible(pyobj))
            return QXmlQuery(Shiboken::Converter<QXmlQuery::QueryLanguage >::toCpp(pyobj));
        else if (Shiboken::Converter<QXmlNamePool & >::isConvertible(pyobj))
            return QXmlQuery(Shiboken::Converter<QXmlNamePool & >::toCpp(pyobj));
        else if (shiboType->ext_isconvertible && shiboType->ext_tocpp && shiboType->ext_isconvertible(pyobj)) {
            QXmlQuery* cptr = reinterpret_cast<QXmlQuery*>(shiboType->ext_tocpp(pyobj));
            std::auto_ptr<QXmlQuery > cptr_auto_ptr(cptr);
            return *cptr;
        }
    }
    return *Shiboken::Converter<QXmlQuery* >::toCpp((PyObject*)pyobj);
}

inline bool Shiboken::Converter<QSourceLocation >::isConvertible(PyObject* pyobj)
{
    if (ValueTypeConverter<QSourceLocation >::isConvertible(pyobj))
        return true;
    SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QSourceLocation >());
    return Shiboken::Converter<QUrl & >::isConvertible(pyobj)
         || (shiboType->ext_isconvertible && shiboType->ext_isconvertible(pyobj));
}

inline QSourceLocation Shiboken::Converter<QSourceLocation >::toCpp(PyObject* pyobj)
{
    if (!Shiboken_TypeCheck(pyobj, QSourceLocation)) {
        SbkBaseWrapperType* shiboType = reinterpret_cast<SbkBaseWrapperType*>(SbkType<QSourceLocation >());
        if (Shiboken::Converter<QUrl & >::isConvertible(pyobj))
            return QSourceLocation(Shiboken::Converter<QUrl & >::toCpp(pyobj));
        else if (shiboType->ext_isconvertible && shiboType->ext_tocpp && shiboType->ext_isconvertible(pyobj)) {
            QSourceLocation* cptr = reinterpret_cast<QSourceLocation*>(shiboType->ext_tocpp(pyobj));
            std::auto_ptr<QSourceLocation > cptr_auto_ptr(cptr);
            return *cptr;
        }
    }
    return *Shiboken::Converter<QSourceLocation* >::toCpp((PyObject*)pyobj);
}


#endif // SBK_QTXMLPATTERNS_PYTHON_H

