/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */



#ifndef SBK_QTXML_PYTHON_H
#define SBK_QTXML_PYTHON_H

//workaround to access protected functions
#define protected public

#include <Python.h>
#include <conversions.h>
#include <pyenum.h>
#include <basewrapper.h>
#include <bindingmanager.h>
#include <memory>

#if defined _WIN32 || defined __CYGWIN__
    #define SHIBOKEN_QTXML_API __declspec(dllexport)
#else
#if __GNUC__ >= 4
    #define SHIBOKEN_QTXML_API __attribute__ ((visibility("default")))
#else
    #define SHIBOKEN_QTXML_API
#endif
#endif

// Module Includes
#include <pyside_qtcore_python.h>

// Binded library includes
#include <qdom.h>
#include <qxml.h>
// Conversion Includes - Primitive Types
#include <QTextDocument>
#include <QtConcurrentFilter>

// Conversion Includes - Container Types
#include <QList>
#include <QMap>
#include <QMultiMap>
#include <QVector>
#include <QPair>
#include <pysideconversions.h>
#include <QSet>
#include <qqueue.h>

// Type indices
#define SBK_QXMLENTITYRESOLVER_IDX                                   0
#define SBK_QXMLATTRIBUTES_IDX                                       1
#define SBK_QXMLLEXICALHANDLER_IDX                                   2
#define SBK_QDOMNODELIST_IDX                                         3
#define SBK_QXMLDECLHANDLER_IDX                                      4
#define SBK_QDOMNAMEDNODEMAP_IDX                                     5
#define SBK_QXMLLOCATOR_IDX                                          6
#define SBK_QXMLREADER_IDX                                           7
#define SBK_QXMLSIMPLEREADER_IDX                                     8
#define SBK_QXMLDTDHANDLER_IDX                                       9
#define SBK_QXMLNAMESPACESUPPORT_IDX                                 10
#define SBK_QDOMIMPLEMENTATION_IDX                                   11
#define SBK_QDOMIMPLEMENTATION_INVALIDDATAPOLICY_IDX                 12
#define SBK_QXMLERRORHANDLER_IDX                                     13
#define SBK_QXMLCONTENTHANDLER_IDX                                   14
#define SBK_QXMLDEFAULTHANDLER_IDX                                   15
#define SBK_QXMLINPUTSOURCE_IDX                                      16
#define SBK_QDOMNODE_IDX                                             17
#define SBK_QDOMNODE_NODETYPE_IDX                                    18
#define SBK_QDOMNODE_ENCODINGPOLICY_IDX                              19
#define SBK_QDOMELEMENT_IDX                                          20
#define SBK_QDOMATTR_IDX                                             21
#define SBK_QDOMDOCUMENTFRAGMENT_IDX                                 22
#define SBK_QDOMNOTATION_IDX                                         23
#define SBK_QDOMPROCESSINGINSTRUCTION_IDX                            24
#define SBK_QDOMENTITY_IDX                                           25
#define SBK_QDOMDOCUMENT_IDX                                         26
#define SBK_QDOMDOCUMENTTYPE_IDX                                     27
#define SBK_QDOMENTITYREFERENCE_IDX                                  28
#define SBK_QXMLPARSEEXCEPTION_IDX                                   29
#define SBK_QDOMCHARACTERDATA_IDX                                    30
#define SBK_QDOMTEXT_IDX                                             31
#define SBK_QDOMCDATASECTION_IDX                                     32
#define SBK_QDOMCOMMENT_IDX                                          33
#define SBK_QtXml_IDX_COUNT                                          34

// This variable stores all python types exported by this module
extern PyTypeObject** SbkPySide_QtXmlTypes;

// Macros for type check
#define SbkQXmlEntityResolver_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtXmlTypes[SBK_QXMLENTITYRESOLVER_IDX])
#define SbkQXmlAttributes_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtXmlTypes[SBK_QXMLATTRIBUTES_IDX])
#define SbkQXmlLexicalHandler_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtXmlTypes[SBK_QXMLLEXICALHANDLER_IDX])
#define SbkQDomNodeList_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtXmlTypes[SBK_QDOMNODELIST_IDX])
#define SbkQXmlDeclHandler_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtXmlTypes[SBK_QXMLDECLHANDLER_IDX])
#define SbkQDomNamedNodeMap_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtXmlTypes[SBK_QDOMNAMEDNODEMAP_IDX])
#define SbkQXmlLocator_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtXmlTypes[SBK_QXMLLOCATOR_IDX])
#define SbkQXmlReader_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtXmlTypes[SBK_QXMLREADER_IDX])
#define SbkQXmlSimpleReader_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtXmlTypes[SBK_QXMLSIMPLEREADER_IDX])
#define SbkQXmlDTDHandler_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtXmlTypes[SBK_QXMLDTDHANDLER_IDX])
#define SbkQXmlNamespaceSupport_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtXmlTypes[SBK_QXMLNAMESPACESUPPORT_IDX])
#define SbkPySide_QtXml_QDomImplementation_InvalidDataPolicy_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtXmlTypes[SBK_QDOMIMPLEMENTATION_INVALIDDATAPOLICY_IDX])
#define SbkQDomImplementation_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtXmlTypes[SBK_QDOMIMPLEMENTATION_IDX])
#define SbkQXmlErrorHandler_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtXmlTypes[SBK_QXMLERRORHANDLER_IDX])
#define SbkQXmlContentHandler_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtXmlTypes[SBK_QXMLCONTENTHANDLER_IDX])
#define SbkQXmlDefaultHandler_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtXmlTypes[SBK_QXMLDEFAULTHANDLER_IDX])
#define SbkQXmlInputSource_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtXmlTypes[SBK_QXMLINPUTSOURCE_IDX])
#define SbkPySide_QtXml_QDomNode_NodeType_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtXmlTypes[SBK_QDOMNODE_NODETYPE_IDX])
#define SbkPySide_QtXml_QDomNode_EncodingPolicy_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtXmlTypes[SBK_QDOMNODE_ENCODINGPOLICY_IDX])
#define SbkQDomNode_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtXmlTypes[SBK_QDOMNODE_IDX])
#define SbkQDomElement_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtXmlTypes[SBK_QDOMELEMENT_IDX])
#define SbkQDomAttr_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtXmlTypes[SBK_QDOMATTR_IDX])
#define SbkQDomDocumentFragment_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtXmlTypes[SBK_QDOMDOCUMENTFRAGMENT_IDX])
#define SbkQDomNotation_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtXmlTypes[SBK_QDOMNOTATION_IDX])
#define SbkQDomProcessingInstruction_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtXmlTypes[SBK_QDOMPROCESSINGINSTRUCTION_IDX])
#define SbkQDomEntity_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtXmlTypes[SBK_QDOMENTITY_IDX])
#define SbkQDomDocument_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtXmlTypes[SBK_QDOMDOCUMENT_IDX])
#define SbkQDomDocumentType_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtXmlTypes[SBK_QDOMDOCUMENTTYPE_IDX])
#define SbkQDomEntityReference_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtXmlTypes[SBK_QDOMENTITYREFERENCE_IDX])
#define SbkQXmlParseException_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtXmlTypes[SBK_QXMLPARSEEXCEPTION_IDX])
#define SbkQDomCharacterData_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtXmlTypes[SBK_QDOMCHARACTERDATA_IDX])
#define SbkQDomText_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtXmlTypes[SBK_QDOMTEXT_IDX])
#define SbkQDomCDATASection_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtXmlTypes[SBK_QDOMCDATASECTION_IDX])
#define SbkQDomComment_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtXmlTypes[SBK_QDOMCOMMENT_IDX])

namespace Shiboken
{

// PyType functions, to get the PyObjectType for a type T
template<> inline PyTypeObject* SbkType<QXmlEntityResolver >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtXmlTypes[SBK_QXMLENTITYRESOLVER_IDX]); }
template<> inline PyTypeObject* SbkType<QXmlAttributes >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtXmlTypes[SBK_QXMLATTRIBUTES_IDX]); }
template<> inline PyTypeObject* SbkType<QXmlLexicalHandler >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtXmlTypes[SBK_QXMLLEXICALHANDLER_IDX]); }
template<> inline PyTypeObject* SbkType<QDomNodeList >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtXmlTypes[SBK_QDOMNODELIST_IDX]); }
template<> inline PyTypeObject* SbkType<QXmlDeclHandler >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtXmlTypes[SBK_QXMLDECLHANDLER_IDX]); }
template<> inline PyTypeObject* SbkType<QDomNamedNodeMap >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtXmlTypes[SBK_QDOMNAMEDNODEMAP_IDX]); }
template<> inline PyTypeObject* SbkType<QXmlLocator >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtXmlTypes[SBK_QXMLLOCATOR_IDX]); }
template<> inline PyTypeObject* SbkType<QXmlReader >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtXmlTypes[SBK_QXMLREADER_IDX]); }
template<> inline PyTypeObject* SbkType<QXmlSimpleReader >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtXmlTypes[SBK_QXMLSIMPLEREADER_IDX]); }
template<> inline PyTypeObject* SbkType<QXmlDTDHandler >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtXmlTypes[SBK_QXMLDTDHANDLER_IDX]); }
template<> inline PyTypeObject* SbkType<QXmlNamespaceSupport >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtXmlTypes[SBK_QXMLNAMESPACESUPPORT_IDX]); }
template<> inline PyTypeObject* SbkType<QDomImplementation::InvalidDataPolicy >() { return SbkPySide_QtXmlTypes[SBK_QDOMIMPLEMENTATION_INVALIDDATAPOLICY_IDX]; }
template<> inline PyTypeObject* SbkType<QDomImplementation >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtXmlTypes[SBK_QDOMIMPLEMENTATION_IDX]); }
template<> inline PyTypeObject* SbkType<QXmlErrorHandler >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtXmlTypes[SBK_QXMLERRORHANDLER_IDX]); }
template<> inline PyTypeObject* SbkType<QXmlContentHandler >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtXmlTypes[SBK_QXMLCONTENTHANDLER_IDX]); }
template<> inline PyTypeObject* SbkType<QXmlDefaultHandler >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtXmlTypes[SBK_QXMLDEFAULTHANDLER_IDX]); }
template<> inline PyTypeObject* SbkType<QXmlInputSource >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtXmlTypes[SBK_QXMLINPUTSOURCE_IDX]); }
template<> inline PyTypeObject* SbkType<QDomNode::NodeType >() { return SbkPySide_QtXmlTypes[SBK_QDOMNODE_NODETYPE_IDX]; }
template<> inline PyTypeObject* SbkType<QDomNode::EncodingPolicy >() { return SbkPySide_QtXmlTypes[SBK_QDOMNODE_ENCODINGPOLICY_IDX]; }
template<> inline PyTypeObject* SbkType<QDomNode >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtXmlTypes[SBK_QDOMNODE_IDX]); }
template<> inline PyTypeObject* SbkType<QDomElement >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtXmlTypes[SBK_QDOMELEMENT_IDX]); }
template<> inline PyTypeObject* SbkType<QDomAttr >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtXmlTypes[SBK_QDOMATTR_IDX]); }
template<> inline PyTypeObject* SbkType<QDomDocumentFragment >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtXmlTypes[SBK_QDOMDOCUMENTFRAGMENT_IDX]); }
template<> inline PyTypeObject* SbkType<QDomNotation >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtXmlTypes[SBK_QDOMNOTATION_IDX]); }
template<> inline PyTypeObject* SbkType<QDomProcessingInstruction >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtXmlTypes[SBK_QDOMPROCESSINGINSTRUCTION_IDX]); }
template<> inline PyTypeObject* SbkType<QDomEntity >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtXmlTypes[SBK_QDOMENTITY_IDX]); }
template<> inline PyTypeObject* SbkType<QDomDocument >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtXmlTypes[SBK_QDOMDOCUMENT_IDX]); }
template<> inline PyTypeObject* SbkType<QDomDocumentType >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtXmlTypes[SBK_QDOMDOCUMENTTYPE_IDX]); }
template<> inline PyTypeObject* SbkType<QDomEntityReference >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtXmlTypes[SBK_QDOMENTITYREFERENCE_IDX]); }
template<> inline PyTypeObject* SbkType<QXmlParseException >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtXmlTypes[SBK_QXMLPARSEEXCEPTION_IDX]); }
template<> inline PyTypeObject* SbkType<QDomCharacterData >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtXmlTypes[SBK_QDOMCHARACTERDATA_IDX]); }
template<> inline PyTypeObject* SbkType<QDomText >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtXmlTypes[SBK_QDOMTEXT_IDX]); }
template<> inline PyTypeObject* SbkType<QDomCDATASection >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtXmlTypes[SBK_QDOMCDATASECTION_IDX]); }
template<> inline PyTypeObject* SbkType<QDomComment >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtXmlTypes[SBK_QDOMCOMMENT_IDX]); }

// Generated converters declarations ----------------------------------

template<>
struct Converter<QXmlEntityResolver* > : ObjectTypeConverter<QXmlEntityResolver >
{
};

template<>
struct Converter<QXmlEntityResolver& > : ObjectTypeReferenceConverter<QXmlEntityResolver >
{
};

template <>
struct SbkTypeInfo<QXmlAttributes >
{
    static const bool isCppWrapper = true;
};
template<>
struct Converter<QXmlAttributes > : ValueTypeConverter<QXmlAttributes >
{
};

template<>
struct Converter<QXmlLexicalHandler* > : ObjectTypeConverter<QXmlLexicalHandler >
{
};

template<>
struct Converter<QXmlLexicalHandler& > : ObjectTypeReferenceConverter<QXmlLexicalHandler >
{
};

template<>
struct Converter<QDomNodeList > : ValueTypeConverter<QDomNodeList >
{
};

template<>
struct Converter<QXmlDeclHandler* > : ObjectTypeConverter<QXmlDeclHandler >
{
};

template<>
struct Converter<QXmlDeclHandler& > : ObjectTypeReferenceConverter<QXmlDeclHandler >
{
};

template<>
struct Converter<QDomNamedNodeMap > : ValueTypeConverter<QDomNamedNodeMap >
{
};

template<>
struct Converter<QXmlLocator* > : ObjectTypeConverter<QXmlLocator >
{
};

template<>
struct Converter<QXmlLocator& > : ObjectTypeReferenceConverter<QXmlLocator >
{
};

template<>
struct Converter<QXmlReader* > : ObjectTypeConverter<QXmlReader >
{
};

template<>
struct Converter<QXmlReader& > : ObjectTypeReferenceConverter<QXmlReader >
{
};

template<>
struct Converter<QXmlSimpleReader* > : ObjectTypeConverter<QXmlSimpleReader >
{
};

template<>
struct Converter<QXmlSimpleReader& > : ObjectTypeReferenceConverter<QXmlSimpleReader >
{
};

template<>
struct Converter<QXmlDTDHandler* > : ObjectTypeConverter<QXmlDTDHandler >
{
};

template<>
struct Converter<QXmlDTDHandler& > : ObjectTypeReferenceConverter<QXmlDTDHandler >
{
};

template<>
struct Converter<QXmlNamespaceSupport* > : ObjectTypeConverter<QXmlNamespaceSupport >
{
};

template<>
struct Converter<QXmlNamespaceSupport& > : ObjectTypeReferenceConverter<QXmlNamespaceSupport >
{
};

template<>
struct Converter<QDomImplementation::InvalidDataPolicy > : EnumConverter<QDomImplementation::InvalidDataPolicy >
{
};

template<>
struct Converter<QDomImplementation > : ValueTypeConverter<QDomImplementation >
{
};

template<>
struct Converter<QXmlErrorHandler* > : ObjectTypeConverter<QXmlErrorHandler >
{
};

template<>
struct Converter<QXmlErrorHandler& > : ObjectTypeReferenceConverter<QXmlErrorHandler >
{
};

template<>
struct Converter<QXmlContentHandler* > : ObjectTypeConverter<QXmlContentHandler >
{
};

template<>
struct Converter<QXmlContentHandler& > : ObjectTypeReferenceConverter<QXmlContentHandler >
{
};

template<>
struct Converter<QXmlDefaultHandler* > : ObjectTypeConverter<QXmlDefaultHandler >
{
};

template<>
struct Converter<QXmlDefaultHandler& > : ObjectTypeReferenceConverter<QXmlDefaultHandler >
{
};

template<>
struct Converter<QXmlInputSource* > : ObjectTypeConverter<QXmlInputSource >
{
};

template<>
struct Converter<QXmlInputSource& > : ObjectTypeReferenceConverter<QXmlInputSource >
{
};

template<>
struct Converter<QDomNode::NodeType > : EnumConverter<QDomNode::NodeType >
{
};

template<>
struct Converter<QDomNode::EncodingPolicy > : EnumConverter<QDomNode::EncodingPolicy >
{
};

template<>
struct Converter<QDomNode > : ValueTypeConverter<QDomNode >
{
};

template<>
struct Converter<QDomElement > : ValueTypeConverter<QDomElement >
{
};

template<>
struct Converter<QDomAttr > : ValueTypeConverter<QDomAttr >
{
};

template<>
struct Converter<QDomDocumentFragment > : ValueTypeConverter<QDomDocumentFragment >
{
};

template<>
struct Converter<QDomNotation > : ValueTypeConverter<QDomNotation >
{
};

template<>
struct Converter<QDomProcessingInstruction > : ValueTypeConverter<QDomProcessingInstruction >
{
};

template<>
struct Converter<QDomEntity > : ValueTypeConverter<QDomEntity >
{
};

template<>
struct Converter<QDomDocument > : ValueTypeConverter<QDomDocument >
{
};

template<>
struct Converter<QDomDocumentType > : ValueTypeConverter<QDomDocumentType >
{
};

template<>
struct Converter<QDomEntityReference > : ValueTypeConverter<QDomEntityReference >
{
};

template<>
struct Converter<QXmlParseException > : ValueTypeConverter<QXmlParseException >
{
};

template<>
struct Converter<QDomCharacterData > : ValueTypeConverter<QDomCharacterData >
{
};

template<>
struct Converter<QDomText > : ValueTypeConverter<QDomText >
{
};

template<>
struct Converter<QDomCDATASection > : ValueTypeConverter<QDomCDATASection >
{
};

template<>
struct Converter<QDomComment > : ValueTypeConverter<QDomComment >
{
};

} // namespace Shiboken

// User defined converters --------------------------------------------
// Generated converters implemantations -------------------------------


#endif // SBK_QTXML_PYTHON_H

