/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */



#ifndef SBK_QTUITOOLS_PYTHON_H
#define SBK_QTUITOOLS_PYTHON_H

//workaround to access protected functions
#define protected public

#include <Python.h>
#include <conversions.h>
#include <pyenum.h>
#include <basewrapper.h>
#include <bindingmanager.h>
#include <memory>

#if defined _WIN32 || defined __CYGWIN__
    #define SHIBOKEN_QTUITOOLS_API __declspec(dllexport)
#else
#if __GNUC__ >= 4
    #define SHIBOKEN_QTUITOOLS_API __attribute__ ((visibility("default")))
#else
    #define SHIBOKEN_QTUITOOLS_API
#endif
#endif

// Module Includes
#include <pyside_qtgui_python.h>
#include <pyside_qtcore_python.h>
#include <pyside_qtxml_python.h>

// Binded library includes
#include <quiloader.h>
// Conversion Includes - Primitive Types
#include <QTextDocument>
#include <QtConcurrentFilter>

// Conversion Includes - Container Types
#include <QMap>
#include <QVector>
#include <QSet>
#include <QPair>
#include <pysideconversions.h>
#include <qqueue.h>
#include <QList>
#include <QMultiMap>

// Type indices
#define SBK_QUILOADER_IDX                                            0
#define SBK_QtUiTools_IDX_COUNT                                      1

// This variable stores all python types exported by this module
extern PyTypeObject** SbkPySide_QtUiToolsTypes;

// Macros for type check
#define SbkQUiLoader_Check(op) PyObject_TypeCheck(op, (PyTypeObject*)SbkPySide_QtUiToolsTypes[SBK_QUILOADER_IDX])

namespace Shiboken
{

// PyType functions, to get the PyObjectType for a type T
template<> inline PyTypeObject* SbkType<QUiLoader >() { return reinterpret_cast<PyTypeObject*>(SbkPySide_QtUiToolsTypes[SBK_QUILOADER_IDX]); }

// Generated converters declarations ----------------------------------

template<>
struct Converter<QUiLoader* > : ObjectTypeConverter<QUiLoader >
{
};

template<>
struct Converter<QUiLoader& > : ObjectTypeReferenceConverter<QUiLoader >
{
};

} // namespace Shiboken

// User defined converters --------------------------------------------
// Generated converters implemantations -------------------------------


#endif // SBK_QTUITOOLS_PYTHON_H

