/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtscript_python.h"

#include "qscriptprogram_wrapper.h"

// Extra includes
#include <qscriptprogram.h>
#include <qstring.h>

using namespace Shiboken;

static int
SbkQScriptProgram_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QScriptProgram* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "QScriptProgram", 0, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return -1;

    if (numArgs == 0) {
        // QScriptProgram()
        cptr = new QScriptProgram();
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QString & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // QScriptProgram(QString,QString,int)
            cptr = new QScriptProgram(*cpp_arg0);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QString >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return -1;
            std::auto_ptr<QString > cpp_arg1_auto_ptr;
            QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
            if (!SbkQString_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
            if (numArgs == 2) {
                // QScriptProgram(QString,QString,int)
                cptr = new QScriptProgram(*cpp_arg0, *cpp_arg1);
                //CppGenerator::writeParentChildManagement
            } else if (PyNumber_Check(pyargs[2])) {
                int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
                // QScriptProgram(QString,QString,int)
                cptr = new QScriptProgram(*cpp_arg0, *cpp_arg1, cpp_arg2);
                //CppGenerator::writeParentChildManagement
            } else goto SbkQScriptProgram_Init_TypeError;
        } else goto SbkQScriptProgram_Init_TypeError;
    } else if (numArgs == 1 && Shiboken::Converter<QScriptProgram & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QScriptProgram* cpp_arg0 = Shiboken::Converter<QScriptProgram* >::toCpp(pyargs[0]);
        // QScriptProgram(QScriptProgram)
        cptr = new QScriptProgram(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQScriptProgram_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QScriptProgram >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQScriptProgram_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQScriptProgram_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtScript.QScriptProgram", "PySide.QtCore.QString, PySide.QtCore.QString = QString(), int = 1", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtScript.QScriptProgram", overloads);
        return -1;
}

static PyObject* SbkQScriptProgramFunc_fileName(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // fileName()const
    QScriptProgram* cppSelf = Shiboken::Converter<QScriptProgram* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QScriptProgram::fileName();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQScriptProgramFunc_firstLineNumber(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // firstLineNumber()const
    QScriptProgram* cppSelf = Shiboken::Converter<QScriptProgram* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QScriptProgram::firstLineNumber();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQScriptProgramFunc_isNull(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isNull()const
    QScriptProgram* cppSelf = Shiboken::Converter<QScriptProgram* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QScriptProgram::isNull();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQScriptProgramFunc_sourceCode(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // sourceCode()const
    QScriptProgram* cppSelf = Shiboken::Converter<QScriptProgram* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QScriptProgram::sourceCode();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQScriptProgram_methods[] = {
    {"fileName", (PyCFunction)SbkQScriptProgramFunc_fileName, METH_NOARGS},
    {"firstLineNumber", (PyCFunction)SbkQScriptProgramFunc_firstLineNumber, METH_NOARGS},
    {"isNull", (PyCFunction)SbkQScriptProgramFunc_isNull, METH_NOARGS},
    {"sourceCode", (PyCFunction)SbkQScriptProgramFunc_sourceCode, METH_NOARGS},
    {0} // Sentinel
};

// Rich comparison
static PyObject* SbkQScriptProgram_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result = false;
    QScriptProgram& cpp_self = *Shiboken::Converter<QScriptProgram* >::toCpp((PyObject*)self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<QScriptProgram & >::isConvertible(other)) {
                // operator!=(const QScriptProgram & other) const
                const QScriptProgram & cpp_other = Shiboken::Converter<QScriptProgram & >::toCpp(other);
                result = (cpp_self != cpp_other);
            } else if (Shiboken::Converter<QScriptProgram* >::isConvertible(other)) {
                if (Shiboken::cppObjectIsInvalid(other))
                    return 0;
                QScriptProgram* cpp_other = Shiboken::Converter<QScriptProgram* >::toCpp(other);
                result = (cpp_self != (*cpp_other));
            } else goto SbkQScriptProgram_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<QScriptProgram & >::isConvertible(other)) {
                // operator==(const QScriptProgram & other) const
                const QScriptProgram & cpp_other = Shiboken::Converter<QScriptProgram & >::toCpp(other);
                result = (cpp_self == cpp_other);
            } else if (Shiboken::Converter<QScriptProgram* >::isConvertible(other)) {
                if (Shiboken::cppObjectIsInvalid(other))
                    return 0;
                QScriptProgram* cpp_other = Shiboken::Converter<QScriptProgram* >::toCpp(other);
                result = (cpp_self == (*cpp_other));
            } else goto SbkQScriptProgram_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    SbkQScriptProgram_RichComparison_TypeError:
    Py_RETURN_FALSE;

}

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQScriptProgram_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtScript.QScriptProgram",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQScriptProgram_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQScriptProgram_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQScriptProgram_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QScriptProgram >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_QScriptProgram(PyObject* module)
{
    SbkPySide_QtScriptTypes[SBK_QSCRIPTPROGRAM_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQScriptProgram_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQScriptProgram_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQScriptProgram_Type));
    PyModule_AddObject(module, "QScriptProgram",
        ((PyObject*)&SbkQScriptProgram_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QScriptProgram >("QScriptProgram*");
    Shiboken::TypeResolver::createObjectTypeResolver<QScriptProgram >(typeid(QScriptProgram).name());
}


} // extern "C"

