/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtnetwork_python.h"

#include "qnetworkaddressentry_wrapper.h"

// Extra includes
#include <qhostaddress.h>
#include <qnetworkinterface.h>

using namespace Shiboken;

static int
SbkQNetworkAddressEntry_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QNetworkAddressEntry* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QNetworkAddressEntry", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QNetworkAddressEntry()
        cptr = new QNetworkAddressEntry();
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QNetworkAddressEntry & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QNetworkAddressEntry* cpp_arg0 = Shiboken::Converter<QNetworkAddressEntry* >::toCpp(pyargs[0]);
        // QNetworkAddressEntry(QNetworkAddressEntry)
        cptr = new QNetworkAddressEntry(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQNetworkAddressEntry_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QNetworkAddressEntry >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQNetworkAddressEntry_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQNetworkAddressEntry_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtNetwork.QNetworkAddressEntry", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtNetwork.QNetworkAddressEntry", overloads);
        return -1;
}

static PyObject* SbkQNetworkAddressEntryFunc_broadcast(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // broadcast()const
    QNetworkAddressEntry* cppSelf = Shiboken::Converter<QNetworkAddressEntry* >::toCpp((PyObject*)self);
    QHostAddress cpp_result = cppSelf->QNetworkAddressEntry::broadcast();
    py_result = Shiboken::Converter<QHostAddress >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQNetworkAddressEntryFunc_ip(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // ip()const
    QNetworkAddressEntry* cppSelf = Shiboken::Converter<QNetworkAddressEntry* >::toCpp((PyObject*)self);
    QHostAddress cpp_result = cppSelf->QNetworkAddressEntry::ip();
    py_result = Shiboken::Converter<QHostAddress >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQNetworkAddressEntryFunc_netmask(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // netmask()const
    QNetworkAddressEntry* cppSelf = Shiboken::Converter<QNetworkAddressEntry* >::toCpp((PyObject*)self);
    QHostAddress cpp_result = cppSelf->QNetworkAddressEntry::netmask();
    py_result = Shiboken::Converter<QHostAddress >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQNetworkAddressEntryFunc_prefixLength(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // prefixLength()const
    QNetworkAddressEntry* cppSelf = Shiboken::Converter<QNetworkAddressEntry* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QNetworkAddressEntry::prefixLength();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQNetworkAddressEntryFunc_setBroadcast(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QHostAddress & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QHostAddress > cpp_arg0_auto_ptr;
        QHostAddress* cpp_arg0 = Shiboken::Converter<QHostAddress* >::toCpp(arg);
        if (!SbkQHostAddress_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QHostAddress >(cpp_arg0);
        // setBroadcast(QHostAddress)
        QNetworkAddressEntry* cppSelf = Shiboken::Converter<QNetworkAddressEntry* >::toCpp((PyObject*)self);
        cppSelf->QNetworkAddressEntry::setBroadcast(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQNetworkAddressEntryFunc_setBroadcast_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQNetworkAddressEntryFunc_setBroadcast_TypeError:
        const char* overloads[] = {"PySide.QtNetwork.QHostAddress", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QNetworkAddressEntry.setBroadcast", overloads);
        return 0;
}

static PyObject* SbkQNetworkAddressEntryFunc_setIp(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QHostAddress & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QHostAddress > cpp_arg0_auto_ptr;
        QHostAddress* cpp_arg0 = Shiboken::Converter<QHostAddress* >::toCpp(arg);
        if (!SbkQHostAddress_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QHostAddress >(cpp_arg0);
        // setIp(QHostAddress)
        QNetworkAddressEntry* cppSelf = Shiboken::Converter<QNetworkAddressEntry* >::toCpp((PyObject*)self);
        cppSelf->QNetworkAddressEntry::setIp(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQNetworkAddressEntryFunc_setIp_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQNetworkAddressEntryFunc_setIp_TypeError:
        const char* overloads[] = {"PySide.QtNetwork.QHostAddress", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QNetworkAddressEntry.setIp", overloads);
        return 0;
}

static PyObject* SbkQNetworkAddressEntryFunc_setNetmask(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QHostAddress & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QHostAddress > cpp_arg0_auto_ptr;
        QHostAddress* cpp_arg0 = Shiboken::Converter<QHostAddress* >::toCpp(arg);
        if (!SbkQHostAddress_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QHostAddress >(cpp_arg0);
        // setNetmask(QHostAddress)
        QNetworkAddressEntry* cppSelf = Shiboken::Converter<QNetworkAddressEntry* >::toCpp((PyObject*)self);
        cppSelf->QNetworkAddressEntry::setNetmask(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQNetworkAddressEntryFunc_setNetmask_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQNetworkAddressEntryFunc_setNetmask_TypeError:
        const char* overloads[] = {"PySide.QtNetwork.QHostAddress", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QNetworkAddressEntry.setNetmask", overloads);
        return 0;
}

static PyObject* SbkQNetworkAddressEntryFunc_setPrefixLength(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setPrefixLength(int)
        QNetworkAddressEntry* cppSelf = Shiboken::Converter<QNetworkAddressEntry* >::toCpp((PyObject*)self);
        cppSelf->QNetworkAddressEntry::setPrefixLength(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQNetworkAddressEntryFunc_setPrefixLength_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQNetworkAddressEntryFunc_setPrefixLength_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtNetwork.QNetworkAddressEntry.setPrefixLength", overloads);
        return 0;
}

static PyMethodDef SbkQNetworkAddressEntry_methods[] = {
    {"broadcast", (PyCFunction)SbkQNetworkAddressEntryFunc_broadcast, METH_NOARGS},
    {"ip", (PyCFunction)SbkQNetworkAddressEntryFunc_ip, METH_NOARGS},
    {"netmask", (PyCFunction)SbkQNetworkAddressEntryFunc_netmask, METH_NOARGS},
    {"prefixLength", (PyCFunction)SbkQNetworkAddressEntryFunc_prefixLength, METH_NOARGS},
    {"setBroadcast", (PyCFunction)SbkQNetworkAddressEntryFunc_setBroadcast, METH_O},
    {"setIp", (PyCFunction)SbkQNetworkAddressEntryFunc_setIp, METH_O},
    {"setNetmask", (PyCFunction)SbkQNetworkAddressEntryFunc_setNetmask, METH_O},
    {"setPrefixLength", (PyCFunction)SbkQNetworkAddressEntryFunc_setPrefixLength, METH_O},
    {0} // Sentinel
};

// Rich comparison
static PyObject* SbkQNetworkAddressEntry_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result = false;
    QNetworkAddressEntry& cpp_self = *Shiboken::Converter<QNetworkAddressEntry* >::toCpp((PyObject*)self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<QNetworkAddressEntry & >::isConvertible(other)) {
                // operator!=(const QNetworkAddressEntry & other) const
                QNetworkAddressEntry* cpp_other = Shiboken::Converter<QNetworkAddressEntry* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QNetworkAddressEntry  >::toCpp(other) : (cpp_self != (*cpp_other));
            } else goto SbkQNetworkAddressEntry_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<QNetworkAddressEntry & >::isConvertible(other)) {
                // operator==(const QNetworkAddressEntry & other) const
                QNetworkAddressEntry* cpp_other = Shiboken::Converter<QNetworkAddressEntry* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QNetworkAddressEntry  >::toCpp(other) : (cpp_self == (*cpp_other));
            } else goto SbkQNetworkAddressEntry_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    SbkQNetworkAddressEntry_RichComparison_TypeError:
    Py_RETURN_FALSE;

}

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQNetworkAddressEntry_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtNetwork.QNetworkAddressEntry",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQNetworkAddressEntry_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQNetworkAddressEntry_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQNetworkAddressEntry_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QNetworkAddressEntry >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_QNetworkAddressEntry(PyObject* module)
{
    SbkPySide_QtNetworkTypes[SBK_QNETWORKADDRESSENTRY_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQNetworkAddressEntry_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQNetworkAddressEntry_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQNetworkAddressEntry_Type));
    PyModule_AddObject(module, "QNetworkAddressEntry",
        ((PyObject*)&SbkQNetworkAddressEntry_Type));

    Shiboken::TypeResolver::createValueTypeResolver<QNetworkAddressEntry >("QNetworkAddressEntry");
    Shiboken::TypeResolver::createValueTypeResolver<QNetworkAddressEntry >(typeid(QNetworkAddressEntry).name());
}


} // extern "C"

