/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include "pyside_qtmultimedia_python.h"

#include "qabstractvideosurface_wrapper.h"

// Extra includes
#include <QList>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qstring.h>
#include <qthread.h>
#include <qvariant.h>
#include <qvideoframe.h>
#include <qvideosurfaceformat.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QAbstractVideoSurfaceWrapper::QAbstractVideoSurfaceWrapper(QObject * parent) : QAbstractVideoSurface(parent), m_metaObject(0) {
    // ... middle
}

void QAbstractVideoSurfaceWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QChildEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QAbstractVideoSurfaceWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractVideoSurfaceWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QAbstractVideoSurfaceWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QAbstractVideoSurfaceWrapper::event(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QObject::event(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QAbstractVideoSurface.event", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
    return cpp_result;
}

bool QAbstractVideoSurfaceWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QObject * >::toPython(arg__1),
        Shiboken::Converter<QEvent * >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QAbstractVideoSurface.eventFilter", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 1));
    return cpp_result;
}

bool QAbstractVideoSurfaceWrapper::isFormatSupported(const QVideoSurfaceFormat & format) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "isFormatSupported"));
    if (py_override.isNull()) {
        return this->QAbstractVideoSurface::isFormatSupported(format);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QVideoSurfaceFormat & >::toPython(format)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QAbstractVideoSurface.isFormatSupported", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QAbstractVideoSurfaceWrapper::present(const QVideoFrame & frame)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "present"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractVideoSurface.present()' not implemented.");
        return bool(0);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QVideoFrame & >::toPython(frame)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QAbstractVideoSurface.present", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QAbstractVideoSurfaceWrapper::start(const QVideoSurfaceFormat & format)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "start"));
    if (py_override.isNull()) {
        return this->QAbstractVideoSurface::start(format);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QVideoSurfaceFormat & >::toPython(format)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QAbstractVideoSurface.start", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QAbstractVideoSurfaceWrapper::stop()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "stop"));
    if (py_override.isNull()) {
        return this->QAbstractVideoSurface::stop();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QList<QVideoFrame::PixelFormat > QAbstractVideoSurfaceWrapper::supportedPixelFormats(QAbstractVideoBuffer::HandleType handleType) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "supportedPixelFormats"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractVideoSurface.supportedPixelFormats()' not implemented.");
        return QList<QVideoFrame::PixelFormat >();
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QAbstractVideoBuffer::HandleType >::toPython(handleType)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QList<QVideoFrame::PixelFormat >();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QList<QVideoFrame::PixelFormat > >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QAbstractVideoSurface.supportedPixelFormats", "list", py_result->ob_type->tp_name);
        return QList<QVideoFrame::PixelFormat >();
    }
    QList<QVideoFrame::PixelFormat > cpp_result(Shiboken::Converter<QList<QVideoFrame::PixelFormat > >::toCpp(py_result));
    return cpp_result;
}

void QAbstractVideoSurfaceWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QTimerEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

const QMetaObject* QAbstractVideoSurfaceWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QAbstractVideoSurface::staticMetaObject);
}
    return m_metaObject;
}

int QAbstractVideoSurfaceWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QAbstractVideoSurface::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QAbstractVideoSurfaceWrapper::~QAbstractVideoSurfaceWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQAbstractVideoSurface_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QAbstractVideoSurfaceWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    SbkBaseWrapperType* type = reinterpret_cast<SbkBaseWrapperType*>(self->ob_type);
    SbkBaseWrapperType* myType = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtMultimediaTypes[SBK_QABSTRACTVIDEOSURFACE_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'QAbstractVideoSurface' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QAbstractVideoSurface", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QAbstractVideoSurface(QObject*)
        cptr = new QAbstractVideoSurfaceWrapper();
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else if (Shiboken::Converter<QObject * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(pyargs[0]);
        // QAbstractVideoSurface(QObject*)
        cptr = new QAbstractVideoSurfaceWrapper(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else goto SbkQAbstractVideoSurface_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QAbstractVideoSurface >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQAbstractVideoSurface_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQAbstractVideoSurface_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtMultimedia.QAbstractVideoSurface", overloads);
        return -1;
}

static PyObject* SbkQAbstractVideoSurfaceFunc_error(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // error()const
    QAbstractVideoSurface* cppSelf = Shiboken::Converter<QAbstractVideoSurface* >::toCpp((PyObject*)self);
    QAbstractVideoSurface::Error cpp_result = cppSelf->QAbstractVideoSurface::error();
    py_result = Shiboken::Converter<QAbstractVideoSurface::Error >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQAbstractVideoSurfaceFunc_isActive(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isActive()const
    QAbstractVideoSurface* cppSelf = Shiboken::Converter<QAbstractVideoSurface* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QAbstractVideoSurface::isActive();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQAbstractVideoSurfaceFunc_isFormatSupported(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QVideoSurfaceFormat & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QVideoSurfaceFormat* cpp_arg0 = Shiboken::Converter<QVideoSurfaceFormat* >::toCpp(arg);
        // isFormatSupported(QVideoSurfaceFormat)const
        QAbstractVideoSurface* cppSelf = Shiboken::Converter<QAbstractVideoSurface* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QAbstractVideoSurface::isFormatSupported(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractVideoSurfaceFunc_isFormatSupported_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQAbstractVideoSurfaceFunc_isFormatSupported_TypeError:
        const char* overloads[] = {"PySide.QtMultimedia.QVideoSurfaceFormat", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtMultimedia.QAbstractVideoSurface.isFormatSupported", overloads);
        return 0;
}

static PyObject* SbkQAbstractVideoSurfaceFunc_present(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QVideoFrame & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QVideoFrame* cpp_arg0 = Shiboken::Converter<QVideoFrame* >::toCpp(arg);
        // present(QVideoFrame)
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractVideoSurface.present()' not implemented.");
            return 0;
        }
        QAbstractVideoSurface* cppSelf = Shiboken::Converter<QAbstractVideoSurface* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->present(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractVideoSurfaceFunc_present_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQAbstractVideoSurfaceFunc_present_TypeError:
        const char* overloads[] = {"PySide.QtMultimedia.QVideoFrame", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtMultimedia.QAbstractVideoSurface.present", overloads);
        return 0;
}

static PyObject* SbkQAbstractVideoSurfaceFunc_setError(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QAbstractVideoSurface::Error >::isConvertible(arg)) {
        QAbstractVideoSurface::Error cpp_arg0 = Shiboken::Converter<QAbstractVideoSurface::Error >::toCpp(arg);
        // setError(QAbstractVideoSurface::Error)
        QAbstractVideoSurface* cppSelf = Shiboken::Converter<QAbstractVideoSurface* >::toCpp((PyObject*)self);
        cppSelf->QAbstractVideoSurface::setError(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractVideoSurfaceFunc_setError_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractVideoSurfaceFunc_setError_TypeError:
        const char* overloads[] = {"PySide.QtMultimedia.QAbstractVideoSurface.Error", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtMultimedia.QAbstractVideoSurface.setError", overloads);
        return 0;
}

static PyObject* SbkQAbstractVideoSurfaceFunc_start(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QVideoSurfaceFormat & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QVideoSurfaceFormat* cpp_arg0 = Shiboken::Converter<QVideoSurfaceFormat* >::toCpp(arg);
        // start(QVideoSurfaceFormat)
        QAbstractVideoSurface* cppSelf = Shiboken::Converter<QAbstractVideoSurface* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QAbstractVideoSurface::start(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractVideoSurfaceFunc_start_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQAbstractVideoSurfaceFunc_start_TypeError:
        const char* overloads[] = {"PySide.QtMultimedia.QVideoSurfaceFormat", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtMultimedia.QAbstractVideoSurface.start", overloads);
        return 0;
}

static PyObject* SbkQAbstractVideoSurfaceFunc_stop(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // stop()
    QAbstractVideoSurface* cppSelf = Shiboken::Converter<QAbstractVideoSurface* >::toCpp((PyObject*)self);
    cppSelf->QAbstractVideoSurface::stop();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQAbstractVideoSurfaceFunc_supportedPixelFormats(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // supportedPixelFormats(QAbstractVideoBuffer::HandleType)const
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractVideoSurface.supportedPixelFormats()' not implemented.");
            return 0;
        }
        QAbstractVideoSurface* cppSelf = Shiboken::Converter<QAbstractVideoSurface* >::toCpp((PyObject*)self);
        QList<QVideoFrame::PixelFormat > cpp_result = cppSelf->supportedPixelFormats();
        py_result = Shiboken::Converter<QList<QVideoFrame::PixelFormat > >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QAbstractVideoBuffer::HandleType >::isConvertible(arg)) {
        QAbstractVideoBuffer::HandleType cpp_arg0 = Shiboken::Converter<QAbstractVideoBuffer::HandleType >::toCpp(arg);
        // supportedPixelFormats(QAbstractVideoBuffer::HandleType)const
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractVideoSurface.supportedPixelFormats()' not implemented.");
            return 0;
        }
        QAbstractVideoSurface* cppSelf = Shiboken::Converter<QAbstractVideoSurface* >::toCpp((PyObject*)self);
        QList<QVideoFrame::PixelFormat > cpp_result = cppSelf->supportedPixelFormats(cpp_arg0);
        py_result = Shiboken::Converter<QList<QVideoFrame::PixelFormat > >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractVideoSurfaceFunc_supportedPixelFormats_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQAbstractVideoSurfaceFunc_supportedPixelFormats_TypeError:
        const char* overloads[] = {"PySide.QtMultimedia.QAbstractVideoBuffer.HandleType = QAbstractVideoBuffer.NoHandle", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtMultimedia.QAbstractVideoSurface.supportedPixelFormats", overloads);
        return 0;
}

static PyMethodDef SbkQAbstractVideoSurface_methods[] = {
    {"error", (PyCFunction)SbkQAbstractVideoSurfaceFunc_error, METH_NOARGS},
    {"isActive", (PyCFunction)SbkQAbstractVideoSurfaceFunc_isActive, METH_NOARGS},
    {"isFormatSupported", (PyCFunction)SbkQAbstractVideoSurfaceFunc_isFormatSupported, METH_O},
    {"present", (PyCFunction)SbkQAbstractVideoSurfaceFunc_present, METH_O},
    {"setError", (PyCFunction)SbkQAbstractVideoSurfaceFunc_setError, METH_O},
    {"start", (PyCFunction)SbkQAbstractVideoSurfaceFunc_start, METH_O},
    {"stop", (PyCFunction)SbkQAbstractVideoSurfaceFunc_stop, METH_NOARGS},
    {"supportedPixelFormats", (PyCFunction)SbkQAbstractVideoSurfaceFunc_supportedPixelFormats, METH_NOARGS|METH_O},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQAbstractVideoSurface_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtMultimedia.QAbstractVideoSurface",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQAbstractVideoSurface_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQAbstractVideoSurface_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QAbstractVideoSurface >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static PyGetSetDef SbkPySide_QtMultimedia_QAbstractVideoSurface_Error_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtMultimedia_QAbstractVideoSurface_Error_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtMultimedia_QAbstractVideoSurface_Error_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Error",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtMultimedia_QAbstractVideoSurface_Error_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtMultimedia_QAbstractVideoSurface_Error_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtMultimedia_QAbstractVideoSurface_Error_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void) init_QAbstractVideoSurface(PyObject* module)
{
    SbkPySide_QtMultimediaTypes[SBK_QABSTRACTVIDEOSURFACE_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQAbstractVideoSurface_Type);

    SbkQAbstractVideoSurface_Type.super.ht_type.tp_base = SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX];
    // Fill type discovery information
    SbkQAbstractVideoSurface_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQAbstractVideoSurface_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQAbstractVideoSurface_Type));
    PyModule_AddObject(module, "QAbstractVideoSurface",
        ((PyObject*)&SbkQAbstractVideoSurface_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: Error
    SbkPySide_QtMultimediaTypes[SBK_QABSTRACTVIDEOSURFACE_ERROR_IDX] = &SbkPySide_QtMultimedia_QAbstractVideoSurface_Error_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtMultimedia_QAbstractVideoSurface_Error_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtMultimedia_QAbstractVideoSurface_Error_Type);
    PyDict_SetItemString(SbkQAbstractVideoSurface_Type.super.ht_type.tp_dict,
            "Error",((PyObject*)&SbkPySide_QtMultimedia_QAbstractVideoSurface_Error_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtMultimedia_QAbstractVideoSurface_Error_Type,
        (long) QAbstractVideoSurface::NoError, "NoError");
    PyDict_SetItemString(SbkQAbstractVideoSurface_Type.super.ht_type.tp_dict,
        "NoError", enum_item);
    PyDict_SetItemString(SbkPySide_QtMultimedia_QAbstractVideoSurface_Error_Type.tp_dict,
        "NoError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtMultimedia_QAbstractVideoSurface_Error_Type,
        (long) QAbstractVideoSurface::UnsupportedFormatError, "UnsupportedFormatError");
    PyDict_SetItemString(SbkQAbstractVideoSurface_Type.super.ht_type.tp_dict,
        "UnsupportedFormatError", enum_item);
    PyDict_SetItemString(SbkPySide_QtMultimedia_QAbstractVideoSurface_Error_Type.tp_dict,
        "UnsupportedFormatError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtMultimedia_QAbstractVideoSurface_Error_Type,
        (long) QAbstractVideoSurface::IncorrectFormatError, "IncorrectFormatError");
    PyDict_SetItemString(SbkQAbstractVideoSurface_Type.super.ht_type.tp_dict,
        "IncorrectFormatError", enum_item);
    PyDict_SetItemString(SbkPySide_QtMultimedia_QAbstractVideoSurface_Error_Type.tp_dict,
        "IncorrectFormatError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtMultimedia_QAbstractVideoSurface_Error_Type,
        (long) QAbstractVideoSurface::StoppedError, "StoppedError");
    PyDict_SetItemString(SbkQAbstractVideoSurface_Type.super.ht_type.tp_dict,
        "StoppedError", enum_item);
    PyDict_SetItemString(SbkPySide_QtMultimedia_QAbstractVideoSurface_Error_Type.tp_dict,
        "StoppedError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtMultimedia_QAbstractVideoSurface_Error_Type,
        (long) QAbstractVideoSurface::ResourceError, "ResourceError");
    PyDict_SetItemString(SbkQAbstractVideoSurface_Type.super.ht_type.tp_dict,
        "ResourceError", enum_item);
    PyDict_SetItemString(SbkPySide_QtMultimedia_QAbstractVideoSurface_Error_Type.tp_dict,
        "ResourceError", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QAbstractVideoSurface::Error");

    Shiboken::TypeResolver::createObjectTypeResolver<QAbstractVideoSurface >("QAbstractVideoSurface*");
    Shiboken::TypeResolver::createObjectTypeResolver<QAbstractVideoSurface >(typeid(QAbstractVideoSurface).name());
}


} // extern "C"

