/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qtexttableformat_wrapper.h"

// Extra includes
#include <QMap>
#include <QVector>
#include <qbrush.h>
#include <qcolor.h>
#include <qpen.h>
#include <qstring.h>
#include <qtextformat.h>
#include <qvariant.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QTextTableFormatWrapper::QTextTableFormatWrapper() : QTextTableFormat() {
    // ... middle
}

QTextTableFormatWrapper::QTextTableFormatWrapper(const QTextFormat & fmt) : QTextTableFormat(fmt) {
    // ... middle
}

QTextTableFormatWrapper::~QTextTableFormatWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

static int
SbkQTextTableFormat_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QTextTableFormatWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QTextTableFormat", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QTextTableFormat()
        cptr = new QTextTableFormatWrapper();
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QTextFormat & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QTextFormat* cpp_arg0 = Shiboken::Converter<QTextFormat* >::toCpp(pyargs[0]);
        // QTextTableFormat(QTextFormat)
        cptr = new QTextTableFormatWrapper(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QTextTableFormat & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QTextTableFormat* cpp_arg0 = Shiboken::Converter<QTextTableFormat* >::toCpp(pyargs[0]);
        // QTextTableFormat(QTextTableFormat)
        cptr = new QTextTableFormatWrapper(*reinterpret_cast<QTextTableFormatWrapper*>(cpp_arg0));
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextTableFormat_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QTextTableFormat >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQTextTableFormat_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQTextTableFormat_Init_TypeError:
        const char* overloads[] = {"PySide.QtGui.QTextTableFormat", "", "PySide.QtGui.QTextFormat", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QTextTableFormat", overloads);
        return -1;
}

static PyObject* SbkQTextTableFormatFunc_alignment(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // alignment()const
    QTextTableFormat* cppSelf = Shiboken::Converter<QTextTableFormat* >::toCpp((PyObject*)self);
    QFlags<Qt::AlignmentFlag> cpp_result = cppSelf->QTextTableFormat::alignment();
    py_result = Shiboken::Converter<QFlags<Qt::AlignmentFlag> >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextTableFormatFunc_cellPadding(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // cellPadding()const
    QTextTableFormat* cppSelf = Shiboken::Converter<QTextTableFormat* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QTextTableFormat::cellPadding();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextTableFormatFunc_cellSpacing(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // cellSpacing()const
    QTextTableFormat* cppSelf = Shiboken::Converter<QTextTableFormat* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QTextTableFormat::cellSpacing();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextTableFormatFunc_clearColumnWidthConstraints(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // clearColumnWidthConstraints()
    QTextTableFormat* cppSelf = Shiboken::Converter<QTextTableFormat* >::toCpp((PyObject*)self);
    cppSelf->QTextTableFormat::clearColumnWidthConstraints();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQTextTableFormatFunc_columnWidthConstraints(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // columnWidthConstraints()const
    QTextTableFormat* cppSelf = Shiboken::Converter<QTextTableFormat* >::toCpp((PyObject*)self);
    QVector<QTextLength > cpp_result = cppSelf->QTextTableFormat::columnWidthConstraints();
    py_result = Shiboken::Converter<QVector<QTextLength > >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextTableFormatFunc_columns(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // columns()const
    QTextTableFormat* cppSelf = Shiboken::Converter<QTextTableFormat* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTextTableFormat::columns();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextTableFormatFunc_headerRowCount(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // headerRowCount()const
    QTextTableFormat* cppSelf = Shiboken::Converter<QTextTableFormat* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTextTableFormat::headerRowCount();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextTableFormatFunc_isValid(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isValid()const
    QTextTableFormat* cppSelf = Shiboken::Converter<QTextTableFormat* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QTextTableFormat::isValid();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextTableFormatFunc_setAlignment(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (SbkPySide_QtCore_Qt_AlignmentFlag_Check(arg)) {
        QFlags<Qt::AlignmentFlag> cpp_arg0 = Shiboken::Converter<QFlags<Qt::AlignmentFlag> >::toCpp(arg);
        // setAlignment(QFlags<Qt::AlignmentFlag>)
        QTextTableFormat* cppSelf = Shiboken::Converter<QTextTableFormat* >::toCpp((PyObject*)self);
        cppSelf->QTextTableFormat::setAlignment(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextTableFormatFunc_setAlignment_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextTableFormatFunc_setAlignment_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.Alignment", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextTableFormat.setAlignment", overloads);
        return 0;
}

static PyObject* SbkQTextTableFormatFunc_setCellPadding(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setCellPadding(qreal)
        QTextTableFormat* cppSelf = Shiboken::Converter<QTextTableFormat* >::toCpp((PyObject*)self);
        cppSelf->QTextTableFormat::setCellPadding(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextTableFormatFunc_setCellPadding_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextTableFormatFunc_setCellPadding_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextTableFormat.setCellPadding", overloads);
        return 0;
}

static PyObject* SbkQTextTableFormatFunc_setCellSpacing(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setCellSpacing(qreal)
        QTextTableFormat* cppSelf = Shiboken::Converter<QTextTableFormat* >::toCpp((PyObject*)self);
        cppSelf->QTextTableFormat::setCellSpacing(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextTableFormatFunc_setCellSpacing_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextTableFormatFunc_setCellSpacing_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextTableFormat.setCellSpacing", overloads);
        return 0;
}

static PyObject* SbkQTextTableFormatFunc_setColumnWidthConstraints(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QVector<QTextLength >  >::isConvertible(arg)) {
        QVector<QTextLength >  cpp_arg0 = Shiboken::Converter<QVector<QTextLength >  >::toCpp(arg);
        // setColumnWidthConstraints(QVector<QTextLength>)
        QTextTableFormat* cppSelf = Shiboken::Converter<QTextTableFormat* >::toCpp((PyObject*)self);
        cppSelf->QTextTableFormat::setColumnWidthConstraints(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextTableFormatFunc_setColumnWidthConstraints_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextTableFormatFunc_setColumnWidthConstraints_TypeError:
        const char* overloads[] = {"list", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextTableFormat.setColumnWidthConstraints", overloads);
        return 0;
}

static PyObject* SbkQTextTableFormatFunc_setColumns(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setColumns(int)
        QTextTableFormat* cppSelf = Shiboken::Converter<QTextTableFormat* >::toCpp((PyObject*)self);
        cppSelf->QTextTableFormat::setColumns(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextTableFormatFunc_setColumns_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextTableFormatFunc_setColumns_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextTableFormat.setColumns", overloads);
        return 0;
}

static PyObject* SbkQTextTableFormatFunc_setHeaderRowCount(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setHeaderRowCount(int)
        QTextTableFormat* cppSelf = Shiboken::Converter<QTextTableFormat* >::toCpp((PyObject*)self);
        cppSelf->QTextTableFormat::setHeaderRowCount(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQTextTableFormatFunc_setHeaderRowCount_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextTableFormatFunc_setHeaderRowCount_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QTextTableFormat.setHeaderRowCount", overloads);
        return 0;
}

static PyMethodDef SbkQTextTableFormat_methods[] = {
    {"alignment", (PyCFunction)SbkQTextTableFormatFunc_alignment, METH_NOARGS},
    {"cellPadding", (PyCFunction)SbkQTextTableFormatFunc_cellPadding, METH_NOARGS},
    {"cellSpacing", (PyCFunction)SbkQTextTableFormatFunc_cellSpacing, METH_NOARGS},
    {"clearColumnWidthConstraints", (PyCFunction)SbkQTextTableFormatFunc_clearColumnWidthConstraints, METH_NOARGS},
    {"columnWidthConstraints", (PyCFunction)SbkQTextTableFormatFunc_columnWidthConstraints, METH_NOARGS},
    {"columns", (PyCFunction)SbkQTextTableFormatFunc_columns, METH_NOARGS},
    {"headerRowCount", (PyCFunction)SbkQTextTableFormatFunc_headerRowCount, METH_NOARGS},
    {"isValid", (PyCFunction)SbkQTextTableFormatFunc_isValid, METH_NOARGS},
    {"setAlignment", (PyCFunction)SbkQTextTableFormatFunc_setAlignment, METH_O},
    {"setCellPadding", (PyCFunction)SbkQTextTableFormatFunc_setCellPadding, METH_O},
    {"setCellSpacing", (PyCFunction)SbkQTextTableFormatFunc_setCellSpacing, METH_O},
    {"setColumnWidthConstraints", (PyCFunction)SbkQTextTableFormatFunc_setColumnWidthConstraints, METH_O},
    {"setColumns", (PyCFunction)SbkQTextTableFormatFunc_setColumns, METH_O},
    {"setHeaderRowCount", (PyCFunction)SbkQTextTableFormatFunc_setHeaderRowCount, METH_O},
    {0} // Sentinel
};

extern "C"
{

static void* SbkQTextTableFormat_ObjCopierFunc(const void* ptr){
    return new QTextTableFormatWrapper(*reinterpret_cast<const QTextTableFormat*>(ptr));
}

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQTextTableFormat_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QTextTableFormat",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQTextTableFormat_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQTextTableFormat_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          &SbkQTextTableFormat_ObjCopierFunc,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QTextTableFormat >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_QTextTableFormat(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QTEXTTABLEFORMAT_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQTextTableFormat_Type);

    SbkQTextTableFormat_Type.super.ht_type.tp_base = SbkPySide_QtGuiTypes[SBK_QTEXTFRAMEFORMAT_IDX];
    // Fill type discovery information
    SbkQTextTableFormat_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QTEXTFORMAT_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQTextTableFormat_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQTextTableFormat_Type));
    PyModule_AddObject(module, "QTextTableFormat",
        ((PyObject*)&SbkQTextTableFormat_Type));

    Shiboken::TypeResolver::createValueTypeResolver<QTextTableFormat >("QTextTableFormat");
    Shiboken::TypeResolver::createValueTypeResolver<QTextTableFormat >(typeid(QTextTableFormat).name());
}


} // extern "C"

