/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qtextitem_wrapper.h"

// Extra includes
#include <qfont.h>
#include <qstring.h>

using namespace Shiboken;

static int
SbkQTextItem_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QTextItem* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    // QTextItem()
    cptr = new QTextItem();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QTextItem >(), cptr)) {
        delete cptr;
        return -1;
    }
    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;
}

static PyObject* SbkQTextItemFunc_ascent(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // ascent()const
    QTextItem* cppSelf = Shiboken::Converter<QTextItem* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QTextItem::ascent();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextItemFunc_descent(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // descent()const
    QTextItem* cppSelf = Shiboken::Converter<QTextItem* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QTextItem::descent();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextItemFunc_font(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // font()const
    QTextItem* cppSelf = Shiboken::Converter<QTextItem* >::toCpp((PyObject*)self);
    QFont cpp_result = cppSelf->QTextItem::font();
    py_result = Shiboken::Converter<QFont >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextItemFunc_renderFlags(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // renderFlags()const
    QTextItem* cppSelf = Shiboken::Converter<QTextItem* >::toCpp((PyObject*)self);
    QFlags<QTextItem::RenderFlag> cpp_result = cppSelf->QTextItem::renderFlags();
    py_result = Shiboken::Converter<QFlags<QTextItem::RenderFlag> >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextItemFunc_text(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // text()const
    QTextItem* cppSelf = Shiboken::Converter<QTextItem* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QTextItem::text();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQTextItemFunc_width(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // width()const
    QTextItem* cppSelf = Shiboken::Converter<QTextItem* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QTextItem::width();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQTextItem_methods[] = {
    {"ascent", (PyCFunction)SbkQTextItemFunc_ascent, METH_NOARGS},
    {"descent", (PyCFunction)SbkQTextItemFunc_descent, METH_NOARGS},
    {"font", (PyCFunction)SbkQTextItemFunc_font, METH_NOARGS},
    {"renderFlags", (PyCFunction)SbkQTextItemFunc_renderFlags, METH_NOARGS},
    {"text", (PyCFunction)SbkQTextItemFunc_text, METH_NOARGS},
    {"width", (PyCFunction)SbkQTextItemFunc_width, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQTextItem_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QTextItem",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQTextItem_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQTextItem_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QTextItem >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

PyObject*
SbkPySide_QtGui_QTextItem_RenderFlag___and__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QTextItem::RenderFlags >::toPython(
        ((QTextItem::RenderFlags) ((SbkEnumObject*)self)->ob_ival)
        & Shiboken::Converter< QTextItem::RenderFlags >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtGui_QTextItem_RenderFlag___or__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QTextItem::RenderFlags >::toPython(
        ((QTextItem::RenderFlags) ((SbkEnumObject*)self)->ob_ival)
        | Shiboken::Converter< QTextItem::RenderFlags >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtGui_QTextItem_RenderFlag___xor__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QTextItem::RenderFlags >::toPython(
        ((QTextItem::RenderFlags) ((SbkEnumObject*)self)->ob_ival)
        ^ Shiboken::Converter< QTextItem::RenderFlags >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtGui_QTextItem_RenderFlag___invert__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QTextItem::RenderFlags >::toPython(
        ~ Shiboken::Converter< QTextItem::RenderFlags >::toCpp(self)
    );
}


static PyNumberMethods SbkPySide_QtGui_QTextItem_RenderFlag_as_number = {
    /*nb_add*/                  0,
    /*nb_subtract*/             0,
    /*nb_multiply*/             0,
    /*nb_divide*/               0,
    /*nb_remainder*/            0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             0,
    /*nb_positive*/             0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)SbkPySide_QtGui_QTextItem_RenderFlag___invert__,
    /*nb_lshift*/               0,
    /*nb_rshift*/               0,
    /*nb_and*/                  (binaryfunc)SbkPySide_QtGui_QTextItem_RenderFlag___and__,
    /*nb_xor*/                  (binaryfunc)SbkPySide_QtGui_QTextItem_RenderFlag___xor__,
    /*nb_or*/                   (binaryfunc)SbkPySide_QtGui_QTextItem_RenderFlag___or__,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          0,
    /*nb_inplace_subtract*/     0,
    /*nb_inplace_multiply*/     0,
    /*nb_inplace_divide*/       0,
    /*nb_inplace_remainder*/    0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       0,
    /*nb_inplace_rshift*/       0,
    /*nb_inplace_and*/          0,
    /*nb_inplace_xor*/          0,
    /*nb_inplace_or*/           0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};


static PyGetSetDef SbkPySide_QtGui_QTextItem_RenderFlag_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QTextItem_RenderFlag_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QTextItem_RenderFlag_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "RenderFlag",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        &SbkPySide_QtGui_QTextItem_RenderFlag_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QTextItem_RenderFlag_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QTextItem_RenderFlag_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QTextItem_RenderFlag_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QTextItem_RenderFlags_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QTextItem_RenderFlags_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "RenderFlags",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             &SbkPySide_QtGui_QTextItem_RenderFlag_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QTextItem_RenderFlags_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QTextItem_RenderFlags_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    if (!PyType_IsSubtype(type, &SbkPySide_QtGui_QTextItem_RenderFlags_Type))
        return 0;

    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}



PyAPI_FUNC(void) init_QTextItem(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QTEXTITEM_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQTextItem_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQTextItem_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQTextItem_Type));
    PyModule_AddObject(module, "QTextItem",
        ((PyObject*)&SbkQTextItem_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: RenderFlag
    SbkPySide_QtGuiTypes[SBK_QTEXTITEM_RENDERFLAG_IDX] = &SbkPySide_QtGui_QTextItem_RenderFlag_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QTextItem_RenderFlag_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QTextItem_RenderFlag_Type);
    PyDict_SetItemString(SbkQTextItem_Type.super.ht_type.tp_dict,
            "RenderFlag",((PyObject*)&SbkPySide_QtGui_QTextItem_RenderFlag_Type));

    // init flags class: QFlags<QTextItem::RenderFlag>
    SbkPySide_QtGuiTypes[SBK_QFLAGS_QTEXTITEM_RENDERFLAG__IDX] = &SbkPySide_QtGui_QTextItem_RenderFlags_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QTextItem_RenderFlags_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QTextItem_RenderFlags_Type);
    PyDict_SetItemString(SbkQTextItem_Type.super.ht_type.tp_dict,
            "RenderFlags",((PyObject*)&SbkPySide_QtGui_QTextItem_RenderFlags_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextItem_RenderFlag_Type,
        (long) QTextItem::RightToLeft, "RightToLeft");
    PyDict_SetItemString(SbkQTextItem_Type.super.ht_type.tp_dict,
        "RightToLeft", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextItem_RenderFlag_Type.tp_dict,
        "RightToLeft", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextItem_RenderFlag_Type,
        (long) QTextItem::Overline, "Overline");
    PyDict_SetItemString(SbkQTextItem_Type.super.ht_type.tp_dict,
        "Overline", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextItem_RenderFlag_Type.tp_dict,
        "Overline", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextItem_RenderFlag_Type,
        (long) QTextItem::Underline, "Underline");
    PyDict_SetItemString(SbkQTextItem_Type.super.ht_type.tp_dict,
        "Underline", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextItem_RenderFlag_Type.tp_dict,
        "Underline", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextItem_RenderFlag_Type,
        (long) QTextItem::StrikeOut, "StrikeOut");
    PyDict_SetItemString(SbkQTextItem_Type.super.ht_type.tp_dict,
        "StrikeOut", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextItem_RenderFlag_Type.tp_dict,
        "StrikeOut", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QTextItem_RenderFlag_Type,
        (long) QTextItem::Dummy, "Dummy");
    PyDict_SetItemString(SbkQTextItem_Type.super.ht_type.tp_dict,
        "Dummy", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QTextItem_RenderFlag_Type.tp_dict,
        "Dummy", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QTextItem::RenderFlag");

    Shiboken::TypeResolver::createObjectTypeResolver<QTextItem >("QTextItem*");
    Shiboken::TypeResolver::createObjectTypeResolver<QTextItem >(typeid(QTextItem).name());
}


} // extern "C"

