/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include "pyside_qtgui_python.h"

#include "qstandarditemmodel_wrapper.h"

// Extra includes
#include <QList>
#include <QMap>
#include <QSize>
#include <QStringList>
#include <pysideconversions.h>
#include <qabstractitemmodel.h>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qdatastream.h>
#include <qmimedata.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qsize.h>
#include <qstandarditemmodel.h>
#include <qstring.h>
#include <qstringlist.h>
#include <qthread.h>
#include <qvariant.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QStandardItemModelWrapper::QStandardItemModelWrapper(QObject * parent) : QStandardItemModel(parent), m_metaObject(0) {
    // ... middle
}

QStandardItemModelWrapper::QStandardItemModelWrapper(int rows, int columns, QObject * parent) : QStandardItemModel(rows, columns, parent), m_metaObject(0) {
    // ... middle
}

QModelIndex QStandardItemModelWrapper::buddy(const QModelIndex & index) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "buddy"));
    if (py_override.isNull()) {
        return this->QAbstractItemModel::buddy(index);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QModelIndex & >::toPython(index)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QModelIndex();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QModelIndex >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QStandardItemModel.buddy", SbkType<QModelIndex >()->tp_name, py_result->ob_type->tp_name);
        return QModelIndex();
    }
    QModelIndex cpp_result(Shiboken::Converter<QModelIndex >::toCpp(py_result));
    return cpp_result;
}

bool QStandardItemModelWrapper::canFetchMore(const QModelIndex & parent) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "canFetchMore"));
    if (py_override.isNull()) {
        return this->QAbstractItemModel::canFetchMore(parent);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QModelIndex & >::toPython(parent)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QStandardItemModel.canFetchMore", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QStandardItemModelWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QChildEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

int QStandardItemModelWrapper::columnCount(const QModelIndex & parent) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "columnCount"));
    if (py_override.isNull()) {
        return this->QStandardItemModel::columnCount(parent);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QModelIndex & >::toPython(parent)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QStandardItemModel.columnCount", SbkType<int >()->tp_name, py_result->ob_type->tp_name);
        return int(0);
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QStandardItemModelWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QStandardItemModelWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

QVariant QStandardItemModelWrapper::data(const QModelIndex & index, int role) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "data"));
    if (py_override.isNull()) {
        return this->QStandardItemModel::data(index, role);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(Si)",
        Shiboken::Converter<QModelIndex & >::toPython(index),
        role
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QVariant();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QVariant >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QStandardItemModel.data", SbkType<QVariant >()->tp_name, py_result->ob_type->tp_name);
        return QVariant();
    }
    QVariant cpp_result(Shiboken::Converter<QVariant >::toCpp(py_result));
    return cpp_result;
}

void QStandardItemModelWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QStandardItemModelWrapper::dropMimeData(const QMimeData * data, Qt::DropAction action, int row, int column, const QModelIndex & parent)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "dropMimeData"));
    if (py_override.isNull()) {
        return this->QStandardItemModel::dropMimeData(data, action, row, column, parent);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SSiiS)",
        Shiboken::Converter<QMimeData * >::toPython(data),
        Shiboken::Converter<Qt::DropAction >::toPython(action),
        row,
        column,
        Shiboken::Converter<QModelIndex & >::toPython(parent)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QStandardItemModel.dropMimeData", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QStandardItemModelWrapper::event(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QObject::event(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QStandardItemModel.event", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
    return cpp_result;
}

bool QStandardItemModelWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QObject * >::toPython(arg__1),
        Shiboken::Converter<QEvent * >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QStandardItemModel.eventFilter", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 1));
    return cpp_result;
}

void QStandardItemModelWrapper::fetchMore(const QModelIndex & parent)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "fetchMore"));
    if (py_override.isNull()) {
        return this->QAbstractItemModel::fetchMore(parent);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QModelIndex & >::toPython(parent)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QFlags<Qt::ItemFlag> QStandardItemModelWrapper::flags(const QModelIndex & index) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "flags"));
    if (py_override.isNull()) {
        return this->QStandardItemModel::flags(index);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QModelIndex & >::toPython(index)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QFlags<Qt::ItemFlag>();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QFlags<Qt::ItemFlag> >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QStandardItemModel.flags", SbkType<QFlags<Qt::ItemFlag> >()->tp_name, py_result->ob_type->tp_name);
        return QFlags<Qt::ItemFlag>();
    }
    QFlags<Qt::ItemFlag> cpp_result(Shiboken::Converter<QFlags<Qt::ItemFlag> >::toCpp(py_result));
    return cpp_result;
}

bool QStandardItemModelWrapper::hasChildren(const QModelIndex & parent) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "hasChildren"));
    if (py_override.isNull()) {
        return this->QStandardItemModel::hasChildren(parent);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QModelIndex & >::toPython(parent)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QStandardItemModel.hasChildren", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

QVariant QStandardItemModelWrapper::headerData(int section, Qt::Orientation orientation, int role) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "headerData"));
    if (py_override.isNull()) {
        return this->QStandardItemModel::headerData(section, orientation, role);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(iSi)",
        section,
        Shiboken::Converter<Qt::Orientation >::toPython(orientation),
        role
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QVariant();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QVariant >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QStandardItemModel.headerData", SbkType<QVariant >()->tp_name, py_result->ob_type->tp_name);
        return QVariant();
    }
    QVariant cpp_result(Shiboken::Converter<QVariant >::toCpp(py_result));
    return cpp_result;
}

QModelIndex QStandardItemModelWrapper::index(int row, int column, const QModelIndex & parent) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "index"));
    if (py_override.isNull()) {
        return this->QStandardItemModel::index(row, column, parent);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(iiS)",
        row,
        column,
        Shiboken::Converter<QModelIndex & >::toPython(parent)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QModelIndex();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QModelIndex >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QStandardItemModel.index", SbkType<QModelIndex >()->tp_name, py_result->ob_type->tp_name);
        return QModelIndex();
    }
    QModelIndex cpp_result(Shiboken::Converter<QModelIndex >::toCpp(py_result));
    return cpp_result;
}

bool QStandardItemModelWrapper::insertColumns(int column, int count, const QModelIndex & parent)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "insertColumns"));
    if (py_override.isNull()) {
        return this->QStandardItemModel::insertColumns(column, count, parent);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(iiS)",
        column,
        count,
        Shiboken::Converter<QModelIndex & >::toPython(parent)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QStandardItemModel.insertColumns", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QStandardItemModelWrapper::insertRows(int row, int count, const QModelIndex & parent)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "insertRows"));
    if (py_override.isNull()) {
        return this->QStandardItemModel::insertRows(row, count, parent);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(iiS)",
        row,
        count,
        Shiboken::Converter<QModelIndex & >::toPython(parent)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QStandardItemModel.insertRows", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

QMap<int, QVariant > QStandardItemModelWrapper::itemData(const QModelIndex & index) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "itemData"));
    if (py_override.isNull()) {
        return this->QStandardItemModel::itemData(index);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QModelIndex & >::toPython(index)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QMap<int, QVariant >();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QMap<int, QVariant > >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QStandardItemModel.itemData", "map", py_result->ob_type->tp_name);
        return QMap<int, QVariant >();
    }
    QMap<int, QVariant > cpp_result(Shiboken::Converter<QMap<int, QVariant > >::toCpp(py_result));
    return cpp_result;
}

QList<QModelIndex > QStandardItemModelWrapper::match(const QModelIndex & start, int role, const QVariant & value, int hits, QFlags<Qt::MatchFlag> flags) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "match"));
    if (py_override.isNull()) {
        return this->QAbstractItemModel::match(start, role, value, hits, flags);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SiSiS)",
        Shiboken::Converter<QModelIndex & >::toPython(start),
        role,
        Shiboken::Converter<QVariant & >::toPython(value),
        hits,
        Shiboken::Converter<QFlags<Qt::MatchFlag> >::toPython(flags)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QList<QModelIndex >();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QList<QModelIndex > >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QStandardItemModel.match", "list", py_result->ob_type->tp_name);
        return QList<QModelIndex >();
    }
    QList<QModelIndex > cpp_result(Shiboken::Converter<QList<QModelIndex > >::toCpp(py_result));
    return cpp_result;
}

QMimeData * QStandardItemModelWrapper::mimeData(const QList<QModelIndex > & indexes) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mimeData"));
    if (py_override.isNull()) {
        return this->QStandardItemModel::mimeData(indexes);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QList<QModelIndex >  >::toPython(indexes)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QMimeData * >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QStandardItemModel.mimeData", SbkType<QMimeData * >()->tp_name, py_result->ob_type->tp_name);
        return 0;
    }
    QMimeData * cpp_result(Shiboken::Converter<QMimeData * >::toCpp(py_result));
    return cpp_result;
}

QStringList QStandardItemModelWrapper::mimeTypes() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mimeTypes"));
    if (py_override.isNull()) {
        return this->QStandardItemModel::mimeTypes();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QStringList();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QStringList >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QStandardItemModel.mimeTypes", SbkType<QStringList >()->tp_name, py_result->ob_type->tp_name);
        return QStringList();
    }
    QStringList cpp_result(Shiboken::Converter<QStringList >::toCpp(py_result));
    return cpp_result;
}

QModelIndex QStandardItemModelWrapper::parent(const QModelIndex & child) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "parent"));
    if (py_override.isNull()) {
        return this->QStandardItemModel::parent(child);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QModelIndex & >::toPython(child)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QModelIndex();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QModelIndex >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QStandardItemModel.parent", SbkType<QModelIndex >()->tp_name, py_result->ob_type->tp_name);
        return QModelIndex();
    }
    QModelIndex cpp_result(Shiboken::Converter<QModelIndex >::toCpp(py_result));
    return cpp_result;
}

bool QStandardItemModelWrapper::removeColumns(int column, int count, const QModelIndex & parent)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "removeColumns"));
    if (py_override.isNull()) {
        return this->QStandardItemModel::removeColumns(column, count, parent);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(iiS)",
        column,
        count,
        Shiboken::Converter<QModelIndex & >::toPython(parent)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QStandardItemModel.removeColumns", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QStandardItemModelWrapper::removeRows(int row, int count, const QModelIndex & parent)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "removeRows"));
    if (py_override.isNull()) {
        return this->QStandardItemModel::removeRows(row, count, parent);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(iiS)",
        row,
        count,
        Shiboken::Converter<QModelIndex & >::toPython(parent)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QStandardItemModel.removeRows", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QStandardItemModelWrapper::revert()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "revert"));
    if (py_override.isNull()) {
        return this->QAbstractItemModel::revert();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

int QStandardItemModelWrapper::rowCount(const QModelIndex & parent) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "rowCount"));
    if (py_override.isNull()) {
        return this->QStandardItemModel::rowCount(parent);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QModelIndex & >::toPython(parent)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QStandardItemModel.rowCount", SbkType<int >()->tp_name, py_result->ob_type->tp_name);
        return int(0);
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

bool QStandardItemModelWrapper::setData(const QModelIndex & index, const QVariant & value, int role)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setData"));
    if (py_override.isNull()) {
        return this->QStandardItemModel::setData(index, value, role);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SSi)",
        Shiboken::Converter<QModelIndex & >::toPython(index),
        Shiboken::Converter<QVariant & >::toPython(value),
        role
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QStandardItemModel.setData", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QStandardItemModelWrapper::setHeaderData(int section, Qt::Orientation orientation, const QVariant & value, int role)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setHeaderData"));
    if (py_override.isNull()) {
        return this->QStandardItemModel::setHeaderData(section, orientation, value, role);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(iSSi)",
        section,
        Shiboken::Converter<Qt::Orientation >::toPython(orientation),
        Shiboken::Converter<QVariant & >::toPython(value),
        role
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QStandardItemModel.setHeaderData", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QStandardItemModelWrapper::setItemData(const QModelIndex & index, const QMap<int, QVariant > & roles)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setItemData"));
    if (py_override.isNull()) {
        return this->QStandardItemModel::setItemData(index, roles);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QModelIndex & >::toPython(index),
        Shiboken::Converter<QMap<int, QVariant >  >::toPython(roles)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QStandardItemModel.setItemData", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QStandardItemModelWrapper::sort(int column, Qt::SortOrder order)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "sort"));
    if (py_override.isNull()) {
        return this->QStandardItemModel::sort(column, order);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(iS)",
        column,
        Shiboken::Converter<Qt::SortOrder >::toPython(order)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QSize QStandardItemModelWrapper::span(const QModelIndex & index) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "span"));
    if (py_override.isNull()) {
        return this->QAbstractItemModel::span(index);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QModelIndex & >::toPython(index)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSize();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSize >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QStandardItemModel.span", SbkType<QSize >()->tp_name, py_result->ob_type->tp_name);
        return QSize();
    }
    QSize cpp_result(Shiboken::Converter<QSize >::toCpp(py_result));
    return cpp_result;
}

bool QStandardItemModelWrapper::submit()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "submit"));
    if (py_override.isNull()) {
        return this->QAbstractItemModel::submit();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QStandardItemModel.submit", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

QFlags<Qt::DropAction> QStandardItemModelWrapper::supportedDropActions() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "supportedDropActions"));
    if (py_override.isNull()) {
        return this->QStandardItemModel::supportedDropActions();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QFlags<Qt::DropAction>();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QFlags<Qt::DropAction> >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QStandardItemModel.supportedDropActions", SbkType<QFlags<Qt::DropAction> >()->tp_name, py_result->ob_type->tp_name);
        return QFlags<Qt::DropAction>();
    }
    QFlags<Qt::DropAction> cpp_result(Shiboken::Converter<QFlags<Qt::DropAction> >::toCpp(py_result));
    return cpp_result;
}

void QStandardItemModelWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QTimerEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

const QMetaObject* QStandardItemModelWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QStandardItemModel::staticMetaObject);
}
    return m_metaObject;
}

int QStandardItemModelWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QStandardItemModel::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QStandardItemModelWrapper::~QStandardItemModelWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQStandardItemModel_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QStandardItemModelWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "QStandardItemModel", 0, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return -1;

    if (numArgs == 0) {
        // QStandardItemModel(QObject*)
        cptr = new QStandardItemModelWrapper();
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else if (PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        if (numArgs == 2) {
            // QStandardItemModel(int,int,QObject*)
            cptr = new QStandardItemModelWrapper(cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(pyargs[2], self);
        } else if (Shiboken::Converter<QObject * >::isConvertible(pyargs[2])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                return -1;
            QObject* cpp_arg2 = Shiboken::Converter<QObject* >::toCpp(pyargs[2]);
            // QStandardItemModel(int,int,QObject*)
            cptr = new QStandardItemModelWrapper(cpp_arg0, cpp_arg1, cpp_arg2);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(pyargs[2], self);
        } else goto SbkQStandardItemModel_Init_TypeError;
    } else if (Shiboken::Converter<QObject * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(pyargs[0]);
        // QStandardItemModel(QObject*)
        cptr = new QStandardItemModelWrapper(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else goto SbkQStandardItemModel_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QStandardItemModel >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQStandardItemModel_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQStandardItemModel_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject = None", "int, int, PySide.QtCore.QObject = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QStandardItemModel", overloads);
        return -1;
}

static PyObject* SbkQStandardItemModelFunc_appendRow(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QStandardItem * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QStandardItem* cpp_arg0 = Shiboken::Converter<QStandardItem* >::toCpp(arg);
        // appendRow(QStandardItem*)
        QStandardItemModel* cppSelf = Shiboken::Converter<QStandardItemModel* >::toCpp((PyObject*)self);
        cppSelf->QStandardItemModel::appendRow(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, arg);
    } else goto SbkQStandardItemModelFunc_appendRow_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQStandardItemModelFunc_appendRow_TypeError:
        const char* overloads[] = {"PySide.QtGui.QStandardItem", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QStandardItemModel.appendRow", overloads);
        return 0;
}

static PyObject* SbkQStandardItemModelFunc_columnCount(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // columnCount(QModelIndex)const
        QStandardItemModel* cppSelf = Shiboken::Converter<QStandardItemModel* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QStandardItemModel::columnCount();
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QModelIndex & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(arg);
        // columnCount(QModelIndex)const
        QStandardItemModel* cppSelf = Shiboken::Converter<QStandardItemModel* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QStandardItemModel::columnCount(*cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQStandardItemModelFunc_columnCount_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQStandardItemModelFunc_columnCount_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex = QModelIndex()", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QStandardItemModel.columnCount", overloads);
        return 0;
}

static PyObject* SbkQStandardItemModelFunc_data(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "data", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QModelIndex & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // data(QModelIndex,int)const
            QStandardItemModel* cppSelf = Shiboken::Converter<QStandardItemModel* >::toCpp((PyObject*)self);
            QVariant cpp_result = cppSelf->QStandardItemModel::data(*cpp_arg0);
            py_result = Shiboken::Converter<QVariant >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            // data(QModelIndex,int)const
            QStandardItemModel* cppSelf = Shiboken::Converter<QStandardItemModel* >::toCpp((PyObject*)self);
            QVariant cpp_result = cppSelf->QStandardItemModel::data(*cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<QVariant >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQStandardItemModelFunc_data_TypeError;
    } else goto SbkQStandardItemModelFunc_data_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQStandardItemModelFunc_data_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex, int = Qt.DisplayRole", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QStandardItemModel.data", overloads);
        return 0;
}

static PyObject* SbkQStandardItemModelFunc_dropMimeData(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "dropMimeData", 5, 5, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4])))
        return 0;

    if (numArgs == 5 && Shiboken::Converter<QMimeData * >::isConvertible(pyargs[0]) && Shiboken::Converter<Qt::DropAction >::isConvertible(pyargs[1]) && PyNumber_Check(pyargs[2]) && PyNumber_Check(pyargs[3]) && Shiboken::Converter<QModelIndex & >::isConvertible(pyargs[4])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QMimeData* cpp_arg0 = Shiboken::Converter<QMimeData* >::toCpp(pyargs[0]);
        Qt::DropAction cpp_arg1 = Shiboken::Converter<Qt::DropAction >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        int cpp_arg3 = Shiboken::Converter<int >::toCpp(pyargs[3]);
        if (Shiboken::cppObjectIsInvalid(pyargs[4]))
            return 0;
        QModelIndex* cpp_arg4 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[4]);
        // dropMimeData(const QMimeData*,Qt::DropAction,int,int,QModelIndex)
        QStandardItemModel* cppSelf = Shiboken::Converter<QStandardItemModel* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QStandardItemModel::dropMimeData(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, *cpp_arg4);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQStandardItemModelFunc_dropMimeData_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQStandardItemModelFunc_dropMimeData_TypeError:
        const char* overloads[] = {"PySide.QtCore.QMimeData, PySide.QtCore.Qt.DropAction, int, int, PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QStandardItemModel.dropMimeData", overloads);
        return 0;
}

static PyObject* SbkQStandardItemModelFunc_flags(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QModelIndex & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(arg);
        // flags(QModelIndex)const
        QStandardItemModel* cppSelf = Shiboken::Converter<QStandardItemModel* >::toCpp((PyObject*)self);
        QFlags<Qt::ItemFlag> cpp_result = cppSelf->QStandardItemModel::flags(*cpp_arg0);
        py_result = Shiboken::Converter<QFlags<Qt::ItemFlag> >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQStandardItemModelFunc_flags_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQStandardItemModelFunc_flags_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QStandardItemModel.flags", overloads);
        return 0;
}

static PyObject* SbkQStandardItemModelFunc_hasChildren(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // hasChildren(QModelIndex)const
        QStandardItemModel* cppSelf = Shiboken::Converter<QStandardItemModel* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QStandardItemModel::hasChildren();
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QModelIndex & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(arg);
        // hasChildren(QModelIndex)const
        QStandardItemModel* cppSelf = Shiboken::Converter<QStandardItemModel* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QStandardItemModel::hasChildren(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQStandardItemModelFunc_hasChildren_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQStandardItemModelFunc_hasChildren_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex = QModelIndex()", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QStandardItemModel.hasChildren", overloads);
        return 0;
}

static PyObject* SbkQStandardItemModelFunc_headerData(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "headerData", 2, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (PyNumber_Check(pyargs[0]) && Shiboken::Converter<Qt::Orientation >::isConvertible(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        Qt::Orientation cpp_arg1 = Shiboken::Converter<Qt::Orientation >::toCpp(pyargs[1]);
        if (numArgs == 2) {
            // headerData(int,Qt::Orientation,int)const
            QStandardItemModel* cppSelf = Shiboken::Converter<QStandardItemModel* >::toCpp((PyObject*)self);
            QVariant cpp_result = cppSelf->QStandardItemModel::headerData(cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<QVariant >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[2])) {
            int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
            // headerData(int,Qt::Orientation,int)const
            QStandardItemModel* cppSelf = Shiboken::Converter<QStandardItemModel* >::toCpp((PyObject*)self);
            QVariant cpp_result = cppSelf->QStandardItemModel::headerData(cpp_arg0, cpp_arg1, cpp_arg2);
            py_result = Shiboken::Converter<QVariant >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQStandardItemModelFunc_headerData_TypeError;
    } else goto SbkQStandardItemModelFunc_headerData_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQStandardItemModelFunc_headerData_TypeError:
        const char* overloads[] = {"int, PySide.QtCore.Qt.Orientation, int = Qt.DisplayRole", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QStandardItemModel.headerData", overloads);
        return 0;
}

static PyObject* SbkQStandardItemModelFunc_horizontalHeaderItem(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // horizontalHeaderItem(int)const
        QStandardItemModel* cppSelf = Shiboken::Converter<QStandardItemModel* >::toCpp((PyObject*)self);
        QStandardItem * cpp_result = cppSelf->QStandardItemModel::horizontalHeaderItem(cpp_arg0);
        py_result = Shiboken::Converter<QStandardItem * >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else goto SbkQStandardItemModelFunc_horizontalHeaderItem_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQStandardItemModelFunc_horizontalHeaderItem_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QStandardItemModel.horizontalHeaderItem", overloads);
        return 0;
}

static PyObject* SbkQStandardItemModelFunc_index(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "index", 2, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        if (numArgs == 2) {
            // index(int,int,QModelIndex)const
            QStandardItemModel* cppSelf = Shiboken::Converter<QStandardItemModel* >::toCpp((PyObject*)self);
            QModelIndex cpp_result = cppSelf->QStandardItemModel::index(cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<QModelIndex >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QModelIndex & >::isConvertible(pyargs[2])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                return 0;
            QModelIndex* cpp_arg2 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[2]);
            // index(int,int,QModelIndex)const
            QStandardItemModel* cppSelf = Shiboken::Converter<QStandardItemModel* >::toCpp((PyObject*)self);
            QModelIndex cpp_result = cppSelf->QStandardItemModel::index(cpp_arg0, cpp_arg1, *cpp_arg2);
            py_result = Shiboken::Converter<QModelIndex >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQStandardItemModelFunc_index_TypeError;
    } else goto SbkQStandardItemModelFunc_index_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQStandardItemModelFunc_index_TypeError:
        const char* overloads[] = {"int, int, PySide.QtCore.QModelIndex = QModelIndex()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QStandardItemModel.index", overloads);
        return 0;
}

static PyObject* SbkQStandardItemModelFunc_indexFromItem(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QStandardItem * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QStandardItem* cpp_arg0 = Shiboken::Converter<QStandardItem* >::toCpp(arg);
        // indexFromItem(const QStandardItem*)const
        QStandardItemModel* cppSelf = Shiboken::Converter<QStandardItemModel* >::toCpp((PyObject*)self);
        QModelIndex cpp_result = cppSelf->QStandardItemModel::indexFromItem(cpp_arg0);
        py_result = Shiboken::Converter<QModelIndex >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQStandardItemModelFunc_indexFromItem_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQStandardItemModelFunc_indexFromItem_TypeError:
        const char* overloads[] = {"PySide.QtGui.QStandardItem", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QStandardItemModel.indexFromItem", overloads);
        return 0;
}

static PyObject* SbkQStandardItemModelFunc_insertColumn(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "insertColumn", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // insertColumn(int,QModelIndex)
            QStandardItemModel* cppSelf = Shiboken::Converter<QStandardItemModel* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QStandardItemModel::insertColumn(cpp_arg0);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QModelIndex & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QModelIndex* cpp_arg1 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[1]);
            // insertColumn(int,QModelIndex)
            QStandardItemModel* cppSelf = Shiboken::Converter<QStandardItemModel* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QStandardItemModel::insertColumn(cpp_arg0, *cpp_arg1);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQStandardItemModelFunc_insertColumn_TypeError;
    } else goto SbkQStandardItemModelFunc_insertColumn_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQStandardItemModelFunc_insertColumn_TypeError:
        const char* overloads[] = {"int, PySide.QtCore.QModelIndex = QModelIndex()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QStandardItemModel.insertColumn", overloads);
        return 0;
}

static PyObject* SbkQStandardItemModelFunc_insertColumns(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "insertColumns", 2, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        if (numArgs == 2) {
            // insertColumns(int,int,QModelIndex)
            QStandardItemModel* cppSelf = Shiboken::Converter<QStandardItemModel* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QStandardItemModel::insertColumns(cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QModelIndex & >::isConvertible(pyargs[2])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                return 0;
            QModelIndex* cpp_arg2 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[2]);
            // insertColumns(int,int,QModelIndex)
            QStandardItemModel* cppSelf = Shiboken::Converter<QStandardItemModel* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QStandardItemModel::insertColumns(cpp_arg0, cpp_arg1, *cpp_arg2);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQStandardItemModelFunc_insertColumns_TypeError;
    } else goto SbkQStandardItemModelFunc_insertColumns_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQStandardItemModelFunc_insertColumns_TypeError:
        const char* overloads[] = {"int, int, PySide.QtCore.QModelIndex = QModelIndex()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QStandardItemModel.insertColumns", overloads);
        return 0;
}

static PyObject* SbkQStandardItemModelFunc_insertRow(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "insertRow", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // insertRow(int,QModelIndex)
            QStandardItemModel* cppSelf = Shiboken::Converter<QStandardItemModel* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QStandardItemModel::insertRow(cpp_arg0);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QModelIndex & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QModelIndex* cpp_arg1 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[1]);
            // insertRow(int,QModelIndex)
            QStandardItemModel* cppSelf = Shiboken::Converter<QStandardItemModel* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QStandardItemModel::insertRow(cpp_arg0, *cpp_arg1);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && Shiboken::Converter<QStandardItem * >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QStandardItem* cpp_arg1 = Shiboken::Converter<QStandardItem* >::toCpp(pyargs[1]);
            // insertRow(int,QStandardItem*)
            QStandardItemModel* cppSelf = Shiboken::Converter<QStandardItemModel* >::toCpp((PyObject*)self);
            cppSelf->QStandardItemModel::insertRow(cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(self, pyargs[1]);
            py_result = Py_None;
            Py_INCREF(Py_None);
        } else goto SbkQStandardItemModelFunc_insertRow_TypeError;
    } else goto SbkQStandardItemModelFunc_insertRow_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQStandardItemModelFunc_insertRow_TypeError:
        const char* overloads[] = {"int, PySide.QtGui.QStandardItem", "int, PySide.QtCore.QModelIndex = QModelIndex()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QStandardItemModel.insertRow", overloads);
        return 0;
}

static PyObject* SbkQStandardItemModelFunc_insertRows(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "insertRows", 2, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        if (numArgs == 2) {
            // insertRows(int,int,QModelIndex)
            QStandardItemModel* cppSelf = Shiboken::Converter<QStandardItemModel* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QStandardItemModel::insertRows(cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QModelIndex & >::isConvertible(pyargs[2])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                return 0;
            QModelIndex* cpp_arg2 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[2]);
            // insertRows(int,int,QModelIndex)
            QStandardItemModel* cppSelf = Shiboken::Converter<QStandardItemModel* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QStandardItemModel::insertRows(cpp_arg0, cpp_arg1, *cpp_arg2);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQStandardItemModelFunc_insertRows_TypeError;
    } else goto SbkQStandardItemModelFunc_insertRows_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQStandardItemModelFunc_insertRows_TypeError:
        const char* overloads[] = {"int, int, PySide.QtCore.QModelIndex = QModelIndex()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QStandardItemModel.insertRows", overloads);
        return 0;
}

static PyObject* SbkQStandardItemModelFunc_invisibleRootItem(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // invisibleRootItem()const
    QStandardItemModel* cppSelf = Shiboken::Converter<QStandardItemModel* >::toCpp((PyObject*)self);
    QStandardItem * cpp_result = cppSelf->QStandardItemModel::invisibleRootItem();
    py_result = Shiboken::Converter<QStandardItem * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQStandardItemModelFunc_item(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "item", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // item(int,int)const
            QStandardItemModel* cppSelf = Shiboken::Converter<QStandardItemModel* >::toCpp((PyObject*)self);
            QStandardItem * cpp_result = cppSelf->QStandardItemModel::item(cpp_arg0);
            py_result = Shiboken::Converter<QStandardItem * >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(self, py_result);
        } else if (PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            // item(int,int)const
            QStandardItemModel* cppSelf = Shiboken::Converter<QStandardItemModel* >::toCpp((PyObject*)self);
            QStandardItem * cpp_result = cppSelf->QStandardItemModel::item(cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<QStandardItem * >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(self, py_result);
        } else goto SbkQStandardItemModelFunc_item_TypeError;
    } else goto SbkQStandardItemModelFunc_item_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQStandardItemModelFunc_item_TypeError:
        const char* overloads[] = {"int, int = 0", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QStandardItemModel.item", overloads);
        return 0;
}

static PyObject* SbkQStandardItemModelFunc_itemData(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QModelIndex & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(arg);
        // itemData(QModelIndex)const
        QStandardItemModel* cppSelf = Shiboken::Converter<QStandardItemModel* >::toCpp((PyObject*)self);
        QMap<int, QVariant > cpp_result = cppSelf->QStandardItemModel::itemData(*cpp_arg0);
        py_result = Shiboken::Converter<QMap<int, QVariant > >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQStandardItemModelFunc_itemData_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQStandardItemModelFunc_itemData_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QStandardItemModel.itemData", overloads);
        return 0;
}

static PyObject* SbkQStandardItemModelFunc_itemFromIndex(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QModelIndex & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(arg);
        // itemFromIndex(QModelIndex)const
        QStandardItemModel* cppSelf = Shiboken::Converter<QStandardItemModel* >::toCpp((PyObject*)self);
        QStandardItem * cpp_result = cppSelf->QStandardItemModel::itemFromIndex(*cpp_arg0);
        py_result = Shiboken::Converter<QStandardItem * >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else goto SbkQStandardItemModelFunc_itemFromIndex_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQStandardItemModelFunc_itemFromIndex_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QStandardItemModel.itemFromIndex", overloads);
        return 0;
}

static PyObject* SbkQStandardItemModelFunc_itemPrototype(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // itemPrototype()const
    QStandardItemModel* cppSelf = Shiboken::Converter<QStandardItemModel* >::toCpp((PyObject*)self);
    const QStandardItem * cpp_result = cppSelf->QStandardItemModel::itemPrototype();
    py_result = Shiboken::Converter<QStandardItem * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQStandardItemModelFunc_mimeData(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QList<QModelIndex >  >::isConvertible(arg)) {
        QList<QModelIndex >  cpp_arg0 = Shiboken::Converter<QList<QModelIndex >  >::toCpp(arg);
        // mimeData(QList<QModelIndex>)const
        QStandardItemModel* cppSelf = Shiboken::Converter<QStandardItemModel* >::toCpp((PyObject*)self);
        QMimeData * cpp_result = cppSelf->QStandardItemModel::mimeData(cpp_arg0);
        py_result = Shiboken::Converter<QMimeData * >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else goto SbkQStandardItemModelFunc_mimeData_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQStandardItemModelFunc_mimeData_TypeError:
        const char* overloads[] = {"list", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QStandardItemModel.mimeData", overloads);
        return 0;
}

static PyObject* SbkQStandardItemModelFunc_mimeTypes(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // mimeTypes()const
    QStandardItemModel* cppSelf = Shiboken::Converter<QStandardItemModel* >::toCpp((PyObject*)self);
    QStringList cpp_result = cppSelf->QStandardItemModel::mimeTypes();
    py_result = Shiboken::Converter<QStringList >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQStandardItemModelFunc_parent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QModelIndex & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(arg);
        // parent(QModelIndex)const
        QStandardItemModel* cppSelf = Shiboken::Converter<QStandardItemModel* >::toCpp((PyObject*)self);
        QModelIndex cpp_result = cppSelf->QStandardItemModel::parent(*cpp_arg0);
        py_result = Shiboken::Converter<QModelIndex >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQStandardItemModelFunc_parent_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQStandardItemModelFunc_parent_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QStandardItemModel.parent", overloads);
        return 0;
}

static PyObject* SbkQStandardItemModelFunc_removeColumns(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "removeColumns", 2, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        if (numArgs == 2) {
            // removeColumns(int,int,QModelIndex)
            QStandardItemModel* cppSelf = Shiboken::Converter<QStandardItemModel* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QStandardItemModel::removeColumns(cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QModelIndex & >::isConvertible(pyargs[2])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                return 0;
            QModelIndex* cpp_arg2 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[2]);
            // removeColumns(int,int,QModelIndex)
            QStandardItemModel* cppSelf = Shiboken::Converter<QStandardItemModel* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QStandardItemModel::removeColumns(cpp_arg0, cpp_arg1, *cpp_arg2);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQStandardItemModelFunc_removeColumns_TypeError;
    } else goto SbkQStandardItemModelFunc_removeColumns_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQStandardItemModelFunc_removeColumns_TypeError:
        const char* overloads[] = {"int, int, PySide.QtCore.QModelIndex = QModelIndex()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QStandardItemModel.removeColumns", overloads);
        return 0;
}

static PyObject* SbkQStandardItemModelFunc_removeRows(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "removeRows", 2, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        if (numArgs == 2) {
            // removeRows(int,int,QModelIndex)
            QStandardItemModel* cppSelf = Shiboken::Converter<QStandardItemModel* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QStandardItemModel::removeRows(cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QModelIndex & >::isConvertible(pyargs[2])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                return 0;
            QModelIndex* cpp_arg2 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[2]);
            // removeRows(int,int,QModelIndex)
            QStandardItemModel* cppSelf = Shiboken::Converter<QStandardItemModel* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QStandardItemModel::removeRows(cpp_arg0, cpp_arg1, *cpp_arg2);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQStandardItemModelFunc_removeRows_TypeError;
    } else goto SbkQStandardItemModelFunc_removeRows_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQStandardItemModelFunc_removeRows_TypeError:
        const char* overloads[] = {"int, int, PySide.QtCore.QModelIndex = QModelIndex()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QStandardItemModel.removeRows", overloads);
        return 0;
}

static PyObject* SbkQStandardItemModelFunc_rowCount(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // rowCount(QModelIndex)const
        QStandardItemModel* cppSelf = Shiboken::Converter<QStandardItemModel* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QStandardItemModel::rowCount();
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QModelIndex & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(arg);
        // rowCount(QModelIndex)const
        QStandardItemModel* cppSelf = Shiboken::Converter<QStandardItemModel* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QStandardItemModel::rowCount(*cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQStandardItemModelFunc_rowCount_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQStandardItemModelFunc_rowCount_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex = QModelIndex()", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QStandardItemModel.rowCount", overloads);
        return 0;
}

static PyObject* SbkQStandardItemModelFunc_setColumnCount(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setColumnCount(int)
        QStandardItemModel* cppSelf = Shiboken::Converter<QStandardItemModel* >::toCpp((PyObject*)self);
        cppSelf->QStandardItemModel::setColumnCount(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQStandardItemModelFunc_setColumnCount_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQStandardItemModelFunc_setColumnCount_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QStandardItemModel.setColumnCount", overloads);
        return 0;
}

static PyObject* SbkQStandardItemModelFunc_setData(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "setData", 2, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (Shiboken::Converter<QModelIndex & >::isConvertible(pyargs[0]) && Shiboken::Converter<QVariant & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QVariant > cpp_arg1_auto_ptr;
        QVariant* cpp_arg1 = Shiboken::Converter<QVariant* >::toCpp(pyargs[1]);
        if (!SbkQVariant_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QVariant >(cpp_arg1);
        if (numArgs == 2) {
            // setData(QModelIndex,QVariant,int)
            QStandardItemModel* cppSelf = Shiboken::Converter<QStandardItemModel* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QStandardItemModel::setData(*cpp_arg0, *cpp_arg1);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[2])) {
            int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
            // setData(QModelIndex,QVariant,int)
            QStandardItemModel* cppSelf = Shiboken::Converter<QStandardItemModel* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QStandardItemModel::setData(*cpp_arg0, *cpp_arg1, cpp_arg2);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQStandardItemModelFunc_setData_TypeError;
    } else goto SbkQStandardItemModelFunc_setData_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQStandardItemModelFunc_setData_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex, PySide.QtCore.QVariant, int = Qt.EditRole", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QStandardItemModel.setData", overloads);
        return 0;
}

static PyObject* SbkQStandardItemModelFunc_setHeaderData(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "setHeaderData", 3, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (PyNumber_Check(pyargs[0]) && Shiboken::Converter<Qt::Orientation >::isConvertible(pyargs[1]) && Shiboken::Converter<QVariant & >::isConvertible(pyargs[2])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        Qt::Orientation cpp_arg1 = Shiboken::Converter<Qt::Orientation >::toCpp(pyargs[1]);
        if (Shiboken::cppObjectIsInvalid(pyargs[2]))
            return 0;
        std::auto_ptr<QVariant > cpp_arg2_auto_ptr;
        QVariant* cpp_arg2 = Shiboken::Converter<QVariant* >::toCpp(pyargs[2]);
        if (!SbkQVariant_Check(pyargs[2]))
            cpp_arg2_auto_ptr = std::auto_ptr<QVariant >(cpp_arg2);
        if (numArgs == 3) {
            // setHeaderData(int,Qt::Orientation,QVariant,int)
            QStandardItemModel* cppSelf = Shiboken::Converter<QStandardItemModel* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QStandardItemModel::setHeaderData(cpp_arg0, cpp_arg1, *cpp_arg2);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[3])) {
            int cpp_arg3 = Shiboken::Converter<int >::toCpp(pyargs[3]);
            // setHeaderData(int,Qt::Orientation,QVariant,int)
            QStandardItemModel* cppSelf = Shiboken::Converter<QStandardItemModel* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QStandardItemModel::setHeaderData(cpp_arg0, cpp_arg1, *cpp_arg2, cpp_arg3);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQStandardItemModelFunc_setHeaderData_TypeError;
    } else goto SbkQStandardItemModelFunc_setHeaderData_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQStandardItemModelFunc_setHeaderData_TypeError:
        const char* overloads[] = {"int, PySide.QtCore.Qt.Orientation, PySide.QtCore.QVariant, int = Qt.EditRole", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QStandardItemModel.setHeaderData", overloads);
        return 0;
}

static PyObject* SbkQStandardItemModelFunc_setHorizontalHeaderItem(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setHorizontalHeaderItem", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && Shiboken::Converter<QStandardItem * >::isConvertible(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QStandardItem* cpp_arg1 = Shiboken::Converter<QStandardItem* >::toCpp(pyargs[1]);
        // setHorizontalHeaderItem(int,QStandardItem*)
        QStandardItemModel* cppSelf = Shiboken::Converter<QStandardItemModel* >::toCpp((PyObject*)self);
        cppSelf->QStandardItemModel::setHorizontalHeaderItem(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, pyargs[1]);
    } else goto SbkQStandardItemModelFunc_setHorizontalHeaderItem_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQStandardItemModelFunc_setHorizontalHeaderItem_TypeError:
        const char* overloads[] = {"int, PySide.QtGui.QStandardItem", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QStandardItemModel.setHorizontalHeaderItem", overloads);
        return 0;
}

static PyObject* SbkQStandardItemModelFunc_setHorizontalHeaderLabels(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QStringList & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QStringList > cpp_arg0_auto_ptr;
        QStringList* cpp_arg0 = Shiboken::Converter<QStringList* >::toCpp(arg);
        if (!SbkQStringList_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QStringList >(cpp_arg0);
        // setHorizontalHeaderLabels(QStringList)
        QStandardItemModel* cppSelf = Shiboken::Converter<QStandardItemModel* >::toCpp((PyObject*)self);
        cppSelf->QStandardItemModel::setHorizontalHeaderLabels(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQStandardItemModelFunc_setHorizontalHeaderLabels_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQStandardItemModelFunc_setHorizontalHeaderLabels_TypeError:
        const char* overloads[] = {"PySide.QtCore.QStringList", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QStandardItemModel.setHorizontalHeaderLabels", overloads);
        return 0;
}

static PyObject* SbkQStandardItemModelFunc_setItem(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "setItem", 2, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (numArgs == 3 && PyNumber_Check(pyargs[1]) && Shiboken::Converter<QStandardItem * >::isConvertible(pyargs[2])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                return 0;
            QStandardItem* cpp_arg2 = Shiboken::Converter<QStandardItem* >::toCpp(pyargs[2]);
            // setItem(int,int,QStandardItem*)
            QStandardItemModel* cppSelf = Shiboken::Converter<QStandardItemModel* >::toCpp((PyObject*)self);
            cppSelf->QStandardItemModel::setItem(cpp_arg0, cpp_arg1, cpp_arg2);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(self, pyargs[2]);
        } else if (numArgs == 2 && Shiboken::Converter<QStandardItem * >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QStandardItem* cpp_arg1 = Shiboken::Converter<QStandardItem* >::toCpp(pyargs[1]);
            // setItem(int,QStandardItem*)
            QStandardItemModel* cppSelf = Shiboken::Converter<QStandardItemModel* >::toCpp((PyObject*)self);
            cppSelf->QStandardItemModel::setItem(cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(self, pyargs[1]);
        } else goto SbkQStandardItemModelFunc_setItem_TypeError;
    } else goto SbkQStandardItemModelFunc_setItem_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQStandardItemModelFunc_setItem_TypeError:
        const char* overloads[] = {"int, PySide.QtGui.QStandardItem", "int, int, PySide.QtGui.QStandardItem", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QStandardItemModel.setItem", overloads);
        return 0;
}

static PyObject* SbkQStandardItemModelFunc_setItemData(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setItemData", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QModelIndex & >::isConvertible(pyargs[0]) && Shiboken::Converter<QMap<int, QVariant >  >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(pyargs[0]);
        QMap<int, QVariant >  cpp_arg1 = Shiboken::Converter<QMap<int, QVariant >  >::toCpp(pyargs[1]);
        // setItemData(QModelIndex,QMap<int,QVariant>)
        QStandardItemModel* cppSelf = Shiboken::Converter<QStandardItemModel* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QStandardItemModel::setItemData(*cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQStandardItemModelFunc_setItemData_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQStandardItemModelFunc_setItemData_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex, dict", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QStandardItemModel.setItemData", overloads);
        return 0;
}

static PyObject* SbkQStandardItemModelFunc_setItemPrototype(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QStandardItem * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QStandardItem* cpp_arg0 = Shiboken::Converter<QStandardItem* >::toCpp(arg);
        // setItemPrototype(const QStandardItem*)
        QStandardItemModel* cppSelf = Shiboken::Converter<QStandardItemModel* >::toCpp((PyObject*)self);
        cppSelf->QStandardItemModel::setItemPrototype(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, arg);
    } else goto SbkQStandardItemModelFunc_setItemPrototype_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQStandardItemModelFunc_setItemPrototype_TypeError:
        const char* overloads[] = {"PySide.QtGui.QStandardItem", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QStandardItemModel.setItemPrototype", overloads);
        return 0;
}

static PyObject* SbkQStandardItemModelFunc_setRowCount(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setRowCount(int)
        QStandardItemModel* cppSelf = Shiboken::Converter<QStandardItemModel* >::toCpp((PyObject*)self);
        cppSelf->QStandardItemModel::setRowCount(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQStandardItemModelFunc_setRowCount_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQStandardItemModelFunc_setRowCount_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QStandardItemModel.setRowCount", overloads);
        return 0;
}

static PyObject* SbkQStandardItemModelFunc_setSortRole(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setSortRole(int)
        QStandardItemModel* cppSelf = Shiboken::Converter<QStandardItemModel* >::toCpp((PyObject*)self);
        cppSelf->QStandardItemModel::setSortRole(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQStandardItemModelFunc_setSortRole_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQStandardItemModelFunc_setSortRole_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QStandardItemModel.setSortRole", overloads);
        return 0;
}

static PyObject* SbkQStandardItemModelFunc_setVerticalHeaderItem(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setVerticalHeaderItem", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && Shiboken::Converter<QStandardItem * >::isConvertible(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QStandardItem* cpp_arg1 = Shiboken::Converter<QStandardItem* >::toCpp(pyargs[1]);
        // setVerticalHeaderItem(int,QStandardItem*)
        QStandardItemModel* cppSelf = Shiboken::Converter<QStandardItemModel* >::toCpp((PyObject*)self);
        cppSelf->QStandardItemModel::setVerticalHeaderItem(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, pyargs[1]);
    } else goto SbkQStandardItemModelFunc_setVerticalHeaderItem_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQStandardItemModelFunc_setVerticalHeaderItem_TypeError:
        const char* overloads[] = {"int, PySide.QtGui.QStandardItem", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QStandardItemModel.setVerticalHeaderItem", overloads);
        return 0;
}

static PyObject* SbkQStandardItemModelFunc_setVerticalHeaderLabels(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QStringList & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QStringList > cpp_arg0_auto_ptr;
        QStringList* cpp_arg0 = Shiboken::Converter<QStringList* >::toCpp(arg);
        if (!SbkQStringList_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QStringList >(cpp_arg0);
        // setVerticalHeaderLabels(QStringList)
        QStandardItemModel* cppSelf = Shiboken::Converter<QStandardItemModel* >::toCpp((PyObject*)self);
        cppSelf->QStandardItemModel::setVerticalHeaderLabels(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQStandardItemModelFunc_setVerticalHeaderLabels_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQStandardItemModelFunc_setVerticalHeaderLabels_TypeError:
        const char* overloads[] = {"PySide.QtCore.QStringList", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QStandardItemModel.setVerticalHeaderLabels", overloads);
        return 0;
}

static PyObject* SbkQStandardItemModelFunc_sort(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "sort", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // sort(int,Qt::SortOrder)
            QStandardItemModel* cppSelf = Shiboken::Converter<QStandardItemModel* >::toCpp((PyObject*)self);
            cppSelf->QStandardItemModel::sort(cpp_arg0);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<Qt::SortOrder >::isConvertible(pyargs[1])) {
            Qt::SortOrder cpp_arg1 = Shiboken::Converter<Qt::SortOrder >::toCpp(pyargs[1]);
            // sort(int,Qt::SortOrder)
            QStandardItemModel* cppSelf = Shiboken::Converter<QStandardItemModel* >::toCpp((PyObject*)self);
            cppSelf->QStandardItemModel::sort(cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQStandardItemModelFunc_sort_TypeError;
    } else goto SbkQStandardItemModelFunc_sort_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQStandardItemModelFunc_sort_TypeError:
        const char* overloads[] = {"int, PySide.QtCore.Qt.SortOrder = Qt.AscendingOrder", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QStandardItemModel.sort", overloads);
        return 0;
}

static PyObject* SbkQStandardItemModelFunc_sortRole(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // sortRole()const
    QStandardItemModel* cppSelf = Shiboken::Converter<QStandardItemModel* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QStandardItemModel::sortRole();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQStandardItemModelFunc_supportedDropActions(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // supportedDropActions()const
    QStandardItemModel* cppSelf = Shiboken::Converter<QStandardItemModel* >::toCpp((PyObject*)self);
    QFlags<Qt::DropAction> cpp_result = cppSelf->QStandardItemModel::supportedDropActions();
    py_result = Shiboken::Converter<QFlags<Qt::DropAction> >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQStandardItemModelFunc_takeHorizontalHeaderItem(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // takeHorizontalHeaderItem(int)
        QStandardItemModel* cppSelf = Shiboken::Converter<QStandardItemModel* >::toCpp((PyObject*)self);
        QStandardItem * cpp_result = cppSelf->QStandardItemModel::takeHorizontalHeaderItem(cpp_arg0);
        py_result = Shiboken::Converter<QStandardItem * >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(Py_None, py_result);
    } else goto SbkQStandardItemModelFunc_takeHorizontalHeaderItem_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQStandardItemModelFunc_takeHorizontalHeaderItem_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QStandardItemModel.takeHorizontalHeaderItem", overloads);
        return 0;
}

static PyObject* SbkQStandardItemModelFunc_takeItem(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "takeItem", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // takeItem(int,int)
            QStandardItemModel* cppSelf = Shiboken::Converter<QStandardItemModel* >::toCpp((PyObject*)self);
            QStandardItem * cpp_result = cppSelf->QStandardItemModel::takeItem(cpp_arg0);
            py_result = Shiboken::Converter<QStandardItem * >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(Py_None, py_result);
        } else if (PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            // takeItem(int,int)
            QStandardItemModel* cppSelf = Shiboken::Converter<QStandardItemModel* >::toCpp((PyObject*)self);
            QStandardItem * cpp_result = cppSelf->QStandardItemModel::takeItem(cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<QStandardItem * >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(Py_None, py_result);
        } else goto SbkQStandardItemModelFunc_takeItem_TypeError;
    } else goto SbkQStandardItemModelFunc_takeItem_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQStandardItemModelFunc_takeItem_TypeError:
        const char* overloads[] = {"int, int = 0", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QStandardItemModel.takeItem", overloads);
        return 0;
}

static PyObject* SbkQStandardItemModelFunc_takeVerticalHeaderItem(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // takeVerticalHeaderItem(int)
        QStandardItemModel* cppSelf = Shiboken::Converter<QStandardItemModel* >::toCpp((PyObject*)self);
        QStandardItem * cpp_result = cppSelf->QStandardItemModel::takeVerticalHeaderItem(cpp_arg0);
        py_result = Shiboken::Converter<QStandardItem * >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(Py_None, py_result);
    } else goto SbkQStandardItemModelFunc_takeVerticalHeaderItem_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQStandardItemModelFunc_takeVerticalHeaderItem_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QStandardItemModel.takeVerticalHeaderItem", overloads);
        return 0;
}

static PyObject* SbkQStandardItemModelFunc_verticalHeaderItem(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // verticalHeaderItem(int)const
        QStandardItemModel* cppSelf = Shiboken::Converter<QStandardItemModel* >::toCpp((PyObject*)self);
        QStandardItem * cpp_result = cppSelf->QStandardItemModel::verticalHeaderItem(cpp_arg0);
        py_result = Shiboken::Converter<QStandardItem * >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else goto SbkQStandardItemModelFunc_verticalHeaderItem_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQStandardItemModelFunc_verticalHeaderItem_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QStandardItemModel.verticalHeaderItem", overloads);
        return 0;
}

static PyMethodDef SbkQStandardItemModel_methods[] = {
    {"appendRow", (PyCFunction)SbkQStandardItemModelFunc_appendRow, METH_O},
    {"columnCount", (PyCFunction)SbkQStandardItemModelFunc_columnCount, METH_NOARGS|METH_O},
    {"data", (PyCFunction)SbkQStandardItemModelFunc_data, METH_VARARGS},
    {"dropMimeData", (PyCFunction)SbkQStandardItemModelFunc_dropMimeData, METH_VARARGS},
    {"flags", (PyCFunction)SbkQStandardItemModelFunc_flags, METH_O},
    {"hasChildren", (PyCFunction)SbkQStandardItemModelFunc_hasChildren, METH_NOARGS|METH_O},
    {"headerData", (PyCFunction)SbkQStandardItemModelFunc_headerData, METH_VARARGS},
    {"horizontalHeaderItem", (PyCFunction)SbkQStandardItemModelFunc_horizontalHeaderItem, METH_O},
    {"index", (PyCFunction)SbkQStandardItemModelFunc_index, METH_VARARGS},
    {"indexFromItem", (PyCFunction)SbkQStandardItemModelFunc_indexFromItem, METH_O},
    {"insertColumn", (PyCFunction)SbkQStandardItemModelFunc_insertColumn, METH_VARARGS},
    {"insertColumns", (PyCFunction)SbkQStandardItemModelFunc_insertColumns, METH_VARARGS},
    {"insertRow", (PyCFunction)SbkQStandardItemModelFunc_insertRow, METH_VARARGS},
    {"insertRows", (PyCFunction)SbkQStandardItemModelFunc_insertRows, METH_VARARGS},
    {"invisibleRootItem", (PyCFunction)SbkQStandardItemModelFunc_invisibleRootItem, METH_NOARGS},
    {"item", (PyCFunction)SbkQStandardItemModelFunc_item, METH_VARARGS},
    {"itemData", (PyCFunction)SbkQStandardItemModelFunc_itemData, METH_O},
    {"itemFromIndex", (PyCFunction)SbkQStandardItemModelFunc_itemFromIndex, METH_O},
    {"itemPrototype", (PyCFunction)SbkQStandardItemModelFunc_itemPrototype, METH_NOARGS},
    {"mimeData", (PyCFunction)SbkQStandardItemModelFunc_mimeData, METH_O},
    {"mimeTypes", (PyCFunction)SbkQStandardItemModelFunc_mimeTypes, METH_NOARGS},
    {"parent", (PyCFunction)SbkQStandardItemModelFunc_parent, METH_O},
    {"removeColumns", (PyCFunction)SbkQStandardItemModelFunc_removeColumns, METH_VARARGS},
    {"removeRows", (PyCFunction)SbkQStandardItemModelFunc_removeRows, METH_VARARGS},
    {"rowCount", (PyCFunction)SbkQStandardItemModelFunc_rowCount, METH_NOARGS|METH_O},
    {"setColumnCount", (PyCFunction)SbkQStandardItemModelFunc_setColumnCount, METH_O},
    {"setData", (PyCFunction)SbkQStandardItemModelFunc_setData, METH_VARARGS},
    {"setHeaderData", (PyCFunction)SbkQStandardItemModelFunc_setHeaderData, METH_VARARGS},
    {"setHorizontalHeaderItem", (PyCFunction)SbkQStandardItemModelFunc_setHorizontalHeaderItem, METH_VARARGS},
    {"setHorizontalHeaderLabels", (PyCFunction)SbkQStandardItemModelFunc_setHorizontalHeaderLabels, METH_O},
    {"setItem", (PyCFunction)SbkQStandardItemModelFunc_setItem, METH_VARARGS},
    {"setItemData", (PyCFunction)SbkQStandardItemModelFunc_setItemData, METH_VARARGS},
    {"setItemPrototype", (PyCFunction)SbkQStandardItemModelFunc_setItemPrototype, METH_O},
    {"setRowCount", (PyCFunction)SbkQStandardItemModelFunc_setRowCount, METH_O},
    {"setSortRole", (PyCFunction)SbkQStandardItemModelFunc_setSortRole, METH_O},
    {"setVerticalHeaderItem", (PyCFunction)SbkQStandardItemModelFunc_setVerticalHeaderItem, METH_VARARGS},
    {"setVerticalHeaderLabels", (PyCFunction)SbkQStandardItemModelFunc_setVerticalHeaderLabels, METH_O},
    {"sort", (PyCFunction)SbkQStandardItemModelFunc_sort, METH_VARARGS},
    {"sortRole", (PyCFunction)SbkQStandardItemModelFunc_sortRole, METH_NOARGS},
    {"supportedDropActions", (PyCFunction)SbkQStandardItemModelFunc_supportedDropActions, METH_NOARGS},
    {"takeHorizontalHeaderItem", (PyCFunction)SbkQStandardItemModelFunc_takeHorizontalHeaderItem, METH_O},
    {"takeItem", (PyCFunction)SbkQStandardItemModelFunc_takeItem, METH_VARARGS},
    {"takeVerticalHeaderItem", (PyCFunction)SbkQStandardItemModelFunc_takeVerticalHeaderItem, METH_O},
    {"verticalHeaderItem", (PyCFunction)SbkQStandardItemModelFunc_verticalHeaderItem, METH_O},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQStandardItemModel_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QStandardItemModel",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQStandardItemModel_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQStandardItemModel_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QStandardItemModel >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_QStandardItemModel(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QSTANDARDITEMMODEL_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQStandardItemModel_Type);

    SbkQStandardItemModel_Type.super.ht_type.tp_base = SbkPySide_QtCoreTypes[SBK_QABSTRACTITEMMODEL_IDX];
    // Fill type discovery information
    SbkQStandardItemModel_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQStandardItemModel_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQStandardItemModel_Type));
    PyModule_AddObject(module, "QStandardItemModel",
        ((PyObject*)&SbkQStandardItemModel_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QStandardItemModel >("QStandardItemModel*");
    Shiboken::TypeResolver::createObjectTypeResolver<QStandardItemModel >(typeid(QStandardItemModel).name());
}


} // extern "C"

