/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qpainterpath_element_wrapper.h"

// Extra includes
#include <QPainterPath>

using namespace Shiboken;

static int
SbkQPainterPath_Element_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QPainterPath::Element* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "Element", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // Element()
        cptr = new QPainterPath::Element();
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QPainterPath::Element & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QPainterPath::Element* cpp_arg0 = Shiboken::Converter<QPainterPath::Element* >::toCpp(pyargs[0]);
        // Element(QPainterPath::Element)
        cptr = new QPainterPath::Element(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPainterPath_Element_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QPainterPath::Element >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQPainterPath_Element_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->referredObjects = new Shiboken::RefCountMap;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQPainterPath_Element_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtGui.QPainterPath::Element", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.Element", overloads);
        return -1;
}

static PyObject* SbkQPainterPath_ElementFunc_isCurveTo(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isCurveTo()const
    QPainterPath::Element* cppSelf = Shiboken::Converter<QPainterPath::Element* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QPainterPath::Element::isCurveTo();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQPainterPath_ElementFunc_isLineTo(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isLineTo()const
    QPainterPath::Element* cppSelf = Shiboken::Converter<QPainterPath::Element* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QPainterPath::Element::isLineTo();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQPainterPath_ElementFunc_isMoveTo(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isMoveTo()const
    QPainterPath::Element* cppSelf = Shiboken::Converter<QPainterPath::Element* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QPainterPath::Element::isMoveTo();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQPainterPath_Element_methods[] = {
    {"isCurveTo", (PyCFunction)SbkQPainterPath_ElementFunc_isCurveTo, METH_NOARGS},
    {"isLineTo", (PyCFunction)SbkQPainterPath_ElementFunc_isLineTo, METH_NOARGS},
    {"isMoveTo", (PyCFunction)SbkQPainterPath_ElementFunc_isMoveTo, METH_NOARGS},
    {0} // Sentinel
};

// Rich comparison
static PyObject* SbkQPainterPath_Element_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result = false;
    QPainterPath::Element& cpp_self = *Shiboken::Converter<QPainterPath::Element* >::toCpp((PyObject*)self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<QPainterPath::Element & >::isConvertible(other)) {
                // operator!=(const QPainterPath::Element & e) const
                QPainterPath::Element* cpp_other = Shiboken::Converter<QPainterPath::Element* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QPainterPath::Element  >::toCpp(other) : (cpp_self != (*cpp_other));
            } else goto SbkQPainterPath_Element_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<QPainterPath::Element & >::isConvertible(other)) {
                // operator==(const QPainterPath::Element & e) const
                QPainterPath::Element* cpp_other = Shiboken::Converter<QPainterPath::Element* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QPainterPath::Element  >::toCpp(other) : (cpp_self == (*cpp_other));
            } else goto SbkQPainterPath_Element_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    SbkQPainterPath_Element_RichComparison_TypeError:
    Py_RETURN_FALSE;

}

static PyObject* SbkQPainterPath_Element_get_x(SbkBaseWrapper* self)
{
    return Shiboken::Converter<double >::toPython(Shiboken::Converter<QPainterPath::Element* >::toCpp((PyObject*)self)->x);
}
static int SbkQPainterPath_Element_set_x(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'x' may not be deleted");
        return -1;
    }
    if (!PyNumber_Check(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'x', 'qreal' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QPainterPath::Element* >::toCpp((PyObject*)self)->x = Shiboken::Converter<double >::toCpp(value);

    return 0;
}

static PyObject* SbkQPainterPath_Element_get_y(SbkBaseWrapper* self)
{
    return Shiboken::Converter<double >::toPython(Shiboken::Converter<QPainterPath::Element* >::toCpp((PyObject*)self)->y);
}
static int SbkQPainterPath_Element_set_y(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'y' may not be deleted");
        return -1;
    }
    if (!PyNumber_Check(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'y', 'qreal' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QPainterPath::Element* >::toCpp((PyObject*)self)->y = Shiboken::Converter<double >::toCpp(value);

    return 0;
}

static PyObject* SbkQPainterPath_Element_get_type(SbkBaseWrapper* self)
{
    return Shiboken::Converter<QPainterPath::ElementType >::toPython(Shiboken::Converter<QPainterPath::Element* >::toCpp((PyObject*)self)->type);
}
static int SbkQPainterPath_Element_set_type(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'type' may not be deleted");
        return -1;
    }
    if (!Shiboken::Converter<QPainterPath::ElementType >::isConvertible(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'type', 'ElementType' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QPainterPath::Element* >::toCpp((PyObject*)self)->type = Shiboken::Converter<QPainterPath::ElementType >::toCpp(value);

    return 0;
}

// Getters and Setters for Element
static PyGetSetDef SbkQPainterPath_Element_getsetlist[] = {
    {const_cast<char*>("x"), (getter)SbkQPainterPath_Element_get_x, (setter)SbkQPainterPath_Element_set_x},
    {const_cast<char*>("y"), (getter)SbkQPainterPath_Element_get_y, (setter)SbkQPainterPath_Element_set_y},
    {const_cast<char*>("type"), (getter)SbkQPainterPath_Element_get_type, (setter)SbkQPainterPath_Element_set_type},
    {0}  // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQPainterPath_Element_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.Element",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQPainterPath_Element_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQPainterPath_Element_methods,
    /*tp_members*/          0,
    /*tp_getset*/           SbkQPainterPath_Element_getsetlist,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQPainterPath_Element_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QPainterPath::Element >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_QPainterPath_Element(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QPAINTERPATH_ELEMENT_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQPainterPath_Element_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQPainterPath_Element_Type) < 0)
        return;

    PyDict_SetItemString(module,"Element", (PyObject*)&SbkQPainterPath_Element_Type);
    Shiboken::TypeResolver::createValueTypeResolver<QPainterPath::Element >("QPainterPath::Element");
    Shiboken::TypeResolver::createValueTypeResolver<QPainterPath::Element >(typeid(QPainterPath::Element).name());
}


} // extern "C"

