/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qpaintdevice_wrapper.h"

// Extra includes
#include <qpaintdevice.h>
#include <qpaintengine.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QPaintDeviceWrapper::QPaintDeviceWrapper() : QPaintDevice() {
    // ... middle
}

int QPaintDeviceWrapper::devType() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "devType"));
    if (py_override.isNull()) {
        return this->QPaintDevice::devType();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QPaintDevice.devType", SbkType<int >()->tp_name, py_result->ob_type->tp_name);
        return int(0);
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

int QPaintDeviceWrapper::metric(QPaintDevice::PaintDeviceMetric metric) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "metric"));
    if (py_override.isNull()) {
        return this->QPaintDevice::metric(metric);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QPaintDevice::PaintDeviceMetric >::toPython(metric)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QPaintDevice.metric", SbkType<int >()->tp_name, py_result->ob_type->tp_name);
        return int(0);
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

QPaintEngine * QPaintDeviceWrapper::paintEngine() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "paintEngine"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QPaintDevice.paintEngine()' not implemented.");
        return 0;
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QPaintEngine * >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QPaintDevice.paintEngine", SbkType<QPaintEngine * >()->tp_name, py_result->ob_type->tp_name);
        return 0;
    }
    QPaintEngine * cpp_result(Shiboken::Converter<QPaintEngine * >::toCpp(py_result));
    return cpp_result;
}

QPaintDeviceWrapper::~QPaintDeviceWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

static int
SbkQPaintDevice_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QPaintDeviceWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    SbkBaseWrapperType* type = reinterpret_cast<SbkBaseWrapperType*>(self->ob_type);
    SbkBaseWrapperType* myType = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QPAINTDEVICE_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'QPaintDevice' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }

    // QPaintDevice()
    cptr = new QPaintDeviceWrapper();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QPaintDevice >(), cptr)) {
        delete cptr;
        return -1;
    }
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    sbkSelf->referredObjects = new Shiboken::RefCountMap;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;
}

static PyObject* SbkQPaintDeviceFunc_colorCount(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // colorCount()const
    QPaintDevice* cppSelf = Shiboken::Converter<QPaintDevice* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QPaintDevice::colorCount();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQPaintDeviceFunc_depth(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // depth()const
    QPaintDevice* cppSelf = Shiboken::Converter<QPaintDevice* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QPaintDevice::depth();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQPaintDeviceFunc_devType(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // devType()const
    QPaintDevice* cppSelf = Shiboken::Converter<QPaintDevice* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QPaintDevice::devType();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQPaintDeviceFunc_height(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // height()const
    QPaintDevice* cppSelf = Shiboken::Converter<QPaintDevice* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QPaintDevice::height();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQPaintDeviceFunc_heightMM(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // heightMM()const
    QPaintDevice* cppSelf = Shiboken::Converter<QPaintDevice* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QPaintDevice::heightMM();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQPaintDeviceFunc_logicalDpiX(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // logicalDpiX()const
    QPaintDevice* cppSelf = Shiboken::Converter<QPaintDevice* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QPaintDevice::logicalDpiX();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQPaintDeviceFunc_logicalDpiY(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // logicalDpiY()const
    QPaintDevice* cppSelf = Shiboken::Converter<QPaintDevice* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QPaintDevice::logicalDpiY();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQPaintDeviceFunc_metric(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QPaintDevice::PaintDeviceMetric >::isConvertible(arg)) {
        QPaintDevice::PaintDeviceMetric cpp_arg0 = Shiboken::Converter<QPaintDevice::PaintDeviceMetric >::toCpp(arg);
        // metric(QPaintDevice::PaintDeviceMetric)const
        QPaintDevice* cppSelf = Shiboken::Converter<QPaintDevice* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QPaintDevice::metric(cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQPaintDeviceFunc_metric_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQPaintDeviceFunc_metric_TypeError:
        const char* overloads[] = {"PySide.QtGui.QPaintDevice.PaintDeviceMetric", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QPaintDevice.metric", overloads);
        return 0;
}

static PyObject* SbkQPaintDeviceFunc_numColors(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // numColors()const
    QPaintDevice* cppSelf = Shiboken::Converter<QPaintDevice* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QPaintDevice::numColors();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQPaintDeviceFunc_paintEngine(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // paintEngine()const
    if (SbkBaseWrapper_containsCppWrapper(self)) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QPaintDevice.paintEngine()' not implemented.");
        return 0;
    }
    QPaintDevice* cppSelf = Shiboken::Converter<QPaintDevice* >::toCpp((PyObject*)self);
    QPaintEngine * cpp_result = cppSelf->paintEngine();
    py_result = Shiboken::Converter<QPaintEngine * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQPaintDeviceFunc_paintingActive(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // paintingActive()const
    QPaintDevice* cppSelf = Shiboken::Converter<QPaintDevice* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QPaintDevice::paintingActive();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQPaintDeviceFunc_physicalDpiX(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // physicalDpiX()const
    QPaintDevice* cppSelf = Shiboken::Converter<QPaintDevice* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QPaintDevice::physicalDpiX();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQPaintDeviceFunc_physicalDpiY(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // physicalDpiY()const
    QPaintDevice* cppSelf = Shiboken::Converter<QPaintDevice* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QPaintDevice::physicalDpiY();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQPaintDeviceFunc_width(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // width()const
    QPaintDevice* cppSelf = Shiboken::Converter<QPaintDevice* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QPaintDevice::width();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQPaintDeviceFunc_widthMM(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // widthMM()const
    QPaintDevice* cppSelf = Shiboken::Converter<QPaintDevice* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QPaintDevice::widthMM();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQPaintDevice_methods[] = {
    {"colorCount", (PyCFunction)SbkQPaintDeviceFunc_colorCount, METH_NOARGS},
    {"depth", (PyCFunction)SbkQPaintDeviceFunc_depth, METH_NOARGS},
    {"devType", (PyCFunction)SbkQPaintDeviceFunc_devType, METH_NOARGS},
    {"height", (PyCFunction)SbkQPaintDeviceFunc_height, METH_NOARGS},
    {"heightMM", (PyCFunction)SbkQPaintDeviceFunc_heightMM, METH_NOARGS},
    {"logicalDpiX", (PyCFunction)SbkQPaintDeviceFunc_logicalDpiX, METH_NOARGS},
    {"logicalDpiY", (PyCFunction)SbkQPaintDeviceFunc_logicalDpiY, METH_NOARGS},
    {"metric", (PyCFunction)SbkQPaintDeviceFunc_metric, METH_O},
    {"numColors", (PyCFunction)SbkQPaintDeviceFunc_numColors, METH_NOARGS},
    {"paintEngine", (PyCFunction)SbkQPaintDeviceFunc_paintEngine, METH_NOARGS},
    {"paintingActive", (PyCFunction)SbkQPaintDeviceFunc_paintingActive, METH_NOARGS},
    {"physicalDpiX", (PyCFunction)SbkQPaintDeviceFunc_physicalDpiX, METH_NOARGS},
    {"physicalDpiY", (PyCFunction)SbkQPaintDeviceFunc_physicalDpiY, METH_NOARGS},
    {"width", (PyCFunction)SbkQPaintDeviceFunc_width, METH_NOARGS},
    {"widthMM", (PyCFunction)SbkQPaintDeviceFunc_widthMM, METH_NOARGS},
    {0} // Sentinel
};

static PyObject* SbkQPaintDevice_get_painters(SbkBaseWrapper* self)
{
    return Shiboken::Converter<ushort >::toPython(Shiboken::Converter<QPaintDevice* >::toCpp((PyObject*)self)->painters);
}
static int SbkQPaintDevice_set_painters(SbkBaseWrapper* self, PyObject* value)
{
    if (value == 0) {
        PyErr_SetString(PyExc_TypeError, "'painters' may not be deleted");
        return -1;
    }
    if (!PyNumber_Check(value)) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'painters', 'ushort' or convertible type expected");
        return -1;
    }

    Shiboken::Converter<QPaintDevice* >::toCpp((PyObject*)self)->painters = Shiboken::Converter<ushort >::toCpp(value);

    return 0;
}

// Getters and Setters for QPaintDevice
static PyGetSetDef SbkQPaintDevice_getsetlist[] = {
    {const_cast<char*>("painters"), (getter)SbkQPaintDevice_get_painters, (setter)SbkQPaintDevice_set_painters},
    {0}  // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQPaintDevice_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QPaintDevice",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQPaintDevice_methods,
    /*tp_members*/          0,
    /*tp_getset*/           SbkQPaintDevice_getsetlist,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQPaintDevice_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QPaintDevice >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static SbkBaseWrapperType* SbkQPaintDevice_typeDiscovery(void* cptr, SbkBaseWrapperType* instanceType)
{
    if (instanceType->mi_specialcast)
        cptr = instanceType->mi_specialcast(cptr, &SbkQPaintDevice_Type);
    TypeResolver* typeResolver = TypeResolver::get(typeid(*reinterpret_cast<QPaintDevice*>(cptr)).name());
    if (typeResolver)
        return reinterpret_cast<SbkBaseWrapperType*>(typeResolver->pythonType());
    return 0;
}

static PyGetSetDef SbkPySide_QtGui_QPaintDevice_PaintDeviceMetric_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QPaintDevice_PaintDeviceMetric_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QPaintDevice_PaintDeviceMetric_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PaintDeviceMetric",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QPaintDevice_PaintDeviceMetric_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QPaintDevice_PaintDeviceMetric_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QPaintDevice_PaintDeviceMetric_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void) init_QPaintDevice(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QPAINTDEVICE_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQPaintDevice_Type);

    // Fill type discovery information
    SbkQPaintDevice_Type.type_discovery = new Shiboken::TypeDiscovery;
    SbkQPaintDevice_Type.type_discovery->addTypeDiscoveryFunction(&SbkQPaintDevice_typeDiscovery);

    if (PyType_Ready((PyTypeObject*)&SbkQPaintDevice_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQPaintDevice_Type));
    PyModule_AddObject(module, "QPaintDevice",
        ((PyObject*)&SbkQPaintDevice_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: PaintDeviceMetric
    SbkPySide_QtGuiTypes[SBK_QPAINTDEVICE_PAINTDEVICEMETRIC_IDX] = &SbkPySide_QtGui_QPaintDevice_PaintDeviceMetric_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QPaintDevice_PaintDeviceMetric_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QPaintDevice_PaintDeviceMetric_Type);
    PyDict_SetItemString(SbkQPaintDevice_Type.super.ht_type.tp_dict,
            "PaintDeviceMetric",((PyObject*)&SbkPySide_QtGui_QPaintDevice_PaintDeviceMetric_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPaintDevice_PaintDeviceMetric_Type,
        (long) QPaintDevice::PdmWidth, "PdmWidth");
    PyDict_SetItemString(SbkQPaintDevice_Type.super.ht_type.tp_dict,
        "PdmWidth", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPaintDevice_PaintDeviceMetric_Type.tp_dict,
        "PdmWidth", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPaintDevice_PaintDeviceMetric_Type,
        (long) QPaintDevice::PdmHeight, "PdmHeight");
    PyDict_SetItemString(SbkQPaintDevice_Type.super.ht_type.tp_dict,
        "PdmHeight", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPaintDevice_PaintDeviceMetric_Type.tp_dict,
        "PdmHeight", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPaintDevice_PaintDeviceMetric_Type,
        (long) QPaintDevice::PdmWidthMM, "PdmWidthMM");
    PyDict_SetItemString(SbkQPaintDevice_Type.super.ht_type.tp_dict,
        "PdmWidthMM", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPaintDevice_PaintDeviceMetric_Type.tp_dict,
        "PdmWidthMM", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPaintDevice_PaintDeviceMetric_Type,
        (long) QPaintDevice::PdmHeightMM, "PdmHeightMM");
    PyDict_SetItemString(SbkQPaintDevice_Type.super.ht_type.tp_dict,
        "PdmHeightMM", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPaintDevice_PaintDeviceMetric_Type.tp_dict,
        "PdmHeightMM", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPaintDevice_PaintDeviceMetric_Type,
        (long) QPaintDevice::PdmNumColors, "PdmNumColors");
    PyDict_SetItemString(SbkQPaintDevice_Type.super.ht_type.tp_dict,
        "PdmNumColors", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPaintDevice_PaintDeviceMetric_Type.tp_dict,
        "PdmNumColors", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPaintDevice_PaintDeviceMetric_Type,
        (long) QPaintDevice::PdmDepth, "PdmDepth");
    PyDict_SetItemString(SbkQPaintDevice_Type.super.ht_type.tp_dict,
        "PdmDepth", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPaintDevice_PaintDeviceMetric_Type.tp_dict,
        "PdmDepth", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPaintDevice_PaintDeviceMetric_Type,
        (long) QPaintDevice::PdmDpiX, "PdmDpiX");
    PyDict_SetItemString(SbkQPaintDevice_Type.super.ht_type.tp_dict,
        "PdmDpiX", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPaintDevice_PaintDeviceMetric_Type.tp_dict,
        "PdmDpiX", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPaintDevice_PaintDeviceMetric_Type,
        (long) QPaintDevice::PdmDpiY, "PdmDpiY");
    PyDict_SetItemString(SbkQPaintDevice_Type.super.ht_type.tp_dict,
        "PdmDpiY", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPaintDevice_PaintDeviceMetric_Type.tp_dict,
        "PdmDpiY", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPaintDevice_PaintDeviceMetric_Type,
        (long) QPaintDevice::PdmPhysicalDpiX, "PdmPhysicalDpiX");
    PyDict_SetItemString(SbkQPaintDevice_Type.super.ht_type.tp_dict,
        "PdmPhysicalDpiX", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPaintDevice_PaintDeviceMetric_Type.tp_dict,
        "PdmPhysicalDpiX", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QPaintDevice_PaintDeviceMetric_Type,
        (long) QPaintDevice::PdmPhysicalDpiY, "PdmPhysicalDpiY");
    PyDict_SetItemString(SbkQPaintDevice_Type.super.ht_type.tp_dict,
        "PdmPhysicalDpiY", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QPaintDevice_PaintDeviceMetric_Type.tp_dict,
        "PdmPhysicalDpiY", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QPaintDevice::PaintDeviceMetric");

    Shiboken::TypeResolver::createObjectTypeResolver<QPaintDevice >("QPaintDevice*");
    Shiboken::TypeResolver::createObjectTypeResolver<QPaintDevice >(typeid(QPaintDevice).name());
}


} // extern "C"

