/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qgraphicsgridlayout_wrapper.h"

// Extra includes
#include <qcoreevent.h>
#include <qgraphicsgridlayout.h>
#include <qgraphicsitem.h>
#include <qgraphicslayoutitem.h>
#include <qrect.h>
#include <qsize.h>
#include <qsizepolicy.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QGraphicsGridLayoutWrapper::QGraphicsGridLayoutWrapper(QGraphicsLayoutItem * parent) : QGraphicsGridLayout(parent) {
    // ... middle
}

int QGraphicsGridLayoutWrapper::count() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "count"));
    if (py_override.isNull()) {
        return this->QGraphicsGridLayout::count();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QGraphicsGridLayout.count", SbkType<int >()->tp_name, py_result->ob_type->tp_name);
        return int(0);
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

void QGraphicsGridLayoutWrapper::invalidate()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "invalidate"));
    if (py_override.isNull()) {
        return this->QGraphicsGridLayout::invalidate();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QGraphicsLayoutItem * QGraphicsGridLayoutWrapper::itemAt(int index) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "itemAt"));
    if (py_override.isNull()) {
        return this->QGraphicsGridLayout::itemAt(index);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        index
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QGraphicsLayoutItem * >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QGraphicsGridLayout.itemAt", SbkType<QGraphicsLayoutItem * >()->tp_name, py_result->ob_type->tp_name);
        return 0;
    }
    QGraphicsLayoutItem * cpp_result(Shiboken::Converter<QGraphicsLayoutItem * >::toCpp(py_result));
    return cpp_result;
}

void QGraphicsGridLayoutWrapper::removeAt(int index)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "removeAt"));
    if (py_override.isNull()) {
        return this->QGraphicsGridLayout::removeAt(index);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        index
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGraphicsGridLayoutWrapper::setGeometry(const QRectF & rect)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setGeometry"));
    if (py_override.isNull()) {
        return this->QGraphicsGridLayout::setGeometry(rect);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QRectF & >::toPython(rect)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QSizeF QGraphicsGridLayoutWrapper::sizeHint(Qt::SizeHint which, const QSizeF & constraint) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "sizeHint"));
    if (py_override.isNull()) {
        return this->QGraphicsGridLayout::sizeHint(which, constraint);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<Qt::SizeHint >::toPython(which),
        Shiboken::Converter<QSizeF & >::toPython(constraint)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QSizeF();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QSizeF >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QGraphicsGridLayout.sizeHint", SbkType<QSizeF >()->tp_name, py_result->ob_type->tp_name);
        return QSizeF();
    }
    QSizeF cpp_result(Shiboken::Converter<QSizeF >::toCpp(py_result));
    return cpp_result;
}

void QGraphicsGridLayoutWrapper::updateGeometry()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "updateGeometry"));
    if (py_override.isNull()) {
        return this->QGraphicsLayout::updateGeometry();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QGraphicsGridLayoutWrapper::widgetEvent(QEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "widgetEvent"));
    if (py_override.isNull()) {
        return this->QGraphicsLayout::widgetEvent(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

QGraphicsGridLayoutWrapper::~QGraphicsGridLayoutWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

static int
SbkQGraphicsGridLayout_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QGraphicsGridLayoutWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QGraphicsGridLayout", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QGraphicsGridLayout(QGraphicsLayoutItem*)
        cptr = new QGraphicsGridLayoutWrapper();
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else if (Shiboken::Converter<QGraphicsLayoutItem * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QGraphicsLayoutItem* cpp_arg0 = Shiboken::Converter<QGraphicsLayoutItem* >::toCpp(pyargs[0]);
        // QGraphicsGridLayout(QGraphicsLayoutItem*)
        cptr = new QGraphicsGridLayoutWrapper(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else goto SbkQGraphicsGridLayout_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QGraphicsGridLayout >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQGraphicsGridLayout_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQGraphicsGridLayout_Init_TypeError:
        const char* overloads[] = {"PySide.QtGui.QGraphicsLayoutItem = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsGridLayout", overloads);
        return -1;
}

static PyObject* SbkQGraphicsGridLayoutFunc_addItem(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "addItem", 3, 6, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4]), &(pyargs[5])))
        return 0;

    if (Shiboken::Converter<QGraphicsLayoutItem * >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QGraphicsLayoutItem* cpp_arg0 = Shiboken::Converter<QGraphicsLayoutItem* >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        if (numArgs == 3) {
            // addItem(QGraphicsLayoutItem*,int,int,QFlags<Qt::AlignmentFlag>)
            QGraphicsGridLayout* cppSelf = Shiboken::Converter<QGraphicsGridLayout* >::toCpp((PyObject*)self);
            cppSelf->QGraphicsGridLayout::addItem(cpp_arg0, cpp_arg1, cpp_arg2);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(self, pyargs[0]);
        } else if (PyNumber_Check(pyargs[3]) && PyNumber_Check(pyargs[4])) {
            int cpp_arg3 = Shiboken::Converter<int >::toCpp(pyargs[3]);
            int cpp_arg4 = Shiboken::Converter<int >::toCpp(pyargs[4]);
            if (numArgs == 5) {
                // addItem(QGraphicsLayoutItem*,int,int,int,int,QFlags<Qt::AlignmentFlag>)
                QGraphicsGridLayout* cppSelf = Shiboken::Converter<QGraphicsGridLayout* >::toCpp((PyObject*)self);
                cppSelf->QGraphicsGridLayout::addItem(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, cpp_arg4);
                //CppGenerator::writeParentChildManagement
                Shiboken::setParent(self, pyargs[0]);
            } else if (SbkPySide_QtCore_Qt_AlignmentFlag_Check(pyargs[5])) {
                QFlags<Qt::AlignmentFlag> cpp_arg5 = Shiboken::Converter<QFlags<Qt::AlignmentFlag> >::toCpp(pyargs[5]);
                // addItem(QGraphicsLayoutItem*,int,int,int,int,QFlags<Qt::AlignmentFlag>)
                QGraphicsGridLayout* cppSelf = Shiboken::Converter<QGraphicsGridLayout* >::toCpp((PyObject*)self);
                cppSelf->QGraphicsGridLayout::addItem(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, cpp_arg4, cpp_arg5);
                //CppGenerator::writeParentChildManagement
                Shiboken::setParent(self, pyargs[0]);
            } else goto SbkQGraphicsGridLayoutFunc_addItem_TypeError;
        } else if (SbkPySide_QtCore_Qt_AlignmentFlag_Check(pyargs[3])) {
            QFlags<Qt::AlignmentFlag> cpp_arg3 = Shiboken::Converter<QFlags<Qt::AlignmentFlag> >::toCpp(pyargs[3]);
            // addItem(QGraphicsLayoutItem*,int,int,QFlags<Qt::AlignmentFlag>)
            QGraphicsGridLayout* cppSelf = Shiboken::Converter<QGraphicsGridLayout* >::toCpp((PyObject*)self);
            cppSelf->QGraphicsGridLayout::addItem(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(self, pyargs[0]);
        } else goto SbkQGraphicsGridLayoutFunc_addItem_TypeError;
    } else goto SbkQGraphicsGridLayoutFunc_addItem_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsGridLayoutFunc_addItem_TypeError:
        const char* overloads[] = {"PySide.QtGui.QGraphicsLayoutItem, int, int, PySide.QtCore.Qt.Alignment = 0", "PySide.QtGui.QGraphicsLayoutItem, int, int, int, int, PySide.QtCore.Qt.Alignment = 0", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsGridLayout.addItem", overloads);
        return 0;
}

static PyObject* SbkQGraphicsGridLayoutFunc_alignment(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QGraphicsLayoutItem * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QGraphicsLayoutItem* cpp_arg0 = Shiboken::Converter<QGraphicsLayoutItem* >::toCpp(arg);
        // alignment(QGraphicsLayoutItem*)const
        QGraphicsGridLayout* cppSelf = Shiboken::Converter<QGraphicsGridLayout* >::toCpp((PyObject*)self);
        QFlags<Qt::AlignmentFlag> cpp_result = cppSelf->QGraphicsGridLayout::alignment(cpp_arg0);
        py_result = Shiboken::Converter<QFlags<Qt::AlignmentFlag> >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsGridLayoutFunc_alignment_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQGraphicsGridLayoutFunc_alignment_TypeError:
        const char* overloads[] = {"PySide.QtGui.QGraphicsLayoutItem", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsGridLayout.alignment", overloads);
        return 0;
}

static PyObject* SbkQGraphicsGridLayoutFunc_columnAlignment(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // columnAlignment(int)const
        QGraphicsGridLayout* cppSelf = Shiboken::Converter<QGraphicsGridLayout* >::toCpp((PyObject*)self);
        QFlags<Qt::AlignmentFlag> cpp_result = cppSelf->QGraphicsGridLayout::columnAlignment(cpp_arg0);
        py_result = Shiboken::Converter<QFlags<Qt::AlignmentFlag> >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsGridLayoutFunc_columnAlignment_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQGraphicsGridLayoutFunc_columnAlignment_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsGridLayout.columnAlignment", overloads);
        return 0;
}

static PyObject* SbkQGraphicsGridLayoutFunc_columnCount(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // columnCount()const
    QGraphicsGridLayout* cppSelf = Shiboken::Converter<QGraphicsGridLayout* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QGraphicsGridLayout::columnCount();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGraphicsGridLayoutFunc_columnMaximumWidth(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // columnMaximumWidth(int)const
        QGraphicsGridLayout* cppSelf = Shiboken::Converter<QGraphicsGridLayout* >::toCpp((PyObject*)self);
        qreal cpp_result = cppSelf->QGraphicsGridLayout::columnMaximumWidth(cpp_arg0);
        py_result = Shiboken::Converter<double >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsGridLayoutFunc_columnMaximumWidth_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQGraphicsGridLayoutFunc_columnMaximumWidth_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsGridLayout.columnMaximumWidth", overloads);
        return 0;
}

static PyObject* SbkQGraphicsGridLayoutFunc_columnMinimumWidth(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // columnMinimumWidth(int)const
        QGraphicsGridLayout* cppSelf = Shiboken::Converter<QGraphicsGridLayout* >::toCpp((PyObject*)self);
        qreal cpp_result = cppSelf->QGraphicsGridLayout::columnMinimumWidth(cpp_arg0);
        py_result = Shiboken::Converter<double >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsGridLayoutFunc_columnMinimumWidth_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQGraphicsGridLayoutFunc_columnMinimumWidth_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsGridLayout.columnMinimumWidth", overloads);
        return 0;
}

static PyObject* SbkQGraphicsGridLayoutFunc_columnPreferredWidth(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // columnPreferredWidth(int)const
        QGraphicsGridLayout* cppSelf = Shiboken::Converter<QGraphicsGridLayout* >::toCpp((PyObject*)self);
        qreal cpp_result = cppSelf->QGraphicsGridLayout::columnPreferredWidth(cpp_arg0);
        py_result = Shiboken::Converter<double >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsGridLayoutFunc_columnPreferredWidth_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQGraphicsGridLayoutFunc_columnPreferredWidth_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsGridLayout.columnPreferredWidth", overloads);
        return 0;
}

static PyObject* SbkQGraphicsGridLayoutFunc_columnSpacing(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // columnSpacing(int)const
        QGraphicsGridLayout* cppSelf = Shiboken::Converter<QGraphicsGridLayout* >::toCpp((PyObject*)self);
        qreal cpp_result = cppSelf->QGraphicsGridLayout::columnSpacing(cpp_arg0);
        py_result = Shiboken::Converter<double >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsGridLayoutFunc_columnSpacing_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQGraphicsGridLayoutFunc_columnSpacing_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsGridLayout.columnSpacing", overloads);
        return 0;
}

static PyObject* SbkQGraphicsGridLayoutFunc_columnStretchFactor(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // columnStretchFactor(int)const
        QGraphicsGridLayout* cppSelf = Shiboken::Converter<QGraphicsGridLayout* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QGraphicsGridLayout::columnStretchFactor(cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsGridLayoutFunc_columnStretchFactor_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQGraphicsGridLayoutFunc_columnStretchFactor_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsGridLayout.columnStretchFactor", overloads);
        return 0;
}

static PyObject* SbkQGraphicsGridLayoutFunc_count(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // count()const
    QGraphicsGridLayout* cppSelf = Shiboken::Converter<QGraphicsGridLayout* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QGraphicsGridLayout::count();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGraphicsGridLayoutFunc_horizontalSpacing(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // horizontalSpacing()const
    QGraphicsGridLayout* cppSelf = Shiboken::Converter<QGraphicsGridLayout* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QGraphicsGridLayout::horizontalSpacing();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGraphicsGridLayoutFunc_invalidate(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // invalidate()
    QGraphicsGridLayout* cppSelf = Shiboken::Converter<QGraphicsGridLayout* >::toCpp((PyObject*)self);
    cppSelf->QGraphicsGridLayout::invalidate();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQGraphicsGridLayoutFunc_itemAt(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "itemAt", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // itemAt(int)const
            QGraphicsGridLayout* cppSelf = Shiboken::Converter<QGraphicsGridLayout* >::toCpp((PyObject*)self);
            QGraphicsLayoutItem * cpp_result = cppSelf->QGraphicsGridLayout::itemAt(cpp_arg0);
            py_result = Shiboken::Converter<QGraphicsLayoutItem * >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(self, py_result);
        } else if (numArgs == 2 && PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            // itemAt(int,int)const
            QGraphicsGridLayout* cppSelf = Shiboken::Converter<QGraphicsGridLayout* >::toCpp((PyObject*)self);
            QGraphicsLayoutItem * cpp_result = cppSelf->QGraphicsGridLayout::itemAt(cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<QGraphicsLayoutItem * >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(self, py_result);
        } else goto SbkQGraphicsGridLayoutFunc_itemAt_TypeError;
    } else goto SbkQGraphicsGridLayoutFunc_itemAt_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQGraphicsGridLayoutFunc_itemAt_TypeError:
        const char* overloads[] = {"int", "int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsGridLayout.itemAt", overloads);
        return 0;
}

static PyObject* SbkQGraphicsGridLayoutFunc_removeAt(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // removeAt(int)
        QGraphicsGridLayout* cppSelf = Shiboken::Converter<QGraphicsGridLayout* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsGridLayout::removeAt(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsGridLayoutFunc_removeAt_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsGridLayoutFunc_removeAt_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsGridLayout.removeAt", overloads);
        return 0;
}

static PyObject* SbkQGraphicsGridLayoutFunc_rowAlignment(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // rowAlignment(int)const
        QGraphicsGridLayout* cppSelf = Shiboken::Converter<QGraphicsGridLayout* >::toCpp((PyObject*)self);
        QFlags<Qt::AlignmentFlag> cpp_result = cppSelf->QGraphicsGridLayout::rowAlignment(cpp_arg0);
        py_result = Shiboken::Converter<QFlags<Qt::AlignmentFlag> >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsGridLayoutFunc_rowAlignment_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQGraphicsGridLayoutFunc_rowAlignment_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsGridLayout.rowAlignment", overloads);
        return 0;
}

static PyObject* SbkQGraphicsGridLayoutFunc_rowCount(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // rowCount()const
    QGraphicsGridLayout* cppSelf = Shiboken::Converter<QGraphicsGridLayout* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QGraphicsGridLayout::rowCount();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQGraphicsGridLayoutFunc_rowMaximumHeight(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // rowMaximumHeight(int)const
        QGraphicsGridLayout* cppSelf = Shiboken::Converter<QGraphicsGridLayout* >::toCpp((PyObject*)self);
        qreal cpp_result = cppSelf->QGraphicsGridLayout::rowMaximumHeight(cpp_arg0);
        py_result = Shiboken::Converter<double >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsGridLayoutFunc_rowMaximumHeight_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQGraphicsGridLayoutFunc_rowMaximumHeight_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsGridLayout.rowMaximumHeight", overloads);
        return 0;
}

static PyObject* SbkQGraphicsGridLayoutFunc_rowMinimumHeight(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // rowMinimumHeight(int)const
        QGraphicsGridLayout* cppSelf = Shiboken::Converter<QGraphicsGridLayout* >::toCpp((PyObject*)self);
        qreal cpp_result = cppSelf->QGraphicsGridLayout::rowMinimumHeight(cpp_arg0);
        py_result = Shiboken::Converter<double >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsGridLayoutFunc_rowMinimumHeight_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQGraphicsGridLayoutFunc_rowMinimumHeight_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsGridLayout.rowMinimumHeight", overloads);
        return 0;
}

static PyObject* SbkQGraphicsGridLayoutFunc_rowPreferredHeight(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // rowPreferredHeight(int)const
        QGraphicsGridLayout* cppSelf = Shiboken::Converter<QGraphicsGridLayout* >::toCpp((PyObject*)self);
        qreal cpp_result = cppSelf->QGraphicsGridLayout::rowPreferredHeight(cpp_arg0);
        py_result = Shiboken::Converter<double >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsGridLayoutFunc_rowPreferredHeight_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQGraphicsGridLayoutFunc_rowPreferredHeight_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsGridLayout.rowPreferredHeight", overloads);
        return 0;
}

static PyObject* SbkQGraphicsGridLayoutFunc_rowSpacing(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // rowSpacing(int)const
        QGraphicsGridLayout* cppSelf = Shiboken::Converter<QGraphicsGridLayout* >::toCpp((PyObject*)self);
        qreal cpp_result = cppSelf->QGraphicsGridLayout::rowSpacing(cpp_arg0);
        py_result = Shiboken::Converter<double >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsGridLayoutFunc_rowSpacing_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQGraphicsGridLayoutFunc_rowSpacing_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsGridLayout.rowSpacing", overloads);
        return 0;
}

static PyObject* SbkQGraphicsGridLayoutFunc_rowStretchFactor(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // rowStretchFactor(int)const
        QGraphicsGridLayout* cppSelf = Shiboken::Converter<QGraphicsGridLayout* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QGraphicsGridLayout::rowStretchFactor(cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsGridLayoutFunc_rowStretchFactor_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQGraphicsGridLayoutFunc_rowStretchFactor_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsGridLayout.rowStretchFactor", overloads);
        return 0;
}

static PyObject* SbkQGraphicsGridLayoutFunc_setAlignment(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setAlignment", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QGraphicsLayoutItem * >::isConvertible(pyargs[0]) && SbkPySide_QtCore_Qt_AlignmentFlag_Check(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QGraphicsLayoutItem* cpp_arg0 = Shiboken::Converter<QGraphicsLayoutItem* >::toCpp(pyargs[0]);
        QFlags<Qt::AlignmentFlag> cpp_arg1 = Shiboken::Converter<QFlags<Qt::AlignmentFlag> >::toCpp(pyargs[1]);
        // setAlignment(QGraphicsLayoutItem*,QFlags<Qt::AlignmentFlag>)
        QGraphicsGridLayout* cppSelf = Shiboken::Converter<QGraphicsGridLayout* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsGridLayout::setAlignment(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, pyargs[0]);
    } else goto SbkQGraphicsGridLayoutFunc_setAlignment_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsGridLayoutFunc_setAlignment_TypeError:
        const char* overloads[] = {"PySide.QtGui.QGraphicsLayoutItem, PySide.QtCore.Qt.Alignment", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsGridLayout.setAlignment", overloads);
        return 0;
}

static PyObject* SbkQGraphicsGridLayoutFunc_setColumnAlignment(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setColumnAlignment", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && SbkPySide_QtCore_Qt_AlignmentFlag_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        QFlags<Qt::AlignmentFlag> cpp_arg1 = Shiboken::Converter<QFlags<Qt::AlignmentFlag> >::toCpp(pyargs[1]);
        // setColumnAlignment(int,QFlags<Qt::AlignmentFlag>)
        QGraphicsGridLayout* cppSelf = Shiboken::Converter<QGraphicsGridLayout* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsGridLayout::setColumnAlignment(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsGridLayoutFunc_setColumnAlignment_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsGridLayoutFunc_setColumnAlignment_TypeError:
        const char* overloads[] = {"int, PySide.QtCore.Qt.Alignment", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsGridLayout.setColumnAlignment", overloads);
        return 0;
}

static PyObject* SbkQGraphicsGridLayoutFunc_setColumnFixedWidth(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setColumnFixedWidth", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        // setColumnFixedWidth(int,qreal)
        QGraphicsGridLayout* cppSelf = Shiboken::Converter<QGraphicsGridLayout* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsGridLayout::setColumnFixedWidth(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsGridLayoutFunc_setColumnFixedWidth_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsGridLayoutFunc_setColumnFixedWidth_TypeError:
        const char* overloads[] = {"int, float", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsGridLayout.setColumnFixedWidth", overloads);
        return 0;
}

static PyObject* SbkQGraphicsGridLayoutFunc_setColumnMaximumWidth(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setColumnMaximumWidth", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        // setColumnMaximumWidth(int,qreal)
        QGraphicsGridLayout* cppSelf = Shiboken::Converter<QGraphicsGridLayout* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsGridLayout::setColumnMaximumWidth(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsGridLayoutFunc_setColumnMaximumWidth_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsGridLayoutFunc_setColumnMaximumWidth_TypeError:
        const char* overloads[] = {"int, float", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsGridLayout.setColumnMaximumWidth", overloads);
        return 0;
}

static PyObject* SbkQGraphicsGridLayoutFunc_setColumnMinimumWidth(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setColumnMinimumWidth", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        // setColumnMinimumWidth(int,qreal)
        QGraphicsGridLayout* cppSelf = Shiboken::Converter<QGraphicsGridLayout* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsGridLayout::setColumnMinimumWidth(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsGridLayoutFunc_setColumnMinimumWidth_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsGridLayoutFunc_setColumnMinimumWidth_TypeError:
        const char* overloads[] = {"int, float", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsGridLayout.setColumnMinimumWidth", overloads);
        return 0;
}

static PyObject* SbkQGraphicsGridLayoutFunc_setColumnPreferredWidth(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setColumnPreferredWidth", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        // setColumnPreferredWidth(int,qreal)
        QGraphicsGridLayout* cppSelf = Shiboken::Converter<QGraphicsGridLayout* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsGridLayout::setColumnPreferredWidth(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsGridLayoutFunc_setColumnPreferredWidth_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsGridLayoutFunc_setColumnPreferredWidth_TypeError:
        const char* overloads[] = {"int, float", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsGridLayout.setColumnPreferredWidth", overloads);
        return 0;
}

static PyObject* SbkQGraphicsGridLayoutFunc_setColumnSpacing(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setColumnSpacing", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        // setColumnSpacing(int,qreal)
        QGraphicsGridLayout* cppSelf = Shiboken::Converter<QGraphicsGridLayout* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsGridLayout::setColumnSpacing(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsGridLayoutFunc_setColumnSpacing_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsGridLayoutFunc_setColumnSpacing_TypeError:
        const char* overloads[] = {"int, float", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsGridLayout.setColumnSpacing", overloads);
        return 0;
}

static PyObject* SbkQGraphicsGridLayoutFunc_setColumnStretchFactor(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setColumnStretchFactor", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // setColumnStretchFactor(int,int)
        QGraphicsGridLayout* cppSelf = Shiboken::Converter<QGraphicsGridLayout* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsGridLayout::setColumnStretchFactor(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsGridLayoutFunc_setColumnStretchFactor_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsGridLayoutFunc_setColumnStretchFactor_TypeError:
        const char* overloads[] = {"int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsGridLayout.setColumnStretchFactor", overloads);
        return 0;
}

static PyObject* SbkQGraphicsGridLayoutFunc_setGeometry(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QRectF & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QRectF > cpp_arg0_auto_ptr;
        QRectF* cpp_arg0 = Shiboken::Converter<QRectF* >::toCpp(arg);
        if (!SbkQRectF_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QRectF >(cpp_arg0);
        // setGeometry(QRectF)
        QGraphicsGridLayout* cppSelf = Shiboken::Converter<QGraphicsGridLayout* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsGridLayout::setGeometry(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsGridLayoutFunc_setGeometry_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsGridLayoutFunc_setGeometry_TypeError:
        const char* overloads[] = {"PySide.QtCore.QRectF", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsGridLayout.setGeometry", overloads);
        return 0;
}

static PyObject* SbkQGraphicsGridLayoutFunc_setHorizontalSpacing(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setHorizontalSpacing(qreal)
        QGraphicsGridLayout* cppSelf = Shiboken::Converter<QGraphicsGridLayout* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsGridLayout::setHorizontalSpacing(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsGridLayoutFunc_setHorizontalSpacing_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsGridLayoutFunc_setHorizontalSpacing_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsGridLayout.setHorizontalSpacing", overloads);
        return 0;
}

static PyObject* SbkQGraphicsGridLayoutFunc_setRowAlignment(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setRowAlignment", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && SbkPySide_QtCore_Qt_AlignmentFlag_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        QFlags<Qt::AlignmentFlag> cpp_arg1 = Shiboken::Converter<QFlags<Qt::AlignmentFlag> >::toCpp(pyargs[1]);
        // setRowAlignment(int,QFlags<Qt::AlignmentFlag>)
        QGraphicsGridLayout* cppSelf = Shiboken::Converter<QGraphicsGridLayout* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsGridLayout::setRowAlignment(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsGridLayoutFunc_setRowAlignment_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsGridLayoutFunc_setRowAlignment_TypeError:
        const char* overloads[] = {"int, PySide.QtCore.Qt.Alignment", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsGridLayout.setRowAlignment", overloads);
        return 0;
}

static PyObject* SbkQGraphicsGridLayoutFunc_setRowFixedHeight(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setRowFixedHeight", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        // setRowFixedHeight(int,qreal)
        QGraphicsGridLayout* cppSelf = Shiboken::Converter<QGraphicsGridLayout* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsGridLayout::setRowFixedHeight(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsGridLayoutFunc_setRowFixedHeight_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsGridLayoutFunc_setRowFixedHeight_TypeError:
        const char* overloads[] = {"int, float", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsGridLayout.setRowFixedHeight", overloads);
        return 0;
}

static PyObject* SbkQGraphicsGridLayoutFunc_setRowMaximumHeight(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setRowMaximumHeight", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        // setRowMaximumHeight(int,qreal)
        QGraphicsGridLayout* cppSelf = Shiboken::Converter<QGraphicsGridLayout* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsGridLayout::setRowMaximumHeight(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsGridLayoutFunc_setRowMaximumHeight_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsGridLayoutFunc_setRowMaximumHeight_TypeError:
        const char* overloads[] = {"int, float", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsGridLayout.setRowMaximumHeight", overloads);
        return 0;
}

static PyObject* SbkQGraphicsGridLayoutFunc_setRowMinimumHeight(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setRowMinimumHeight", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        // setRowMinimumHeight(int,qreal)
        QGraphicsGridLayout* cppSelf = Shiboken::Converter<QGraphicsGridLayout* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsGridLayout::setRowMinimumHeight(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsGridLayoutFunc_setRowMinimumHeight_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsGridLayoutFunc_setRowMinimumHeight_TypeError:
        const char* overloads[] = {"int, float", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsGridLayout.setRowMinimumHeight", overloads);
        return 0;
}

static PyObject* SbkQGraphicsGridLayoutFunc_setRowPreferredHeight(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setRowPreferredHeight", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        // setRowPreferredHeight(int,qreal)
        QGraphicsGridLayout* cppSelf = Shiboken::Converter<QGraphicsGridLayout* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsGridLayout::setRowPreferredHeight(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsGridLayoutFunc_setRowPreferredHeight_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsGridLayoutFunc_setRowPreferredHeight_TypeError:
        const char* overloads[] = {"int, float", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsGridLayout.setRowPreferredHeight", overloads);
        return 0;
}

static PyObject* SbkQGraphicsGridLayoutFunc_setRowSpacing(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setRowSpacing", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        // setRowSpacing(int,qreal)
        QGraphicsGridLayout* cppSelf = Shiboken::Converter<QGraphicsGridLayout* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsGridLayout::setRowSpacing(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsGridLayoutFunc_setRowSpacing_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsGridLayoutFunc_setRowSpacing_TypeError:
        const char* overloads[] = {"int, float", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsGridLayout.setRowSpacing", overloads);
        return 0;
}

static PyObject* SbkQGraphicsGridLayoutFunc_setRowStretchFactor(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setRowStretchFactor", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // setRowStretchFactor(int,int)
        QGraphicsGridLayout* cppSelf = Shiboken::Converter<QGraphicsGridLayout* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsGridLayout::setRowStretchFactor(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsGridLayoutFunc_setRowStretchFactor_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsGridLayoutFunc_setRowStretchFactor_TypeError:
        const char* overloads[] = {"int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsGridLayout.setRowStretchFactor", overloads);
        return 0;
}

static PyObject* SbkQGraphicsGridLayoutFunc_setSpacing(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setSpacing(qreal)
        QGraphicsGridLayout* cppSelf = Shiboken::Converter<QGraphicsGridLayout* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsGridLayout::setSpacing(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsGridLayoutFunc_setSpacing_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsGridLayoutFunc_setSpacing_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsGridLayout.setSpacing", overloads);
        return 0;
}

static PyObject* SbkQGraphicsGridLayoutFunc_setVerticalSpacing(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setVerticalSpacing(qreal)
        QGraphicsGridLayout* cppSelf = Shiboken::Converter<QGraphicsGridLayout* >::toCpp((PyObject*)self);
        cppSelf->QGraphicsGridLayout::setVerticalSpacing(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQGraphicsGridLayoutFunc_setVerticalSpacing_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQGraphicsGridLayoutFunc_setVerticalSpacing_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QGraphicsGridLayout.setVerticalSpacing", overloads);
        return 0;
}

static PyObject* SbkQGraphicsGridLayoutFunc_sizeHint(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "sizeHint", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<Qt::SizeHint >::isConvertible(pyargs[0])) {
        Qt::SizeHint cpp_arg0 = Shiboken::Converter<Qt::SizeHint >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // sizeHint(Qt::SizeHint,QSizeF)const
            QGraphicsGridLayout* cppSelf = Shiboken::Converter<QGraphicsGridLayout* >::toCpp((PyObject*)self);
            QSizeF cpp_result = cppSelf->QGraphicsGridLayout::sizeHint(cpp_arg0);
            py_result = Shiboken::Converter<QSizeF >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QSizeF & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QSizeF > cpp_arg1_auto_ptr;
            QSizeF* cpp_arg1 = Shiboken::Converter<QSizeF* >::toCpp(pyargs[1]);
            if (!SbkQSizeF_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QSizeF >(cpp_arg1);
            // sizeHint(Qt::SizeHint,QSizeF)const
            QGraphicsGridLayout* cppSelf = Shiboken::Converter<QGraphicsGridLayout* >::toCpp((PyObject*)self);
            QSizeF cpp_result = cppSelf->QGraphicsGridLayout::sizeHint(cpp_arg0, *cpp_arg1);
            py_result = Shiboken::Converter<QSizeF >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQGraphicsGridLayoutFunc_sizeHint_TypeError;
    } else goto SbkQGraphicsGridLayoutFunc_sizeHint_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQGraphicsGridLayoutFunc_sizeHint_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.SizeHint, PySide.QtCore.QSizeF = QSizeF()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QGraphicsGridLayout.sizeHint", overloads);
        return 0;
}

static PyObject* SbkQGraphicsGridLayoutFunc_verticalSpacing(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // verticalSpacing()const
    QGraphicsGridLayout* cppSelf = Shiboken::Converter<QGraphicsGridLayout* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QGraphicsGridLayout::verticalSpacing();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQGraphicsGridLayout_methods[] = {
    {"addItem", (PyCFunction)SbkQGraphicsGridLayoutFunc_addItem, METH_VARARGS},
    {"alignment", (PyCFunction)SbkQGraphicsGridLayoutFunc_alignment, METH_O},
    {"columnAlignment", (PyCFunction)SbkQGraphicsGridLayoutFunc_columnAlignment, METH_O},
    {"columnCount", (PyCFunction)SbkQGraphicsGridLayoutFunc_columnCount, METH_NOARGS},
    {"columnMaximumWidth", (PyCFunction)SbkQGraphicsGridLayoutFunc_columnMaximumWidth, METH_O},
    {"columnMinimumWidth", (PyCFunction)SbkQGraphicsGridLayoutFunc_columnMinimumWidth, METH_O},
    {"columnPreferredWidth", (PyCFunction)SbkQGraphicsGridLayoutFunc_columnPreferredWidth, METH_O},
    {"columnSpacing", (PyCFunction)SbkQGraphicsGridLayoutFunc_columnSpacing, METH_O},
    {"columnStretchFactor", (PyCFunction)SbkQGraphicsGridLayoutFunc_columnStretchFactor, METH_O},
    {"count", (PyCFunction)SbkQGraphicsGridLayoutFunc_count, METH_NOARGS},
    {"horizontalSpacing", (PyCFunction)SbkQGraphicsGridLayoutFunc_horizontalSpacing, METH_NOARGS},
    {"invalidate", (PyCFunction)SbkQGraphicsGridLayoutFunc_invalidate, METH_NOARGS},
    {"itemAt", (PyCFunction)SbkQGraphicsGridLayoutFunc_itemAt, METH_VARARGS},
    {"removeAt", (PyCFunction)SbkQGraphicsGridLayoutFunc_removeAt, METH_O},
    {"rowAlignment", (PyCFunction)SbkQGraphicsGridLayoutFunc_rowAlignment, METH_O},
    {"rowCount", (PyCFunction)SbkQGraphicsGridLayoutFunc_rowCount, METH_NOARGS},
    {"rowMaximumHeight", (PyCFunction)SbkQGraphicsGridLayoutFunc_rowMaximumHeight, METH_O},
    {"rowMinimumHeight", (PyCFunction)SbkQGraphicsGridLayoutFunc_rowMinimumHeight, METH_O},
    {"rowPreferredHeight", (PyCFunction)SbkQGraphicsGridLayoutFunc_rowPreferredHeight, METH_O},
    {"rowSpacing", (PyCFunction)SbkQGraphicsGridLayoutFunc_rowSpacing, METH_O},
    {"rowStretchFactor", (PyCFunction)SbkQGraphicsGridLayoutFunc_rowStretchFactor, METH_O},
    {"setAlignment", (PyCFunction)SbkQGraphicsGridLayoutFunc_setAlignment, METH_VARARGS},
    {"setColumnAlignment", (PyCFunction)SbkQGraphicsGridLayoutFunc_setColumnAlignment, METH_VARARGS},
    {"setColumnFixedWidth", (PyCFunction)SbkQGraphicsGridLayoutFunc_setColumnFixedWidth, METH_VARARGS},
    {"setColumnMaximumWidth", (PyCFunction)SbkQGraphicsGridLayoutFunc_setColumnMaximumWidth, METH_VARARGS},
    {"setColumnMinimumWidth", (PyCFunction)SbkQGraphicsGridLayoutFunc_setColumnMinimumWidth, METH_VARARGS},
    {"setColumnPreferredWidth", (PyCFunction)SbkQGraphicsGridLayoutFunc_setColumnPreferredWidth, METH_VARARGS},
    {"setColumnSpacing", (PyCFunction)SbkQGraphicsGridLayoutFunc_setColumnSpacing, METH_VARARGS},
    {"setColumnStretchFactor", (PyCFunction)SbkQGraphicsGridLayoutFunc_setColumnStretchFactor, METH_VARARGS},
    {"setGeometry", (PyCFunction)SbkQGraphicsGridLayoutFunc_setGeometry, METH_O},
    {"setHorizontalSpacing", (PyCFunction)SbkQGraphicsGridLayoutFunc_setHorizontalSpacing, METH_O},
    {"setRowAlignment", (PyCFunction)SbkQGraphicsGridLayoutFunc_setRowAlignment, METH_VARARGS},
    {"setRowFixedHeight", (PyCFunction)SbkQGraphicsGridLayoutFunc_setRowFixedHeight, METH_VARARGS},
    {"setRowMaximumHeight", (PyCFunction)SbkQGraphicsGridLayoutFunc_setRowMaximumHeight, METH_VARARGS},
    {"setRowMinimumHeight", (PyCFunction)SbkQGraphicsGridLayoutFunc_setRowMinimumHeight, METH_VARARGS},
    {"setRowPreferredHeight", (PyCFunction)SbkQGraphicsGridLayoutFunc_setRowPreferredHeight, METH_VARARGS},
    {"setRowSpacing", (PyCFunction)SbkQGraphicsGridLayoutFunc_setRowSpacing, METH_VARARGS},
    {"setRowStretchFactor", (PyCFunction)SbkQGraphicsGridLayoutFunc_setRowStretchFactor, METH_VARARGS},
    {"setSpacing", (PyCFunction)SbkQGraphicsGridLayoutFunc_setSpacing, METH_O},
    {"setVerticalSpacing", (PyCFunction)SbkQGraphicsGridLayoutFunc_setVerticalSpacing, METH_O},
    {"sizeHint", (PyCFunction)SbkQGraphicsGridLayoutFunc_sizeHint, METH_VARARGS},
    {"verticalSpacing", (PyCFunction)SbkQGraphicsGridLayoutFunc_verticalSpacing, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQGraphicsGridLayout_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QGraphicsGridLayout",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQGraphicsGridLayout_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQGraphicsGridLayout_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QGraphicsGridLayout >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_QGraphicsGridLayout(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QGRAPHICSGRIDLAYOUT_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQGraphicsGridLayout_Type);

    SbkQGraphicsGridLayout_Type.super.ht_type.tp_base = SbkPySide_QtGuiTypes[SBK_QGRAPHICSLAYOUT_IDX];
    // Fill type discovery information
    SbkQGraphicsGridLayout_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QGRAPHICSLAYOUTITEM_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQGraphicsGridLayout_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQGraphicsGridLayout_Type));
    PyModule_AddObject(module, "QGraphicsGridLayout",
        ((PyObject*)&SbkQGraphicsGridLayout_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QGraphicsGridLayout >("QGraphicsGridLayout*");
    Shiboken::TypeResolver::createObjectTypeResolver<QGraphicsGridLayout >(typeid(QGraphicsGridLayout).name());
}


} // extern "C"

