/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qfont_wrapper.h"

// Extra includes
#include <QStringList>
#include <qdatastream.h>
#include <qfont.h>
#include <qpaintdevice.h>
#include <qstring.h>
#include <qstringlist.h>
#include <qvariant.h>

using namespace Shiboken;

static int
SbkQFont_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QFont* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "QFont", 0, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return -1;

    if (numArgs == 0) {
        // QFont()
        cptr = new QFont();
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QString & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // QFont(QString,int,int,bool)
            cptr = new QFont(*cpp_arg0);
            //CppGenerator::writeParentChildManagement
        } else if (PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            if (numArgs == 2) {
                // QFont(QString,int,int,bool)
                cptr = new QFont(*cpp_arg0, cpp_arg1);
                //CppGenerator::writeParentChildManagement
            } else if (PyNumber_Check(pyargs[2])) {
                int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
                if (numArgs == 3) {
                    // QFont(QString,int,int,bool)
                    cptr = new QFont(*cpp_arg0, cpp_arg1, cpp_arg2);
                    //CppGenerator::writeParentChildManagement
                } else if (PyNumber_Check(pyargs[3])) {
                    bool cpp_arg3 = Shiboken::Converter<bool >::toCpp(pyargs[3]);
                    // QFont(QString,int,int,bool)
                    cptr = new QFont(*cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
                    //CppGenerator::writeParentChildManagement
                } else goto SbkQFont_Init_TypeError;
            } else goto SbkQFont_Init_TypeError;
        } else goto SbkQFont_Init_TypeError;
    } else if (Shiboken::Converter<QFont & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QFont > cpp_arg0_auto_ptr;
        QFont* cpp_arg0 = Shiboken::Converter<QFont* >::toCpp(pyargs[0]);
        if (!SbkQFont_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QFont >(cpp_arg0);
        if (numArgs == 1) {
            // QFont(QFont)
            cptr = new QFont(*cpp_arg0);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && Shiboken::Converter<QPaintDevice * >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return -1;
            QPaintDevice* cpp_arg1 = Shiboken::Converter<QPaintDevice* >::toCpp(pyargs[1]);
            // QFont(QFont,QPaintDevice*)
            cptr = new QFont(*cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQFont_Init_TypeError;
    } else goto SbkQFont_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QFont >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQFont_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQFont_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtGui.QFont", "PySide.QtGui.QFont, PySide.QtGui.QPaintDevice", "PySide.QtCore.QString, int = -1, int = -1, bool = false", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QFont", overloads);
        return -1;
}

static PyObject* SbkQFontFunc_bold(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // bold()const
    QFont* cppSelf = Shiboken::Converter<QFont* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QFont::bold();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFontFunc_cacheStatistics(PyObject* self)
{

    // cacheStatistics()
    QFont::cacheStatistics();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQFontFunc_capitalization(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // capitalization()const
    QFont* cppSelf = Shiboken::Converter<QFont* >::toCpp((PyObject*)self);
    QFont::Capitalization cpp_result = cppSelf->QFont::capitalization();
    py_result = Shiboken::Converter<QFont::Capitalization >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFontFunc_cleanup(PyObject* self)
{

    // cleanup()
    QFont::cleanup();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQFontFunc_defaultFamily(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // defaultFamily()const
    QFont* cppSelf = Shiboken::Converter<QFont* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QFont::defaultFamily();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFontFunc_exactMatch(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // exactMatch()const
    QFont* cppSelf = Shiboken::Converter<QFont* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QFont::exactMatch();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFontFunc_family(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // family()const
    QFont* cppSelf = Shiboken::Converter<QFont* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QFont::family();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFontFunc_fixedPitch(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // fixedPitch()const
    QFont* cppSelf = Shiboken::Converter<QFont* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QFont::fixedPitch();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFontFunc_fromString(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // fromString(QString)
        QFont* cppSelf = Shiboken::Converter<QFont* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QFont::fromString(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQFontFunc_fromString_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQFontFunc_fromString_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QFont.fromString", overloads);
        return 0;
}

static PyObject* SbkQFontFunc_handle(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // handle()const
    QFont* cppSelf = Shiboken::Converter<QFont* >::toCpp((PyObject*)self);
    Qt::HANDLE cpp_result = cppSelf->QFont::handle();
    py_result = Shiboken::Converter<Qt::HANDLE >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFontFunc_initialize(PyObject* self)
{

    // initialize()
    QFont::initialize();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQFontFunc_insertSubstitution(PyObject* self, PyObject* args)
{

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "insertSubstitution", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QString & >::isConvertible(pyargs[0]) && Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!SbkQString_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        // insertSubstitution(QString,QString)
        QFont::insertSubstitution(*cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQFontFunc_insertSubstitution_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQFontFunc_insertSubstitution_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QFont.insertSubstitution", overloads);
        return 0;
}

static PyObject* SbkQFontFunc_insertSubstitutions(PyObject* self, PyObject* args)
{

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "insertSubstitutions", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QString & >::isConvertible(pyargs[0]) && Shiboken::Converter<QStringList & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QStringList > cpp_arg1_auto_ptr;
        QStringList* cpp_arg1 = Shiboken::Converter<QStringList* >::toCpp(pyargs[1]);
        if (!SbkQStringList_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QStringList >(cpp_arg1);
        // insertSubstitutions(QString,QStringList)
        QFont::insertSubstitutions(*cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQFontFunc_insertSubstitutions_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQFontFunc_insertSubstitutions_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QStringList", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QFont.insertSubstitutions", overloads);
        return 0;
}

static PyObject* SbkQFontFunc_isCopyOf(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QFont & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QFont > cpp_arg0_auto_ptr;
        QFont* cpp_arg0 = Shiboken::Converter<QFont* >::toCpp(arg);
        if (!SbkQFont_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QFont >(cpp_arg0);
        // isCopyOf(QFont)const
        QFont* cppSelf = Shiboken::Converter<QFont* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QFont::isCopyOf(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQFontFunc_isCopyOf_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQFontFunc_isCopyOf_TypeError:
        const char* overloads[] = {"PySide.QtGui.QFont", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QFont.isCopyOf", overloads);
        return 0;
}

static PyObject* SbkQFontFunc_italic(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // italic()const
    QFont* cppSelf = Shiboken::Converter<QFont* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QFont::italic();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFontFunc_kerning(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // kerning()const
    QFont* cppSelf = Shiboken::Converter<QFont* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QFont::kerning();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFontFunc_key(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // key()const
    QFont* cppSelf = Shiboken::Converter<QFont* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QFont::key();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFontFunc_lastResortFamily(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // lastResortFamily()const
    QFont* cppSelf = Shiboken::Converter<QFont* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QFont::lastResortFamily();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFontFunc_lastResortFont(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // lastResortFont()const
    QFont* cppSelf = Shiboken::Converter<QFont* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QFont::lastResortFont();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFontFunc_letterSpacing(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // letterSpacing()const
    QFont* cppSelf = Shiboken::Converter<QFont* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QFont::letterSpacing();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFontFunc_letterSpacingType(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // letterSpacingType()const
    QFont* cppSelf = Shiboken::Converter<QFont* >::toCpp((PyObject*)self);
    QFont::SpacingType cpp_result = cppSelf->QFont::letterSpacingType();
    py_result = Shiboken::Converter<QFont::SpacingType >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFontFunc_overline(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // overline()const
    QFont* cppSelf = Shiboken::Converter<QFont* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QFont::overline();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFontFunc_pixelSize(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // pixelSize()const
    QFont* cppSelf = Shiboken::Converter<QFont* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QFont::pixelSize();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFontFunc_pointSize(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // pointSize()const
    QFont* cppSelf = Shiboken::Converter<QFont* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QFont::pointSize();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFontFunc_pointSizeF(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // pointSizeF()const
    QFont* cppSelf = Shiboken::Converter<QFont* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QFont::pointSizeF();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFontFunc_rawMode(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // rawMode()const
    QFont* cppSelf = Shiboken::Converter<QFont* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QFont::rawMode();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFontFunc_rawName(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // rawName()const
    QFont* cppSelf = Shiboken::Converter<QFont* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QFont::rawName();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFontFunc_removeSubstitution(PyObject* self, PyObject* arg)
{

    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // removeSubstitution(QString)
        QFont::removeSubstitution(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQFontFunc_removeSubstitution_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQFontFunc_removeSubstitution_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QFont.removeSubstitution", overloads);
        return 0;
}

static PyObject* SbkQFontFunc_resolve(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // resolve()const
        QFont* cppSelf = Shiboken::Converter<QFont* >::toCpp((PyObject*)self);
        uint cpp_result = cppSelf->QFont::resolve();
        py_result = Shiboken::Converter<unsigned int >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (PyNumber_Check(arg)) {
        uint cpp_arg0 = Shiboken::Converter<uint >::toCpp(arg);
        // resolve(uint)
        QFont* cppSelf = Shiboken::Converter<QFont* >::toCpp((PyObject*)self);
        cppSelf->QFont::resolve(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        py_result = Py_None;
        Py_INCREF(Py_None);
    } else if (Shiboken::Converter<QFont & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QFont > cpp_arg0_auto_ptr;
        QFont* cpp_arg0 = Shiboken::Converter<QFont* >::toCpp(arg);
        if (!SbkQFont_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QFont >(cpp_arg0);
        // resolve(QFont)const
        QFont* cppSelf = Shiboken::Converter<QFont* >::toCpp((PyObject*)self);
        QFont cpp_result = cppSelf->QFont::resolve(*cpp_arg0);
        py_result = Shiboken::Converter<QFont >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQFontFunc_resolve_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQFontFunc_resolve_TypeError:
        const char* overloads[] = {"", "PySide.QtGui.QFont", "unsigned int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QFont.resolve", overloads);
        return 0;
}

static PyObject* SbkQFontFunc_setBold(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setBold(bool)
        QFont* cppSelf = Shiboken::Converter<QFont* >::toCpp((PyObject*)self);
        cppSelf->QFont::setBold(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQFontFunc_setBold_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQFontFunc_setBold_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QFont.setBold", overloads);
        return 0;
}

static PyObject* SbkQFontFunc_setCapitalization(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QFont::Capitalization >::isConvertible(arg)) {
        QFont::Capitalization cpp_arg0 = Shiboken::Converter<QFont::Capitalization >::toCpp(arg);
        // setCapitalization(QFont::Capitalization)
        QFont* cppSelf = Shiboken::Converter<QFont* >::toCpp((PyObject*)self);
        cppSelf->QFont::setCapitalization(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQFontFunc_setCapitalization_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQFontFunc_setCapitalization_TypeError:
        const char* overloads[] = {"PySide.QtGui.QFont.Capitalization", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QFont.setCapitalization", overloads);
        return 0;
}

static PyObject* SbkQFontFunc_setFamily(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setFamily(QString)
        QFont* cppSelf = Shiboken::Converter<QFont* >::toCpp((PyObject*)self);
        cppSelf->QFont::setFamily(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQFontFunc_setFamily_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQFontFunc_setFamily_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QFont.setFamily", overloads);
        return 0;
}

static PyObject* SbkQFontFunc_setFixedPitch(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setFixedPitch(bool)
        QFont* cppSelf = Shiboken::Converter<QFont* >::toCpp((PyObject*)self);
        cppSelf->QFont::setFixedPitch(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQFontFunc_setFixedPitch_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQFontFunc_setFixedPitch_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QFont.setFixedPitch", overloads);
        return 0;
}

static PyObject* SbkQFontFunc_setItalic(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setItalic(bool)
        QFont* cppSelf = Shiboken::Converter<QFont* >::toCpp((PyObject*)self);
        cppSelf->QFont::setItalic(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQFontFunc_setItalic_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQFontFunc_setItalic_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QFont.setItalic", overloads);
        return 0;
}

static PyObject* SbkQFontFunc_setKerning(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setKerning(bool)
        QFont* cppSelf = Shiboken::Converter<QFont* >::toCpp((PyObject*)self);
        cppSelf->QFont::setKerning(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQFontFunc_setKerning_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQFontFunc_setKerning_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QFont.setKerning", overloads);
        return 0;
}

static PyObject* SbkQFontFunc_setLetterSpacing(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setLetterSpacing", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QFont::SpacingType >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        QFont::SpacingType cpp_arg0 = Shiboken::Converter<QFont::SpacingType >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        // setLetterSpacing(QFont::SpacingType,qreal)
        QFont* cppSelf = Shiboken::Converter<QFont* >::toCpp((PyObject*)self);
        cppSelf->QFont::setLetterSpacing(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQFontFunc_setLetterSpacing_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQFontFunc_setLetterSpacing_TypeError:
        const char* overloads[] = {"PySide.QtGui.QFont.SpacingType, float", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QFont.setLetterSpacing", overloads);
        return 0;
}

static PyObject* SbkQFontFunc_setOverline(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setOverline(bool)
        QFont* cppSelf = Shiboken::Converter<QFont* >::toCpp((PyObject*)self);
        cppSelf->QFont::setOverline(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQFontFunc_setOverline_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQFontFunc_setOverline_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QFont.setOverline", overloads);
        return 0;
}

static PyObject* SbkQFontFunc_setPixelSize(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setPixelSize(int)
        QFont* cppSelf = Shiboken::Converter<QFont* >::toCpp((PyObject*)self);
        cppSelf->QFont::setPixelSize(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQFontFunc_setPixelSize_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQFontFunc_setPixelSize_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QFont.setPixelSize", overloads);
        return 0;
}

static PyObject* SbkQFontFunc_setPointSize(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setPointSize(int)
        QFont* cppSelf = Shiboken::Converter<QFont* >::toCpp((PyObject*)self);
        cppSelf->QFont::setPointSize(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQFontFunc_setPointSize_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQFontFunc_setPointSize_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QFont.setPointSize", overloads);
        return 0;
}

static PyObject* SbkQFontFunc_setPointSizeF(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setPointSizeF(qreal)
        QFont* cppSelf = Shiboken::Converter<QFont* >::toCpp((PyObject*)self);
        cppSelf->QFont::setPointSizeF(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQFontFunc_setPointSizeF_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQFontFunc_setPointSizeF_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QFont.setPointSizeF", overloads);
        return 0;
}

static PyObject* SbkQFontFunc_setRawMode(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setRawMode(bool)
        QFont* cppSelf = Shiboken::Converter<QFont* >::toCpp((PyObject*)self);
        cppSelf->QFont::setRawMode(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQFontFunc_setRawMode_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQFontFunc_setRawMode_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QFont.setRawMode", overloads);
        return 0;
}

static PyObject* SbkQFontFunc_setRawName(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setRawName(QString)
        QFont* cppSelf = Shiboken::Converter<QFont* >::toCpp((PyObject*)self);
        cppSelf->QFont::setRawName(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQFontFunc_setRawName_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQFontFunc_setRawName_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QFont.setRawName", overloads);
        return 0;
}

static PyObject* SbkQFontFunc_setStretch(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setStretch(int)
        QFont* cppSelf = Shiboken::Converter<QFont* >::toCpp((PyObject*)self);
        cppSelf->QFont::setStretch(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQFontFunc_setStretch_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQFontFunc_setStretch_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QFont.setStretch", overloads);
        return 0;
}

static PyObject* SbkQFontFunc_setStrikeOut(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setStrikeOut(bool)
        QFont* cppSelf = Shiboken::Converter<QFont* >::toCpp((PyObject*)self);
        cppSelf->QFont::setStrikeOut(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQFontFunc_setStrikeOut_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQFontFunc_setStrikeOut_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QFont.setStrikeOut", overloads);
        return 0;
}

static PyObject* SbkQFontFunc_setStyle(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QFont::Style >::isConvertible(arg)) {
        QFont::Style cpp_arg0 = Shiboken::Converter<QFont::Style >::toCpp(arg);
        // setStyle(QFont::Style)
        QFont* cppSelf = Shiboken::Converter<QFont* >::toCpp((PyObject*)self);
        cppSelf->QFont::setStyle(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQFontFunc_setStyle_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQFontFunc_setStyle_TypeError:
        const char* overloads[] = {"PySide.QtGui.QFont.Style", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QFont.setStyle", overloads);
        return 0;
}

static PyObject* SbkQFontFunc_setStyleHint(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setStyleHint", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QFont::StyleHint >::isConvertible(pyargs[0])) {
        QFont::StyleHint cpp_arg0 = Shiboken::Converter<QFont::StyleHint >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // setStyleHint(QFont::StyleHint,QFont::StyleStrategy)
            QFont* cppSelf = Shiboken::Converter<QFont* >::toCpp((PyObject*)self);
            cppSelf->QFont::setStyleHint(cpp_arg0);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QFont::StyleStrategy >::isConvertible(pyargs[1])) {
            QFont::StyleStrategy cpp_arg1 = Shiboken::Converter<QFont::StyleStrategy >::toCpp(pyargs[1]);
            // setStyleHint(QFont::StyleHint,QFont::StyleStrategy)
            QFont* cppSelf = Shiboken::Converter<QFont* >::toCpp((PyObject*)self);
            cppSelf->QFont::setStyleHint(cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQFontFunc_setStyleHint_TypeError;
    } else goto SbkQFontFunc_setStyleHint_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQFontFunc_setStyleHint_TypeError:
        const char* overloads[] = {"PySide.QtGui.QFont.StyleHint, PySide.QtGui.QFont.StyleStrategy = PreferDefault", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QFont.setStyleHint", overloads);
        return 0;
}

static PyObject* SbkQFontFunc_setStyleStrategy(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QFont::StyleStrategy >::isConvertible(arg)) {
        QFont::StyleStrategy cpp_arg0 = Shiboken::Converter<QFont::StyleStrategy >::toCpp(arg);
        // setStyleStrategy(QFont::StyleStrategy)
        QFont* cppSelf = Shiboken::Converter<QFont* >::toCpp((PyObject*)self);
        cppSelf->QFont::setStyleStrategy(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQFontFunc_setStyleStrategy_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQFontFunc_setStyleStrategy_TypeError:
        const char* overloads[] = {"PySide.QtGui.QFont.StyleStrategy", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QFont.setStyleStrategy", overloads);
        return 0;
}

static PyObject* SbkQFontFunc_setUnderline(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setUnderline(bool)
        QFont* cppSelf = Shiboken::Converter<QFont* >::toCpp((PyObject*)self);
        cppSelf->QFont::setUnderline(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQFontFunc_setUnderline_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQFontFunc_setUnderline_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QFont.setUnderline", overloads);
        return 0;
}

static PyObject* SbkQFontFunc_setWeight(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setWeight(int)
        QFont* cppSelf = Shiboken::Converter<QFont* >::toCpp((PyObject*)self);
        cppSelf->QFont::setWeight(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQFontFunc_setWeight_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQFontFunc_setWeight_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QFont.setWeight", overloads);
        return 0;
}

static PyObject* SbkQFontFunc_setWordSpacing(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setWordSpacing(qreal)
        QFont* cppSelf = Shiboken::Converter<QFont* >::toCpp((PyObject*)self);
        cppSelf->QFont::setWordSpacing(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQFontFunc_setWordSpacing_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQFontFunc_setWordSpacing_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QFont.setWordSpacing", overloads);
        return 0;
}

static PyObject* SbkQFontFunc_stretch(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // stretch()const
    QFont* cppSelf = Shiboken::Converter<QFont* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QFont::stretch();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFontFunc_strikeOut(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // strikeOut()const
    QFont* cppSelf = Shiboken::Converter<QFont* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QFont::strikeOut();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFontFunc_style(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // style()const
    QFont* cppSelf = Shiboken::Converter<QFont* >::toCpp((PyObject*)self);
    QFont::Style cpp_result = cppSelf->QFont::style();
    py_result = Shiboken::Converter<QFont::Style >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFontFunc_styleHint(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // styleHint()const
    QFont* cppSelf = Shiboken::Converter<QFont* >::toCpp((PyObject*)self);
    QFont::StyleHint cpp_result = cppSelf->QFont::styleHint();
    py_result = Shiboken::Converter<QFont::StyleHint >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFontFunc_styleStrategy(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // styleStrategy()const
    QFont* cppSelf = Shiboken::Converter<QFont* >::toCpp((PyObject*)self);
    QFont::StyleStrategy cpp_result = cppSelf->QFont::styleStrategy();
    py_result = Shiboken::Converter<QFont::StyleStrategy >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFontFunc_substitute(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // substitute(QString)
        QString cpp_result = QFont::substitute(*cpp_arg0);
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQFontFunc_substitute_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQFontFunc_substitute_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QFont.substitute", overloads);
        return 0;
}

static PyObject* SbkQFontFunc_substitutes(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // substitutes(QString)
        QStringList cpp_result = QFont::substitutes(*cpp_arg0);
        py_result = Shiboken::Converter<QStringList >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQFontFunc_substitutes_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQFontFunc_substitutes_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QFont.substitutes", overloads);
        return 0;
}

static PyObject* SbkQFontFunc_substitutions(PyObject* self)
{
    PyObject* py_result = 0;

    // substitutions()
    QStringList cpp_result = QFont::substitutions();
    py_result = Shiboken::Converter<QStringList >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFontFunc_toString(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toString()const
    QFont* cppSelf = Shiboken::Converter<QFont* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QFont::toString();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFontFunc_underline(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // underline()const
    QFont* cppSelf = Shiboken::Converter<QFont* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QFont::underline();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFontFunc_weight(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // weight()const
    QFont* cppSelf = Shiboken::Converter<QFont* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QFont::weight();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFontFunc_wordSpacing(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // wordSpacing()const
    QFont* cppSelf = Shiboken::Converter<QFont* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QFont::wordSpacing();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQFont_methods[] = {
    {"bold", (PyCFunction)SbkQFontFunc_bold, METH_NOARGS},
    {"cacheStatistics", (PyCFunction)SbkQFontFunc_cacheStatistics, METH_NOARGS|METH_STATIC},
    {"capitalization", (PyCFunction)SbkQFontFunc_capitalization, METH_NOARGS},
    {"cleanup", (PyCFunction)SbkQFontFunc_cleanup, METH_NOARGS|METH_STATIC},
    {"defaultFamily", (PyCFunction)SbkQFontFunc_defaultFamily, METH_NOARGS},
    {"exactMatch", (PyCFunction)SbkQFontFunc_exactMatch, METH_NOARGS},
    {"family", (PyCFunction)SbkQFontFunc_family, METH_NOARGS},
    {"fixedPitch", (PyCFunction)SbkQFontFunc_fixedPitch, METH_NOARGS},
    {"fromString", (PyCFunction)SbkQFontFunc_fromString, METH_O},
    {"handle", (PyCFunction)SbkQFontFunc_handle, METH_NOARGS},
    {"initialize", (PyCFunction)SbkQFontFunc_initialize, METH_NOARGS|METH_STATIC},
    {"insertSubstitution", (PyCFunction)SbkQFontFunc_insertSubstitution, METH_VARARGS|METH_STATIC},
    {"insertSubstitutions", (PyCFunction)SbkQFontFunc_insertSubstitutions, METH_VARARGS|METH_STATIC},
    {"isCopyOf", (PyCFunction)SbkQFontFunc_isCopyOf, METH_O},
    {"italic", (PyCFunction)SbkQFontFunc_italic, METH_NOARGS},
    {"kerning", (PyCFunction)SbkQFontFunc_kerning, METH_NOARGS},
    {"key", (PyCFunction)SbkQFontFunc_key, METH_NOARGS},
    {"lastResortFamily", (PyCFunction)SbkQFontFunc_lastResortFamily, METH_NOARGS},
    {"lastResortFont", (PyCFunction)SbkQFontFunc_lastResortFont, METH_NOARGS},
    {"letterSpacing", (PyCFunction)SbkQFontFunc_letterSpacing, METH_NOARGS},
    {"letterSpacingType", (PyCFunction)SbkQFontFunc_letterSpacingType, METH_NOARGS},
    {"overline", (PyCFunction)SbkQFontFunc_overline, METH_NOARGS},
    {"pixelSize", (PyCFunction)SbkQFontFunc_pixelSize, METH_NOARGS},
    {"pointSize", (PyCFunction)SbkQFontFunc_pointSize, METH_NOARGS},
    {"pointSizeF", (PyCFunction)SbkQFontFunc_pointSizeF, METH_NOARGS},
    {"rawMode", (PyCFunction)SbkQFontFunc_rawMode, METH_NOARGS},
    {"rawName", (PyCFunction)SbkQFontFunc_rawName, METH_NOARGS},
    {"removeSubstitution", (PyCFunction)SbkQFontFunc_removeSubstitution, METH_O|METH_STATIC},
    {"resolve", (PyCFunction)SbkQFontFunc_resolve, METH_NOARGS|METH_O},
    {"setBold", (PyCFunction)SbkQFontFunc_setBold, METH_O},
    {"setCapitalization", (PyCFunction)SbkQFontFunc_setCapitalization, METH_O},
    {"setFamily", (PyCFunction)SbkQFontFunc_setFamily, METH_O},
    {"setFixedPitch", (PyCFunction)SbkQFontFunc_setFixedPitch, METH_O},
    {"setItalic", (PyCFunction)SbkQFontFunc_setItalic, METH_O},
    {"setKerning", (PyCFunction)SbkQFontFunc_setKerning, METH_O},
    {"setLetterSpacing", (PyCFunction)SbkQFontFunc_setLetterSpacing, METH_VARARGS},
    {"setOverline", (PyCFunction)SbkQFontFunc_setOverline, METH_O},
    {"setPixelSize", (PyCFunction)SbkQFontFunc_setPixelSize, METH_O},
    {"setPointSize", (PyCFunction)SbkQFontFunc_setPointSize, METH_O},
    {"setPointSizeF", (PyCFunction)SbkQFontFunc_setPointSizeF, METH_O},
    {"setRawMode", (PyCFunction)SbkQFontFunc_setRawMode, METH_O},
    {"setRawName", (PyCFunction)SbkQFontFunc_setRawName, METH_O},
    {"setStretch", (PyCFunction)SbkQFontFunc_setStretch, METH_O},
    {"setStrikeOut", (PyCFunction)SbkQFontFunc_setStrikeOut, METH_O},
    {"setStyle", (PyCFunction)SbkQFontFunc_setStyle, METH_O},
    {"setStyleHint", (PyCFunction)SbkQFontFunc_setStyleHint, METH_VARARGS},
    {"setStyleStrategy", (PyCFunction)SbkQFontFunc_setStyleStrategy, METH_O},
    {"setUnderline", (PyCFunction)SbkQFontFunc_setUnderline, METH_O},
    {"setWeight", (PyCFunction)SbkQFontFunc_setWeight, METH_O},
    {"setWordSpacing", (PyCFunction)SbkQFontFunc_setWordSpacing, METH_O},
    {"stretch", (PyCFunction)SbkQFontFunc_stretch, METH_NOARGS},
    {"strikeOut", (PyCFunction)SbkQFontFunc_strikeOut, METH_NOARGS},
    {"style", (PyCFunction)SbkQFontFunc_style, METH_NOARGS},
    {"styleHint", (PyCFunction)SbkQFontFunc_styleHint, METH_NOARGS},
    {"styleStrategy", (PyCFunction)SbkQFontFunc_styleStrategy, METH_NOARGS},
    {"substitute", (PyCFunction)SbkQFontFunc_substitute, METH_O|METH_STATIC},
    {"substitutes", (PyCFunction)SbkQFontFunc_substitutes, METH_O|METH_STATIC},
    {"substitutions", (PyCFunction)SbkQFontFunc_substitutions, METH_NOARGS|METH_STATIC},
    {"toString", (PyCFunction)SbkQFontFunc_toString, METH_NOARGS},
    {"underline", (PyCFunction)SbkQFontFunc_underline, METH_NOARGS},
    {"weight", (PyCFunction)SbkQFontFunc_weight, METH_NOARGS},
    {"wordSpacing", (PyCFunction)SbkQFontFunc_wordSpacing, METH_NOARGS},
    {0} // Sentinel
};

static PyObject* SbkQFontFunc___lshift__(PyObject* self, PyObject* arg)
{
    bool isReverse = SbkQFont_Check(arg) && !SbkQFont_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse
        && SbkBaseWrapper_Check(arg)
        && !PyObject_TypeCheck(arg, self->ob_type)
        && PyObject_HasAttrString(arg, const_cast<char*>("__rlshift__"))) {
        PyObject* revOpMethod = PyObject_GetAttrString(arg, const_cast<char*>("__rlshift__"));
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            py_result = PyObject_CallFunction(revOpMethod, const_cast<char*>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(py_result);
                py_result = 0;
            }
        }
        Py_XDECREF(revOpMethod);

    }
    // Do not enter here if other object has implemented a reverse operator.
    if (!py_result) {

    if (isReverse && Shiboken::Converter<QDataStream & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDataStream* cpp_arg0 = Shiboken::Converter<QDataStream* >::toCpp(arg);
        // operator<<(QDataStream&,QFont) [reverse operator]
        QFont* cppSelf = Shiboken::Converter<QFont* >::toCpp((PyObject*)self);
        QDataStream & cpp_result = (*cpp_arg0) << (*cppSelf);
        py_result = Shiboken::Converter<QDataStream & >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else goto SbkQFontFunc___lshift___TypeError;

    } // End of "if (!py_result)"


    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQFontFunc___lshift___TypeError:
        const char* overloads[] = {"PySide.QtCore.QDataStream", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QFont.__lshift__", overloads);
        return 0;
}

static PyObject* SbkQFontFunc___rshift__(PyObject* self, PyObject* arg)
{
    bool isReverse = SbkQFont_Check(arg) && !SbkQFont_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse
        && SbkBaseWrapper_Check(arg)
        && !PyObject_TypeCheck(arg, self->ob_type)
        && PyObject_HasAttrString(arg, const_cast<char*>("__rrshift__"))) {
        PyObject* revOpMethod = PyObject_GetAttrString(arg, const_cast<char*>("__rrshift__"));
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            py_result = PyObject_CallFunction(revOpMethod, const_cast<char*>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(py_result);
                py_result = 0;
            }
        }
        Py_XDECREF(revOpMethod);

    }
    // Do not enter here if other object has implemented a reverse operator.
    if (!py_result) {

    if (isReverse && Shiboken::Converter<QDataStream & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QDataStream* cpp_arg0 = Shiboken::Converter<QDataStream* >::toCpp(arg);
        // operator>>(QDataStream&,QFont&) [reverse operator]
        QFont* cppSelf = Shiboken::Converter<QFont* >::toCpp((PyObject*)self);
        QDataStream & cpp_result = (*cpp_arg0) >> (*cppSelf);
        py_result = Shiboken::Converter<QDataStream & >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else goto SbkQFontFunc___rshift___TypeError;

    } // End of "if (!py_result)"


    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQFontFunc___rshift___TypeError:
        const char* overloads[] = {"PySide.QtCore.QDataStream", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QFont.__rshift__", overloads);
        return 0;
}

// type has number operators
static PyNumberMethods SbkQFont_as_number = {
    /*nb_add*/                  (binaryfunc)0,
    /*nb_subtract*/             (binaryfunc)0,
    /*nb_multiply*/             (binaryfunc)0,
    /*nb_divide*/               (binaryfunc)0,
    /*nb_remainder*/            (binaryfunc)0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             (unaryfunc)0,
    /*nb_positive*/             (unaryfunc)0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)0,
    /*nb_lshift*/               (binaryfunc)SbkQFontFunc___lshift__,
    /*nb_rshift*/               (binaryfunc)SbkQFontFunc___rshift__,
    /*nb_and*/                  (binaryfunc)0,
    /*nb_xor*/                  (binaryfunc)0,
    /*nb_or*/                   (binaryfunc)0,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          (binaryfunc)0,
    /*nb_inplace_subtract*/     (binaryfunc)0,
    /*nb_inplace_multiply*/     (binaryfunc)0,
    /*nb_inplace_divide*/       (binaryfunc)0,
    /*nb_inplace_remainder*/    (binaryfunc)0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       (binaryfunc)0,
    /*nb_inplace_rshift*/       (binaryfunc)0,
    /*nb_inplace_and*/          (binaryfunc)0,
    /*nb_inplace_xor*/          (binaryfunc)0,
    /*nb_inplace_or*/           (binaryfunc)0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};

// Rich comparison
static PyObject* SbkQFont_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result = false;
    QFont& cpp_self = *Shiboken::Converter<QFont* >::toCpp((PyObject*)self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<QFont & >::isConvertible(other)) {
                // operator!=(const QFont & arg__1) const
                QFont* cpp_other = Shiboken::Converter<QFont* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QFont  >::toCpp(other) : (cpp_self != (*cpp_other));
            } else if (Shiboken::Converter<QFont >::isConvertible(other)) {
                if (Shiboken::cppObjectIsInvalid(other))
                    return 0;
                std::auto_ptr<QFont > cpp_other_auto_ptr;
                QFont* cpp_other = Shiboken::Converter<QFont* >::toCpp(other);
                if (!SbkQFont_Check(other))
                    cpp_other_auto_ptr = std::auto_ptr<QFont >(cpp_other);
                result = (cpp_self != (*cpp_other));
            } else goto SbkQFont_RichComparison_TypeError;

            break;
        case Py_LT:
            if (Shiboken::Converter<QFont & >::isConvertible(other)) {
                // operator<(const QFont & arg__1) const
                QFont* cpp_other = Shiboken::Converter<QFont* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QFont  >::toCpp(other) : (cpp_self < (*cpp_other));
            } else if (Shiboken::Converter<QFont >::isConvertible(other)) {
                if (Shiboken::cppObjectIsInvalid(other))
                    return 0;
                std::auto_ptr<QFont > cpp_other_auto_ptr;
                QFont* cpp_other = Shiboken::Converter<QFont* >::toCpp(other);
                if (!SbkQFont_Check(other))
                    cpp_other_auto_ptr = std::auto_ptr<QFont >(cpp_other);
                result = (cpp_self < (*cpp_other));
            } else goto SbkQFont_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<QFont & >::isConvertible(other)) {
                // operator==(const QFont & arg__1) const
                QFont* cpp_other = Shiboken::Converter<QFont* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QFont  >::toCpp(other) : (cpp_self == (*cpp_other));
            } else if (Shiboken::Converter<QFont >::isConvertible(other)) {
                if (Shiboken::cppObjectIsInvalid(other))
                    return 0;
                std::auto_ptr<QFont > cpp_other_auto_ptr;
                QFont* cpp_other = Shiboken::Converter<QFont* >::toCpp(other);
                if (!SbkQFont_Check(other))
                    cpp_other_auto_ptr = std::auto_ptr<QFont >(cpp_other);
                result = (cpp_self == (*cpp_other));
            } else goto SbkQFont_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    SbkQFont_RichComparison_TypeError:
    Py_RETURN_FALSE;

}

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQFont_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QFont",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        &SbkQFont_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQFont_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQFont_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQFont_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QFont >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static PyGetSetDef SbkPySide_QtGui_QFont_StyleStrategy_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QFont_StyleStrategy_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QFont_StyleStrategy_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "StyleStrategy",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QFont_StyleStrategy_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QFont_StyleStrategy_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QFont_StyleStrategy_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtGui_QFont_SpacingType_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QFont_SpacingType_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QFont_SpacingType_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "SpacingType",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QFont_SpacingType_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QFont_SpacingType_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QFont_SpacingType_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtGui_QFont_StyleHint_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QFont_StyleHint_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QFont_StyleHint_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "StyleHint",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QFont_StyleHint_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QFont_StyleHint_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QFont_StyleHint_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtGui_QFont_Weight_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QFont_Weight_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QFont_Weight_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Weight",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QFont_Weight_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QFont_Weight_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QFont_Weight_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtGui_QFont_Capitalization_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QFont_Capitalization_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QFont_Capitalization_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Capitalization",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QFont_Capitalization_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QFont_Capitalization_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QFont_Capitalization_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtGui_QFont_Stretch_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QFont_Stretch_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QFont_Stretch_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Stretch",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QFont_Stretch_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QFont_Stretch_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QFont_Stretch_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtGui_QFont_Style_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QFont_Style_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QFont_Style_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Style",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QFont_Style_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QFont_Style_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QFont_Style_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void) init_QFont(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QFONT_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQFont_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQFont_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQFont_Type));
    PyModule_AddObject(module, "QFont",
        ((PyObject*)&SbkQFont_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: StyleStrategy
    SbkPySide_QtGuiTypes[SBK_QFONT_STYLESTRATEGY_IDX] = &SbkPySide_QtGui_QFont_StyleStrategy_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QFont_StyleStrategy_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QFont_StyleStrategy_Type);
    PyDict_SetItemString(SbkQFont_Type.super.ht_type.tp_dict,
            "StyleStrategy",((PyObject*)&SbkPySide_QtGui_QFont_StyleStrategy_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFont_StyleStrategy_Type,
        (long) QFont::PreferDefault, "PreferDefault");
    PyDict_SetItemString(SbkQFont_Type.super.ht_type.tp_dict,
        "PreferDefault", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFont_StyleStrategy_Type.tp_dict,
        "PreferDefault", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFont_StyleStrategy_Type,
        (long) QFont::PreferBitmap, "PreferBitmap");
    PyDict_SetItemString(SbkQFont_Type.super.ht_type.tp_dict,
        "PreferBitmap", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFont_StyleStrategy_Type.tp_dict,
        "PreferBitmap", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFont_StyleStrategy_Type,
        (long) QFont::PreferDevice, "PreferDevice");
    PyDict_SetItemString(SbkQFont_Type.super.ht_type.tp_dict,
        "PreferDevice", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFont_StyleStrategy_Type.tp_dict,
        "PreferDevice", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFont_StyleStrategy_Type,
        (long) QFont::PreferOutline, "PreferOutline");
    PyDict_SetItemString(SbkQFont_Type.super.ht_type.tp_dict,
        "PreferOutline", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFont_StyleStrategy_Type.tp_dict,
        "PreferOutline", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFont_StyleStrategy_Type,
        (long) QFont::ForceOutline, "ForceOutline");
    PyDict_SetItemString(SbkQFont_Type.super.ht_type.tp_dict,
        "ForceOutline", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFont_StyleStrategy_Type.tp_dict,
        "ForceOutline", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFont_StyleStrategy_Type,
        (long) QFont::PreferMatch, "PreferMatch");
    PyDict_SetItemString(SbkQFont_Type.super.ht_type.tp_dict,
        "PreferMatch", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFont_StyleStrategy_Type.tp_dict,
        "PreferMatch", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFont_StyleStrategy_Type,
        (long) QFont::PreferQuality, "PreferQuality");
    PyDict_SetItemString(SbkQFont_Type.super.ht_type.tp_dict,
        "PreferQuality", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFont_StyleStrategy_Type.tp_dict,
        "PreferQuality", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFont_StyleStrategy_Type,
        (long) QFont::PreferAntialias, "PreferAntialias");
    PyDict_SetItemString(SbkQFont_Type.super.ht_type.tp_dict,
        "PreferAntialias", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFont_StyleStrategy_Type.tp_dict,
        "PreferAntialias", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFont_StyleStrategy_Type,
        (long) QFont::NoAntialias, "NoAntialias");
    PyDict_SetItemString(SbkQFont_Type.super.ht_type.tp_dict,
        "NoAntialias", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFont_StyleStrategy_Type.tp_dict,
        "NoAntialias", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFont_StyleStrategy_Type,
        (long) QFont::OpenGLCompatible, "OpenGLCompatible");
    PyDict_SetItemString(SbkQFont_Type.super.ht_type.tp_dict,
        "OpenGLCompatible", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFont_StyleStrategy_Type.tp_dict,
        "OpenGLCompatible", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFont_StyleStrategy_Type,
        (long) QFont::NoFontMerging, "NoFontMerging");
    PyDict_SetItemString(SbkQFont_Type.super.ht_type.tp_dict,
        "NoFontMerging", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFont_StyleStrategy_Type.tp_dict,
        "NoFontMerging", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QFont::StyleStrategy");

    // init enum class: SpacingType
    SbkPySide_QtGuiTypes[SBK_QFONT_SPACINGTYPE_IDX] = &SbkPySide_QtGui_QFont_SpacingType_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QFont_SpacingType_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QFont_SpacingType_Type);
    PyDict_SetItemString(SbkQFont_Type.super.ht_type.tp_dict,
            "SpacingType",((PyObject*)&SbkPySide_QtGui_QFont_SpacingType_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFont_SpacingType_Type,
        (long) QFont::PercentageSpacing, "PercentageSpacing");
    PyDict_SetItemString(SbkQFont_Type.super.ht_type.tp_dict,
        "PercentageSpacing", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFont_SpacingType_Type.tp_dict,
        "PercentageSpacing", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFont_SpacingType_Type,
        (long) QFont::AbsoluteSpacing, "AbsoluteSpacing");
    PyDict_SetItemString(SbkQFont_Type.super.ht_type.tp_dict,
        "AbsoluteSpacing", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFont_SpacingType_Type.tp_dict,
        "AbsoluteSpacing", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QFont::SpacingType");

    // init enum class: StyleHint
    SbkPySide_QtGuiTypes[SBK_QFONT_STYLEHINT_IDX] = &SbkPySide_QtGui_QFont_StyleHint_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QFont_StyleHint_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QFont_StyleHint_Type);
    PyDict_SetItemString(SbkQFont_Type.super.ht_type.tp_dict,
            "StyleHint",((PyObject*)&SbkPySide_QtGui_QFont_StyleHint_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFont_StyleHint_Type,
        (long) QFont::Helvetica, "Helvetica");
    PyDict_SetItemString(SbkQFont_Type.super.ht_type.tp_dict,
        "Helvetica", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFont_StyleHint_Type.tp_dict,
        "Helvetica", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFont_StyleHint_Type,
        (long) QFont::SansSerif, "SansSerif");
    PyDict_SetItemString(SbkQFont_Type.super.ht_type.tp_dict,
        "SansSerif", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFont_StyleHint_Type.tp_dict,
        "SansSerif", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFont_StyleHint_Type,
        (long) QFont::Times, "Times");
    PyDict_SetItemString(SbkQFont_Type.super.ht_type.tp_dict,
        "Times", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFont_StyleHint_Type.tp_dict,
        "Times", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFont_StyleHint_Type,
        (long) QFont::Serif, "Serif");
    PyDict_SetItemString(SbkQFont_Type.super.ht_type.tp_dict,
        "Serif", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFont_StyleHint_Type.tp_dict,
        "Serif", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFont_StyleHint_Type,
        (long) QFont::Courier, "Courier");
    PyDict_SetItemString(SbkQFont_Type.super.ht_type.tp_dict,
        "Courier", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFont_StyleHint_Type.tp_dict,
        "Courier", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFont_StyleHint_Type,
        (long) QFont::TypeWriter, "TypeWriter");
    PyDict_SetItemString(SbkQFont_Type.super.ht_type.tp_dict,
        "TypeWriter", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFont_StyleHint_Type.tp_dict,
        "TypeWriter", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFont_StyleHint_Type,
        (long) QFont::OldEnglish, "OldEnglish");
    PyDict_SetItemString(SbkQFont_Type.super.ht_type.tp_dict,
        "OldEnglish", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFont_StyleHint_Type.tp_dict,
        "OldEnglish", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFont_StyleHint_Type,
        (long) QFont::Decorative, "Decorative");
    PyDict_SetItemString(SbkQFont_Type.super.ht_type.tp_dict,
        "Decorative", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFont_StyleHint_Type.tp_dict,
        "Decorative", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFont_StyleHint_Type,
        (long) QFont::System, "System");
    PyDict_SetItemString(SbkQFont_Type.super.ht_type.tp_dict,
        "System", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFont_StyleHint_Type.tp_dict,
        "System", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFont_StyleHint_Type,
        (long) QFont::AnyStyle, "AnyStyle");
    PyDict_SetItemString(SbkQFont_Type.super.ht_type.tp_dict,
        "AnyStyle", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFont_StyleHint_Type.tp_dict,
        "AnyStyle", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QFont::StyleHint");

    // init enum class: Weight
    SbkPySide_QtGuiTypes[SBK_QFONT_WEIGHT_IDX] = &SbkPySide_QtGui_QFont_Weight_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QFont_Weight_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QFont_Weight_Type);
    PyDict_SetItemString(SbkQFont_Type.super.ht_type.tp_dict,
            "Weight",((PyObject*)&SbkPySide_QtGui_QFont_Weight_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFont_Weight_Type,
        (long) QFont::Light, "Light");
    PyDict_SetItemString(SbkQFont_Type.super.ht_type.tp_dict,
        "Light", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFont_Weight_Type.tp_dict,
        "Light", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFont_Weight_Type,
        (long) QFont::Normal, "Normal");
    PyDict_SetItemString(SbkQFont_Type.super.ht_type.tp_dict,
        "Normal", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFont_Weight_Type.tp_dict,
        "Normal", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFont_Weight_Type,
        (long) QFont::DemiBold, "DemiBold");
    PyDict_SetItemString(SbkQFont_Type.super.ht_type.tp_dict,
        "DemiBold", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFont_Weight_Type.tp_dict,
        "DemiBold", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFont_Weight_Type,
        (long) QFont::Bold, "Bold");
    PyDict_SetItemString(SbkQFont_Type.super.ht_type.tp_dict,
        "Bold", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFont_Weight_Type.tp_dict,
        "Bold", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFont_Weight_Type,
        (long) QFont::Black, "Black");
    PyDict_SetItemString(SbkQFont_Type.super.ht_type.tp_dict,
        "Black", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFont_Weight_Type.tp_dict,
        "Black", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QFont::Weight");

    // init enum class: Capitalization
    SbkPySide_QtGuiTypes[SBK_QFONT_CAPITALIZATION_IDX] = &SbkPySide_QtGui_QFont_Capitalization_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QFont_Capitalization_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QFont_Capitalization_Type);
    PyDict_SetItemString(SbkQFont_Type.super.ht_type.tp_dict,
            "Capitalization",((PyObject*)&SbkPySide_QtGui_QFont_Capitalization_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFont_Capitalization_Type,
        (long) QFont::MixedCase, "MixedCase");
    PyDict_SetItemString(SbkQFont_Type.super.ht_type.tp_dict,
        "MixedCase", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFont_Capitalization_Type.tp_dict,
        "MixedCase", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFont_Capitalization_Type,
        (long) QFont::AllUppercase, "AllUppercase");
    PyDict_SetItemString(SbkQFont_Type.super.ht_type.tp_dict,
        "AllUppercase", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFont_Capitalization_Type.tp_dict,
        "AllUppercase", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFont_Capitalization_Type,
        (long) QFont::AllLowercase, "AllLowercase");
    PyDict_SetItemString(SbkQFont_Type.super.ht_type.tp_dict,
        "AllLowercase", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFont_Capitalization_Type.tp_dict,
        "AllLowercase", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFont_Capitalization_Type,
        (long) QFont::SmallCaps, "SmallCaps");
    PyDict_SetItemString(SbkQFont_Type.super.ht_type.tp_dict,
        "SmallCaps", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFont_Capitalization_Type.tp_dict,
        "SmallCaps", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFont_Capitalization_Type,
        (long) QFont::Capitalize, "Capitalize");
    PyDict_SetItemString(SbkQFont_Type.super.ht_type.tp_dict,
        "Capitalize", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFont_Capitalization_Type.tp_dict,
        "Capitalize", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QFont::Capitalization");

    // init enum class: Stretch
    SbkPySide_QtGuiTypes[SBK_QFONT_STRETCH_IDX] = &SbkPySide_QtGui_QFont_Stretch_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QFont_Stretch_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QFont_Stretch_Type);
    PyDict_SetItemString(SbkQFont_Type.super.ht_type.tp_dict,
            "Stretch",((PyObject*)&SbkPySide_QtGui_QFont_Stretch_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFont_Stretch_Type,
        (long) QFont::UltraCondensed, "UltraCondensed");
    PyDict_SetItemString(SbkQFont_Type.super.ht_type.tp_dict,
        "UltraCondensed", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFont_Stretch_Type.tp_dict,
        "UltraCondensed", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFont_Stretch_Type,
        (long) QFont::ExtraCondensed, "ExtraCondensed");
    PyDict_SetItemString(SbkQFont_Type.super.ht_type.tp_dict,
        "ExtraCondensed", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFont_Stretch_Type.tp_dict,
        "ExtraCondensed", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFont_Stretch_Type,
        (long) QFont::Condensed, "Condensed");
    PyDict_SetItemString(SbkQFont_Type.super.ht_type.tp_dict,
        "Condensed", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFont_Stretch_Type.tp_dict,
        "Condensed", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFont_Stretch_Type,
        (long) QFont::SemiCondensed, "SemiCondensed");
    PyDict_SetItemString(SbkQFont_Type.super.ht_type.tp_dict,
        "SemiCondensed", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFont_Stretch_Type.tp_dict,
        "SemiCondensed", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFont_Stretch_Type,
        (long) QFont::Unstretched, "Unstretched");
    PyDict_SetItemString(SbkQFont_Type.super.ht_type.tp_dict,
        "Unstretched", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFont_Stretch_Type.tp_dict,
        "Unstretched", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFont_Stretch_Type,
        (long) QFont::SemiExpanded, "SemiExpanded");
    PyDict_SetItemString(SbkQFont_Type.super.ht_type.tp_dict,
        "SemiExpanded", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFont_Stretch_Type.tp_dict,
        "SemiExpanded", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFont_Stretch_Type,
        (long) QFont::Expanded, "Expanded");
    PyDict_SetItemString(SbkQFont_Type.super.ht_type.tp_dict,
        "Expanded", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFont_Stretch_Type.tp_dict,
        "Expanded", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFont_Stretch_Type,
        (long) QFont::ExtraExpanded, "ExtraExpanded");
    PyDict_SetItemString(SbkQFont_Type.super.ht_type.tp_dict,
        "ExtraExpanded", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFont_Stretch_Type.tp_dict,
        "ExtraExpanded", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFont_Stretch_Type,
        (long) QFont::UltraExpanded, "UltraExpanded");
    PyDict_SetItemString(SbkQFont_Type.super.ht_type.tp_dict,
        "UltraExpanded", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFont_Stretch_Type.tp_dict,
        "UltraExpanded", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QFont::Stretch");

    // init enum class: Style
    SbkPySide_QtGuiTypes[SBK_QFONT_STYLE_IDX] = &SbkPySide_QtGui_QFont_Style_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QFont_Style_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QFont_Style_Type);
    PyDict_SetItemString(SbkQFont_Type.super.ht_type.tp_dict,
            "Style",((PyObject*)&SbkPySide_QtGui_QFont_Style_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFont_Style_Type,
        (long) QFont::StyleNormal, "StyleNormal");
    PyDict_SetItemString(SbkQFont_Type.super.ht_type.tp_dict,
        "StyleNormal", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFont_Style_Type.tp_dict,
        "StyleNormal", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFont_Style_Type,
        (long) QFont::StyleItalic, "StyleItalic");
    PyDict_SetItemString(SbkQFont_Type.super.ht_type.tp_dict,
        "StyleItalic", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFont_Style_Type.tp_dict,
        "StyleItalic", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QFont_Style_Type,
        (long) QFont::StyleOblique, "StyleOblique");
    PyDict_SetItemString(SbkQFont_Type.super.ht_type.tp_dict,
        "StyleOblique", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QFont_Style_Type.tp_dict,
        "StyleOblique", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QFont::Style");

    Shiboken::TypeResolver::createValueTypeResolver<QFont >("QFont");
    Shiboken::TypeResolver::createValueTypeResolver<QFont >(typeid(QFont).name());
}


} // extern "C"

