/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qfocusevent_wrapper.h"

// Extra includes

using namespace Shiboken;

// Native ---------------------------------------------------------

QFocusEventWrapper::QFocusEventWrapper(QEvent::Type type, Qt::FocusReason reason) : QFocusEvent(type, reason) {
    // ... middle
}

QFocusEventWrapper::~QFocusEventWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

static int
SbkQFocusEvent_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QFocusEventWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "QFocusEvent", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return -1;

    if (Shiboken::Converter<QEvent::Type >::isConvertible(pyargs[0])) {
        QEvent::Type cpp_arg0 = Shiboken::Converter<QEvent::Type >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // QFocusEvent(QEvent::Type,Qt::FocusReason)
            cptr = new QFocusEventWrapper(cpp_arg0);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<Qt::FocusReason >::isConvertible(pyargs[1])) {
            Qt::FocusReason cpp_arg1 = Shiboken::Converter<Qt::FocusReason >::toCpp(pyargs[1]);
            // QFocusEvent(QEvent::Type,Qt::FocusReason)
            cptr = new QFocusEventWrapper(cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQFocusEvent_Init_TypeError;
    } else goto SbkQFocusEvent_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QFocusEvent >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQFocusEvent_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQFocusEvent_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent.Type, PySide.QtCore.Qt.FocusReason = Qt.OtherFocusReason", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QFocusEvent", overloads);
        return -1;
}

static PyObject* SbkQFocusEventFunc_gotFocus(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // gotFocus()const
    QFocusEvent* cppSelf = Shiboken::Converter<QFocusEvent* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QFocusEvent::gotFocus();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFocusEventFunc_lostFocus(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // lostFocus()const
    QFocusEvent* cppSelf = Shiboken::Converter<QFocusEvent* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QFocusEvent::lostFocus();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQFocusEventFunc_reason(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // reason()
    QFocusEvent* cppSelf = Shiboken::Converter<QFocusEvent* >::toCpp((PyObject*)self);
    Qt::FocusReason cpp_result = cppSelf->QFocusEvent::reason();
    py_result = Shiboken::Converter<Qt::FocusReason >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQFocusEvent_methods[] = {
    {"gotFocus", (PyCFunction)SbkQFocusEventFunc_gotFocus, METH_NOARGS},
    {"lostFocus", (PyCFunction)SbkQFocusEventFunc_lostFocus, METH_NOARGS},
    {"reason", (PyCFunction)SbkQFocusEventFunc_reason, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQFocusEvent_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QFocusEvent",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQFocusEvent_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQFocusEvent_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QFocusEvent >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static SbkBaseWrapperType* SbkQFocusEvent_typeDiscovery(void* cptr, SbkBaseWrapperType* instanceType)
{
    if (instanceType->mi_specialcast)
        cptr = instanceType->mi_specialcast(cptr, &SbkQFocusEvent_Type);
     if ( reinterpret_cast<QFocusEvent*>(cptr)->type() == QEvent::FocusIn ||  reinterpret_cast<QFocusEvent*>(cptr)->type() == QEvent::FocusOut)
        return &SbkQFocusEvent_Type;
    return 0;
}


PyAPI_FUNC(void) init_QFocusEvent(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QFOCUSEVENT_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQFocusEvent_Type);

    SbkQFocusEvent_Type.super.ht_type.tp_base = SbkPySide_QtCoreTypes[SBK_QEVENT_IDX];
    // Fill type discovery information
    SbkQFocusEvent_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QEVENT_IDX])->type_discovery;
    SbkQFocusEvent_Type.type_discovery->addTypeDiscoveryFunction(&SbkQFocusEvent_typeDiscovery);

    if (PyType_Ready((PyTypeObject*)&SbkQFocusEvent_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQFocusEvent_Type));
    PyModule_AddObject(module, "QFocusEvent",
        ((PyObject*)&SbkQFocusEvent_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QFocusEvent >("QFocusEvent*");
    Shiboken::TypeResolver::createObjectTypeResolver<QFocusEvent >(typeid(QFocusEvent).name());
}


} // extern "C"

