/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include "pyside_qtgui_python.h"

#include "qdatawidgetmapper_wrapper.h"

// Extra includes
#include <QList>
#include <qabstractitemdelegate.h>
#include <qabstractitemmodel.h>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qdatawidgetmapper.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qstring.h>
#include <qthread.h>
#include <qvariant.h>
#include <qwidget.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QDataWidgetMapperWrapper::QDataWidgetMapperWrapper(QObject * parent) : QDataWidgetMapper(parent), m_metaObject(0) {
    // ... middle
}

void QDataWidgetMapperWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QChildEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QDataWidgetMapperWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QDataWidgetMapperWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QDataWidgetMapperWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QDataWidgetMapperWrapper::event(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QObject::event(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QDataWidgetMapper.event", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
    return cpp_result;
}

bool QDataWidgetMapperWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QObject * >::toPython(arg__1),
        Shiboken::Converter<QEvent * >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QDataWidgetMapper.eventFilter", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 1));
    return cpp_result;
}

void QDataWidgetMapperWrapper::setCurrentIndex(int index)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setCurrentIndex"));
    if (py_override.isNull()) {
        return this->QDataWidgetMapper::setCurrentIndex(index);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        index
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QDataWidgetMapperWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QTimerEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

const QMetaObject* QDataWidgetMapperWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QDataWidgetMapper::staticMetaObject);
}
    return m_metaObject;
}

int QDataWidgetMapperWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QDataWidgetMapper::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QDataWidgetMapperWrapper::~QDataWidgetMapperWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQDataWidgetMapper_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QDataWidgetMapperWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QDataWidgetMapper", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QDataWidgetMapper(QObject*)
        cptr = new QDataWidgetMapperWrapper();
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else if (Shiboken::Converter<QObject * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(pyargs[0]);
        // QDataWidgetMapper(QObject*)
        cptr = new QDataWidgetMapperWrapper(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else goto SbkQDataWidgetMapper_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QDataWidgetMapper >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQDataWidgetMapper_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    sbkSelf->referredObjects = new Shiboken::RefCountMap;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQDataWidgetMapper_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QDataWidgetMapper", overloads);
        return -1;
}

static PyObject* SbkQDataWidgetMapperFunc_addMapping(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "addMapping", 2, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (Shiboken::Converter<QWidget * >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        if (numArgs == 2) {
            // addMapping(QWidget*,int)
            QDataWidgetMapper* cppSelf = Shiboken::Converter<QDataWidgetMapper* >::toCpp((PyObject*)self);
            cppSelf->QDataWidgetMapper::addMapping(cpp_arg0, cpp_arg1);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(self, pyargs[0]);
        } else if (numArgs == 3 && Shiboken::Converter<QByteArray & >::isConvertible(pyargs[2])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                return 0;
            std::auto_ptr<QByteArray > cpp_arg2_auto_ptr;
            QByteArray* cpp_arg2 = Shiboken::Converter<QByteArray* >::toCpp(pyargs[2]);
            if (!SbkQByteArray_Check(pyargs[2]))
                cpp_arg2_auto_ptr = std::auto_ptr<QByteArray >(cpp_arg2);
            // addMapping(QWidget*,int,QByteArray)
            QDataWidgetMapper* cppSelf = Shiboken::Converter<QDataWidgetMapper* >::toCpp((PyObject*)self);
            cppSelf->QDataWidgetMapper::addMapping(cpp_arg0, cpp_arg1, *cpp_arg2);
            //CppGenerator::writeParentChildManagement
            Shiboken::setParent(self, pyargs[0]);
        } else goto SbkQDataWidgetMapperFunc_addMapping_TypeError;
    } else goto SbkQDataWidgetMapperFunc_addMapping_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQDataWidgetMapperFunc_addMapping_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget, int", "PySide.QtGui.QWidget, int, PySide.QtCore.QByteArray", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QDataWidgetMapper.addMapping", overloads);
        return 0;
}

static PyObject* SbkQDataWidgetMapperFunc_clearMapping(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // clearMapping()
    QDataWidgetMapper* cppSelf = Shiboken::Converter<QDataWidgetMapper* >::toCpp((PyObject*)self);
    cppSelf->QDataWidgetMapper::clearMapping();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQDataWidgetMapperFunc_currentIndex(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // currentIndex()const
    QDataWidgetMapper* cppSelf = Shiboken::Converter<QDataWidgetMapper* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QDataWidgetMapper::currentIndex();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQDataWidgetMapperFunc_itemDelegate(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // itemDelegate()const
    QDataWidgetMapper* cppSelf = Shiboken::Converter<QDataWidgetMapper* >::toCpp((PyObject*)self);
    QAbstractItemDelegate * cpp_result = cppSelf->QDataWidgetMapper::itemDelegate();
    py_result = Shiboken::Converter<QAbstractItemDelegate * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQDataWidgetMapperFunc_mappedPropertyName(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QWidget * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(arg);
        // mappedPropertyName(QWidget*)const
        QDataWidgetMapper* cppSelf = Shiboken::Converter<QDataWidgetMapper* >::toCpp((PyObject*)self);
        QByteArray cpp_result = cppSelf->QDataWidgetMapper::mappedPropertyName(cpp_arg0);
        py_result = Shiboken::Converter<QByteArray >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDataWidgetMapperFunc_mappedPropertyName_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQDataWidgetMapperFunc_mappedPropertyName_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QDataWidgetMapper.mappedPropertyName", overloads);
        return 0;
}

static PyObject* SbkQDataWidgetMapperFunc_mappedSection(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QWidget * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(arg);
        // mappedSection(QWidget*)const
        QDataWidgetMapper* cppSelf = Shiboken::Converter<QDataWidgetMapper* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QDataWidgetMapper::mappedSection(cpp_arg0);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDataWidgetMapperFunc_mappedSection_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQDataWidgetMapperFunc_mappedSection_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QDataWidgetMapper.mappedSection", overloads);
        return 0;
}

static PyObject* SbkQDataWidgetMapperFunc_mappedWidgetAt(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // mappedWidgetAt(int)const
        QDataWidgetMapper* cppSelf = Shiboken::Converter<QDataWidgetMapper* >::toCpp((PyObject*)self);
        QWidget * cpp_result = cppSelf->QDataWidgetMapper::mappedWidgetAt(cpp_arg0);
        py_result = Shiboken::Converter<QWidget * >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else goto SbkQDataWidgetMapperFunc_mappedWidgetAt_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQDataWidgetMapperFunc_mappedWidgetAt_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QDataWidgetMapper.mappedWidgetAt", overloads);
        return 0;
}

static PyObject* SbkQDataWidgetMapperFunc_model(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // model()const
    QDataWidgetMapper* cppSelf = Shiboken::Converter<QDataWidgetMapper* >::toCpp((PyObject*)self);
    QAbstractItemModel * cpp_result = cppSelf->QDataWidgetMapper::model();
    py_result = Shiboken::Converter<QAbstractItemModel * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQDataWidgetMapperFunc_orientation(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // orientation()const
    QDataWidgetMapper* cppSelf = Shiboken::Converter<QDataWidgetMapper* >::toCpp((PyObject*)self);
    Qt::Orientation cpp_result = cppSelf->QDataWidgetMapper::orientation();
    py_result = Shiboken::Converter<Qt::Orientation >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQDataWidgetMapperFunc_removeMapping(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QWidget * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QWidget* cpp_arg0 = Shiboken::Converter<QWidget* >::toCpp(arg);
        // removeMapping(QWidget*)
        QDataWidgetMapper* cppSelf = Shiboken::Converter<QDataWidgetMapper* >::toCpp((PyObject*)self);
        cppSelf->QDataWidgetMapper::removeMapping(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(Py_None, arg);
    } else goto SbkQDataWidgetMapperFunc_removeMapping_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQDataWidgetMapperFunc_removeMapping_TypeError:
        const char* overloads[] = {"PySide.QtGui.QWidget", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QDataWidgetMapper.removeMapping", overloads);
        return 0;
}

static PyObject* SbkQDataWidgetMapperFunc_revert(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // revert()
    QDataWidgetMapper* cppSelf = Shiboken::Converter<QDataWidgetMapper* >::toCpp((PyObject*)self);
    cppSelf->QDataWidgetMapper::revert();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQDataWidgetMapperFunc_rootIndex(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // rootIndex()const
    QDataWidgetMapper* cppSelf = Shiboken::Converter<QDataWidgetMapper* >::toCpp((PyObject*)self);
    QModelIndex cpp_result = cppSelf->QDataWidgetMapper::rootIndex();
    py_result = Shiboken::Converter<QModelIndex >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQDataWidgetMapperFunc_setCurrentIndex(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setCurrentIndex(int)
        QDataWidgetMapper* cppSelf = Shiboken::Converter<QDataWidgetMapper* >::toCpp((PyObject*)self);
        cppSelf->QDataWidgetMapper::setCurrentIndex(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDataWidgetMapperFunc_setCurrentIndex_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQDataWidgetMapperFunc_setCurrentIndex_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QDataWidgetMapper.setCurrentIndex", overloads);
        return 0;
}

static PyObject* SbkQDataWidgetMapperFunc_setCurrentModelIndex(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QModelIndex & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(arg);
        // setCurrentModelIndex(QModelIndex)
        QDataWidgetMapper* cppSelf = Shiboken::Converter<QDataWidgetMapper* >::toCpp((PyObject*)self);
        cppSelf->QDataWidgetMapper::setCurrentModelIndex(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDataWidgetMapperFunc_setCurrentModelIndex_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQDataWidgetMapperFunc_setCurrentModelIndex_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QDataWidgetMapper.setCurrentModelIndex", overloads);
        return 0;
}

static PyObject* SbkQDataWidgetMapperFunc_setItemDelegate(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QAbstractItemDelegate * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QAbstractItemDelegate* cpp_arg0 = Shiboken::Converter<QAbstractItemDelegate* >::toCpp(arg);
        // setItemDelegate(QAbstractItemDelegate*)
        QDataWidgetMapper* cppSelf = Shiboken::Converter<QDataWidgetMapper* >::toCpp((PyObject*)self);
        cppSelf->QDataWidgetMapper::setItemDelegate(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, arg);
    } else goto SbkQDataWidgetMapperFunc_setItemDelegate_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQDataWidgetMapperFunc_setItemDelegate_TypeError:
        const char* overloads[] = {"PySide.QtGui.QAbstractItemDelegate", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QDataWidgetMapper.setItemDelegate", overloads);
        return 0;
}

static PyObject* SbkQDataWidgetMapperFunc_setModel(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QAbstractItemModel * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QAbstractItemModel* cpp_arg0 = Shiboken::Converter<QAbstractItemModel* >::toCpp(arg);
        // setModel(QAbstractItemModel*)
        QDataWidgetMapper* cppSelf = Shiboken::Converter<QDataWidgetMapper* >::toCpp((PyObject*)self);
        cppSelf->QDataWidgetMapper::setModel(cpp_arg0);
        Shiboken::keepReference(reinterpret_cast<SbkBaseWrapper*>(self), "setModel(QAbstractItemModel*)1", arg);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDataWidgetMapperFunc_setModel_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQDataWidgetMapperFunc_setModel_TypeError:
        const char* overloads[] = {"PySide.QtCore.QAbstractItemModel", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QDataWidgetMapper.setModel", overloads);
        return 0;
}

static PyObject* SbkQDataWidgetMapperFunc_setOrientation(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<Qt::Orientation >::isConvertible(arg)) {
        Qt::Orientation cpp_arg0 = Shiboken::Converter<Qt::Orientation >::toCpp(arg);
        // setOrientation(Qt::Orientation)
        QDataWidgetMapper* cppSelf = Shiboken::Converter<QDataWidgetMapper* >::toCpp((PyObject*)self);
        cppSelf->QDataWidgetMapper::setOrientation(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDataWidgetMapperFunc_setOrientation_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQDataWidgetMapperFunc_setOrientation_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.Orientation", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QDataWidgetMapper.setOrientation", overloads);
        return 0;
}

static PyObject* SbkQDataWidgetMapperFunc_setRootIndex(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QModelIndex & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QModelIndex* cpp_arg0 = Shiboken::Converter<QModelIndex* >::toCpp(arg);
        // setRootIndex(QModelIndex)
        QDataWidgetMapper* cppSelf = Shiboken::Converter<QDataWidgetMapper* >::toCpp((PyObject*)self);
        cppSelf->QDataWidgetMapper::setRootIndex(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDataWidgetMapperFunc_setRootIndex_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQDataWidgetMapperFunc_setRootIndex_TypeError:
        const char* overloads[] = {"PySide.QtCore.QModelIndex", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QDataWidgetMapper.setRootIndex", overloads);
        return 0;
}

static PyObject* SbkQDataWidgetMapperFunc_setSubmitPolicy(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QDataWidgetMapper::SubmitPolicy >::isConvertible(arg)) {
        QDataWidgetMapper::SubmitPolicy cpp_arg0 = Shiboken::Converter<QDataWidgetMapper::SubmitPolicy >::toCpp(arg);
        // setSubmitPolicy(QDataWidgetMapper::SubmitPolicy)
        QDataWidgetMapper* cppSelf = Shiboken::Converter<QDataWidgetMapper* >::toCpp((PyObject*)self);
        cppSelf->QDataWidgetMapper::setSubmitPolicy(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQDataWidgetMapperFunc_setSubmitPolicy_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQDataWidgetMapperFunc_setSubmitPolicy_TypeError:
        const char* overloads[] = {"PySide.QtGui.QDataWidgetMapper.SubmitPolicy", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QDataWidgetMapper.setSubmitPolicy", overloads);
        return 0;
}

static PyObject* SbkQDataWidgetMapperFunc_submit(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // submit()
    QDataWidgetMapper* cppSelf = Shiboken::Converter<QDataWidgetMapper* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QDataWidgetMapper::submit();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQDataWidgetMapperFunc_submitPolicy(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // submitPolicy()const
    QDataWidgetMapper* cppSelf = Shiboken::Converter<QDataWidgetMapper* >::toCpp((PyObject*)self);
    QDataWidgetMapper::SubmitPolicy cpp_result = cppSelf->QDataWidgetMapper::submitPolicy();
    py_result = Shiboken::Converter<QDataWidgetMapper::SubmitPolicy >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQDataWidgetMapperFunc_toFirst(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // toFirst()
    QDataWidgetMapper* cppSelf = Shiboken::Converter<QDataWidgetMapper* >::toCpp((PyObject*)self);
    cppSelf->QDataWidgetMapper::toFirst();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQDataWidgetMapperFunc_toLast(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // toLast()
    QDataWidgetMapper* cppSelf = Shiboken::Converter<QDataWidgetMapper* >::toCpp((PyObject*)self);
    cppSelf->QDataWidgetMapper::toLast();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQDataWidgetMapperFunc_toNext(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // toNext()
    QDataWidgetMapper* cppSelf = Shiboken::Converter<QDataWidgetMapper* >::toCpp((PyObject*)self);
    cppSelf->QDataWidgetMapper::toNext();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQDataWidgetMapperFunc_toPrevious(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // toPrevious()
    QDataWidgetMapper* cppSelf = Shiboken::Converter<QDataWidgetMapper* >::toCpp((PyObject*)self);
    cppSelf->QDataWidgetMapper::toPrevious();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyMethodDef SbkQDataWidgetMapper_methods[] = {
    {"addMapping", (PyCFunction)SbkQDataWidgetMapperFunc_addMapping, METH_VARARGS},
    {"clearMapping", (PyCFunction)SbkQDataWidgetMapperFunc_clearMapping, METH_NOARGS},
    {"currentIndex", (PyCFunction)SbkQDataWidgetMapperFunc_currentIndex, METH_NOARGS},
    {"itemDelegate", (PyCFunction)SbkQDataWidgetMapperFunc_itemDelegate, METH_NOARGS},
    {"mappedPropertyName", (PyCFunction)SbkQDataWidgetMapperFunc_mappedPropertyName, METH_O},
    {"mappedSection", (PyCFunction)SbkQDataWidgetMapperFunc_mappedSection, METH_O},
    {"mappedWidgetAt", (PyCFunction)SbkQDataWidgetMapperFunc_mappedWidgetAt, METH_O},
    {"model", (PyCFunction)SbkQDataWidgetMapperFunc_model, METH_NOARGS},
    {"orientation", (PyCFunction)SbkQDataWidgetMapperFunc_orientation, METH_NOARGS},
    {"removeMapping", (PyCFunction)SbkQDataWidgetMapperFunc_removeMapping, METH_O},
    {"revert", (PyCFunction)SbkQDataWidgetMapperFunc_revert, METH_NOARGS},
    {"rootIndex", (PyCFunction)SbkQDataWidgetMapperFunc_rootIndex, METH_NOARGS},
    {"setCurrentIndex", (PyCFunction)SbkQDataWidgetMapperFunc_setCurrentIndex, METH_O},
    {"setCurrentModelIndex", (PyCFunction)SbkQDataWidgetMapperFunc_setCurrentModelIndex, METH_O},
    {"setItemDelegate", (PyCFunction)SbkQDataWidgetMapperFunc_setItemDelegate, METH_O},
    {"setModel", (PyCFunction)SbkQDataWidgetMapperFunc_setModel, METH_O},
    {"setOrientation", (PyCFunction)SbkQDataWidgetMapperFunc_setOrientation, METH_O},
    {"setRootIndex", (PyCFunction)SbkQDataWidgetMapperFunc_setRootIndex, METH_O},
    {"setSubmitPolicy", (PyCFunction)SbkQDataWidgetMapperFunc_setSubmitPolicy, METH_O},
    {"submit", (PyCFunction)SbkQDataWidgetMapperFunc_submit, METH_NOARGS},
    {"submitPolicy", (PyCFunction)SbkQDataWidgetMapperFunc_submitPolicy, METH_NOARGS},
    {"toFirst", (PyCFunction)SbkQDataWidgetMapperFunc_toFirst, METH_NOARGS},
    {"toLast", (PyCFunction)SbkQDataWidgetMapperFunc_toLast, METH_NOARGS},
    {"toNext", (PyCFunction)SbkQDataWidgetMapperFunc_toNext, METH_NOARGS},
    {"toPrevious", (PyCFunction)SbkQDataWidgetMapperFunc_toPrevious, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQDataWidgetMapper_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QDataWidgetMapper",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQDataWidgetMapper_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQDataWidgetMapper_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QDataWidgetMapper >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};

static PyGetSetDef SbkPySide_QtGui_QDataWidgetMapper_SubmitPolicy_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtGui_QDataWidgetMapper_SubmitPolicy_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtGui_QDataWidgetMapper_SubmitPolicy_Type = {
    PyObject_HEAD_INIT(&Shiboken::SbkEnumType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "SubmitPolicy",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtGui_QDataWidgetMapper_SubmitPolicy_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtGui_QDataWidgetMapper_SubmitPolicy_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject* SbkPySide_QtGui_QDataWidgetMapper_SubmitPolicy_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void) init_QDataWidgetMapper(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QDATAWIDGETMAPPER_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQDataWidgetMapper_Type);

    SbkQDataWidgetMapper_Type.super.ht_type.tp_base = SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX];
    // Fill type discovery information
    SbkQDataWidgetMapper_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQDataWidgetMapper_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQDataWidgetMapper_Type));
    PyModule_AddObject(module, "QDataWidgetMapper",
        ((PyObject*)&SbkQDataWidgetMapper_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: SubmitPolicy
    SbkPySide_QtGuiTypes[SBK_QDATAWIDGETMAPPER_SUBMITPOLICY_IDX] = &SbkPySide_QtGui_QDataWidgetMapper_SubmitPolicy_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtGui_QDataWidgetMapper_SubmitPolicy_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtGui_QDataWidgetMapper_SubmitPolicy_Type);
    PyDict_SetItemString(SbkQDataWidgetMapper_Type.super.ht_type.tp_dict,
            "SubmitPolicy",((PyObject*)&SbkPySide_QtGui_QDataWidgetMapper_SubmitPolicy_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QDataWidgetMapper_SubmitPolicy_Type,
        (long) QDataWidgetMapper::AutoSubmit, "AutoSubmit");
    PyDict_SetItemString(SbkQDataWidgetMapper_Type.super.ht_type.tp_dict,
        "AutoSubmit", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QDataWidgetMapper_SubmitPolicy_Type.tp_dict,
        "AutoSubmit", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtGui_QDataWidgetMapper_SubmitPolicy_Type,
        (long) QDataWidgetMapper::ManualSubmit, "ManualSubmit");
    PyDict_SetItemString(SbkQDataWidgetMapper_Type.super.ht_type.tp_dict,
        "ManualSubmit", enum_item);
    PyDict_SetItemString(SbkPySide_QtGui_QDataWidgetMapper_SubmitPolicy_Type.tp_dict,
        "ManualSubmit", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QDataWidgetMapper::SubmitPolicy");

    Shiboken::TypeResolver::createObjectTypeResolver<QDataWidgetMapper >("QDataWidgetMapper*");
    Shiboken::TypeResolver::createObjectTypeResolver<QDataWidgetMapper >(typeid(QDataWidgetMapper).name());
}


} // extern "C"

