/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtgui_python.h"

#include "qbitmap_wrapper.h"

// Extra includes
#include <qbitmap.h>
#include <qbytearray.h>
#include <qcolor.h>
#include <qimage.h>
#include <qimagewriter.h>
#include <qiodevice.h>
#include <qmatrix.h>
#include <qpaintdevice.h>
#include <qpaintengine.h>
#include <qpixmap.h>
#include <qpoint.h>
#include <qrect.h>
#include <qregion.h>
#include <qsize.h>
#include <qstring.h>
#include <qtransform.h>
#include <qvariant.h>
#include <qwidget.h>
#include <qx11info_x11.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QBitmapWrapper::QBitmapWrapper() : QBitmap() {
    // ... middle
}

QBitmapWrapper::QBitmapWrapper(const QPixmap & arg__1) : QBitmap(arg__1) {
    // ... middle
}

QBitmapWrapper::QBitmapWrapper(const QSize & arg__1) : QBitmap(arg__1) {
    // ... middle
}

QBitmapWrapper::QBitmapWrapper(int w, int h) : QBitmap(w, h) {
    // ... middle
}

int QBitmapWrapper::devType() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "devType"));
    if (py_override.isNull()) {
        return this->QPixmap::devType();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QBitmap.devType", SbkType<int >()->tp_name, py_result->ob_type->tp_name);
        return int(0);
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

int QBitmapWrapper::metric(QPaintDevice::PaintDeviceMetric arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "metric"));
    if (py_override.isNull()) {
        return this->QPixmap::metric(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QPaintDevice::PaintDeviceMetric >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QBitmap.metric", SbkType<int >()->tp_name, py_result->ob_type->tp_name);
        return int(0);
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

QPaintEngine * QBitmapWrapper::paintEngine() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "paintEngine"));
    if (py_override.isNull()) {
        return this->QPixmap::paintEngine();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QPaintEngine * >::isConvertible(py_result);
    typeIsValid = typeIsValid || (py_result == Py_None);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QBitmap.paintEngine", SbkType<QPaintEngine * >()->tp_name, py_result->ob_type->tp_name);
        return 0;
    }
    QPaintEngine * cpp_result(Shiboken::Converter<QPaintEngine * >::toCpp(py_result));
    return cpp_result;
}

QBitmapWrapper::~QBitmapWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

static int
SbkQBitmap_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QBitmapWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "QBitmap", 0, 2, &(pyargs[0]), &(pyargs[1])))
        return -1;

    if (numArgs == 0) {
        // QBitmap()
        cptr = new QBitmapWrapper();
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // QBitmap(int,int)
        cptr = new QBitmapWrapper(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QSize & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QSize* cpp_arg0 = Shiboken::Converter<QSize* >::toCpp(pyargs[0]);
        // QBitmap(QSize)
        cptr = new QBitmapWrapper(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QPixmap & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QPixmap > cpp_arg0_auto_ptr;
        QPixmap* cpp_arg0 = Shiboken::Converter<QPixmap* >::toCpp(pyargs[0]);
        if (!SbkQPixmap_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QPixmap >(cpp_arg0);
        // QBitmap(QPixmap)
        cptr = new QBitmapWrapper(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQBitmap_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QBitmap >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQBitmap_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    sbkSelf->referredObjects = new Shiboken::RefCountMap;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQBitmap_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtGui.QPixmap", "PySide.QtCore.QSize", "int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QBitmap", overloads);
        return -1;
}

static PyObject* SbkQBitmapFunc_clear(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // clear()
    QBitmap* cppSelf = Shiboken::Converter<QBitmap* >::toCpp((PyObject*)self);
    cppSelf->QBitmap::clear();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQBitmapFunc_fromImage(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "fromImage", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QImage & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QImage* cpp_arg0 = Shiboken::Converter<QImage* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // fromImage(QImage,QFlags<Qt::ImageConversionFlag>)
            QBitmap cpp_result = QBitmap::fromImage(*cpp_arg0);
            py_result = Shiboken::Converter<QBitmap >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (SbkPySide_QtCore_Qt_ImageConversionFlag_Check(pyargs[1])) {
            QFlags<Qt::ImageConversionFlag> cpp_arg1 = Shiboken::Converter<QFlags<Qt::ImageConversionFlag> >::toCpp(pyargs[1]);
            // fromImage(QImage,QFlags<Qt::ImageConversionFlag>)
            QBitmap cpp_result = QBitmap::fromImage(*cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<QBitmap >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQBitmapFunc_fromImage_TypeError;
    } else goto SbkQBitmapFunc_fromImage_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQBitmapFunc_fromImage_TypeError:
        const char* overloads[] = {"PySide.QtGui.QImage, PySide.QtCore.Qt.ImageConversionFlags = Qt.AutoColor", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtGui.QBitmap.fromImage", overloads);
        return 0;
}

static PyObject* SbkQBitmapFunc_transformed(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QTransform & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTransform* cpp_arg0 = Shiboken::Converter<QTransform* >::toCpp(arg);
        // transformed(QTransform)const
        QBitmap* cppSelf = Shiboken::Converter<QBitmap* >::toCpp((PyObject*)self);
        QBitmap cpp_result = cppSelf->QBitmap::transformed(*cpp_arg0);
        py_result = Shiboken::Converter<QBitmap >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QMatrix & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QMatrix* cpp_arg0 = Shiboken::Converter<QMatrix* >::toCpp(arg);
        // transformed(QMatrix)const
        QBitmap* cppSelf = Shiboken::Converter<QBitmap* >::toCpp((PyObject*)self);
        QBitmap cpp_result = cppSelf->QBitmap::transformed(*cpp_arg0);
        py_result = Shiboken::Converter<QBitmap >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQBitmapFunc_transformed_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQBitmapFunc_transformed_TypeError:
        const char* overloads[] = {"PySide.QtGui.QMatrix", "PySide.QtGui.QTransform", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtGui.QBitmap.transformed", overloads);
        return 0;
}

static PyMethodDef SbkQBitmap_methods[] = {
    {"clear", (PyCFunction)SbkQBitmapFunc_clear, METH_NOARGS},
    {"fromImage", (PyCFunction)SbkQBitmapFunc_fromImage, METH_VARARGS|METH_STATIC},
    {"transformed", (PyCFunction)SbkQBitmapFunc_transformed, METH_O},
    {0} // Sentinel
};

extern "C"
{

static void* SbkQBitmap_ObjCopierFunc(const void* ptr){
    return new QBitmapWrapper(*reinterpret_cast<const QBitmap*>(ptr));
}

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQBitmap_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtGui.QBitmap",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQBitmap_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQBitmap_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          &SbkQBitmap_ObjCopierFunc,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QBitmap >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_QBitmap(PyObject* module)
{
    SbkPySide_QtGuiTypes[SBK_QBITMAP_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQBitmap_Type);

    SbkQBitmap_Type.super.ht_type.tp_base = SbkPySide_QtGuiTypes[SBK_QPIXMAP_IDX];
    // Fill type discovery information
    SbkQBitmap_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtGuiTypes[SBK_QPAINTDEVICE_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQBitmap_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQBitmap_Type));
    PyModule_AddObject(module, "QBitmap",
        ((PyObject*)&SbkQBitmap_Type));

    Shiboken::TypeResolver::createValueTypeResolver<QBitmap >("QBitmap");
    Shiboken::TypeResolver::createValueTypeResolver<QBitmap >(typeid(QBitmap).name());
}


} // extern "C"

