/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include "pyside_qtcore_python.h"

#include "qsequentialanimationgroup_wrapper.h"

// Extra includes
#include <QList>
#include <qabstractanimation.h>
#include <qanimationgroup.h>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpauseanimation.h>
#include <qsequentialanimationgroup.h>
#include <qstring.h>
#include <qthread.h>
#include <qvariant.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QSequentialAnimationGroupWrapper::QSequentialAnimationGroupWrapper(QObject * parent) : QSequentialAnimationGroup(parent), m_metaObject(0) {
    // ... middle
}

void QSequentialAnimationGroupWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QChildEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QSequentialAnimationGroupWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QSequentialAnimationGroupWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QSequentialAnimationGroupWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

int QSequentialAnimationGroupWrapper::duration() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "duration"));
    if (py_override.isNull()) {
        return this->QSequentialAnimationGroup::duration();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QSequentialAnimationGroup.duration", SbkType<int >()->tp_name, py_result->ob_type->tp_name);
        return int(0);
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

bool QSequentialAnimationGroupWrapper::event(QEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QSequentialAnimationGroup::event(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QSequentialAnimationGroup.event", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QSequentialAnimationGroupWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QObject * >::toPython(arg__1),
        Shiboken::Converter<QEvent * >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QSequentialAnimationGroup.eventFilter", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 1));
    return cpp_result;
}

void QSequentialAnimationGroupWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QTimerEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QSequentialAnimationGroupWrapper::updateCurrentTime(int arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "updateCurrentTime"));
    if (py_override.isNull()) {
        return this->QSequentialAnimationGroup::updateCurrentTime(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        arg__1
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QSequentialAnimationGroupWrapper::updateDirection(QAbstractAnimation::Direction direction)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "updateDirection"));
    if (py_override.isNull()) {
        return this->QSequentialAnimationGroup::updateDirection(direction);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QAbstractAnimation::Direction >::toPython(direction)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QSequentialAnimationGroupWrapper::updateState(QAbstractAnimation::State newState, QAbstractAnimation::State oldState)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "updateState"));
    if (py_override.isNull()) {
        return this->QSequentialAnimationGroup::updateState(newState, oldState);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QAbstractAnimation::State >::toPython(newState),
        Shiboken::Converter<QAbstractAnimation::State >::toPython(oldState)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

const QMetaObject* QSequentialAnimationGroupWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QSequentialAnimationGroup::staticMetaObject);
}
    return m_metaObject;
}

int QSequentialAnimationGroupWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QSequentialAnimationGroup::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QSequentialAnimationGroupWrapper::~QSequentialAnimationGroupWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQSequentialAnimationGroup_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QSequentialAnimationGroupWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QSequentialAnimationGroup", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QSequentialAnimationGroup(QObject*)
        cptr = new QSequentialAnimationGroupWrapper();
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else if (Shiboken::Converter<QObject * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(pyargs[0]);
        // QSequentialAnimationGroup(QObject*)
        cptr = new QSequentialAnimationGroupWrapper(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else goto SbkQSequentialAnimationGroup_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QSequentialAnimationGroup >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQSequentialAnimationGroup_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQSequentialAnimationGroup_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QSequentialAnimationGroup", overloads);
        return -1;
}

static PyObject* SbkQSequentialAnimationGroupFunc_addPause(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // addPause(int)
        QSequentialAnimationGroup* cppSelf = Shiboken::Converter<QSequentialAnimationGroup* >::toCpp((PyObject*)self);
        QPauseAnimation * cpp_result = cppSelf->QSequentialAnimationGroup::addPause(cpp_arg0);
        py_result = Shiboken::Converter<QPauseAnimation * >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else goto SbkQSequentialAnimationGroupFunc_addPause_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQSequentialAnimationGroupFunc_addPause_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QSequentialAnimationGroup.addPause", overloads);
        return 0;
}

static PyObject* SbkQSequentialAnimationGroupFunc_currentAnimation(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // currentAnimation()const
    QSequentialAnimationGroup* cppSelf = Shiboken::Converter<QSequentialAnimationGroup* >::toCpp((PyObject*)self);
    QAbstractAnimation * cpp_result = cppSelf->QSequentialAnimationGroup::currentAnimation();
    py_result = Shiboken::Converter<QAbstractAnimation * >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQSequentialAnimationGroupFunc_duration(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // duration()const
    QSequentialAnimationGroup* cppSelf = Shiboken::Converter<QSequentialAnimationGroup* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QSequentialAnimationGroup::duration();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQSequentialAnimationGroupFunc_event(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QEvent * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QEvent* cpp_arg0 = Shiboken::Converter<QEvent* >::toCpp(arg);
        // event(QEvent*)
        QSequentialAnimationGroup* cppSelf = Shiboken::Converter<QSequentialAnimationGroup* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QSequentialAnimationGroup::event(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQSequentialAnimationGroupFunc_event_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQSequentialAnimationGroupFunc_event_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QSequentialAnimationGroup.event", overloads);
        return 0;
}

static PyObject* SbkQSequentialAnimationGroupFunc_insertPause(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "insertPause", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // insertPause(int,int)
        QSequentialAnimationGroup* cppSelf = Shiboken::Converter<QSequentialAnimationGroup* >::toCpp((PyObject*)self);
        QPauseAnimation * cpp_result = cppSelf->QSequentialAnimationGroup::insertPause(cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<QPauseAnimation * >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(self, py_result);
    } else goto SbkQSequentialAnimationGroupFunc_insertPause_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQSequentialAnimationGroupFunc_insertPause_TypeError:
        const char* overloads[] = {"int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QSequentialAnimationGroup.insertPause", overloads);
        return 0;
}

static PyObject* SbkQSequentialAnimationGroupFunc_updateCurrentTime(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // updateCurrentTime(int)
        QSequentialAnimationGroup* cppSelf = Shiboken::Converter<QSequentialAnimationGroup* >::toCpp((PyObject*)self);
        cppSelf->QSequentialAnimationGroup::updateCurrentTime(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQSequentialAnimationGroupFunc_updateCurrentTime_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSequentialAnimationGroupFunc_updateCurrentTime_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QSequentialAnimationGroup.updateCurrentTime", overloads);
        return 0;
}

static PyObject* SbkQSequentialAnimationGroupFunc_updateDirection(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QAbstractAnimation::Direction >::isConvertible(arg)) {
        QAbstractAnimation::Direction cpp_arg0 = Shiboken::Converter<QAbstractAnimation::Direction >::toCpp(arg);
        // updateDirection(QAbstractAnimation::Direction)
        QSequentialAnimationGroup* cppSelf = Shiboken::Converter<QSequentialAnimationGroup* >::toCpp((PyObject*)self);
        cppSelf->QSequentialAnimationGroup::updateDirection(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQSequentialAnimationGroupFunc_updateDirection_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSequentialAnimationGroupFunc_updateDirection_TypeError:
        const char* overloads[] = {"PySide.QtCore.QAbstractAnimation.Direction", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QSequentialAnimationGroup.updateDirection", overloads);
        return 0;
}

static PyObject* SbkQSequentialAnimationGroupFunc_updateState(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "updateState", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QAbstractAnimation::State >::isConvertible(pyargs[0]) && Shiboken::Converter<QAbstractAnimation::State >::isConvertible(pyargs[1])) {
        QAbstractAnimation::State cpp_arg0 = Shiboken::Converter<QAbstractAnimation::State >::toCpp(pyargs[0]);
        QAbstractAnimation::State cpp_arg1 = Shiboken::Converter<QAbstractAnimation::State >::toCpp(pyargs[1]);
        // updateState(QAbstractAnimation::State,QAbstractAnimation::State)
        QSequentialAnimationGroup* cppSelf = Shiboken::Converter<QSequentialAnimationGroup* >::toCpp((PyObject*)self);
        cppSelf->QSequentialAnimationGroup::updateState(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQSequentialAnimationGroupFunc_updateState_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQSequentialAnimationGroupFunc_updateState_TypeError:
        const char* overloads[] = {"PySide.QtCore.QAbstractAnimation.State, PySide.QtCore.QAbstractAnimation.State", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QSequentialAnimationGroup.updateState", overloads);
        return 0;
}

static PyMethodDef SbkQSequentialAnimationGroup_methods[] = {
    {"addPause", (PyCFunction)SbkQSequentialAnimationGroupFunc_addPause, METH_O},
    {"currentAnimation", (PyCFunction)SbkQSequentialAnimationGroupFunc_currentAnimation, METH_NOARGS},
    {"duration", (PyCFunction)SbkQSequentialAnimationGroupFunc_duration, METH_NOARGS},
    {"event", (PyCFunction)SbkQSequentialAnimationGroupFunc_event, METH_O},
    {"insertPause", (PyCFunction)SbkQSequentialAnimationGroupFunc_insertPause, METH_VARARGS},
    {"updateCurrentTime", (PyCFunction)SbkQSequentialAnimationGroupFunc_updateCurrentTime, METH_O},
    {"updateDirection", (PyCFunction)SbkQSequentialAnimationGroupFunc_updateDirection, METH_O},
    {"updateState", (PyCFunction)SbkQSequentialAnimationGroupFunc_updateState, METH_VARARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQSequentialAnimationGroup_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtCore.QSequentialAnimationGroup",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQSequentialAnimationGroup_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQSequentialAnimationGroup_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QSequentialAnimationGroup >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_QSequentialAnimationGroup(PyObject* module)
{
    SbkPySide_QtCoreTypes[SBK_QSEQUENTIALANIMATIONGROUP_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQSequentialAnimationGroup_Type);

    SbkQSequentialAnimationGroup_Type.super.ht_type.tp_base = SbkPySide_QtCoreTypes[SBK_QANIMATIONGROUP_IDX];
    // Fill type discovery information
    SbkQSequentialAnimationGroup_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQSequentialAnimationGroup_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQSequentialAnimationGroup_Type));
    PyModule_AddObject(module, "QSequentialAnimationGroup",
        ((PyObject*)&SbkQSequentialAnimationGroup_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QSequentialAnimationGroup >("QSequentialAnimationGroup*");
    Shiboken::TypeResolver::createObjectTypeResolver<QSequentialAnimationGroup >(typeid(QSequentialAnimationGroup).name());
}


} // extern "C"

