/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtcore_python.h"

#include "qrectf_wrapper.h"

// Extra includes
#include <qpoint.h>
#include <qrect.h>
#include <qsize.h>

using namespace Shiboken;

static int
SbkQRectF_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QRectF* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 3)
        goto SbkQRectF_Init_TypeError;

    if (!PyArg_UnpackTuple(args, "QRectF", 0, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return -1;

    if (numArgs == 0) {
        // QRectF()
        cptr = new QRectF();
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 4 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2]) && PyNumber_Check(pyargs[3])) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        qreal cpp_arg2 = Shiboken::Converter<qreal >::toCpp(pyargs[2]);
        qreal cpp_arg3 = Shiboken::Converter<qreal >::toCpp(pyargs[3]);
        // QRectF(qreal,qreal,qreal,qreal)
        cptr = new QRectF(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QRect & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QRect* cpp_arg0 = Shiboken::Converter<QRect* >::toCpp(pyargs[0]);
        // QRectF(QRect)
        cptr = new QRectF(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QPointF & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(pyargs[0]);
        if (!SbkQPointF_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        if (numArgs == 2 && Shiboken::Converter<QSizeF & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return -1;
            std::auto_ptr<QSizeF > cpp_arg1_auto_ptr;
            QSizeF* cpp_arg1 = Shiboken::Converter<QSizeF* >::toCpp(pyargs[1]);
            if (!SbkQSizeF_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QSizeF >(cpp_arg1);
            // QRectF(QPointF,QSizeF)
            cptr = new QRectF(*cpp_arg0, *cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else if (numArgs == 2 && Shiboken::Converter<QPointF & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return -1;
            std::auto_ptr<QPointF > cpp_arg1_auto_ptr;
            QPointF* cpp_arg1 = Shiboken::Converter<QPointF* >::toCpp(pyargs[1]);
            if (!SbkQPointF_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QPointF >(cpp_arg1);
            // QRectF(QPointF,QPointF)
            cptr = new QRectF(*cpp_arg0, *cpp_arg1);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQRectF_Init_TypeError;
    } else if (numArgs == 1 && Shiboken::Converter<QRectF & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QRectF > cpp_arg0_auto_ptr;
        QRectF* cpp_arg0 = Shiboken::Converter<QRectF* >::toCpp(pyargs[0]);
        if (!SbkQRectF_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QRectF >(cpp_arg0);
        // QRectF(QRectF)
        cptr = new QRectF(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQRectF_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QRectF >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQRectF_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQRectF_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QRectF", "", "PySide.QtCore.QPointF, PySide.QtCore.QPointF", "PySide.QtCore.QPointF, PySide.QtCore.QSizeF", "PySide.QtCore.QRect", "float, float, float, float", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QRectF", overloads);
        return -1;
}

static PyObject* SbkQRectFFunc_adjust(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "adjust", 4, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (numArgs == 4 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2]) && PyNumber_Check(pyargs[3])) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        qreal cpp_arg2 = Shiboken::Converter<qreal >::toCpp(pyargs[2]);
        qreal cpp_arg3 = Shiboken::Converter<qreal >::toCpp(pyargs[3]);
        // adjust(qreal,qreal,qreal,qreal)
        QRectF* cppSelf = Shiboken::Converter<QRectF* >::toCpp((PyObject*)self);
        cppSelf->QRectF::adjust(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQRectFFunc_adjust_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQRectFFunc_adjust_TypeError:
        const char* overloads[] = {"float, float, float, float", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QRectF.adjust", overloads);
        return 0;
}

static PyObject* SbkQRectFFunc_adjusted(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "adjusted", 4, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (numArgs == 4 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2]) && PyNumber_Check(pyargs[3])) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        qreal cpp_arg2 = Shiboken::Converter<qreal >::toCpp(pyargs[2]);
        qreal cpp_arg3 = Shiboken::Converter<qreal >::toCpp(pyargs[3]);
        // adjusted(qreal,qreal,qreal,qreal)const
        QRectF* cppSelf = Shiboken::Converter<QRectF* >::toCpp((PyObject*)self);
        QRectF cpp_result = cppSelf->QRectF::adjusted(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
        py_result = Shiboken::Converter<QRectF >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQRectFFunc_adjusted_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQRectFFunc_adjusted_TypeError:
        const char* overloads[] = {"float, float, float, float", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QRectF.adjusted", overloads);
        return 0;
}

static PyObject* SbkQRectFFunc_bottom(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // bottom()const
    QRectF* cppSelf = Shiboken::Converter<QRectF* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QRectF::bottom();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQRectFFunc_bottomLeft(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // bottomLeft()const
    QRectF* cppSelf = Shiboken::Converter<QRectF* >::toCpp((PyObject*)self);
    QPointF cpp_result = cppSelf->QRectF::bottomLeft();
    py_result = Shiboken::Converter<QPointF >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQRectFFunc_bottomRight(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // bottomRight()const
    QRectF* cppSelf = Shiboken::Converter<QRectF* >::toCpp((PyObject*)self);
    QPointF cpp_result = cppSelf->QRectF::bottomRight();
    py_result = Shiboken::Converter<QPointF >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQRectFFunc_center(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // center()const
    QRectF* cppSelf = Shiboken::Converter<QRectF* >::toCpp((PyObject*)self);
    QPointF cpp_result = cppSelf->QRectF::center();
    py_result = Shiboken::Converter<QPointF >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQRectFFunc_contains(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "contains", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        // contains(qreal,qreal)const
        QRectF* cppSelf = Shiboken::Converter<QRectF* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QRectF::contains(cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QRectF & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QRectF > cpp_arg0_auto_ptr;
        QRectF* cpp_arg0 = Shiboken::Converter<QRectF* >::toCpp(pyargs[0]);
        if (!SbkQRectF_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QRectF >(cpp_arg0);
        // contains(QRectF)const
        QRectF* cppSelf = Shiboken::Converter<QRectF* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QRectF::contains(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QPointF & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(pyargs[0]);
        if (!SbkQPointF_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        // contains(QPointF)const
        QRectF* cppSelf = Shiboken::Converter<QRectF* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QRectF::contains(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQRectFFunc_contains_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQRectFFunc_contains_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPointF", "PySide.QtCore.QRectF", "float, float", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QRectF.contains", overloads);
        return 0;
}

static PyObject* SbkQRectFFunc_height(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // height()const
    QRectF* cppSelf = Shiboken::Converter<QRectF* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QRectF::height();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQRectFFunc_intersect(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QRectF & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QRectF > cpp_arg0_auto_ptr;
        QRectF* cpp_arg0 = Shiboken::Converter<QRectF* >::toCpp(arg);
        if (!SbkQRectF_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QRectF >(cpp_arg0);
        // intersect(QRectF)const
        QRectF* cppSelf = Shiboken::Converter<QRectF* >::toCpp((PyObject*)self);
        QRectF cpp_result = cppSelf->QRectF::intersect(*cpp_arg0);
        py_result = Shiboken::Converter<QRectF >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQRectFFunc_intersect_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQRectFFunc_intersect_TypeError:
        const char* overloads[] = {"PySide.QtCore.QRectF", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QRectF.intersect", overloads);
        return 0;
}

static PyObject* SbkQRectFFunc_intersected(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QRectF & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QRectF > cpp_arg0_auto_ptr;
        QRectF* cpp_arg0 = Shiboken::Converter<QRectF* >::toCpp(arg);
        if (!SbkQRectF_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QRectF >(cpp_arg0);
        // intersected(QRectF)const
        QRectF* cppSelf = Shiboken::Converter<QRectF* >::toCpp((PyObject*)self);
        QRectF cpp_result = cppSelf->QRectF::intersected(*cpp_arg0);
        py_result = Shiboken::Converter<QRectF >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQRectFFunc_intersected_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQRectFFunc_intersected_TypeError:
        const char* overloads[] = {"PySide.QtCore.QRectF", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QRectF.intersected", overloads);
        return 0;
}

static PyObject* SbkQRectFFunc_intersects(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QRectF & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QRectF > cpp_arg0_auto_ptr;
        QRectF* cpp_arg0 = Shiboken::Converter<QRectF* >::toCpp(arg);
        if (!SbkQRectF_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QRectF >(cpp_arg0);
        // intersects(QRectF)const
        QRectF* cppSelf = Shiboken::Converter<QRectF* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QRectF::intersects(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQRectFFunc_intersects_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQRectFFunc_intersects_TypeError:
        const char* overloads[] = {"PySide.QtCore.QRectF", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QRectF.intersects", overloads);
        return 0;
}

static PyObject* SbkQRectFFunc_isEmpty(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isEmpty()const
    QRectF* cppSelf = Shiboken::Converter<QRectF* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QRectF::isEmpty();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQRectFFunc_isNull(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isNull()const
    QRectF* cppSelf = Shiboken::Converter<QRectF* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QRectF::isNull();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQRectFFunc_isValid(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isValid()const
    QRectF* cppSelf = Shiboken::Converter<QRectF* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QRectF::isValid();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQRectFFunc_left(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // left()const
    QRectF* cppSelf = Shiboken::Converter<QRectF* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QRectF::left();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQRectFFunc_moveBottom(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // moveBottom(qreal)
        QRectF* cppSelf = Shiboken::Converter<QRectF* >::toCpp((PyObject*)self);
        cppSelf->QRectF::moveBottom(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQRectFFunc_moveBottom_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQRectFFunc_moveBottom_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QRectF.moveBottom", overloads);
        return 0;
}

static PyObject* SbkQRectFFunc_moveBottomLeft(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPointF & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(arg);
        if (!SbkQPointF_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        // moveBottomLeft(QPointF)
        QRectF* cppSelf = Shiboken::Converter<QRectF* >::toCpp((PyObject*)self);
        cppSelf->QRectF::moveBottomLeft(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQRectFFunc_moveBottomLeft_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQRectFFunc_moveBottomLeft_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPointF", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QRectF.moveBottomLeft", overloads);
        return 0;
}

static PyObject* SbkQRectFFunc_moveBottomRight(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPointF & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(arg);
        if (!SbkQPointF_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        // moveBottomRight(QPointF)
        QRectF* cppSelf = Shiboken::Converter<QRectF* >::toCpp((PyObject*)self);
        cppSelf->QRectF::moveBottomRight(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQRectFFunc_moveBottomRight_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQRectFFunc_moveBottomRight_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPointF", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QRectF.moveBottomRight", overloads);
        return 0;
}

static PyObject* SbkQRectFFunc_moveCenter(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPointF & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(arg);
        if (!SbkQPointF_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        // moveCenter(QPointF)
        QRectF* cppSelf = Shiboken::Converter<QRectF* >::toCpp((PyObject*)self);
        cppSelf->QRectF::moveCenter(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQRectFFunc_moveCenter_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQRectFFunc_moveCenter_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPointF", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QRectF.moveCenter", overloads);
        return 0;
}

static PyObject* SbkQRectFFunc_moveLeft(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // moveLeft(qreal)
        QRectF* cppSelf = Shiboken::Converter<QRectF* >::toCpp((PyObject*)self);
        cppSelf->QRectF::moveLeft(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQRectFFunc_moveLeft_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQRectFFunc_moveLeft_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QRectF.moveLeft", overloads);
        return 0;
}

static PyObject* SbkQRectFFunc_moveRight(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // moveRight(qreal)
        QRectF* cppSelf = Shiboken::Converter<QRectF* >::toCpp((PyObject*)self);
        cppSelf->QRectF::moveRight(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQRectFFunc_moveRight_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQRectFFunc_moveRight_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QRectF.moveRight", overloads);
        return 0;
}

static PyObject* SbkQRectFFunc_moveTo(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "moveTo", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        // moveTo(qreal,qreal)
        QRectF* cppSelf = Shiboken::Converter<QRectF* >::toCpp((PyObject*)self);
        cppSelf->QRectF::moveTo(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QPointF & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(pyargs[0]);
        if (!SbkQPointF_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        // moveTo(QPointF)
        QRectF* cppSelf = Shiboken::Converter<QRectF* >::toCpp((PyObject*)self);
        cppSelf->QRectF::moveTo(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQRectFFunc_moveTo_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQRectFFunc_moveTo_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPointF", "float, float", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QRectF.moveTo", overloads);
        return 0;
}

static PyObject* SbkQRectFFunc_moveTop(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // moveTop(qreal)
        QRectF* cppSelf = Shiboken::Converter<QRectF* >::toCpp((PyObject*)self);
        cppSelf->QRectF::moveTop(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQRectFFunc_moveTop_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQRectFFunc_moveTop_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QRectF.moveTop", overloads);
        return 0;
}

static PyObject* SbkQRectFFunc_moveTopLeft(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPointF & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(arg);
        if (!SbkQPointF_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        // moveTopLeft(QPointF)
        QRectF* cppSelf = Shiboken::Converter<QRectF* >::toCpp((PyObject*)self);
        cppSelf->QRectF::moveTopLeft(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQRectFFunc_moveTopLeft_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQRectFFunc_moveTopLeft_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPointF", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QRectF.moveTopLeft", overloads);
        return 0;
}

static PyObject* SbkQRectFFunc_moveTopRight(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPointF & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(arg);
        if (!SbkQPointF_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        // moveTopRight(QPointF)
        QRectF* cppSelf = Shiboken::Converter<QRectF* >::toCpp((PyObject*)self);
        cppSelf->QRectF::moveTopRight(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQRectFFunc_moveTopRight_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQRectFFunc_moveTopRight_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPointF", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QRectF.moveTopRight", overloads);
        return 0;
}

static PyObject* SbkQRectFFunc_normalized(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // normalized()const
    QRectF* cppSelf = Shiboken::Converter<QRectF* >::toCpp((PyObject*)self);
    QRectF cpp_result = cppSelf->QRectF::normalized();
    py_result = Shiboken::Converter<QRectF >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQRectFFunc_right(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // right()const
    QRectF* cppSelf = Shiboken::Converter<QRectF* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QRectF::right();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQRectFFunc_setBottom(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setBottom(qreal)
        QRectF* cppSelf = Shiboken::Converter<QRectF* >::toCpp((PyObject*)self);
        cppSelf->QRectF::setBottom(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQRectFFunc_setBottom_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQRectFFunc_setBottom_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QRectF.setBottom", overloads);
        return 0;
}

static PyObject* SbkQRectFFunc_setBottomLeft(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPointF & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(arg);
        if (!SbkQPointF_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        // setBottomLeft(QPointF)
        QRectF* cppSelf = Shiboken::Converter<QRectF* >::toCpp((PyObject*)self);
        cppSelf->QRectF::setBottomLeft(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQRectFFunc_setBottomLeft_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQRectFFunc_setBottomLeft_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPointF", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QRectF.setBottomLeft", overloads);
        return 0;
}

static PyObject* SbkQRectFFunc_setBottomRight(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPointF & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(arg);
        if (!SbkQPointF_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        // setBottomRight(QPointF)
        QRectF* cppSelf = Shiboken::Converter<QRectF* >::toCpp((PyObject*)self);
        cppSelf->QRectF::setBottomRight(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQRectFFunc_setBottomRight_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQRectFFunc_setBottomRight_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPointF", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QRectF.setBottomRight", overloads);
        return 0;
}

static PyObject* SbkQRectFFunc_setCoords(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "setCoords", 4, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (numArgs == 4 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2]) && PyNumber_Check(pyargs[3])) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        qreal cpp_arg2 = Shiboken::Converter<qreal >::toCpp(pyargs[2]);
        qreal cpp_arg3 = Shiboken::Converter<qreal >::toCpp(pyargs[3]);
        // setCoords(qreal,qreal,qreal,qreal)
        QRectF* cppSelf = Shiboken::Converter<QRectF* >::toCpp((PyObject*)self);
        cppSelf->QRectF::setCoords(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQRectFFunc_setCoords_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQRectFFunc_setCoords_TypeError:
        const char* overloads[] = {"float, float, float, float", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QRectF.setCoords", overloads);
        return 0;
}

static PyObject* SbkQRectFFunc_setHeight(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setHeight(qreal)
        QRectF* cppSelf = Shiboken::Converter<QRectF* >::toCpp((PyObject*)self);
        cppSelf->QRectF::setHeight(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQRectFFunc_setHeight_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQRectFFunc_setHeight_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QRectF.setHeight", overloads);
        return 0;
}

static PyObject* SbkQRectFFunc_setLeft(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setLeft(qreal)
        QRectF* cppSelf = Shiboken::Converter<QRectF* >::toCpp((PyObject*)self);
        cppSelf->QRectF::setLeft(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQRectFFunc_setLeft_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQRectFFunc_setLeft_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QRectF.setLeft", overloads);
        return 0;
}

static PyObject* SbkQRectFFunc_setRect(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "setRect", 4, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (numArgs == 4 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2]) && PyNumber_Check(pyargs[3])) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        qreal cpp_arg2 = Shiboken::Converter<qreal >::toCpp(pyargs[2]);
        qreal cpp_arg3 = Shiboken::Converter<qreal >::toCpp(pyargs[3]);
        // setRect(qreal,qreal,qreal,qreal)
        QRectF* cppSelf = Shiboken::Converter<QRectF* >::toCpp((PyObject*)self);
        cppSelf->QRectF::setRect(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQRectFFunc_setRect_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQRectFFunc_setRect_TypeError:
        const char* overloads[] = {"float, float, float, float", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QRectF.setRect", overloads);
        return 0;
}

static PyObject* SbkQRectFFunc_setRight(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setRight(qreal)
        QRectF* cppSelf = Shiboken::Converter<QRectF* >::toCpp((PyObject*)self);
        cppSelf->QRectF::setRight(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQRectFFunc_setRight_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQRectFFunc_setRight_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QRectF.setRight", overloads);
        return 0;
}

static PyObject* SbkQRectFFunc_setSize(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QSizeF & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QSizeF > cpp_arg0_auto_ptr;
        QSizeF* cpp_arg0 = Shiboken::Converter<QSizeF* >::toCpp(arg);
        if (!SbkQSizeF_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QSizeF >(cpp_arg0);
        // setSize(QSizeF)
        QRectF* cppSelf = Shiboken::Converter<QRectF* >::toCpp((PyObject*)self);
        cppSelf->QRectF::setSize(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQRectFFunc_setSize_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQRectFFunc_setSize_TypeError:
        const char* overloads[] = {"PySide.QtCore.QSizeF", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QRectF.setSize", overloads);
        return 0;
}

static PyObject* SbkQRectFFunc_setTop(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setTop(qreal)
        QRectF* cppSelf = Shiboken::Converter<QRectF* >::toCpp((PyObject*)self);
        cppSelf->QRectF::setTop(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQRectFFunc_setTop_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQRectFFunc_setTop_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QRectF.setTop", overloads);
        return 0;
}

static PyObject* SbkQRectFFunc_setTopLeft(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPointF & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(arg);
        if (!SbkQPointF_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        // setTopLeft(QPointF)
        QRectF* cppSelf = Shiboken::Converter<QRectF* >::toCpp((PyObject*)self);
        cppSelf->QRectF::setTopLeft(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQRectFFunc_setTopLeft_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQRectFFunc_setTopLeft_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPointF", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QRectF.setTopLeft", overloads);
        return 0;
}

static PyObject* SbkQRectFFunc_setTopRight(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPointF & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(arg);
        if (!SbkQPointF_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        // setTopRight(QPointF)
        QRectF* cppSelf = Shiboken::Converter<QRectF* >::toCpp((PyObject*)self);
        cppSelf->QRectF::setTopRight(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQRectFFunc_setTopRight_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQRectFFunc_setTopRight_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPointF", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QRectF.setTopRight", overloads);
        return 0;
}

static PyObject* SbkQRectFFunc_setWidth(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setWidth(qreal)
        QRectF* cppSelf = Shiboken::Converter<QRectF* >::toCpp((PyObject*)self);
        cppSelf->QRectF::setWidth(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQRectFFunc_setWidth_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQRectFFunc_setWidth_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QRectF.setWidth", overloads);
        return 0;
}

static PyObject* SbkQRectFFunc_setX(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setX(qreal)
        QRectF* cppSelf = Shiboken::Converter<QRectF* >::toCpp((PyObject*)self);
        cppSelf->QRectF::setX(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQRectFFunc_setX_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQRectFFunc_setX_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QRectF.setX", overloads);
        return 0;
}

static PyObject* SbkQRectFFunc_setY(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // setY(qreal)
        QRectF* cppSelf = Shiboken::Converter<QRectF* >::toCpp((PyObject*)self);
        cppSelf->QRectF::setY(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQRectFFunc_setY_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQRectFFunc_setY_TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QRectF.setY", overloads);
        return 0;
}

static PyObject* SbkQRectFFunc_size(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // size()const
    QRectF* cppSelf = Shiboken::Converter<QRectF* >::toCpp((PyObject*)self);
    QSizeF cpp_result = cppSelf->QRectF::size();
    py_result = Shiboken::Converter<QSizeF >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQRectFFunc_toAlignedRect(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toAlignedRect()const
    QRectF* cppSelf = Shiboken::Converter<QRectF* >::toCpp((PyObject*)self);
    QRect cpp_result = cppSelf->QRectF::toAlignedRect();
    py_result = Shiboken::Converter<QRect >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQRectFFunc_toRect(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toRect()const
    QRectF* cppSelf = Shiboken::Converter<QRectF* >::toCpp((PyObject*)self);
    QRect cpp_result = cppSelf->QRectF::toRect();
    py_result = Shiboken::Converter<QRect >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQRectFFunc_top(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // top()const
    QRectF* cppSelf = Shiboken::Converter<QRectF* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QRectF::top();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQRectFFunc_topLeft(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // topLeft()const
    QRectF* cppSelf = Shiboken::Converter<QRectF* >::toCpp((PyObject*)self);
    QPointF cpp_result = cppSelf->QRectF::topLeft();
    py_result = Shiboken::Converter<QPointF >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQRectFFunc_topRight(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // topRight()const
    QRectF* cppSelf = Shiboken::Converter<QRectF* >::toCpp((PyObject*)self);
    QPointF cpp_result = cppSelf->QRectF::topRight();
    py_result = Shiboken::Converter<QPointF >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQRectFFunc_translate(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "translate", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        // translate(qreal,qreal)
        QRectF* cppSelf = Shiboken::Converter<QRectF* >::toCpp((PyObject*)self);
        cppSelf->QRectF::translate(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QPointF & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(pyargs[0]);
        if (!SbkQPointF_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        // translate(QPointF)
        QRectF* cppSelf = Shiboken::Converter<QRectF* >::toCpp((PyObject*)self);
        cppSelf->QRectF::translate(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQRectFFunc_translate_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQRectFFunc_translate_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPointF", "float, float", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QRectF.translate", overloads);
        return 0;
}

static PyObject* SbkQRectFFunc_translated(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "translated", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(pyargs[0]);
        qreal cpp_arg1 = Shiboken::Converter<qreal >::toCpp(pyargs[1]);
        // translated(qreal,qreal)const
        QRectF* cppSelf = Shiboken::Converter<QRectF* >::toCpp((PyObject*)self);
        QRectF cpp_result = cppSelf->QRectF::translated(cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<QRectF >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QPointF & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QPointF > cpp_arg0_auto_ptr;
        QPointF* cpp_arg0 = Shiboken::Converter<QPointF* >::toCpp(pyargs[0]);
        if (!SbkQPointF_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QPointF >(cpp_arg0);
        // translated(QPointF)const
        QRectF* cppSelf = Shiboken::Converter<QRectF* >::toCpp((PyObject*)self);
        QRectF cpp_result = cppSelf->QRectF::translated(*cpp_arg0);
        py_result = Shiboken::Converter<QRectF >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQRectFFunc_translated_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQRectFFunc_translated_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPointF", "float, float", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QRectF.translated", overloads);
        return 0;
}

static PyObject* SbkQRectFFunc_unite(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QRectF & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QRectF > cpp_arg0_auto_ptr;
        QRectF* cpp_arg0 = Shiboken::Converter<QRectF* >::toCpp(arg);
        if (!SbkQRectF_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QRectF >(cpp_arg0);
        // unite(QRectF)const
        QRectF* cppSelf = Shiboken::Converter<QRectF* >::toCpp((PyObject*)self);
        QRectF cpp_result = cppSelf->QRectF::unite(*cpp_arg0);
        py_result = Shiboken::Converter<QRectF >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQRectFFunc_unite_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQRectFFunc_unite_TypeError:
        const char* overloads[] = {"PySide.QtCore.QRectF", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QRectF.unite", overloads);
        return 0;
}

static PyObject* SbkQRectFFunc_united(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QRectF & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QRectF > cpp_arg0_auto_ptr;
        QRectF* cpp_arg0 = Shiboken::Converter<QRectF* >::toCpp(arg);
        if (!SbkQRectF_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QRectF >(cpp_arg0);
        // united(QRectF)const
        QRectF* cppSelf = Shiboken::Converter<QRectF* >::toCpp((PyObject*)self);
        QRectF cpp_result = cppSelf->QRectF::united(*cpp_arg0);
        py_result = Shiboken::Converter<QRectF >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQRectFFunc_united_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQRectFFunc_united_TypeError:
        const char* overloads[] = {"PySide.QtCore.QRectF", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QRectF.united", overloads);
        return 0;
}

static PyObject* SbkQRectFFunc_width(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // width()const
    QRectF* cppSelf = Shiboken::Converter<QRectF* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QRectF::width();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQRectFFunc_x(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // x()const
    QRectF* cppSelf = Shiboken::Converter<QRectF* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QRectF::x();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQRectFFunc_y(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // y()const
    QRectF* cppSelf = Shiboken::Converter<QRectF* >::toCpp((PyObject*)self);
    qreal cpp_result = cppSelf->QRectF::y();
    py_result = Shiboken::Converter<double >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQRectF_methods[] = {
    {"adjust", (PyCFunction)SbkQRectFFunc_adjust, METH_VARARGS},
    {"adjusted", (PyCFunction)SbkQRectFFunc_adjusted, METH_VARARGS},
    {"bottom", (PyCFunction)SbkQRectFFunc_bottom, METH_NOARGS},
    {"bottomLeft", (PyCFunction)SbkQRectFFunc_bottomLeft, METH_NOARGS},
    {"bottomRight", (PyCFunction)SbkQRectFFunc_bottomRight, METH_NOARGS},
    {"center", (PyCFunction)SbkQRectFFunc_center, METH_NOARGS},
    {"contains", (PyCFunction)SbkQRectFFunc_contains, METH_VARARGS},
    {"height", (PyCFunction)SbkQRectFFunc_height, METH_NOARGS},
    {"intersect", (PyCFunction)SbkQRectFFunc_intersect, METH_O},
    {"intersected", (PyCFunction)SbkQRectFFunc_intersected, METH_O},
    {"intersects", (PyCFunction)SbkQRectFFunc_intersects, METH_O},
    {"isEmpty", (PyCFunction)SbkQRectFFunc_isEmpty, METH_NOARGS},
    {"isNull", (PyCFunction)SbkQRectFFunc_isNull, METH_NOARGS},
    {"isValid", (PyCFunction)SbkQRectFFunc_isValid, METH_NOARGS},
    {"left", (PyCFunction)SbkQRectFFunc_left, METH_NOARGS},
    {"moveBottom", (PyCFunction)SbkQRectFFunc_moveBottom, METH_O},
    {"moveBottomLeft", (PyCFunction)SbkQRectFFunc_moveBottomLeft, METH_O},
    {"moveBottomRight", (PyCFunction)SbkQRectFFunc_moveBottomRight, METH_O},
    {"moveCenter", (PyCFunction)SbkQRectFFunc_moveCenter, METH_O},
    {"moveLeft", (PyCFunction)SbkQRectFFunc_moveLeft, METH_O},
    {"moveRight", (PyCFunction)SbkQRectFFunc_moveRight, METH_O},
    {"moveTo", (PyCFunction)SbkQRectFFunc_moveTo, METH_VARARGS},
    {"moveTop", (PyCFunction)SbkQRectFFunc_moveTop, METH_O},
    {"moveTopLeft", (PyCFunction)SbkQRectFFunc_moveTopLeft, METH_O},
    {"moveTopRight", (PyCFunction)SbkQRectFFunc_moveTopRight, METH_O},
    {"normalized", (PyCFunction)SbkQRectFFunc_normalized, METH_NOARGS},
    {"right", (PyCFunction)SbkQRectFFunc_right, METH_NOARGS},
    {"setBottom", (PyCFunction)SbkQRectFFunc_setBottom, METH_O},
    {"setBottomLeft", (PyCFunction)SbkQRectFFunc_setBottomLeft, METH_O},
    {"setBottomRight", (PyCFunction)SbkQRectFFunc_setBottomRight, METH_O},
    {"setCoords", (PyCFunction)SbkQRectFFunc_setCoords, METH_VARARGS},
    {"setHeight", (PyCFunction)SbkQRectFFunc_setHeight, METH_O},
    {"setLeft", (PyCFunction)SbkQRectFFunc_setLeft, METH_O},
    {"setRect", (PyCFunction)SbkQRectFFunc_setRect, METH_VARARGS},
    {"setRight", (PyCFunction)SbkQRectFFunc_setRight, METH_O},
    {"setSize", (PyCFunction)SbkQRectFFunc_setSize, METH_O},
    {"setTop", (PyCFunction)SbkQRectFFunc_setTop, METH_O},
    {"setTopLeft", (PyCFunction)SbkQRectFFunc_setTopLeft, METH_O},
    {"setTopRight", (PyCFunction)SbkQRectFFunc_setTopRight, METH_O},
    {"setWidth", (PyCFunction)SbkQRectFFunc_setWidth, METH_O},
    {"setX", (PyCFunction)SbkQRectFFunc_setX, METH_O},
    {"setY", (PyCFunction)SbkQRectFFunc_setY, METH_O},
    {"size", (PyCFunction)SbkQRectFFunc_size, METH_NOARGS},
    {"toAlignedRect", (PyCFunction)SbkQRectFFunc_toAlignedRect, METH_NOARGS},
    {"toRect", (PyCFunction)SbkQRectFFunc_toRect, METH_NOARGS},
    {"top", (PyCFunction)SbkQRectFFunc_top, METH_NOARGS},
    {"topLeft", (PyCFunction)SbkQRectFFunc_topLeft, METH_NOARGS},
    {"topRight", (PyCFunction)SbkQRectFFunc_topRight, METH_NOARGS},
    {"translate", (PyCFunction)SbkQRectFFunc_translate, METH_VARARGS},
    {"translated", (PyCFunction)SbkQRectFFunc_translated, METH_VARARGS},
    {"unite", (PyCFunction)SbkQRectFFunc_unite, METH_O},
    {"united", (PyCFunction)SbkQRectFFunc_united, METH_O},
    {"width", (PyCFunction)SbkQRectFFunc_width, METH_NOARGS},
    {"x", (PyCFunction)SbkQRectFFunc_x, METH_NOARGS},
    {"y", (PyCFunction)SbkQRectFFunc_y, METH_NOARGS},
    {0} // Sentinel
};

static PyObject* SbkQRectFFunc___and__(PyObject* self, PyObject* arg)
{
    bool isReverse = SbkQRectF_Check(arg) && !SbkQRectF_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse
        && SbkBaseWrapper_Check(arg)
        && !PyObject_TypeCheck(arg, self->ob_type)
        && PyObject_HasAttrString(arg, const_cast<char*>("__rand__"))) {
        PyObject* revOpMethod = PyObject_GetAttrString(arg, const_cast<char*>("__rand__"));
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            py_result = PyObject_CallFunction(revOpMethod, const_cast<char*>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(py_result);
                py_result = 0;
            }
        }
        Py_XDECREF(revOpMethod);

    }
    // Do not enter here if other object has implemented a reverse operator.
    if (!py_result) {

    if (!isReverse && Shiboken::Converter<QRectF & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QRectF > cpp_arg0_auto_ptr;
        QRectF* cpp_arg0 = Shiboken::Converter<QRectF* >::toCpp(arg);
        if (!SbkQRectF_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QRectF >(cpp_arg0);
        // operator&(QRectF)const
        QRectF* cppSelf = Shiboken::Converter<QRectF* >::toCpp((PyObject*)self);
        QRectF cpp_result = (*cppSelf) & (*cpp_arg0);
        py_result = Shiboken::Converter<QRectF >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQRectFFunc___and___TypeError;

    } // End of "if (!py_result)"


    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQRectFFunc___and___TypeError:
        const char* overloads[] = {"PySide.QtCore.QRectF", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QRectF.__and__", overloads);
        return 0;
}

static PyObject* SbkQRectFFunc___iand__(PyObject* self, PyObject* arg)
{
    bool isReverse = SbkQRectF_Check(arg) && !SbkQRectF_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (!isReverse && Shiboken::Converter<QRectF & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QRectF > cpp_arg0_auto_ptr;
        QRectF* cpp_arg0 = Shiboken::Converter<QRectF* >::toCpp(arg);
        if (!SbkQRectF_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QRectF >(cpp_arg0);
        // operator&=(QRectF)
        QRectF* cppSelf = Shiboken::Converter<QRectF* >::toCpp((PyObject*)self);
        (*cppSelf) &= (*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQRectFFunc___iand___TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_INCREF(self);
    return self;

    SbkQRectFFunc___iand___TypeError:
        const char* overloads[] = {"PySide.QtCore.QRectF", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QRectF.__iand__", overloads);
        return 0;
}

static PyObject* SbkQRectFFunc___or__(PyObject* self, PyObject* arg)
{
    bool isReverse = SbkQRectF_Check(arg) && !SbkQRectF_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse
        && SbkBaseWrapper_Check(arg)
        && !PyObject_TypeCheck(arg, self->ob_type)
        && PyObject_HasAttrString(arg, const_cast<char*>("__ror__"))) {
        PyObject* revOpMethod = PyObject_GetAttrString(arg, const_cast<char*>("__ror__"));
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            py_result = PyObject_CallFunction(revOpMethod, const_cast<char*>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(py_result);
                py_result = 0;
            }
        }
        Py_XDECREF(revOpMethod);

    }
    // Do not enter here if other object has implemented a reverse operator.
    if (!py_result) {

    if (!isReverse && Shiboken::Converter<QRectF & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QRectF > cpp_arg0_auto_ptr;
        QRectF* cpp_arg0 = Shiboken::Converter<QRectF* >::toCpp(arg);
        if (!SbkQRectF_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QRectF >(cpp_arg0);
        // operator|(QRectF)const
        QRectF* cppSelf = Shiboken::Converter<QRectF* >::toCpp((PyObject*)self);
        QRectF cpp_result = (*cppSelf) | (*cpp_arg0);
        py_result = Shiboken::Converter<QRectF >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQRectFFunc___or___TypeError;

    } // End of "if (!py_result)"


    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQRectFFunc___or___TypeError:
        const char* overloads[] = {"PySide.QtCore.QRectF", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QRectF.__or__", overloads);
        return 0;
}

static PyObject* SbkQRectFFunc___ior__(PyObject* self, PyObject* arg)
{
    bool isReverse = SbkQRectF_Check(arg) && !SbkQRectF_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (!isReverse && Shiboken::Converter<QRectF & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QRectF > cpp_arg0_auto_ptr;
        QRectF* cpp_arg0 = Shiboken::Converter<QRectF* >::toCpp(arg);
        if (!SbkQRectF_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QRectF >(cpp_arg0);
        // operator|=(QRectF)
        QRectF* cppSelf = Shiboken::Converter<QRectF* >::toCpp((PyObject*)self);
        (*cppSelf) |= (*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQRectFFunc___ior___TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_INCREF(self);
    return self;

    SbkQRectFFunc___ior___TypeError:
        const char* overloads[] = {"PySide.QtCore.QRectF", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QRectF.__ior__", overloads);
        return 0;
}

// type has number operators
static PyNumberMethods SbkQRectF_as_number = {
    /*nb_add*/                  (binaryfunc)0,
    /*nb_subtract*/             (binaryfunc)0,
    /*nb_multiply*/             (binaryfunc)0,
    /*nb_divide*/               (binaryfunc)0,
    /*nb_remainder*/            (binaryfunc)0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             (unaryfunc)0,
    /*nb_positive*/             (unaryfunc)0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)0,
    /*nb_lshift*/               (binaryfunc)0,
    /*nb_rshift*/               (binaryfunc)0,
    /*nb_and*/                  (binaryfunc)SbkQRectFFunc___and__,
    /*nb_xor*/                  (binaryfunc)0,
    /*nb_or*/                   (binaryfunc)SbkQRectFFunc___or__,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          (binaryfunc)0,
    /*nb_inplace_subtract*/     (binaryfunc)0,
    /*nb_inplace_multiply*/     (binaryfunc)0,
    /*nb_inplace_divide*/       (binaryfunc)0,
    /*nb_inplace_remainder*/    (binaryfunc)0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       (binaryfunc)0,
    /*nb_inplace_rshift*/       (binaryfunc)0,
    /*nb_inplace_and*/          (binaryfunc)SbkQRectFFunc___iand__,
    /*nb_inplace_xor*/          (binaryfunc)0,
    /*nb_inplace_or*/           (binaryfunc)SbkQRectFFunc___ior__,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};

// Rich comparison
static PyObject* SbkQRectF_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result = false;
    QRectF& cpp_self = *Shiboken::Converter<QRectF* >::toCpp((PyObject*)self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<QRectF & >::isConvertible(other)) {
                // operator!=(const QRectF & arg__2)
                QRectF* cpp_other = Shiboken::Converter<QRectF* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QRectF  >::toCpp(other) : (cpp_self != (*cpp_other));
            } else if (Shiboken::Converter<QRectF >::isConvertible(other)) {
                if (Shiboken::cppObjectIsInvalid(other))
                    return 0;
                std::auto_ptr<QRectF > cpp_other_auto_ptr;
                QRectF* cpp_other = Shiboken::Converter<QRectF* >::toCpp(other);
                if (!SbkQRectF_Check(other))
                    cpp_other_auto_ptr = std::auto_ptr<QRectF >(cpp_other);
                result = (cpp_self != (*cpp_other));
            } else goto SbkQRectF_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<QRectF & >::isConvertible(other)) {
                // operator==(const QRectF & arg__2)
                QRectF* cpp_other = Shiboken::Converter<QRectF* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QRectF  >::toCpp(other) : (cpp_self == (*cpp_other));
            } else if (Shiboken::Converter<QRectF >::isConvertible(other)) {
                if (Shiboken::cppObjectIsInvalid(other))
                    return 0;
                std::auto_ptr<QRectF > cpp_other_auto_ptr;
                QRectF* cpp_other = Shiboken::Converter<QRectF* >::toCpp(other);
                if (!SbkQRectF_Check(other))
                    cpp_other_auto_ptr = std::auto_ptr<QRectF >(cpp_other);
                result = (cpp_self == (*cpp_other));
            } else goto SbkQRectF_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    SbkQRectF_RichComparison_TypeError:
    Py_RETURN_FALSE;

}

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQRectF_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtCore.QRectF",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        &SbkQRectF_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQRectF_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQRectF_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQRectF_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QRectF >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_QRectF(PyObject* module)
{
    SbkPySide_QtCoreTypes[SBK_QRECTF_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQRectF_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQRectF_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQRectF_Type));
    PyModule_AddObject(module, "QRectF",
        ((PyObject*)&SbkQRectF_Type));

    Shiboken::TypeResolver::createValueTypeResolver<QRectF >("QRectF");
    Shiboken::TypeResolver::createValueTypeResolver<QRectF >(typeid(QRectF).name());
}


} // extern "C"

