/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtcore_python.h"

#include "qprocessenvironment_wrapper.h"

// Extra includes
#include <qprocess.h>
#include <qstring.h>
#include <qstringlist.h>

using namespace Shiboken;

static int
SbkQProcessEnvironment_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QProcessEnvironment* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QProcessEnvironment", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QProcessEnvironment()
        cptr = new QProcessEnvironment();
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QProcessEnvironment & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QProcessEnvironment* cpp_arg0 = Shiboken::Converter<QProcessEnvironment* >::toCpp(pyargs[0]);
        // QProcessEnvironment(QProcessEnvironment)
        cptr = new QProcessEnvironment(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQProcessEnvironment_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QProcessEnvironment >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQProcessEnvironment_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQProcessEnvironment_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtCore.QProcessEnvironment", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QProcessEnvironment", overloads);
        return -1;
}

static PyObject* SbkQProcessEnvironmentFunc_clear(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // clear()
    QProcessEnvironment* cppSelf = Shiboken::Converter<QProcessEnvironment* >::toCpp((PyObject*)self);
    cppSelf->QProcessEnvironment::clear();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQProcessEnvironmentFunc_contains(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // contains(QString)const
        QProcessEnvironment* cppSelf = Shiboken::Converter<QProcessEnvironment* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QProcessEnvironment::contains(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQProcessEnvironmentFunc_contains_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQProcessEnvironmentFunc_contains_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QProcessEnvironment.contains", overloads);
        return 0;
}

static PyObject* SbkQProcessEnvironmentFunc_insert(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "insert", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QString & >::isConvertible(pyargs[0]) && Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!SbkQString_Check(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        // insert(QString,QString)
        QProcessEnvironment* cppSelf = Shiboken::Converter<QProcessEnvironment* >::toCpp((PyObject*)self);
        cppSelf->QProcessEnvironment::insert(*cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQProcessEnvironmentFunc_insert_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQProcessEnvironmentFunc_insert_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QProcessEnvironment.insert", overloads);
        return 0;
}

static PyObject* SbkQProcessEnvironmentFunc_isEmpty(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isEmpty()const
    QProcessEnvironment* cppSelf = Shiboken::Converter<QProcessEnvironment* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QProcessEnvironment::isEmpty();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQProcessEnvironmentFunc_remove(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!SbkQString_Check(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // remove(QString)
        QProcessEnvironment* cppSelf = Shiboken::Converter<QProcessEnvironment* >::toCpp((PyObject*)self);
        cppSelf->QProcessEnvironment::remove(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQProcessEnvironmentFunc_remove_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQProcessEnvironmentFunc_remove_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QProcessEnvironment.remove", overloads);
        return 0;
}

static PyObject* SbkQProcessEnvironmentFunc_systemEnvironment(PyObject* self)
{
    PyObject* py_result = 0;

    // systemEnvironment()
    QProcessEnvironment cpp_result = QProcessEnvironment::systemEnvironment();
    py_result = Shiboken::Converter<QProcessEnvironment >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQProcessEnvironmentFunc_toStringList(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toStringList()const
    QProcessEnvironment* cppSelf = Shiboken::Converter<QProcessEnvironment* >::toCpp((PyObject*)self);
    QStringList cpp_result = cppSelf->QProcessEnvironment::toStringList();
    py_result = Shiboken::Converter<QStringList >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQProcessEnvironmentFunc_value(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "value", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QString & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!SbkQString_Check(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        if (numArgs == 1) {
            // value(QString,QString)const
            QProcessEnvironment* cppSelf = Shiboken::Converter<QProcessEnvironment* >::toCpp((PyObject*)self);
            QString cpp_result = cppSelf->QProcessEnvironment::value(*cpp_arg0);
            py_result = Shiboken::Converter<QString >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else if (Shiboken::Converter<QString & >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            std::auto_ptr<QString > cpp_arg1_auto_ptr;
            QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
            if (!SbkQString_Check(pyargs[1]))
                cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
            // value(QString,QString)const
            QProcessEnvironment* cppSelf = Shiboken::Converter<QProcessEnvironment* >::toCpp((PyObject*)self);
            QString cpp_result = cppSelf->QProcessEnvironment::value(*cpp_arg0, *cpp_arg1);
            py_result = Shiboken::Converter<QString >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQProcessEnvironmentFunc_value_TypeError;
    } else goto SbkQProcessEnvironmentFunc_value_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQProcessEnvironmentFunc_value_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, PySide.QtCore.QString = QString()", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QProcessEnvironment.value", overloads);
        return 0;
}

static PyMethodDef SbkQProcessEnvironment_methods[] = {
    {"clear", (PyCFunction)SbkQProcessEnvironmentFunc_clear, METH_NOARGS},
    {"contains", (PyCFunction)SbkQProcessEnvironmentFunc_contains, METH_O},
    {"insert", (PyCFunction)SbkQProcessEnvironmentFunc_insert, METH_VARARGS},
    {"isEmpty", (PyCFunction)SbkQProcessEnvironmentFunc_isEmpty, METH_NOARGS},
    {"remove", (PyCFunction)SbkQProcessEnvironmentFunc_remove, METH_O},
    {"systemEnvironment", (PyCFunction)SbkQProcessEnvironmentFunc_systemEnvironment, METH_NOARGS|METH_STATIC},
    {"toStringList", (PyCFunction)SbkQProcessEnvironmentFunc_toStringList, METH_NOARGS},
    {"value", (PyCFunction)SbkQProcessEnvironmentFunc_value, METH_VARARGS},
    {0} // Sentinel
};

// Rich comparison
static PyObject* SbkQProcessEnvironment_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result = false;
    QProcessEnvironment& cpp_self = *Shiboken::Converter<QProcessEnvironment* >::toCpp((PyObject*)self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<QProcessEnvironment & >::isConvertible(other)) {
                // operator!=(const QProcessEnvironment & other) const
                QProcessEnvironment* cpp_other = Shiboken::Converter<QProcessEnvironment* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QProcessEnvironment  >::toCpp(other) : (cpp_self != (*cpp_other));
            } else goto SbkQProcessEnvironment_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<QProcessEnvironment & >::isConvertible(other)) {
                // operator==(const QProcessEnvironment & other) const
                QProcessEnvironment* cpp_other = Shiboken::Converter<QProcessEnvironment* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QProcessEnvironment  >::toCpp(other) : (cpp_self == (*cpp_other));
            } else goto SbkQProcessEnvironment_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    SbkQProcessEnvironment_RichComparison_TypeError:
    Py_RETURN_FALSE;

}

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQProcessEnvironment_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtCore.QProcessEnvironment",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQProcessEnvironment_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQProcessEnvironment_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQProcessEnvironment_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QProcessEnvironment >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_QProcessEnvironment(PyObject* module)
{
    SbkPySide_QtCoreTypes[SBK_QPROCESSENVIRONMENT_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQProcessEnvironment_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQProcessEnvironment_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQProcessEnvironment_Type));
    PyModule_AddObject(module, "QProcessEnvironment",
        ((PyObject*)&SbkQProcessEnvironment_Type));

    Shiboken::TypeResolver::createValueTypeResolver<QProcessEnvironment >("QProcessEnvironment");
    Shiboken::TypeResolver::createValueTypeResolver<QProcessEnvironment >(typeid(QProcessEnvironment).name());
}


} // extern "C"

