/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtcore_python.h"

#include "qline_wrapper.h"

// Extra includes
#include <qline.h>
#include <qpoint.h>

using namespace Shiboken;

static int
SbkQLine_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QLine* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 3)
        goto SbkQLine_Init_TypeError;

    if (!PyArg_UnpackTuple(args, "QLine", 0, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return -1;

    if (numArgs == 0) {
        // QLine()
        cptr = new QLine();
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 4 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2]) && PyNumber_Check(pyargs[3])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        int cpp_arg3 = Shiboken::Converter<int >::toCpp(pyargs[3]);
        // QLine(int,int,int,int)
        cptr = new QLine(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 2 && Shiboken::Converter<QPoint & >::isConvertible(pyargs[0]) && Shiboken::Converter<QPoint & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return -1;
        QPoint* cpp_arg1 = Shiboken::Converter<QPoint* >::toCpp(pyargs[1]);
        // QLine(QPoint,QPoint)
        cptr = new QLine(*cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QLine & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QLine* cpp_arg0 = Shiboken::Converter<QLine* >::toCpp(pyargs[0]);
        // QLine(QLine)
        cptr = new QLine(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQLine_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QLine >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQLine_Init_TypeError;

    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQLine_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QLine", "", "PySide.QtCore.QPoint, PySide.QtCore.QPoint", "int, int, int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QLine", overloads);
        return -1;
}

static PyObject* SbkQLineFunc_dx(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // dx()const
    QLine* cppSelf = Shiboken::Converter<QLine* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QLine::dx();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQLineFunc_dy(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // dy()const
    QLine* cppSelf = Shiboken::Converter<QLine* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QLine::dy();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQLineFunc_isNull(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isNull()const
    QLine* cppSelf = Shiboken::Converter<QLine* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QLine::isNull();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQLineFunc_p1(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // p1()const
    QLine* cppSelf = Shiboken::Converter<QLine* >::toCpp((PyObject*)self);
    QPoint cpp_result = cppSelf->QLine::p1();
    py_result = Shiboken::Converter<QPoint >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQLineFunc_p2(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // p2()const
    QLine* cppSelf = Shiboken::Converter<QLine* >::toCpp((PyObject*)self);
    QPoint cpp_result = cppSelf->QLine::p2();
    py_result = Shiboken::Converter<QPoint >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQLineFunc_setLine(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "setLine", 4, 4, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3])))
        return 0;

    if (numArgs == 4 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1]) && PyNumber_Check(pyargs[2]) && PyNumber_Check(pyargs[3])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
        int cpp_arg3 = Shiboken::Converter<int >::toCpp(pyargs[3]);
        // setLine(int,int,int,int)
        QLine* cppSelf = Shiboken::Converter<QLine* >::toCpp((PyObject*)self);
        cppSelf->QLine::setLine(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQLineFunc_setLine_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQLineFunc_setLine_TypeError:
        const char* overloads[] = {"int, int, int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QLine.setLine", overloads);
        return 0;
}

static PyObject* SbkQLineFunc_setP1(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPoint & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(arg);
        // setP1(QPoint)
        QLine* cppSelf = Shiboken::Converter<QLine* >::toCpp((PyObject*)self);
        cppSelf->QLine::setP1(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQLineFunc_setP1_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQLineFunc_setP1_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPoint", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QLine.setP1", overloads);
        return 0;
}

static PyObject* SbkQLineFunc_setP2(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QPoint & >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(arg);
        // setP2(QPoint)
        QLine* cppSelf = Shiboken::Converter<QLine* >::toCpp((PyObject*)self);
        cppSelf->QLine::setP2(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQLineFunc_setP2_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQLineFunc_setP2_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPoint", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QLine.setP2", overloads);
        return 0;
}

static PyObject* SbkQLineFunc_setPoints(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setPoints", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QPoint & >::isConvertible(pyargs[0]) && Shiboken::Converter<QPoint & >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QPoint* cpp_arg1 = Shiboken::Converter<QPoint* >::toCpp(pyargs[1]);
        // setPoints(QPoint,QPoint)
        QLine* cppSelf = Shiboken::Converter<QLine* >::toCpp((PyObject*)self);
        cppSelf->QLine::setPoints(*cpp_arg0, *cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQLineFunc_setPoints_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQLineFunc_setPoints_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPoint, PySide.QtCore.QPoint", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QLine.setPoints", overloads);
        return 0;
}

static PyObject* SbkQLineFunc_translate(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "translate", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // translate(int,int)
        QLine* cppSelf = Shiboken::Converter<QLine* >::toCpp((PyObject*)self);
        cppSelf->QLine::translate(cpp_arg0, cpp_arg1);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QPoint & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(pyargs[0]);
        // translate(QPoint)
        QLine* cppSelf = Shiboken::Converter<QLine* >::toCpp((PyObject*)self);
        cppSelf->QLine::translate(*cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQLineFunc_translate_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQLineFunc_translate_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPoint", "int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QLine.translate", overloads);
        return 0;
}

static PyObject* SbkQLineFunc_translated(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "translated", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // translated(int,int)const
        QLine* cppSelf = Shiboken::Converter<QLine* >::toCpp((PyObject*)self);
        QLine cpp_result = cppSelf->QLine::translated(cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<QLine >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (numArgs == 1 && Shiboken::Converter<QPoint & >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(pyargs[0]);
        // translated(QPoint)const
        QLine* cppSelf = Shiboken::Converter<QLine* >::toCpp((PyObject*)self);
        QLine cpp_result = cppSelf->QLine::translated(*cpp_arg0);
        py_result = Shiboken::Converter<QLine >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQLineFunc_translated_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQLineFunc_translated_TypeError:
        const char* overloads[] = {"PySide.QtCore.QPoint", "int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QLine.translated", overloads);
        return 0;
}

static PyObject* SbkQLineFunc_x1(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // x1()const
    QLine* cppSelf = Shiboken::Converter<QLine* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QLine::x1();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQLineFunc_x2(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // x2()const
    QLine* cppSelf = Shiboken::Converter<QLine* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QLine::x2();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQLineFunc_y1(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // y1()const
    QLine* cppSelf = Shiboken::Converter<QLine* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QLine::y1();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQLineFunc_y2(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // y2()const
    QLine* cppSelf = Shiboken::Converter<QLine* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QLine::y2();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyMethodDef SbkQLine_methods[] = {
    {"dx", (PyCFunction)SbkQLineFunc_dx, METH_NOARGS},
    {"dy", (PyCFunction)SbkQLineFunc_dy, METH_NOARGS},
    {"isNull", (PyCFunction)SbkQLineFunc_isNull, METH_NOARGS},
    {"p1", (PyCFunction)SbkQLineFunc_p1, METH_NOARGS},
    {"p2", (PyCFunction)SbkQLineFunc_p2, METH_NOARGS},
    {"setLine", (PyCFunction)SbkQLineFunc_setLine, METH_VARARGS},
    {"setP1", (PyCFunction)SbkQLineFunc_setP1, METH_O},
    {"setP2", (PyCFunction)SbkQLineFunc_setP2, METH_O},
    {"setPoints", (PyCFunction)SbkQLineFunc_setPoints, METH_VARARGS},
    {"translate", (PyCFunction)SbkQLineFunc_translate, METH_VARARGS},
    {"translated", (PyCFunction)SbkQLineFunc_translated, METH_VARARGS},
    {"x1", (PyCFunction)SbkQLineFunc_x1, METH_NOARGS},
    {"x2", (PyCFunction)SbkQLineFunc_x2, METH_NOARGS},
    {"y1", (PyCFunction)SbkQLineFunc_y1, METH_NOARGS},
    {"y2", (PyCFunction)SbkQLineFunc_y2, METH_NOARGS},
    {0} // Sentinel
};

// Rich comparison
static PyObject* SbkQLine_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result = false;
    QLine& cpp_self = *Shiboken::Converter<QLine* >::toCpp((PyObject*)self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<QLine & >::isConvertible(other)) {
                // operator!=(const QLine & d) const
                QLine* cpp_other = Shiboken::Converter<QLine* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QLine  >::toCpp(other) : (cpp_self != (*cpp_other));
            } else goto SbkQLine_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<QLine & >::isConvertible(other)) {
                // operator==(const QLine & d) const
                QLine* cpp_other = Shiboken::Converter<QLine* >::toCpp((PyObject*)other);
                result = !cpp_other ? cpp_self == Shiboken::Converter<QLine  >::toCpp(other) : (cpp_self == (*cpp_other));
            } else goto SbkQLine_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    SbkQLine_RichComparison_TypeError:
    Py_RETURN_FALSE;

}

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQLine_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtCore.QLine",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQLine_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQLine_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQLine_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QLine >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_QLine(PyObject* module)
{
    SbkPySide_QtCoreTypes[SBK_QLINE_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQLine_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQLine_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQLine_Type));
    PyModule_AddObject(module, "QLine",
        ((PyObject*)&SbkQLine_Type));

    Shiboken::TypeResolver::createValueTypeResolver<QLine >("QLine");
    Shiboken::TypeResolver::createValueTypeResolver<QLine >(typeid(QLine).name());
}


} // extern "C"

