/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include "pyside_qtcore_python.h"

#include "qabstracteventdispatcher_wrapper.h"

// Extra includes
#include <QList>
#include <QPair>
#include <qabstracteventdispatcher.h>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qsocketnotifier.h>
#include <qstring.h>
#include <qthread.h>
#include <qvariant.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QAbstractEventDispatcherWrapper::QAbstractEventDispatcherWrapper(QObject * parent) : QAbstractEventDispatcher(parent), m_metaObject(0) {
    // ... middle
}

void QAbstractEventDispatcherWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QChildEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QAbstractEventDispatcherWrapper::closingDown()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "closingDown"));
    if (py_override.isNull()) {
        return this->QAbstractEventDispatcher::closingDown();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractEventDispatcherWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractEventDispatcherWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QAbstractEventDispatcherWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QAbstractEventDispatcherWrapper::event(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QObject::event(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QAbstractEventDispatcher.event", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
    return cpp_result;
}

bool QAbstractEventDispatcherWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(SS)",
        Shiboken::Converter<QObject * >::toPython(arg__1),
        Shiboken::Converter<QEvent * >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QAbstractEventDispatcher.eventFilter", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 1));
    return cpp_result;
}

void QAbstractEventDispatcherWrapper::flush()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "flush"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractEventDispatcher.flush()' not implemented.");
        return ;
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QAbstractEventDispatcherWrapper::hasPendingEvents()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "hasPendingEvents"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractEventDispatcher.hasPendingEvents()' not implemented.");
        return bool(0);
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QAbstractEventDispatcher.hasPendingEvents", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QAbstractEventDispatcherWrapper::interrupt()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "interrupt"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractEventDispatcher.interrupt()' not implemented.");
        return ;
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QAbstractEventDispatcherWrapper::processEvents(QFlags<QEventLoop::ProcessEventsFlag> flags)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "processEvents"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractEventDispatcher.processEvents()' not implemented.");
        return bool(0);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QFlags<QEventLoop::ProcessEventsFlag> >::toPython(flags)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QAbstractEventDispatcher.processEvents", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QAbstractEventDispatcherWrapper::registerSocketNotifier(QSocketNotifier * notifier)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "registerSocketNotifier"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractEventDispatcher.registerSocketNotifier()' not implemented.");
        return ;
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QSocketNotifier * >::toPython(notifier)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractEventDispatcherWrapper::registerTimer(int timerId, int interval, QObject * object)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "registerTimer"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractEventDispatcher.registerTimer()' not implemented.");
        return ;
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(iiS)",
        timerId,
        interval,
        Shiboken::Converter<QObject * >::toPython(object)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

QList<QPair<int, int > > QAbstractEventDispatcherWrapper::registeredTimers(QObject * object) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "registeredTimers"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractEventDispatcher.registeredTimers()' not implemented.");
        return QList<QPair<int, int > >();
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QObject * >::toPython(object)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QList<QPair<int, int > >();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QList<QPair<int, int > > >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QAbstractEventDispatcher.registeredTimers", "list", py_result->ob_type->tp_name);
        return QList<QPair<int, int > >();
    }
    QList<QPair<int, int > > cpp_result(Shiboken::Converter<QList<QPair<int, int > > >::toCpp(py_result));
    return cpp_result;
}

void QAbstractEventDispatcherWrapper::startingUp()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "startingUp"));
    if (py_override.isNull()) {
        return this->QAbstractEventDispatcher::startingUp();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QAbstractEventDispatcherWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QTimerEvent * >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QAbstractEventDispatcherWrapper::unregisterSocketNotifier(QSocketNotifier * notifier)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "unregisterSocketNotifier"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractEventDispatcher.unregisterSocketNotifier()' not implemented.");
        return ;
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QSocketNotifier * >::toPython(notifier)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QAbstractEventDispatcherWrapper::unregisterTimer(int timerId)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "unregisterTimer"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractEventDispatcher.unregisterTimer()' not implemented.");
        return bool(0);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(i)",
        timerId
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QAbstractEventDispatcher.unregisterTimer", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QAbstractEventDispatcherWrapper::unregisterTimers(QObject * object)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "unregisterTimers"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractEventDispatcher.unregisterTimers()' not implemented.");
        return bool(0);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(S)",
        Shiboken::Converter<QObject * >::toPython(object)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.", "QAbstractEventDispatcher.unregisterTimers", SbkType<bool >()->tp_name, py_result->ob_type->tp_name);
        return bool(0);
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QAbstractEventDispatcherWrapper::wakeUp()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "wakeUp"));
    if (py_override.isNull()) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractEventDispatcher.wakeUp()' not implemented.");
        return ;
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

const QMetaObject* QAbstractEventDispatcherWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QAbstractEventDispatcher::staticMetaObject);
}
    return m_metaObject;
}

int QAbstractEventDispatcherWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QAbstractEventDispatcher::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QAbstractEventDispatcherWrapper::~QAbstractEventDispatcherWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQAbstractEventDispatcher_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QAbstractEventDispatcherWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    SbkBaseWrapperType* type = reinterpret_cast<SbkBaseWrapperType*>(self->ob_type);
    SbkBaseWrapperType* myType = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QABSTRACTEVENTDISPATCHER_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'QAbstractEventDispatcher' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QAbstractEventDispatcher", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QAbstractEventDispatcher(QObject*)
        cptr = new QAbstractEventDispatcherWrapper();
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else if (Shiboken::Converter<QObject * >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(pyargs[0]);
        // QAbstractEventDispatcher(QObject*)
        cptr = new QAbstractEventDispatcherWrapper(cpp_arg0);
        //CppGenerator::writeParentChildManagement
        Shiboken::setParent(pyargs[0], self);
    } else goto SbkQAbstractEventDispatcher_Init_TypeError;

    if (PyErr_Occurred() || !Shiboken::setCppPointer(sbkSelf, Shiboken::SbkType<QAbstractEventDispatcher >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQAbstractEventDispatcher_Init_TypeError;

    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf, cptr);

    return 1;

    SbkQAbstractEventDispatcher_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QAbstractEventDispatcher", overloads);
        return -1;
}

static PyObject* SbkQAbstractEventDispatcherFunc_closingDown(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // closingDown()
    QAbstractEventDispatcher* cppSelf = Shiboken::Converter<QAbstractEventDispatcher* >::toCpp((PyObject*)self);
    cppSelf->QAbstractEventDispatcher::closingDown();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQAbstractEventDispatcherFunc_flush(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // flush()
    if (SbkBaseWrapper_containsCppWrapper(self)) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractEventDispatcher.flush()' not implemented.");
        return 0;
    }
    QAbstractEventDispatcher* cppSelf = Shiboken::Converter<QAbstractEventDispatcher* >::toCpp((PyObject*)self);
    cppSelf->flush();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQAbstractEventDispatcherFunc_hasPendingEvents(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // hasPendingEvents()
    if (SbkBaseWrapper_containsCppWrapper(self)) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractEventDispatcher.hasPendingEvents()' not implemented.");
        return 0;
    }
    QAbstractEventDispatcher* cppSelf = Shiboken::Converter<QAbstractEventDispatcher* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->hasPendingEvents();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;
}

static PyObject* SbkQAbstractEventDispatcherFunc_instance(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // instance(QThread*)
        QAbstractEventDispatcher * cpp_result = QAbstractEventDispatcher::instance();
        py_result = Shiboken::Converter<QAbstractEventDispatcher * >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else if (Shiboken::Converter<QThread * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QThread* cpp_arg0 = Shiboken::Converter<QThread* >::toCpp(arg);
        // instance(QThread*)
        QAbstractEventDispatcher * cpp_result = QAbstractEventDispatcher::instance(cpp_arg0);
        py_result = Shiboken::Converter<QAbstractEventDispatcher * >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractEventDispatcherFunc_instance_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQAbstractEventDispatcherFunc_instance_TypeError:
        const char* overloads[] = {"PySide.QtCore.QThread = None", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QAbstractEventDispatcher.instance", overloads);
        return 0;
}

static PyObject* SbkQAbstractEventDispatcherFunc_interrupt(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // interrupt()
    if (SbkBaseWrapper_containsCppWrapper(self)) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractEventDispatcher.interrupt()' not implemented.");
        return 0;
    }
    QAbstractEventDispatcher* cppSelf = Shiboken::Converter<QAbstractEventDispatcher* >::toCpp((PyObject*)self);
    cppSelf->interrupt();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQAbstractEventDispatcherFunc_processEvents(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    if (SbkPySide_QtCore_QEventLoop_ProcessEventsFlag_Check(arg)) {
        QFlags<QEventLoop::ProcessEventsFlag> cpp_arg0 = Shiboken::Converter<QFlags<QEventLoop::ProcessEventsFlag> >::toCpp(arg);
        // processEvents(QFlags<QEventLoop::ProcessEventsFlag>)
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractEventDispatcher.processEvents()' not implemented.");
            return 0;
        }
        QAbstractEventDispatcher* cppSelf = Shiboken::Converter<QAbstractEventDispatcher* >::toCpp((PyObject*)self);
        thread_state_saver.save();
        bool cpp_result = cppSelf->processEvents(cpp_arg0);
        thread_state_saver.restore();
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractEventDispatcherFunc_processEvents_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQAbstractEventDispatcherFunc_processEvents_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEventLoop.ProcessEventsFlags", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QAbstractEventDispatcher.processEvents", overloads);
        return 0;
}

static PyObject* SbkQAbstractEventDispatcherFunc_registerSocketNotifier(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QSocketNotifier * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QSocketNotifier* cpp_arg0 = Shiboken::Converter<QSocketNotifier* >::toCpp(arg);
        // registerSocketNotifier(QSocketNotifier*)
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractEventDispatcher.registerSocketNotifier()' not implemented.");
            return 0;
        }
        QAbstractEventDispatcher* cppSelf = Shiboken::Converter<QAbstractEventDispatcher* >::toCpp((PyObject*)self);
        cppSelf->registerSocketNotifier(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractEventDispatcherFunc_registerSocketNotifier_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractEventDispatcherFunc_registerSocketNotifier_TypeError:
        const char* overloads[] = {"PySide.QtCore.QSocketNotifier", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QAbstractEventDispatcher.registerSocketNotifier", overloads);
        return 0;
}

static PyObject* SbkQAbstractEventDispatcherFunc_registerTimer(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "registerTimer", 2, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (PyNumber_Check(pyargs[0])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        if (numArgs == 3 && PyNumber_Check(pyargs[1]) && Shiboken::Converter<QObject * >::isConvertible(pyargs[2])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            if (Shiboken::cppObjectIsInvalid(pyargs[2]))
                return 0;
            QObject* cpp_arg2 = Shiboken::Converter<QObject* >::toCpp(pyargs[2]);
            // registerTimer(int,int,QObject*)
            if (SbkBaseWrapper_containsCppWrapper(self)) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractEventDispatcher.registerTimer()' not implemented.");
                return 0;
            }
            QAbstractEventDispatcher* cppSelf = Shiboken::Converter<QAbstractEventDispatcher* >::toCpp((PyObject*)self);
            cppSelf->registerTimer(cpp_arg0, cpp_arg1, cpp_arg2);
            //CppGenerator::writeParentChildManagement
            py_result = Py_None;
            Py_INCREF(Py_None);
        } else if (numArgs == 2 && Shiboken::Converter<QObject * >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return 0;
            QObject* cpp_arg1 = Shiboken::Converter<QObject* >::toCpp(pyargs[1]);
            // registerTimer(int,QObject*)
            QAbstractEventDispatcher* cppSelf = Shiboken::Converter<QAbstractEventDispatcher* >::toCpp((PyObject*)self);
            int cpp_result = cppSelf->QAbstractEventDispatcher::registerTimer(cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<int >::toPython(cpp_result);
            //CppGenerator::writeParentChildManagement
        } else goto SbkQAbstractEventDispatcherFunc_registerTimer_TypeError;
    } else goto SbkQAbstractEventDispatcherFunc_registerTimer_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQAbstractEventDispatcherFunc_registerTimer_TypeError:
        const char* overloads[] = {"int, PySide.QtCore.QObject", "int, int, PySide.QtCore.QObject", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QAbstractEventDispatcher.registerTimer", overloads);
        return 0;
}

static PyObject* SbkQAbstractEventDispatcherFunc_registeredTimers(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QObject * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(arg);
        // registeredTimers(QObject*)const
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractEventDispatcher.registeredTimers()' not implemented.");
            return 0;
        }
        QAbstractEventDispatcher* cppSelf = Shiboken::Converter<QAbstractEventDispatcher* >::toCpp((PyObject*)self);
        QList<QPair<int, int > > cpp_result = cppSelf->registeredTimers(cpp_arg0);
        py_result = Shiboken::Converter<QList<QPair<int, int > > >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractEventDispatcherFunc_registeredTimers_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQAbstractEventDispatcherFunc_registeredTimers_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QAbstractEventDispatcher.registeredTimers", overloads);
        return 0;
}

static PyObject* SbkQAbstractEventDispatcherFunc_startingUp(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // startingUp()
    QAbstractEventDispatcher* cppSelf = Shiboken::Converter<QAbstractEventDispatcher* >::toCpp((PyObject*)self);
    cppSelf->QAbstractEventDispatcher::startingUp();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject* SbkQAbstractEventDispatcherFunc_unregisterSocketNotifier(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QSocketNotifier * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QSocketNotifier* cpp_arg0 = Shiboken::Converter<QSocketNotifier* >::toCpp(arg);
        // unregisterSocketNotifier(QSocketNotifier*)
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractEventDispatcher.unregisterSocketNotifier()' not implemented.");
            return 0;
        }
        QAbstractEventDispatcher* cppSelf = Shiboken::Converter<QAbstractEventDispatcher* >::toCpp((PyObject*)self);
        cppSelf->unregisterSocketNotifier(cpp_arg0);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractEventDispatcherFunc_unregisterSocketNotifier_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQAbstractEventDispatcherFunc_unregisterSocketNotifier_TypeError:
        const char* overloads[] = {"PySide.QtCore.QSocketNotifier", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QAbstractEventDispatcher.unregisterSocketNotifier", overloads);
        return 0;
}

static PyObject* SbkQAbstractEventDispatcherFunc_unregisterTimer(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // unregisterTimer(int)
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractEventDispatcher.unregisterTimer()' not implemented.");
            return 0;
        }
        QAbstractEventDispatcher* cppSelf = Shiboken::Converter<QAbstractEventDispatcher* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->unregisterTimer(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractEventDispatcherFunc_unregisterTimer_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQAbstractEventDispatcherFunc_unregisterTimer_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QAbstractEventDispatcher.unregisterTimer", overloads);
        return 0;
}

static PyObject* SbkQAbstractEventDispatcherFunc_unregisterTimers(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QObject * >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(arg);
        // unregisterTimers(QObject*)
        if (SbkBaseWrapper_containsCppWrapper(self)) {
            PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractEventDispatcher.unregisterTimers()' not implemented.");
            return 0;
        }
        QAbstractEventDispatcher* cppSelf = Shiboken::Converter<QAbstractEventDispatcher* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->unregisterTimers(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        //CppGenerator::writeParentChildManagement
    } else goto SbkQAbstractEventDispatcherFunc_unregisterTimers_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
    return py_result;

    SbkQAbstractEventDispatcherFunc_unregisterTimers_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QAbstractEventDispatcher.unregisterTimers", overloads);
        return 0;
}

static PyObject* SbkQAbstractEventDispatcherFunc_wakeUp(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // wakeUp()
    if (SbkBaseWrapper_containsCppWrapper(self)) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAbstractEventDispatcher.wakeUp()' not implemented.");
        return 0;
    }
    QAbstractEventDispatcher* cppSelf = Shiboken::Converter<QAbstractEventDispatcher* >::toCpp((PyObject*)self);
    cppSelf->wakeUp();
    //CppGenerator::writeParentChildManagement

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyMethodDef SbkQAbstractEventDispatcher_methods[] = {
    {"closingDown", (PyCFunction)SbkQAbstractEventDispatcherFunc_closingDown, METH_NOARGS},
    {"flush", (PyCFunction)SbkQAbstractEventDispatcherFunc_flush, METH_NOARGS},
    {"hasPendingEvents", (PyCFunction)SbkQAbstractEventDispatcherFunc_hasPendingEvents, METH_NOARGS},
    {"instance", (PyCFunction)SbkQAbstractEventDispatcherFunc_instance, METH_NOARGS|METH_O|METH_STATIC},
    {"interrupt", (PyCFunction)SbkQAbstractEventDispatcherFunc_interrupt, METH_NOARGS},
    {"processEvents", (PyCFunction)SbkQAbstractEventDispatcherFunc_processEvents, METH_O},
    {"registerSocketNotifier", (PyCFunction)SbkQAbstractEventDispatcherFunc_registerSocketNotifier, METH_O},
    {"registerTimer", (PyCFunction)SbkQAbstractEventDispatcherFunc_registerTimer, METH_VARARGS},
    {"registeredTimers", (PyCFunction)SbkQAbstractEventDispatcherFunc_registeredTimers, METH_O},
    {"startingUp", (PyCFunction)SbkQAbstractEventDispatcherFunc_startingUp, METH_NOARGS},
    {"unregisterSocketNotifier", (PyCFunction)SbkQAbstractEventDispatcherFunc_unregisterSocketNotifier, METH_O},
    {"unregisterTimer", (PyCFunction)SbkQAbstractEventDispatcherFunc_unregisterTimer, METH_O},
    {"unregisterTimers", (PyCFunction)SbkQAbstractEventDispatcherFunc_unregisterTimers, METH_O},
    {"wakeUp", (PyCFunction)SbkQAbstractEventDispatcherFunc_wakeUp, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQAbstractEventDispatcher_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtCore.QAbstractEventDispatcher",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::deallocWrapper,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQAbstractEventDispatcher_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQAbstractEventDispatcher_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0,
    /*cpp_dtor*/            &Shiboken::callCppDestructor<QAbstractEventDispatcher >,
    /*is_multicpp*/         0,
    /*is_user_type*/        0
};


PyAPI_FUNC(void) init_QAbstractEventDispatcher(PyObject* module)
{
    SbkPySide_QtCoreTypes[SBK_QABSTRACTEVENTDISPATCHER_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQAbstractEventDispatcher_Type);

    SbkQAbstractEventDispatcher_Type.super.ht_type.tp_base = SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX];
    // Fill type discovery information
    SbkQAbstractEventDispatcher_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQAbstractEventDispatcher_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQAbstractEventDispatcher_Type));
    PyModule_AddObject(module, "QAbstractEventDispatcher",
        ((PyObject*)&SbkQAbstractEventDispatcher_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QAbstractEventDispatcher >("QAbstractEventDispatcher*");
    Shiboken::TypeResolver::createObjectTypeResolver<QAbstractEventDispatcher >(typeid(QAbstractEventDispatcher).name());
}


} // extern "C"

