// Some misc stuff
// (c) Copyright 2007, Grazvydas "notaz" Ignotas

#include "../PicoInt.h"

unsigned char formatted_bram[4*0x10] =
{
#if 0
	0x00, 0xd4, 0x63, 0x00, 0x00, 0x03, 0x03, 0x00, 0x03, 0x03, 0x03, 0x00, 0x03, 0x00, 0x00, 0x03,
	0x00, 0x03, 0x00, 0x00, 0x00, 0x03, 0x03, 0x00, 0x53, 0xd2, 0xf5, 0x3a, 0x48, 0x50, 0x35, 0x0f,
	0x47, 0x14, 0xf5, 0x7e, 0x5c, 0xd4, 0xf3, 0x03, 0x00, 0x03, 0x12, 0x00, 0x0a, 0xff, 0xca, 0xa6,
	0xf5, 0x27, 0xed, 0x22, 0x47, 0xfa, 0x22, 0x96, 0x6c, 0xa5, 0x88, 0x14, 0x48, 0x48, 0x0a, 0xbb,
#endif
	0x5f, 0x5f, 0x5f, 0x5f, 0x5f, 0x5f, 0x5f, 0x5f, 0x5f, 0x5f, 0x5f, 0x00, 0x00, 0x00, 0x00, 0x40,
	0x00, 0x7d, 0x00, 0x7d, 0x00, 0x7d, 0x00, 0x7d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x53, 0x45, 0x47, 0x41, 0x5f, 0x43, 0x44, 0x5f, 0x52, 0x4f, 0x4d, 0x00, 0x01, 0x00, 0x00, 0x00,
	0x52, 0x41, 0x4d, 0x5f, 0x43, 0x41, 0x52, 0x54, 0x52, 0x49, 0x44, 0x47, 0x45, 0x5f, 0x5f, 0x5f,
	// SEGA_CD_ROM.....RAM_CARTRIDGE___
};


// offs | 2Mbit  | 1Mbit  |
//   0  | [ 2M   | unused |
// 128K |  bit ] | bank0  |
// 256K | unused | bank1  |

#ifndef _ASM_MISC_C
PICO_INTERNAL_ASM void wram_2M_to_1M(unsigned char *m)
{
	unsigned short *m1M_b0, *m1M_b1;
	unsigned int i, tmp, *m2M;

	m2M = (unsigned int *) (m + 0x40000);
	m1M_b0 = (unsigned short *) m2M;
	m1M_b1 = (unsigned short *) (m + 0x60000);

	for (i = 0x40000/4; i; i--)
	{
		tmp = *(--m2M);
		*(--m1M_b0) = tmp;
		*(--m1M_b1) = tmp >> 16;
	}
}

PICO_INTERNAL_ASM void wram_1M_to_2M(unsigned char *m)
{
	unsigned short *m1M_b0, *m1M_b1;
	unsigned int i, tmp, *m2M;

	m2M = (unsigned int *) m;
	m1M_b0 = (unsigned short *) (m + 0x20000);
	m1M_b1 = (unsigned short *) (m + 0x40000);

	for (i = 0x40000/4; i; i--)
	{
		tmp = *m1M_b0++ | (*m1M_b1++ << 16);
		*m2M++ = tmp;
	}
}
#endif

