# -*- coding: utf-8 -*-
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from score import Score

class ScoreBoard(QGraphicsObject):
    scores = []

    def __init__(self, parent = None, width = None, height = None):
        QGraphicsObject.__init__(self, parent = parent)
        #self.setFixedSize(width, height)
        self.width = width
        self.height = height
        score = Score(self, False)
        score.setPos((self.width-score.boundingRect().width())/2, 50)
        self.connect(self, SIGNAL('setScores'), score.setScore)
        self.connect(self, SIGNAL('reset'), score.reset)
        #self.scores.append(score)
        score = Score(self, True)
        score.setPos((self.width-score.boundingRect().width())/2, 120)
        self.connect(self, SIGNAL('setScores'), score.setScore)
        self.connect(self, SIGNAL('reset'), score.reset)
        #self.scores.append(score)
        #self.score.setSize(self.geometry().width(), self.geometry().height()/2)

    def paint(self, painter, option, widget):
        #painter.setPen(Qt.black)
        #if self.possible: painter.setBrush(Qt.yellow)
        #else: painter.setBrush(Qt.gray)
        #painter.drawRoundedRect(0, 0, self.width, self.height, 10, 10)
        pass

    def boundingRect(self):
        return QRectF(0, 0, self.width, self.height)

    def setScores(self, scores = [2, 2]):
        self.emit(SIGNAL('setScores'), False, scores[0])
        self.emit(SIGNAL('setScores'), True, scores[1])

    def reset(self):
        self.emit(SIGNAL('reset'), False, scores[0])

