/**
 * @author Ben Lau <xbenlau@gmail.com>
 */

#include "pppencilbox.h"

PPPencilBox::PPPencilBox(QGraphicsItem *parent) :
    QGraphicsObject(parent)
{
    m_pen = new PPPen(this);
    m_eraser = new PPEraser(this);
    m_tool = None;

    paper = 0;

    connect(m_pen,SIGNAL(added()),
            this,SLOT(onStrokeRecorded()));

}

QRectF PPPencilBox::boundingRect() const{
    return QRectF();
}

void PPPencilBox::paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget){
    Q_UNUSED(painter);
    Q_UNUSED(option);
    Q_UNUSED(widget);
}

void PPPencilBox::setPaper(PPPaper *val){

    if (!paper.isNull()) {
        paper.data()->disconnect(this);
        m_pen->disconnect(paper.data());
        m_eraser->disconnect(paper.data());
    }

    Tool oldTool = m_tool;
    setTool(None);

    paper = val;

    if (val) {
        connect(m_pen,SIGNAL(added()),
                paper.data(),SLOT(setDirty()));
        connect(m_eraser,SIGNAL(erased()),
                paper.data(),SLOT(setDirty()));
    }

    setTool(oldTool);
}

void PPPencilBox::setTool(Tool val){
    switch (m_tool) { // Original mode
    case None:
        break;
    case Pen:
        m_pen->stop();
        break;
    case Eraser:
        m_eraser->stop();
        break;
    }

    m_tool = val;

    switch (m_tool) {
    case None:
        break;
    case Pen:
        if (!paper.isNull())
            m_pen->start(paper.data());
        break;
    case Eraser:
        if (!paper.isNull())
            m_eraser->start(paper.data());
        break;
    }

}

PPPencilBox::Tool PPPencilBox::tool(){
    return m_tool;
}

PPPen *PPPencilBox::pen(){
    return m_pen;
}

PPEraser* PPPencilBox::eraser(){
    return m_eraser;
}


void PPPencilBox::onStrokeRecorded(){
    if (!paper.isNull())
        m_pen->start(paper.data());
}

