#include <QGraphicsSceneMouseEvent>
#include <QGraphicsScene>
#include <QtCore>
#include "pperaser.h"
#include "ppgraphicsstroke.h"

PPEraser::PPEraser(QGraphicsItem *parent) :
    QGraphicsObject(parent)
{
    m_canvas = 0;
}

void PPEraser::paint( QPainter * painter, const QStyleOptionGraphicsItem * option, QWidget * widget ) {
    Q_UNUSED(painter);
    Q_UNUSED(option);
    Q_UNUSED(widget);
}

QRectF PPEraser::boundingRect() const{
    return QRectF();
}

void PPEraser::start(QGraphicsItem* canvas){
    stop();
    m_canvas = canvas;
    canvas->installSceneEventFilter(this);
}

void PPEraser::stop(){
    if (m_canvas){
        m_canvas->removeSceneEventFilter(this);
        m_canvas = 0;
    }
}


bool PPEraser::sceneEventFilter ( QGraphicsItem * watched, QEvent * event){

    bool handled = false;
    if (event->type() == QEvent::GraphicsSceneMousePress
        || event->type() == QEvent::GraphicsSceneMouseMove
        || event->type() == QEvent::GraphicsSceneMouseRelease
        ) {
        QGraphicsSceneMouseEvent* mouseEvent = static_cast< QGraphicsSceneMouseEvent *>(event);
        QGraphicsScene *s = scene();

        QPointF pt = watched->mapToScene( mouseEvent->pos() );

        int margin = 15;
        QRectF rect(pt.x(),pt.y(),margin,margin);
        rect.moveCenter(pt);

        QList<QGraphicsItem *> items = s->items(rect,Qt::IntersectsItemShape	);

        int eraseCount = 0;

        foreach (QGraphicsItem *item , items){
            if (item == watched)
                continue;
            PPGraphicsStroke* stroke = qgraphicsitem_cast<PPGraphicsStroke *>(item);
            if (stroke) {
//                qDebug() << "Found sketch item" << sketchItem->tagName();
                eraseCount++;
                delete item;
            }
//            delete item;
        }

        if (eraseCount)
            emit erased();
        handled = true;
    }

    if (handled)
        return handled;
    return QGraphicsObject::sceneEventFilter(watched,event);
}
