/**
 * @author Ben Lau <xbenlau@gmail.com>
 */

#include <QtCore>
#include "sketchxmlpaper.h"

SketchXmlPaper::SketchXmlPaper() : PPXmlPaper()
{
}


QDomElement SketchXmlPaper::read(SketchPaper *paper){
    QDomElement elem = PPXmlPaper::read(paper);
    QDomDocument doc = document();
    elem.setAttribute("resizable",paper->isResizable());

    PPBackground bg = paper->background();
    QDomElement backgroundElem = createBackgroundElement(&bg,doc);
    elem.appendChild(backgroundElem);

    return elem;
}

void SketchXmlPaper::read(QDomElement elem){
    PPXmlPaper::read(elem);
}


bool SketchXmlPaper::write(SketchPaper *paper){
    bool res = PPXmlPaper::write(paper);
    QDomDocument doc = document();
    if (res){
        QDomElement paperElem = doc.firstChildElement("paper");
        QDomElement elem = paperElem.firstChildElement("background");
        if (!elem.isNull()) {
            PPBackground bg;
            if (setBackgroundFromElement(&bg,elem)){
                paper->setBackground(bg);
                paper->setDirty(false);
            }
        }
    }

    return res;
}

bool SketchXmlPaper::write(QDomNode node){
    return PPXmlPaper::write(node);
}

QDomElement SketchXmlPaper::createBackgroundElement(PPBackground *bg , QDomDocument &doc ){
    QDomElement element = doc.createElement("background");

    /// @todo Implement another type
    QColor c = bg->color();
    element.setAttribute("color",c.name());

    if (!bg->src().isEmpty()){
        element.setAttribute("src",bg->src().toString());
        qDebug() << "src = " << bg->src().toString();
        element.setAttribute("repeat-x",bg->repeatX());
        element.setAttribute("repeat-y",bg->repeatY());
    }

    return element;
}

bool SketchXmlPaper::setBackgroundFromElement(PPBackground *bg, QDomElement &elem){
    if (elem.tagName() != "background")
        return false;

    QString color = elem.attribute("color","#FFFFFF");
    QColor c(color);

    bg->setColor(c);

    if (elem.hasAttribute("src")) {
        QUrl src( elem.attribute("src","") );
        bg->setSrc(src);
        QString val = elem.attribute("repeat-x","0");
        bg->setRepeatX( val == "1" ? 1 : 0);
        val = elem.attribute("repeat-y","0");
        bg->setRepeatY( val == "1" ? 1 : 0);
        bg->load();
    }

    return true;
}
