#include <QtCore>
#include <QDomElement>
#include <QGraphicsScene>
#include "sketchpaper.h"
#include "ppgraphicsstroke.h"
#include "ppxmlpaper.h"

/* Normal Page */

SketchPaper::SketchPaper(QGraphicsItem * parent) : PPPaper(parent) {
    clear();
    m_resizable = true;
}

SketchPaper::~SketchPaper() {
}

QRectF SketchPaper::boundingRect() const{
    QRectF rect1( rect());
    QRectF rect2 = childrenBoundingRect();

    QRectF rect3 = rect1.united(rect2);
//    qDebug() << __func__ << rect3;
    /*
    if (scene())
        qDebug() << "scene" << scene()->sceneRect();
        */
    return rect3;
}

void SketchPaper::clear(){
    PPPaper::clear();

    QRect rect (0,0,1600,1600);
    setRect(rect);
}

#if 0
QDomElement SketchPaper::createElement(QDomDocument &doc){

    QDomElement root = doc.createElement("paper");

    QRect r = rect();
    root.setAttribute("width",r.width());
    root.setAttribute("height",r.height());
    root.setAttribute("x",r.x());
    root.setAttribute("y",r.y());
    root.setAttribute("resizable",isResizable());
    root.setAttribute("type","standard");
    root.setAttribute("ver",1);

    PaperBackground bg = background();
    QDomElement backgroundElem = PaperXML::createBackgroundElement(&bg,doc);
    root.appendChild(backgroundElem);

    QList<QGraphicsItem*> items = childItems();

    foreach (QGraphicsItem *item , items){
        /*
        XmlIOIface *sketchItem = dynamic_cast<XmlIOIface *>(item);
        if (sketchItem) {
            QDomElement elem = sketchItem->createDomElement(doc);
            root.appendChild(elem);
        }
        */
        GraphicsStroke* stroke = qgraphicsitem_cast<GraphicsStroke*>(item);
        if (stroke){
            QDomElement elem = PaperXML::createStrokeElement(stroke,doc);
            root.appendChild(elem);
        }
    }

    return root;
}

bool SketchPaper::setFromElement(QDomElement &paper){
    bool res = false;

    if (paper.isNull())
        return false;

    int width = paper.attribute("width","100").toInt();
    int height = paper.attribute("height","100").toInt();
    int x = paper.attribute("x","0").toInt();
    int y = paper.attribute("y","0").toInt();
    setResizable(paper.attribute("resizable","1").toInt());

    prepareGeometryChange();

    setRect(QRect(x,y,width,height));

    QDomNodeList list = paper.childNodes();
    for (int i = 0 ; i < list.size() ;i++) {
        QDomElement elem = list.at(i).toElement();
        if (elem.isNull())
            continue;
        // Hard code in this module. Change to a factory class if more sketch item is supported
        if (elem.tagName() == "stroke") {
            GraphicsStroke *stroke = new GraphicsStroke(this);
            if (!PaperXML::setStrokeFromElement(stroke,elem)){
                delete stroke ;
            }
        } else if (elem.tagName() == "background") {
            PaperBackground bg;
            if (PaperXML::setBackgroundFromElement(&bg,elem)){
                setBackground(bg);
            }
        }
    }

    update();
    setDirty(false);
    return res;
}
#endif

void SketchPaper::snapshot(QPainter * painter, QRectF &target) {
    QGraphicsScene *s = scene();

    ///@todo Don't hardcode ths size of snapshot
    s->render(painter,target,
              QRect(0,0,800,670),
              Qt::KeepAspectRatio);
}

bool SketchPaper::isResizable(){
    return m_resizable;
}

void SketchPaper::setResizable(bool val){
    m_resizable = val;
}
