#ifndef MAEMO5COLORSVPICKER_H
#define MAEMO5COLORSVPICKER_H

#include <QWidget>

/// Saturation & value picker

class Maemo5ColorSVPicker : public QWidget
{
    Q_OBJECT
public:
    explicit Maemo5ColorSVPicker(QWidget *parent = 0);

    int saturation();

    int value();

public slots:
    void setHue(int val);
    void setSaturation(int val);
    void setValue(int val);

signals:
    void changed(int saturation , int value);
    void saturationChanged(int val);
    void valueChanged(int val);

protected:
    void resizeEvent(QResizeEvent *);
    void paintEvent(QPaintEvent*);
    void mouseMoveEvent(QMouseEvent *);
    void mousePressEvent(QMouseEvent *);

private:
    void updateMarker();
    int yToSaturation(int y);
    int xToValue(int x);
    int saturationToY(int s);
    int valueToX(int v);


    int m_hue;
    int m_saturation;
    int m_value;

    QPixmap background;
    QPointF marker;
    int markerWidth;
};

#endif // MAEMO5COLORSVPICKER_H
