#include <QtCore>
#include <QDomElement>
#include <QGraphicsScene>
#include "paper.h"
#include "sketchitem.h"
#include "graphicsstroke.h"

Paper::Paper(QGraphicsItem *parent) :
    QGraphicsObject(parent)
{
    m_resizable = true;
    m_dirty = false;
}

QRectF Paper::boundingRect() const{
    return childrenBoundingRect();
}

void Paper::paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget){
    Q_UNUSED(painter);
    Q_UNUSED(option);
    Q_UNUSED(widget);
}

QRect Paper::rect() const {
    return m_rect;
}

void Paper::setRect(QRect val){
    m_rect = val;
    prepareGeometryChange();
}

bool Paper::isResizable(){
    return m_resizable;
}

void Paper::setResizable(bool val){
    m_resizable = val;
}

void Paper::setDirty(bool val){
    m_dirty = val;
}

bool Paper::dirty(){
    return m_dirty;
}


/* Normal Page */

SketchPaper::SketchPaper(QGraphicsItem * parent) : Paper(parent) {
    QRect rect (0,0,1600,1600);
    setRect(rect);

    QPen pen;
    pen.setStyle(Qt::NoPen);
}

SketchPaper::~SketchPaper() {
}

QRectF SketchPaper::boundingRect() const{
    QRectF rect1( rect());
    QRectF rect2 = childrenBoundingRect();

    QRectF rect3 = rect1.united(rect2);
//    qDebug() << __func__ << rect3;
    /*
    if (scene())
        qDebug() << "scene" << scene()->sceneRect();
        */
    return rect3;
}

QDomElement SketchPaper::createElement(QDomDocument &doc){

    QDomElement root = doc.createElement("paper");

    QRect r = rect();
    root.setAttribute("width",r.width());
    root.setAttribute("height",r.height());
    root.setAttribute("x",r.x());
    root.setAttribute("y",r.y());
    root.setAttribute("resizable",isResizable());
    root.setAttribute("type","standard");
    root.setAttribute("ver",1);

    QList<QGraphicsItem*> items = childItems();

    foreach (QGraphicsItem *item , items){
        SketchItem *sketchItem = dynamic_cast<SketchItem *>(item);
        if (sketchItem) {
            QDomElement elem = sketchItem->createDomElement(doc);
            root.appendChild(elem);
        }
    }

    return root;
}

bool SketchPaper::setFromElement(QDomElement &paper){
    bool res = false;

    if (paper.isNull())
        return false;

    int width = paper.attribute("width","100").toInt();
    int height = paper.attribute("height","100").toInt();
    int x = paper.attribute("x","0").toInt();
    int y = paper.attribute("y","0").toInt();
    setResizable(paper.attribute("resizable","1").toInt());

    setRect(QRect(x,y,width,height));

    QDomNodeList list = paper.childNodes();
    for (int i = 0 ; i < list.size() ;i++) {
        QDomElement elem = list.at(i).toElement();
        // Hard code in this module. Change to a factory class if more sketch item is supported
        if (!elem.isNull() && elem.tagName() == "stroke") {
            GraphicsStroke *stroke = new GraphicsStroke(this);
            if (!stroke->setFromDomElement(elem)){
                delete stroke ;
            }
        }
    }

    prepareGeometryChange();
    update();
    setDirty(false);
    return res;
}

void SketchPaper::snapshot(QPainter * painter, QRectF &target) {
    QGraphicsScene *s = scene();

    s->render(painter,target,
              QRect(0,0,800,670),
              Qt::KeepAspectRatio);

}
