#!/usr/bin/env python
# -*- coding: latin-1 -*-
#
#This file is part of Outlaw Solitaire.
#
#Copyright (c) 2010, Toni Knsl
#All rights reserved.
#
#Redistribution and use in source and binary forms, with or without 
#modification, are permitted provided that the following conditions are met:
#
#    * Redistributions of source code must retain the above copyright notice, 
#      this list of conditions and the following disclaimer.
#    * Redistributions in binary form must reproduce the above copyright notice, 
#      this list of conditions and the following disclaimer in the documentation 
#      and/or other materials provided with the distribution.
#    * The name of the authors may not be used to endorse or promote products 
#      derived from this software without specific prior written permission.
#
#THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
#ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
#WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE 
#DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE 
#FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
#DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
#SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER 
#CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, 
#OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
#OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
if __name__ == '__main__':
    import pygame, os, sys

    BASEPATH = os.path.abspath(os.path.dirname(sys.argv[0])) #Note! Defined also in constants.py, both values must be same

    SCREENW = 800 #Note! Defined also in constants.py, both values must be same
    SCREENH = 480 #Note! Defined also in constants.py, both values must be same
    SCREENFLAGS = pygame.FULLSCREEN
    #SCREENFLAGS = 0
    SHOWMOUSE = 0
    #SHOWMOUSE = 1

    GFXBASEDIR = os.path.join(BASEPATH, 'gfx') #Note! Defined also in constants.py, both values must be same
    SPLASHGFXDIR = 'splash' #Note! Defined also in constants.py, both values must be same
    SPLASHFILE = 'splash_256.png' #Note! Defined also in constants.py, both values must be same
    LOADINGFILE = 'loading.png'
    LOADINGOFFSET = (331,404)

    pygame.init()
    screen = pygame.display.set_mode((SCREENW, SCREENH), SCREENFLAGS)
    pygame.display.set_caption("Outlaw Solitaire", "Outlaw Solitaire")
    pygame.mouse.set_visible(SHOWMOUSE)

    splash = pygame.image.load(os.path.join(GFXBASEDIR, SPLASHGFXDIR, SPLASHFILE)).convert()
    loading = pygame.image.load(os.path.join(GFXBASEDIR, SPLASHGFXDIR, LOADINGFILE)).convert_alpha()
    screen.blit(splash, (0,0))
    screen.blit(loading, LOADINGOFFSET)
    pygame.display.update()

    import main

    mainapp = main.MainApp(screen, SCREENFLAGS)

    while mainapp.running:
        mainapp.update()
