# -*- coding: latin-1 -*-
#
#This file is part of Outlaw Solitaire.
#
#Copyright (c) 2010, Toni Knsl
#All rights reserved.
#
#Redistribution and use in source and binary forms, with or without 
#modification, are permitted provided that the following conditions are met:
#
#    * Redistributions of source code must retain the above copyright notice, 
#      this list of conditions and the following disclaimer.
#    * Redistributions in binary form must reproduce the above copyright notice, 
#      this list of conditions and the following disclaimer in the documentation 
#      and/or other materials provided with the distribution.
#    * The name of the authors may not be used to endorse or promote products 
#      derived from this software without specific prior written permission.
#
#THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
#ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
#WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE 
#DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE 
#FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
#DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
#SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER 
#CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, 
#OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
#OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
import pygame, gfxlib

def CreateTextImage(text, bitmap_font, color=False, surface=None, justify='left'):
    temp_image_width = GetTextWidth(text, bitmap_font)

    if surface:
        temp_image = surface
        temp_image.fill((0,0,0,0))
    else:
        temp_image = gfxlib.CreateAlphaSurface((temp_image_width, bitmap_font.height))        

    if justify == 'left':
        temp_x = 0
    elif justify == 'center':
        temp_x = (temp_image.get_width() - temp_image_width) / 2
    elif justify == 'right':
        temp_x = temp_image.get_width() - temp_image_width
    else:
        raise RuntimeError('CreateTextImage: Invalid justify value: '+justify+'!')

    for temp_char in text:
         temp_image.blit(bitmap_font.bitmap_chars[temp_char].image, (temp_x,0))
         temp_x += bitmap_font.bitmap_chars[temp_char].rect.width

    if color:
        gfxlib.colorize_alpha_image(temp_image, color)

    if surface == None:
        return temp_image

def CreateMultilineTextImage(text_lines, bitmap_font, pad_y=0, color=False, justify='left', surface=None):
    temp_image_height = len(text_lines) * (bitmap_font.height + pad_y) - pad_y

    temp_image_width = 0
    for temp_text in text_lines:
        if GetTextWidth(temp_text, bitmap_font) > temp_image_width:
            temp_image_width = GetTextWidth(temp_text, bitmap_font)

    if surface:
        temp_image = surface
        temp_image.fill((0,0,0,0))
    else:
        temp_image = gfxlib.CreateAlphaSurface((temp_image_width, temp_image_height))

    temp_y = 0
    for temp_text in text_lines:
        if justify == 'left':
            temp_image.blit(CreateTextImage(temp_text, bitmap_font), (0,temp_y))
        elif justify == 'right':
            temp_line_width = GetTextWidth(temp_text, bitmap_font)
            temp_image.blit(CreateTextImage(temp_text, bitmap_font), ((temp_image.get_width()-temp_line_width),temp_y))
        elif justify == 'center':
            temp_line_width = GetTextWidth(temp_text, bitmap_font)
            temp_image.blit(CreateTextImage(temp_text, bitmap_font), ((temp_image.get_width()-temp_line_width)/2,temp_y))
            
        temp_y += bitmap_font.height + pad_y

    if color:
        gfxlib.colorize_alpha_image(temp_image, color)

    return temp_image

def GetTextWidth(text, bitmap_font):
    temp_width = 0
    for temp_char in text:
         temp_width += bitmap_font.bitmap_chars[temp_char].rect.width

    return temp_width

class BitmapChar:
    image = None
    rect = None
    
    def __init__(self):
        pass
        
class BitmapFont:
    bitmap_chars = None
    height = None

    def __init__(self, character_set, font_path, font_file):
        self.bitmap_chars = {}
        
        temp_gfx = gfxlib.LoadAlphaGfx(font_path, font_file)

        self.height = temp_gfx.get_height()      

        temp_divider_color = temp_gfx.get_at((0,0))

        temp_x = 1        
        for temp_char in character_set:
            temp_bitmap_char = BitmapChar()

            temp_width = 0
            temp_color = None
            while temp_color != temp_divider_color:
                temp_color = temp_gfx.get_at((temp_x,0))
                temp_x += 1
                temp_width += 1

            temp_width -= 1
            temp_bitmap_char.image = gfxlib.CreateAlphaSurface((temp_width, self.height))
            temp_bitmap_char.image.blit(temp_gfx, (0,0), (temp_x-temp_width-1, 0, temp_width, self.height))
            temp_bitmap_char.rect = temp_bitmap_char.image.get_rect()
            
            self.bitmap_chars[temp_char] = temp_bitmap_char

if __name__ == '__main__':
    pass            
            
