from PyQt4.QtGui import QGraphicsScene, QGraphicsPixmapItem, QPixmap
from Clef import Clefs
import sys

class Staff(QGraphicsScene):
    
    __notes = [ sys.path[0] + "/ui/down7.png", sys.path[0] + "/ui/down6.png", sys.path[0] + "/ui/down5.png", sys.path[0] + "/ui/down4.png", sys.path[0] + "/ui/down3.png", 
                sys.path[0] + "/ui/down2.png", sys.path[0] + "/ui/down1.png", sys.path[0] + "/ui/row1.png", sys.path[0] + "/ui/space1.png", 
                sys.path[0] + "/ui/row2.png", sys.path[0] + "/ui/space2.png", sys.path[0] + "/ui/row3.png", sys.path[0] + "/ui/space3.png",
                sys.path[0] + "/ui/row4.png", sys.path[0] + "/ui/space4.png", sys.path[0] + "/ui/row5.png", sys.path[0] + "/ui/up1.png", sys.path[0] + "/ui/up2.png", 
                sys.path[0] + "/ui/up3.png", sys.path[0] + "/ui/up4.png", sys.path[0] + "/ui/up5.png", sys.path[0] + "/ui/up6.png", sys.path[0] + "/ui/up7.png" ]

    def __init__(self, parent):
        QGraphicsScene.__init__(self, parent)

        self.clefItem=QGraphicsPixmapItem(QPixmap(Clefs.TREBLE.getResource()))
        self.clefItem.setPos(80, 50)
        self.addItem(self.clefItem)

        self.noteItem=QGraphicsPixmapItem(QPixmap(Staff.__notes[0]))
        self.noteItem.setPos(180, 50)
        self.addItem(self.noteItem)

        svgItem1=QGraphicsPixmapItem(QPixmap(sys.path[0] + "/ui/staff.png"))
        svgItem1.setPos(280, 50)
        self.addItem(svgItem1)

    def showNote(self, note):
        self.removeItem(self.clefItem)
        self.clefItem=QGraphicsPixmapItem(QPixmap(note.getClef().getResource()))
        self.clefItem.setPos(80, 50)
        self.addItem(self.clefItem)

        self.removeItem(self.noteItem)
        self.noteItem=QGraphicsPixmapItem(QPixmap(Staff.__notes[note.getNote()-1]))
        self.noteItem.setPos(180, 50)
        self.addItem(self.noteItem)
