/*
 * Include declarations
 */
#include <libosso.h>
#include <hildon/hildon.h>
#include <gtk/gtk.h>
#include <gdk/gdkpixbuf.h>

/*
 * Program structure definition
 */
typedef enum {NONE,PREVIOUS,NEXT} action_t;

typedef enum {FIT_SCREEN,ONE_THIRD_RESOLUTION,HALF_RESOLUTION,FULL_RESOLUTION} zoom_t;

typedef struct app_data app_data_t;
struct app_data {
	osso_context_t* ossocont;
	DBusConnection* sysbus;
	HildonProgram* app;
	HildonWindow* mainwin;
	GtkWidget* image;
	GdkPixbuf* imgbuffer;
	GtkWidget* imgparamwin;
	gchar* imgparam;
	gchar* currfname;
	gchar* currdir;
	gint currfindex;
	GList* allimgindir;
	const gchar** rawext;
	glong pressbuttontime;
	gdouble pressbuttonx;
	gdouble pressbuttony;
	action_t actioninprog;
	zoom_t zoomlevel;
};

/*
 * Function definitons
 */
app_data_t* app_init();
void app_free(app_data_t *myapp);
