// Copyright 2010 Jochen Becher
//
// This file is part of MovieSchedule.
//
// MovieSchedule is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// MovieSchedule is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with MovieSchedule.  If not, see <http://www.gnu.org/licenses/>.

#include "asynccallclient.h"

#include "asynccallproxy.h"

namespace AsyncCallPrivate {

    AsyncCallClient::AsyncCallClient(QThread *proxy_thread, QObject *parent) :
            QObject(parent),
            _proxy(new AsyncCallProxy(0))
    {
        connect(this, SIGNAL(CallAsync(CallProxyBase*)), _proxy, SLOT(Call(CallProxyBase*)));
        _proxy->moveToThread(proxy_thread);
    }

    void AsyncCallClient::Call(CallProxyBase *call_proxy_base)
    {
        emit CallAsync(call_proxy_base);
        deleteLater();
    }

}
