/*
 *  moonphase home widget for the maemo desktop.
 *  Copyright (C) 2010 Nicolai Hess
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifndef _MOONPHASE_UTIL_H_
#define _MOONPHASE_UTIL_H_
#include <time.h>
struct _moon_phase_data_t
{
  double phase;
  double age;
  double distance_from_earth;
  double angular_diameter;
  double distance_to_sun;
  double sun_angular_diameter;
};

typedef struct _moon_phase_data_t moon_phase_data_t;
double phase(
  double  pdate,                      /* Date for which to calculate phase */
  double  *pphase,                    /* Illuminated fraction */
  double  *mage,                      /* Age of moon in days */
  double  *dist,                      /* Distance in kilometres */
  double  *angdia,                    /* Angular diameter in degrees */
  double  *sudist,                    /* Distance to Sun */
  double  *suangdia);                  /* Sun's angular diameter */
void jyear(double td, long *yy, int *mm, int *dd);
double jtime(struct tm *t);

  //double phase(time_t now, moon_phase_data_t* moon_phase_data);
#endif

