/*
 *  Microfeed - Backend for accessing feed-based services (unstable providers)
 *  Copyright (C) 2009 Henrik Hedberg <henrik.hedberg@innologies.fi>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as published by
 *  the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */
 
#include "twitter.h"
#include <microfeed-common/microfeedprotocol.h>

void do_authentication(MicrofeedPublisher* publisher, MicrofeedHttp* http) {
	char* login = NULL;
	char* password = NULL;
	char* auth;

	if ((login = microfeed_publisher_get_setting_value(publisher, "authentication.login", NULL)) &&
	    (password = microfeed_publisher_get_setting_value(publisher, "authentication.password", NULL))) {
		auth = microfeed_util_string_concatenate(login, ":", password, NULL);
		microfeed_http_set_basic_authentication(http, auth);
		free(auth);
	}
	free(login);
	free(password);
}

MicrofeedError* check_if_error(MicrofeedJson* json) {
	MicrofeedError* error = NULL;
	const char* string;
	
	if ((string = microfeed_json_get_as_string(json, "error"))) {
		error = microfeed_error_new(MICROFEED_ERROR_FROM_SERVICE, string);
	}
	
	return error;
}

int get_rate_limit(MicrofeedPublisher* publisher, MicrofeedHttp* http) {
	int rate_limit = -1;
	char* site;
	char* url;
	MicrofeedJson* json;
	MicrofeedError* error;

	site = microfeed_publisher_get_setting_value(publisher, "service.url", "http://twitter.com");
	url = microfeed_util_string_concatenate(site, "/account/rate_limit_status.json", NULL);
	free(site);

	if ((json = microfeed_http_get_json(http, url))) {
		rate_limit = (int)microfeed_json_get_integer(json, "remaining_hits");
		microfeed_json_free(json);
	}
	free(url);

	return rate_limit;
}
