/*
 *  Microfeed - Backend for accessing feed-based services (unstable providers)
 *  Copyright (C) 2009 Henrik Hedberg <henrik.hedberg@innologies.fi>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as published by
 *  the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */
 
#define _XOPEN_SOURCE
#define _BSD_SOURCE
#define _GNU_SOURCE

#include <microfeed-provider/microfeedfeed.h>
#include <microfeed-common/microfeedmisc.h>
#include <microfeed-common/microfeedprotocol.h>
#include <microfeed-provider/microfeedhttp.h>
#include <microfeed-provider/microfeedjson.h>

#include "dummy.h"

#include <stdio.h>
#include <string.h>

static void destroy_feed(MicrofeedFeed* feed, void* user_data);
static MicrofeedError* update_feed(MicrofeedFeed* feed, int user_initiated, void* user_data);
static MicrofeedError* modify_item(MicrofeedFeed *feed, MicrofeedItem *existing_item, MicrofeedItem *new_item, void *user_data);
static MicrofeedError* mark_item(MicrofeedFeed* feed, const char* uid, int mark_status, void* user_data);

MicrofeedFeedCallbacks overview_feed_callbacks = {
	destroy_feed,
	update_feed,
	modify_item,
	mark_item,
	NULL
};

MicrofeedFeedCallbacks feed_callbacks = {
	destroy_feed,
	update_feed,
	NULL, /* modify_feed_item */
	mark_item,
	NULL
};

static void destroy_feed(MicrofeedFeed* feed, void* user_data) {
	char* url;

	url = (char*)user_data;
	free(url);
}

static MicrofeedError* update_feed(MicrofeedFeed* feed, int user_initiated, void* user_data) {
	static int number = 1;

	char uid[1024];
	MicrofeedItem* item;
	
	snprintf(uid, 1024, "uid-%d", number++);
	item = microfeed_item_new_with_status(uid, time(NULL), MICROFEED_ITEM_STATUS_NEW);
	microfeed_item_set_property(item, MICROFEED_ITEM_PROPERTY_NAME_CONTENT_TEXT, "Lorem Ipsum");
	microfeed_item_set_property(item, MICROFEED_ITEM_PROPERTY_NAME_USER_NICK, "friend");

	microfeed_feed_replace_item(feed, item);
	microfeed_item_free(item);

	return NULL;
}

static MicrofeedError* modify_item(MicrofeedFeed *feed, MicrofeedItem *existing_item, MicrofeedItem *new_item, void *user_data) {	
	if (existing_item) {

		return microfeed_error_new(MICROFEED_ERROR_CANNOT_MODIFY_ITEM, "Cannot modify an existing item.");
	}
	if (microfeed_item_get_property(new_item, MICROFEED_ITEM_PROPERTY_NAME_CONTENT_TEXT)) {

		return microfeed_error_new(MICROFEED_ERROR_MISSING_PROPERTY, "Expected a content.text property.");
	}
	
	microfeed_feed_replace_item(feed, new_item);
	
	return NULL;
}

static MicrofeedError* mark_item(MicrofeedFeed* feed, const char* uid, int mark_status, void* user_data) {
	
	return NULL;
}
