import ctypes
import os

_xlib = ctypes.CDLL("libx11.so.6")
_xrandr = ctypes.CDLL("libXrandr.so.2")


class _XRRScreenConfiguration(Structure): pass


def set_orientation(orientation):

    display = _xlib.XOpenDisplay(os.getenv("DISPLAY"))
    screen = _xlib.XDefaultScreen(display)
    root = _xlib.XDefaultRootWindow(display, screen)

    gsi = rr.XRRGetScreenInfo
    gsi.restype = ctypes.POINTER(XRRScreenConfiguration)
    config = gsi(display, root)

    current_time = ctypes.c_ulong()
    rr.XRRTimes.restype = ctypes.c_ulong
    timestamp = rr.XRRTimes(display, screen, ctypes.byref(current_time))

    xccr = rr.XRRConfigCurrentRate
    xccr.restype = ctypes.c_int
    rate = xccr(config)

    rotation = ctypes.c_ushort()
    size = rr.XRRConfigCurrentConfiguration(config, ctypes.byref(rotation))


    rr.XRRSetScreenConfigAndRate(display, config, root, size,
                                 int(orientation), rate, timestamp)

