/*
 *  Medard for Maemo.
 *  Copyright (C) 2011 Roman Moravcik
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef MEDARDDOWNLOADER_H
#define MEDARDDOWNLOADER_H

#include <QObject>
#include <QDateTime>
#include <QString>
#include <QSize>
#include <QTimer>
#include <QtNetwork/QNetworkAccessManager>
#include <QtNetwork/QNetworkReply>

class MedardDownloader : public QObject
{
    Q_OBJECT

public:
    enum ForecastType {
        SeaLevelPressure = 0,
        Precipitation = 1,
        WindVelocity = 2,
        Cloudiness = 3,
        Temperature  = 4
    };

    enum ForecastDomain {
        Europe = 0,
        CzechRepublic = 1
    };

    MedardDownloader();
    ~MedardDownloader();

    void setForecastType(ForecastType type);

    void setForecastDomain(ForecastDomain domain);

    void setForecastInitialDate(QDateTime date);
    QDateTime forecastInitialDate();
    QDateTime forecastDate();

    void setForecastDateOffset(int offset);
    int forecastDateOffset();
    int minForecastDateOffset();
    int maxForecastDateOffset();

    void downloadImage();

    QSize imageSize();

signals:
    void downloadFinished(const QString &filename, const QDateTime &date);
    void downloadFailed();

private slots:
    void retryTimerEvent();
    void clearDownloadRequest();

    void downloadImageFinished();
    void downloadImageError(QNetworkReply::NetworkError code);

    void retrieveForecastInitialDateFinished();
    void retrieveForecastInitialDateError(QNetworkReply::NetworkError code);

private:
    void tryDownloadImageAgain();
    bool isDownloaded(const QString filename);

    void retrieveForecastInitialDate();

    void createCacheDirectory();
    void cleanCacheDirectory();

private:
    QDateTime m_forecastInitialDate;
    QString m_forecastInitialDateCode;
    int m_forecastDateOffset;
    QString m_forecastType;
    QString m_forecastDomain;

    QNetworkAccessManager *m_network;
    QNetworkReply *m_reply;

    int m_retryCounter;
    QTimer *m_retryTimer;

    QString m_cachePath;
};

#endif // MEDARDDOWNLOADER_H
