/*
 *  Medard for Maemo.
 *  Copyright (C) 2011 Roman Moravcik
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QActionGroup>
#include <QLabel>
#include <QPushButton>

#include "forecastwidget.h"
#include "medarddownloader.h"

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    MainWindow(QWidget *parent = 0);
    virtual ~MainWindow();

private slots:
    void seaLevelPreasureMenuClicked();
    void precipitationMenuClicked();
    void windVelocityMenuClicked();
    void cloudinessMenuClicked();
    void temperatureMenuClicked();
    void aboutMenuClicked();

    void downloadAgainClicked();

    void plusDayClicked();
    void minusDayClicked();
    void plusHourClicked();
    void minusHourClicked();

    void forecastTypeChanged(const QString label, MedardDownloader::ForecastType type);
    void forecastDateOffsetChanged(int offset);
    void forecastDomainChanged(QAction *action);

    void downloadedFinished(const QString &filename, const QDateTime &date);
    void downloadFailed();

private:
    void setupUi();
    void setupMenu();
    void loadSettings();

    void showNavigationButtons();
    void hideNavigationButtons(bool showRetryButton);
    void updateNavigationButtons();

private:
    MedardDownloader *m_downloader;

    ForecastWidget *m_forecast;
    QLabel *m_forecastTypeLabel;
    QLabel *m_forecastInitialDateLabel;
    QLabel *m_forecastDateLabel;

    QPushButton *m_downloadRetryButton;

    QPushButton *m_minusDayButton;
    QPushButton *m_plusDayButton;
    QPushButton *m_minusHourButton;
    QPushButton *m_plusHourButton;

    QActionGroup *m_domainActionGroup;
};

#endif // MAINWINDOW_H
