/*
 *  Medard for Maemo.
 *  Copyright (C) 2011 Roman Moravcik
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <QtGui>

#include "forecastwidget.h"

ForecastWidget::ForecastWidget(QWidget *parent) : QWidget(parent)
{
    m_filename.clear();
    m_error = false;
}

void ForecastWidget::setImage(const QString &filename)
{
    m_filename = filename;
    m_error = false;
    update();
}

void ForecastWidget::clearImage(bool error)
{
    m_filename.clear();
    m_error = error;
    update();
}

void ForecastWidget::paintEvent(QPaintEvent * /* event */)
{
    QPainter painter(this);
    painter.setRenderHint(QPainter::Antialiasing);

    QRect widgetArea(rect().x(), rect().y(), rect().width(), 408);

    painter.setPen(QColor(0, 0, 0));
    painter.setBrush(QColor(255, 255, 255));
    painter.drawRect(widgetArea);

    if (m_error) {
        painter.drawText(widgetArea, Qt::AlignCenter, tr("Download failed!"));
    } else {
        if (!m_filename.isEmpty()) {
            QImage image(m_filename);
            painter.drawImage(widgetArea, image);
        } else {
            painter.drawText(widgetArea, Qt::AlignCenter, tr("Downloading image..."));
        }
    }
}
